<?php
/**
 * Template Name: Form notizia
 */

require_once('common.inc.php');
get_header();

#---------------------------------------------------------------------------------------------------------------------------------
# CHECK LOGIN
#---------------------------------------------------------------------------------------------------------------------------------
check_login();
#---------------------------------------------------------------------------------------------------------------------------------
$errore = false;
$ok_notizia = false;
$code_notizia = getVar("POST", "code_notizia", getVar("GET", "notizia"));
$code_padre = getVar("GET", "padre", getVar("POST", "code_padre"));

$record = Factory::crea("Notizia");
if (strlen($code_notizia))
    $record->loadFromCode($code_notizia);
else
    $record->set("code_padre", $code_padre);

if( 'POST' == $_SERVER['REQUEST_METHOD'] && !empty( $_POST['ok_notizia'] ) &&  $_POST['ok_notizia'] == "1") {
    $record->loadInput();
    
    for ($i=1; $i<=4; $i++) {
        $nome_campo = "immagine".$i;
        $path_base = BASE_DIR;
        $path_rel = "/uploads/notizie/";
        $name = upload_image($nome_campo, $path_base, $path_rel, "NOTIZIA_");
        if ($name !== false) {
            error_log($nome_campo." - ".$path_rel.$name);
            $record->set($nome_campo, $path_rel.$name);
        }
        /*if (is_uploaded_file($_FILES[$nome_campo]['tmp_name'])) {
            $originale = basename($_FILES[$nome_campo]['tmp_name']);
            $path_parts = pathinfo($_FILES[$nome_campo]['name']);
            $extension = strtoupper($path_parts['extension']);

            if (!in_array($extension, array('PNG', 'JPG'))) {
                $errore = true;
                show_message(MSGERROR, "Formato file foto {$i} non permesso!", false);
            }


            if (strlen($originale)) {
                $tipo = $_FILES[$nome_campo]['type'];
                $name = "NOTIZIA_".substr(md5($originale), 0, 8)."__".$_FILES[$nome_campo]['name'];
                $res = move_uploaded_file($_FILES[$nome_campo]['tmp_name'], $path_base.$path_rel.$name);
                if ($res) {
                    error_log($nome_campo." - ".$path_rel.$name);
                    $record->set($nome_campo, $path_rel.$name);
                }
                else{
                    $errore = true;
                    show_message(MSGERROR, "Upload foto {$i} fallito! (1)", false);
                }
            }
        }
        elseif (strlen(basename($_FILES[$nome_campo]['tmp_name'])) > 0) {
            $errore = true;
            show_message(MSGERROR, "Upload foto {$i} fallito! (2)", false);
        }*/
    }
    
    # CHECK
    if (strlen($record->get('titolo')) == 0) {
        $errore = true;
        show_message(MSGERROR, "E' necessario dare un titolo alla notizia.", false);
    }
    if (strlen($record->get('data')) == 0) {
        $errore = true;
        show_message(MSGERROR, "E' necessario indicare una data.", false);
    }
    
    if( !$errore ) {
        $res = Factory::salva($record);
        
        if ($res) {
            $ok_notizia = true;
        }
    }
}

if (!$errore && $ok_notizia) {
    echo <<<EOT
<form action="indietro.php" method="GET">
    <div id="message" class="updated fade"><p><strong>Notizia salvata con successo.</strong></p></div>
    <button type="submit" class="mybutton">OK</button>
</form>
EOT;
}
    
if (!$ok_notizia) {
?>

<script>
jQuery(document).ready(function() {
    jQuery( "#data" ).datepicker({dateFormat : 'dd/mm/yy'});
    $("#testo").wysiwyg({
        rmUnusedControls: false,
        controls: {
            increaseFontSize : { visible : true },
			decreaseFontSize : { visible : true },
			cut   : { visible : true },
			copy  : { visible : true },
			paste : { visible : true },
			html  : { visible: true },
			colorpicker: {
                visible: true,
                css: {
                    "color": function (cssValue, Wysiwyg) {
                        var document = Wysiwyg.innerDocument(),
                            defaultTextareaColor = $(document.body).css("color");

                        if (cssValue !== defaultTextareaColor) {
                            return true;
                        }

                        return false;
                    }
                },
                exec: function() {
                    if ($.wysiwyg.controls.colorpicker) {
                        $.wysiwyg.controls.colorpicker.init(this);
                    }
                },
                tooltip: "Colorpicker"
            },
					
        }
    });
});
</script>


<form action="indietro.php" method="GET">
    <button type="submit" class="mybutton">Indietro</button>
</form>

<h1 class="titolo_pagina">Notizia</h1>

<form method="POST" action="<?php get_permalink(); ?>" id="form_nuova_notizia" name="form_nuova_notizia" enctype="multipart/form-data">

    <table class="mytable">
    
    <?php if ($utente->administrator()) { ?>
    <tr>
        <th><label for="noi">Noi</label></th>
        <td><select name="noi" id="noi" class="one fourth">
                <option value="N" <?php selected($record->get("noi"), 'N'); ?>>no</option>
                <option value="S" <?php selected($record->get("noi"), 'S'); ?>>si</option>
            </select></td>
    </tr>
    <?php } ?>
    
    <tr>
        <th><label for="titolo">Titolo</label></th>
        <td><input type="text" value="<?php echo $record->get("titolo"); ?>" size="50" name="titolo" id="titolo" /></td>
    </tr>
    
    <tr>
        <th><label for="">Data</label></th>
        <td><input type="text" value="<?php echo date_translate($record->get("data"), 'us', 'it'); ?>" size="10" name="data" id="data" />
        </td>
    </tr>
    
<?php
    for ($i=1; $i<=4; $i++) {
        $nome_immagine = "immagine".$i;
        echo <<<EOT
    <tr>
        <th><label for="immagine{$i}">Immagine #{$i}</label></th>
        <td><input type="file" value="" size="15" name="immagine{$i}" id="immagine{$i}" />
EOT;
        if (strlen($record->get($nome_immagine)))
            echo "<img src='{$record->get($nome_immagine)}' height='50px' />";
        echo <<<EOT
        </td>
    </tr>
EOT;
}
?>
    <tr>
        <th><label for="video1">YouTube video</label></th>
        <td><input type="text" value="<?php echo $record->get("video1"); ?>" size="60" name="video1" id="video1" placeholder="https://www.youtube.com/embed/CODICEVIDEO" /></td>
    </tr>
    
    <tr>
        <th><label for="testo">Testo</label></th>
        <td><textarea type="text" rows="5" cols="50" name="testo" id="testo"><?php echo $record->get("testo"); ?></textarea></td>
    </tr>

    <tr>
        <th><label for="url_www">Sito della notizia (URL)</label></th>
        <td>Inserire l'URL completa della pagina web dell'notizia, comprensiva di http://<br />
        <input type="text" value="<?php echo $record->get("url_www"); ?>" size="60" name="url_www" id="url_www" /></td>
    </tr>

    </table>
    <input type="hidden" name="ok_notizia" value="1" />
    <input type="hidden" name="code_utente" value="<?php echo $utente->code; ?>" />
    <input type="hidden" name="code_notizia" value="<?php echo $record->code(); ?>" />
    <input type="hidden" name="code_padre" value="<?php echo $record->get("code_padre"); ?>" />
    <button type="submit" class="mybutton">Salva</button>
</form>

<?php 
}

get_footer(); 
?>