<?php
/**
 * Template Name: Form nuova donazione
 */

require_once('common.inc.php');

get_header();

$code_pelosetto = getVar("POST", "code", getVar("POST", "code_pelosetto", getVar("GET", "pelosetto")));

#---------------------------------------------------------------------------------------------------------------------------------
# CHECK LOGIN
#---------------------------------------------------------------------------------------------------------------------------------
$permalink = get_permalink() ."?pelosetto=".$code_pelosetto;
check_login($permalink);

#----- PELOSETTO -----------------------------------------------------------------------------------------------------------------
$sql = "SELECT * FROM pelosetti WHERE code='{$code_pelosetto}'";
$rs = $db->Esegui($sql);

$pelosetto = array();
if ($rs != FALSE) {
    $pelosetto = $rs->FetchRow();
}

#----- CANILE --------------------------------------------------------------------------------------------------------------------
$sql = "SELECT * FROM vw_anagrafiche WHERE code='{$pelosetto['code_canile']}'";
$rs = $db->Esegui($sql);

$canile = array();
if ($rs != FALSE) {
    $canile = $rs->FetchRow();
}

#----- REFERENTI -----------------------------------------------------------------------------------------------------------------
$sql = "SELECT r.*, i.nome || ' ' || i.cognome as nominativo 
        FROM anagrafiche_referenti r
        JOIN iscritti i ON i.username=r.username
        WHERE r.ruolo='REFERENTE' AND code_anagrafica='{$pelosetto['code_canile']}'";
$rs = $db->Esegui($sql); #DEBUG($sql);

$referenti = array();
if ($rs != FALSE) {
    $referenti = $rs->GetArray();
}

$ok_nuova_donazione = false;
$errore = false;

class RecordDonazioni extends RecordBase {
    
	public function __construct($id=null) {
        parent::__construct("donazioni", "ident", $id);
    }
}
$record = Factory::crea("RecordDonazioni");


if( 'POST' == $_SERVER['REQUEST_METHOD'] && !empty( $_POST['ok_nuova_donazione'] ) &&  $_POST['ok_nuova_donazione'] == "1") {
    $record->loadInput();
    
    /*$code_pelosetto = $_POST['code_pelosetto'];
    $code_utente = $_POST['code_utente'];
    $versamento_tipo = $_POST['versamento_tipo'];
    $versamento_modo = $_POST['versamento_modo'];
    $versamento_referente = $_POST['versamento_referente'];
    $importo_versamento = $_POST['importo_versamento'];
    $motivazione = $_POST['motivazione'];
    $info = $_POST['info'];*/
    
    /*if ($importo_annuale < 120) {
        $errore = true;
        show_message(MSGERROR, "L'importo annuale minimo &egrave; 120 euro.", false);
    }*/
    if ($record->get('importo_versamento') <= 0) {
        $errore = true;
        show_message(MSGERROR, "L'importo deve essere indicato.", false);
    }
    if ($record->get('numero_versamenti') <= 0) {
        $errore = true;
        show_message(MSGERROR, "Il numero di versamenti che si intende effettuare deve essere indicato.", false);
    }
    if ($record->get('versamento_modo') != 'I' && $record->get('versamento_modo') != 'D') {
        $errore = true;
        show_message(MSGERROR, "E' necessario indicare una modalit&agrave; di versamento.", false);
    }
    if ($record->get('versamento_modo') == 'I' && strlen($record->get('versamento_referente')) == 0) {
        $errore = true;
        show_message(MSGERROR, "E' necessario indicare un referente quando il versamento &egrave; indiretto.", false);
    }
    
    if(!$errore) {
        $record->set("tabella", "donazioni");
        $record->set("code_utente", $code_utente);
        /*$record->set("code_pet", $code_pelosetto);
        $record->set("versamento_tipo", $versamento_tipo);
        $record->set("versamento_modo", $versamento_modo);
        $record->set("importo_annuale", $importo_annuale);
        $record->set("motivazione", $motivazione);
        $record->set("info", $info);
        $record->set("versamento_referente", $versamento_referente);*/
        
        #$res = $record->insert() or print($db->ErrorMsg());
        $res = Factory::salva($record);
        #$res = (strlen($record->id()) > 0) ? $record->update() : $record->insert();
        
        if ($res) {
            $ok_nuova_donazione = true;
            
            # Messaggio a chi dona
            $msg = "Grazie per contribuire al mantenimento di {$pelosetto['nome']}!";
            $msg_html = "<b>Grazie per contribuire al mantenimento di {$pelosetto['nome']}!</b>";
            send_mail("Adozione a distanza.", $utente->email, $msg, $msg_html);
            
            # Messaggio al canile
            if (strlen($canile['email'])) {
                $msg = "{$utente->nominativo} si e' preso l'impegno di contribuire al mantenimento di {$pelosetto['nome']}!";
                $msg_html = "<b>{$msg}</b>";
                send_mail("Adozione a distanza.", $canile['email'], $msg, $msg_html);
            }
            
            # Messaggio al referente
            if (strlen($record->get("versamento_referente")) > 0) {
                $sql = "SELECT * FROM iscritti WHERE username='{$record->get("versamento_referente")}'";
                $rs = $db->Esegui($sql);
                $row = $rs->FetchRow();
                
                $referente_email = $row['email'];
                $referente_nome = $row['cognome']." ".$row['nome'];
                switch ($record->get('versamento_tipo')) {
                    case 'A':
                        $versamento_tipo = "annuale";
                        break;
                    case 'B':
                        $versamento_tipo = "bimestrale";
                        break;
                    case 'M':
                        $versamento_tipo = "mensile";
                        break;
                    case 'U':
                        $versamento_tipo = "unico";
                        break;
                }
                $info_canile = "";
                if (strlen($canile['nome']))
                    $info_canile = "Canile: ".$canile['nome'];
                
                $msg = "Contributo al mantenimento di {$pelosetto['nome']}.\r\n
{$utente->nominativo} si e' preso l'impegno di contribuire al mantenimento di {$pelosetto['nome']} e ti ha selezionato come referente.\r\n
Per: {$pelosetto['nome']}\r\n

Importo versamento: {$record->get("importo_versamento")}\r\n
{$info_canile}
";
/*Cadenza dei versamenti: {$versamento_tipo}\r\n
Numero di versamenti: {$record->get("numero_versamenti")}\r\n*/
                $msg_html = "<b>Contributo al mantenimento di {$pelosetto['nome']}.\r\n
{$utente->nominativo} si e' preso l'impegno di contribuire al mantenimento di {$pelosetto['nome']} e ti ha selezionato come referente.<br>
Per: {$pelosetto['nome']}<br>
Importo versamento: {$record->get("importo_versamento")}<br>
{$info_canile}</b>
";
/*Cadenza dei versamenti: {$versamento_tipo}<br>
Numero di versamenti: {$record->get("numero_versamenti")}<br>
*/
                send_mail("Adozione a distanza.", $referente_email, $msg, $msg_html);
            }
        }
    }
}

?>

<?php
if (!$errore && $ok_nuova_donazione) {
    echo <<<EOT
<form action="page-gallery.php" method="POST">
    <div id="message" class="updated fade"><p><strong>Adozione avvenuta con successo.</strong></p></div>
    <button type="submit" class="mybutton">OK</button>
</form>
EOT;
}
 
    
if (!$ok_nuova_donazione) {

?>

<form method="GET" action="<?php echo $history->indietro(); ?>">
    <button type="submit" class="mybutton">Indietro</button>
</form>

<br />

<h1 class="titolo_pagina">Nuova adozione a distanza</h1>

<form method="POST" action="<?php $permalink; ?>" id="form_nuova_donazione" name="form_nuova_donazione">

    <table class="mytable">
    <tr>
        <th><label>Cognome e nome</label></th>
        <td><?php echo $utente->cognome; ?> <?php echo $utente->nome; ?></td>
    </tr>
    
    <tr>
        <th><label for="email">Email</label></th>
        <td><?php echo $utente->email; ?><input type="hidden" value="<?php echo $utente->code; ?>" name="code_utente" id="code_utente" /></td>
    </tr>
    
    <tr>
        <th><label for="pelosetto">Pelosetto</label></th>
        <td>
<?php 
echo "<div style='font-size:1.5em; color:orange;'>".$pelosetto['nome']."</div>"; 
# ----- CANILE -----------------------------------------------------------------------------------
if (strlen($pelosetto['code_canile']) > 0) {
    $indirizzo = (strlen($canile['indirizzo'])) ? $canile['indirizzo']."," : "";
    $localita = (strlen($canile['localita'])) ? "localit&agrave; ".$canile['localita']."," : "";
    echo <<<EOT
    <h3>{$canile['nome']}</h3>
    <p>{$indirizzo} {$localita} {$canile['comune']} - {$canile['regione']}<br />
        <a href="{$canile['url_www']}" target="_blanc">{$canile['url_www']}</a>
    </p>
EOT;
}
?>
        </td>
    </tr>

    <tr>
        <th><label for="versamento_tipo">Importo versamento</label></th>
        <td><div class="row">
            <!--div class="one third">
                <label for="versamento_tipo">Cadenza</label>
                <select name="versamento_tipo" id="versamento_tipo">
                    <option value="A" <?php selected( 'A', $record->get('versamento_tipo'), true); ?>>Annuale</option>
                    <option value="B" <?php selected( 'B', $record->get('versamento_tipo'), true); ?>>Bimestrale</option>
                    <option value="M" <?php selected( 'M', $record->get('versamento_tipo'), true); ?>>Mensile</option>
                    <option value="M" <?php selected( 'U', $record->get('versamento_tipo'), true); ?>>Unico</option>
                </select>
            </div>
            <div class="one third">
                <label for="numero_versamenti">Numero versamenti</label>
                <input type="text" value="<?php echo $record->get('numero_versamenti'); ?>" size="5" name="numero_versamenti" id="numero_versamenti" />
            </div-->
            <div class="one third">
                <!--label for="importo_versamento">Importo</label-->
                <input type="text" value="<?php echo $record->get('importo_versamento'); ?>" size="5" name="importo_versamento" id="importo_versamento" />
                <input type="hidden" value="1" name="numero_versamenti" id="numero_versamenti" />
                <input type="hidden" value="U" name="versamento_tipo" id="versamento_tipo" />
            </div>
        </div></td>
    </tr>

    <!--tr>
        <th><label for="versamento_tipo">Tipo versamenti</label></th>
        <td><select name="versamento_tipo" id="versamento_tipo">
                <option value="A" <?php selected( 'A', $record->get('versamento_tipo'), true); ?>>Annuale</option>
                <option value="B" <?php selected( 'B', $record->get('versamento_tipo'), true); ?>>Bimestrale</option>
                <option value="M" <?php selected( 'M', $record->get('versamento_tipo'), true); ?>>Mensile</option>
            </select>
        </td>
    </tr>

    <tr>
        <th><label for="numero_versamenti">Numero versamenti</label></th>
        <td><input type="text" value="<?php echo $record->get('numero_versamenti'); ?>" size="5" name="numero_versamenti" id="numero_versamenti" /></td>
    </tr>

    <tr>
        <th><label for="importo_versamento">Importo</label></th>
        <td><input type="text" value="<?php echo $record->get('importo_versamento'); ?>" size="5" name="importo_versamento" id="importo_versamento" /></td>
    </tr-->

    <!--tr>
        <td><label for="versamento_modo">Modalit&agrave; di versamento</label></td>
        <td><select name="versamento_modo" id="versamento_modo">
                <option value="D" <?php #selected( 'D', $versamento_modo, true); ?>>Diretto</option>
                <option value="I" <?php #selected( 'I', $versamento_modo, true); ?>>Indiretto</option>
            </select>
        </td>
    </tr-->

    <tr>
        <th><label for="versamento_modo">Modalit&agrave; di versamento</label></th>
        <td>
            <script>
            function change_VersamentoModo(o) {
                var refer = document.getElementById("versamento_referente");
                var url_iban = document.getElementById("url_coordinate_bancarie");
                if (o == 'I') {
                    refer.disabled  = false;
                    url_coordinate_bancarie.style.visibility = "hidden";
                }
                else if (o == 'D') {
                    refer.value = '';
                    refer.disabled  = true;
                    url_coordinate_bancarie.style.visibility = "visible";
                }
                else {
                    refer.value = '';
                    refer.disabled  = true;
                    url_coordinate_bancarie.style.visibility = "hidden";
                }
            }
            </script>
            <input type="radio" name="versamento_modo" value="D" <?php checked( 'D', $record->get('versamento_modo'), true); ?> onchange="change_VersamentoModo('D');">Diretto (tramite sito canile) 
            <a id="url_coordinate_bancarie" style="visibility:hidden;" href="<?php echo $canile['url_coordinate_bancarie']; ?>" target="_blanc"><?php echo $canile['url_coordinate_bancarie']; ?></a>
            <br>
            <input type="radio" name="versamento_modo" value="I" <?php checked( 'I', $record->get('versamento_modo'), true); ?> onchange="change_VersamentoModo('I');">Indiretto tramite 
            <select name="versamento_referente" id="versamento_referente">
                <option value="" <?php selected( '', $record->get('versamento_referente'), true); ?>></option>
<?php
foreach($referenti as $item) {
?>
                <option value="<?php echo $item['username']; ?>" <?php selected($item['username'], $record->get('versamento_referente'), true); ?>><?php echo $item['nominativo']; ?></option>
<?php
}
?>
            </select>
        </td>
    </tr>

    <tr>
        <th><label for="motivazione">Motivazione</label></th>
        <td><textarea rows="5" cols="50" name="motivazione" id="motivazione"><?php echo $record->get('motivazione'); ?></textarea></td>
    </tr>
    
    <tr>
        <th><label for="info">Cosa vuoi sapere sul pelosetto</label></th>
        <td><textarea rows="5" cols="50" name="info" id="info"><?php echo $record->get('info'); ?></textarea></td>
    </tr>

    </table>
    <input type="hidden" name="ok_nuova_donazione" value="1" />
    <input type="hidden" value="<?php echo $pelosetto['code']; ?>" name="code_pelosetto" id="code_pelosetto" />
    <input type="hidden" value="<?php echo $pelosetto['code']; ?>" name="code_pet" id="code_pet" />
    <button type="submit" class="mybutton">Salva</button>
</form>

<script>
window.onload=function(){
    //o = document.getElementById("versamento_modo");
    o = $('input[name=versamento_modo]').value;
    change_VersamentoModo(o);
    
};
</script>
<?php 
}

get_footer(); 
?>