<?php
/**
 * Template Name: Form nuovo iscritto
 */

require_once('common.inc.php');
get_header();

if (isset($_SESSION["FACEBOOK"])) {
    #print_r($_SESSION["FACEBOOK"]);
}

$ok_nuovo_iscritto = false;
#$url_after = getVar("POST", "url");
$errore = false;

class RecordIscrizioni extends RecordBase {}
$record = new RecordIscrizioni("iscritti", "ident");

if( 'POST' == $_SERVER['REQUEST_METHOD'] && !empty( $_POST['ok_nuova_iscrizione'] ) &&  $_POST['ok_nuova_iscrizione'] == "1") {
    $record->loadInput();
    
    $username2 = getVar("POST", "username2");
    $password2 = getVar("POST", "password2");
    $email2 = getVar("POST", "email2");
    
    #print_r($record);
    
    # CHECK
    if (
        strlen($record->get('cognome')) == 0 ||
        strlen($record->get('nome')) == 0 ||
        strlen($record->get('username')) == 0 ||
        strlen($record->get('email')) == 0 ||
        strlen($record->get('password')) == 0 ||
        strlen($record->get('comune')) == 0) {  #comune_codice
        $errore = true;
        show_message(MSGERROR, "E' necessario valorizzare tutti i campi!", false);
    } 
    else {
        if ($password2 != $record->get('password')) {
            $errore = true;
            show_message(MSGERROR, "Le password inserite non coincidono.", false);
        }
        if ($username2 != $record->get('username')) {
            $errore = true;
            show_message(MSGERROR, "Gli username inseriti non coincidono.", false);
        }
        else {
            if (!check_username($record->get('username'))) {
                $errore = true;
                show_message(MSGERROR, "Lo username indicato esiste gi&agrave;.", false);
            }
        }
        if ($email2 != $record->get('email')) {
            $errore = true;
            show_message(MSGERROR, "Le email inserite non coincidono.", false);
        }
        elseif (!IsValidMail($record->get('email'))) {
            $errore = true;
            show_message(MSGERROR, "Le email inserite non sono valide.", false);
        }
        else {
            if (!check_email($record->get('email'))) {
                $errore = true;
                show_message(MSGERROR, "L'email indicata &egrave; gi&agrave; presente.", false);
            }
        }
    }
    
    if(!$errore) {
        if (isset($_SESSION["FACEBOOK"])) {
            $record->set('url_after', $url_after);
            $record->set('tabella', "iscritti");
            $record->set('valido', "1");
            $record->set('validato', '1');
            $res = $record->insert() or print($db->ErrorMsg());
            
            try_login(array('fb_id' => "{$record->get('fb_id')}"));
            
            if ($res) {
                $site_url = (strlen($url_after)) ? $url_after : "index.php";
                echo <<<EOT
<form action="{$site_url}" method="POST">
    <div id="message" class="updated fade"><p><strong>Registrazione avvenuta con successo.</strong></p>
    </div>
    <button type="submit" class="mybutton">OK</button>
</form>
EOT;
                get_footer();
                send_mail("Iscrizione ad Amici di Giulita", $record->get('email'), "Grazie per esserti registrato!", "Grazie per esserti registrato!");
                $msg = <<<EOT
Si e' registrato {$record->get("nome")} {$record->get("cognome")}.\r\n
Email: {$record->get("email")}\r\n
Comune: {$record->get("comune")} 
EOT;
                send_mail(
                    "Iscrizione ad Amici di Giulita", 
                    "staff@amicidigiulita.it", 
                    $msg, 
                    $msg);
                exit();
            }
        }
        else {
            $codice_verifica = md5(microtime());
            $record->set('codice_verifica', $codice_verifica);
            $record->set('url_after', $url_after);
            $record->set('valido', 0);
            $record->set('validato', '0');
            $record->set('tabella', "iscritti");
            $res = $record->insert() or print($db->ErrorMsg());
        }
        
        if ($res) {
            $ok_nuovo_iscritto = true;
            
            $BASE_URL = BASE_URL;
            
            // invio la mail per la conferma
            $msg = "Grazie per esserti registrato!\n\r
Per confermare la tua registrazione clicca sul link sotto:\n\r
\n\r
{$BASE_URL}page-verifica-login.php?code={$codice_verifica}";

            $msg_html =<<<EOT
<h3 style="color:red;">Grazie per esserti registrato!</h3>
<p>Per confermare la tua registrazione clicca sul link sotto:</p>

<p><a href="{$BASE_URL}page-verifica-login.php?code={$codice_verifica}">Conferma iscrizione Amici di Giulita</a></p>


EOT;
            send_mail("Iscrizione ad Amici di Giulita", $record->get('email'), $msg, $msg_html);
        }
    }
}

if (!$errore && $ok_nuovo_iscritto) {
    echo <<<EOT
<form action="/" method="POST">
    <div id="message" class="updated fade"><p><strong>Registrazione avvenuta con successo.</strong></p>
    <p>Ti abbiamo inviato una email all'indirizzo indicato: leggila e clicca sul link che troverai per abilitare il tuo account.</p>
    </div>
    <button type="submit" class="mybutton">OK</button>
</form>
EOT;
}
 
    
if (!$ok_nuovo_iscritto) {

?>

<script>
jQuery(document).ready(function() {
    
});
</script>

<h1 class="titolo_pagina">Diventa amico di Giulita</h1>

<form method="POST" action="<?php $permalink; ?>" id="form_nuova_iscrizione" name="form_nuova_iscrizione">

    <table class="mytable">
<?php
if (!isset($_SESSION["FACEBOOK"])) {
?>
    <tr>
        <th><label for="cognome">Cognome</label></th>
        <td><input type="text" value="<?php echo $record->get('cognome'); ?>" size="20" name="cognome" id="cognome" /></td>
    </tr>

    <tr>
        <th><label for="nome">Nome</label></th>
        <td><input type="text" value="<?php echo $record->get('nome'); ?>" size="20" name="nome" id="nome" /></td>
    </tr>
    
    <tr>
        <th><label for="sesso">Sesso</label></th>
        <td><select name="sesso" id="sesso">
                <option value="M" <?php selected($record->get("sesso"), 'M'); ?>>maschio</option>
                <option value="F" <?php selected($record->get("sesso"), 'F'); ?>>femmina</option>
            </select></td>
    </tr>
    
    <tr>
        <th><label for="username">Username</label></th>
        <td><input type="text" value="<?php echo $record->get('username'); ?>" size="30" name="username" id="username" /></td>
    </tr>
    
    <tr>
        <th><label for="username2">Verifica Username</label></th>
        <td><input type="text" value="<?php echo $username2; ?>" size="30" name="username2" id="username2" style="background:#EEE;" /></td>
    </tr>
    
    <tr>
        <th><label for="password">Password</label></th>
        <td><input type="password" value="<?php echo $record->get('password'); ?>" size="15" name="password" id="password" /></td>
    </tr>
    
    <tr>
        <th><label for="password2">Verifica Password</label></th>
        <td><input type="password" value="<?php echo $password2; ?>" size="15" name="password2" id="password2" style="background:#EEE;" /></td>
    </tr>
<?php
}
else {
    $_SESSION["FACEBOOK"]["gender"] = strtoupper(substr($_SESSION["FACEBOOK"]["gender"], 0, 1));
    echo <<<EOT
    <input type="hidden" name="facebook" value="1" />
    <input type="hidden" name="cognome" value="{$_SESSION["FACEBOOK"]["last_name"]}" />
    <input type="hidden" name="nome" value="{$_SESSION["FACEBOOK"]["first_name"]}" />
    <input type="hidden" name="username" value="{$_SESSION["FACEBOOK"]["id"]}" />
    <input type="hidden" name="username2" value="{$_SESSION["FACEBOOK"]["id"]}" />
    <input type="hidden" name="fb_id" value="{$_SESSION["FACEBOOK"]["id"]}" />
    <input type="hidden" name="password" value="01234567890" />
    <input type="hidden" name="password2" value="01234567890" />
    <input type="hidden" name="sesso" value="{$_SESSION["FACEBOOK"]["gender"]}" />
EOT;
}

if (!isset($_SESSION["FACEBOOK"]["email"])) {
?>    
    <tr>
        <th><label for="email">Email</label></th>
        <td><input type="text" value="<?php echo $record->get('email'); ?>" size="40" name="email" id="email" /></td>
    </tr>
    
    <tr>
        <th><label for="email2">Verifica Email</label></th>
        <td><input type="text" value="<?php echo $email2; ?>" size="40" name="email2" id="email2" style="background:#EEE;" /></td>
    </tr>
<?php
}
else {
    echo <<<EOT
    <input type="hidden" name="email" value="{$_SESSION["FACEBOOK"]["email"]}" />
    <input type="hidden" name="email2" value="{$_SESSION["FACEBOOK"]["email"]}" />
EOT;
}
?> 
    
    <tr>
        <th><label for="comune">Comune</label></th>
        <td>
            <?php /*$utils->search_city("comune_codice", $record->get("comune_codice"), "comune", $record->get("comune"), "provincia", $record->get("provincia"));*/ ?>
                        
            <input type="text" value="" size="50" name="comune" id="comune" />
            <input type="hidden" value="IT" size="4" name="provincia" id="provincia" />
            <input type="hidden" value="-" size="10" name="comune_codice" id="comune_codice" readonly="readonly" /> 
        </td>
    </tr>
    
    <tr>
        <th><label for="diccisudite">Dicci qualcosa su di te</label></th>
        <td><textarea name="diccisudite" id="diccisudite" rows="5" cols="50"><?php echo $record->get('diccisudite'); ?></textarea></td>
    </tr>

    </table>
    <input type="hidden" name="ok_nuova_iscrizione" value="1" />
    <input type="hidden" name="url" value="<?php echo $url_after; ?>" />
    <button type="submit" class="mybutton">Salva</button>
</form>
<?php 
}

get_footer(); 
?>