<?php
/**
 * Template Name: Form pelosetto
 */

require_once('common.inc.php');
get_header();
check_publisher();

#----- CANILI --------------------------------------------------------------------------------------------------------------------
$sql = "SELECT *
        FROM vw_anagrafiche 
        WHERE tipo='CANILE'";
$rs = $db->Esegui($sql);
$canili = $rs->GetArray();

$ok_pelosetto = false;
$errore = false;

$record = Factory::crea("Pelosetto");

$code_pelosetto = getVar("GET", 'pelosetto', getVar("POST", 'code_pelosetto', ''));
if(strlen($code_pelosetto)) {
    $record->loadFromCode($code_pelosetto);
}

if( 'POST' == $_SERVER['REQUEST_METHOD'] && !empty( $_POST['ok_pelosetto'] ) &&  $_POST['ok_pelosetto'] == "1") {
    $record->loadInput();
    
    for ($i=1; $i<=5; $i++) {
        $nome_campo = "foto".$i;
        $path_base = BASE_DIR;
        $path_rel = "/uploads/pelosetti/";
        $name = upload_image($nome_campo, $path_base, $path_rel, "PELOSETTO_");
        if ($name !== false) {
            error_log($nome_campo." - ".$path_rel.$name);
            $record->set($nome_campo, $path_rel.$name);
        }
        /*if (is_uploaded_file($_FILES[$nome_campo]['tmp_name'])) {
            $originale = basename($_FILES[$nome_campo]['tmp_name']);
            $path_parts = pathinfo($_FILES[$nome_campo]['name']);
            $extension = strtoupper($path_parts['extension']);

            if (!in_array($extension, array('PNG', 'JPG'))) {
                $errore = true;
                show_message(MSGERROR, "Formato file foto {$i} non permesso!", false);
            }

            if (strlen($originale)) {
                $tipo = $_FILES[$nome_campo]['type'];
                $name = "PELOSETTO_".substr(md5($originale), 0, 8)."__".$_FILES[$nome_campo]['name'];
                $res = move_uploaded_file($_FILES[$nome_campo]['tmp_name'], $path_base.$path_rel.$name);
                if ($res) {
                    error_log($nome_campo." - ".$path_rel.$name);
                    $record->set($nome_campo, $path_rel.$name);
                }
                else{
                    $errore = true;
                    show_message(MSGERROR, "Upload foto {$i} fallito! (1)", false);
                }
            }
        }
        elseif (strlen(basename($_FILES[$nome_campo]['tmp_name'])) > 0) {
            $errore = true;
            show_message(MSGERROR, "Upload foto {$i} fallito! (2)", false);
        }*/
    }
    
    $nome_campo = "adozione_foto";
    $path_base = BASE_DIR;
    $path_rel = "/uploads/pelosetti/";
    $name = upload_image($nome_campo, $path_base, $path_rel, "PELOSETTO_");
    if ($name !== false) {
        error_log($nome_campo." - ".$path_rel.$name);
        $record->set($nome_campo, $path_rel.$name);
    }
    
    # CHECK
    if (strlen($record->get('stallo_altro_riferimento')) > 0 && strlen($record->get('stallo_comune_codice')) == 0) {
        $errore = true;
        show_message(MSGERROR, "Se si indica un referente per lo stallo &egrave; necessario indicare anche il comune.", false);
    }
    
    
    if( !$errore ) {
        $res = Factory::salva($record);
        
        if ($res) {
            $ok_pelosetto = true;
        }
    }
}

if (!$errore && $ok_pelosetto) {
    echo <<<EOT
<form action="indietro.php" method="GET">
    <div id="message" class="updated fade"><p><strong>Pelosetto salvato con successo.</strong></p></div>
    <button type="submit" class="mybutton">OK</button>
</form>
EOT;
}
    
if (!$ok_pelosetto) {
?>

<script>
jQuery(document).ready(function() {
    jQuery( "#nascita_data" ).datepicker({dateFormat : 'dd/mm/yy'});
    jQuery( "#adozione_data" ).datepicker({dateFormat : 'dd/mm/yy'});
    $("#carattere_descrizione").wysiwyg({
        rmUnusedControls: false,
        controls: {
            increaseFontSize : { visible : true },
			decreaseFontSize : { visible : true },
			cut   : { visible : true },
			copy  : { visible : true },
			paste : { visible : true },
			html  : { visible: true },
			colorpicker: {
                visible: true,
                css: {
                    "color": function (cssValue, Wysiwyg) {
                        var document = Wysiwyg.innerDocument(),
                            defaultTextareaColor = $(document.body).css("color");

                        if (cssValue !== defaultTextareaColor) {
                            return true;
                        }

                        return false;
                    }
                },
                exec: function() {
                    if ($.wysiwyg.controls.colorpicker) {
                        $.wysiwyg.controls.colorpicker.init(this);
                    }
                },
                tooltip: "Colorpicker"
            },
					
        }
    });
});
</script>



<form method="GET" action="indietro.php">
    <button type="submit" class="mybutton">Indietro</button>
</form><br>

<h1 class="titolo_pagina">Pelosetto</h1>

<form method="POST" action="<?php $permalink; ?>" id="form_nuovo_pelosetto" name="form_nuovo_pelosetto" enctype="multipart/form-data">

    <table class="mytable">
    
    <tr>
        <th><label for="flag_stato">Stato</label></th>
        <td><select name="flag_stato" id="flag_stato">
                <option value="disponibile" <?php selected($record->get("flag_stato"), 'disponibile'); ?>>disponibile</option>
                <option value="non disponibile" <?php selected($record->get("flag_stato"), 'non disponibile'); ?>>non disponibile</option>
                <option value="adottato" <?php selected($record->get("flag_stato"), 'adottato'); ?>>adottato</option>
                <option value="deceduto" <?php selected($record->get("flag_stato"), 'deceduto'); ?>>deceduto</option>
            </select>
        </td>
    </tr>
    
    <tr>
        <th><label for="flag_urgente">Urgente</label></th>
        <td><select name="flag_urgente" id="flag_urgente">
                <option value="N" <?php selected($record->get("flag_urgente"), 'N'); ?>>no</option>
                <option value="S" <?php selected($record->get("flag_urgente"), 'S'); ?>>si</option>
            </select>
    </tr>
    
    <tr>
        <th><label for="nome">Nome</label></th>
        <td><input type="text" value="<?php echo $record->get("nome"); ?>" size="30" name="nome" id="nome" /></td>
    </tr>
    
    <tr>
        <th><label for="">Nascita</label></th>
        <td><div class="row">
            <div class="one third ">
                <label for="nascita_anno">Anno</label>
                <input type="text" value="<?php echo $record->get("nascita_anno"); ?>" size="5" name="nascita_anno" id="nascita_anno" />
            </div>
            
            <div class="one third ">
                <label for="nascita_data">Data</label>
                <input type="text" value="<?php echo date_translate($record->get("nascita_data"), 'us', 'it'); ?>" size="12" name="nascita_data" id="nascita_data" />
            </div>
            
            <div class="one third ">
                <label for="provenienza">Provenienza</label>
                <input type="text" value="<?php echo $record->get("provenienza"); ?>" size="50" name="provenienza" id="provenienza" />
            </div>
        </div></td>
    </tr>
    
    <tr>
        <th><label for="">Specie e genere</label></th>
        <td><div class="row">
            <div class="one half mobile">
                <label for="specie">Specie</label>
                <select name="specie" id="specie">
                    <option value="cane" <?php selected($record->get("specie"), 'cane'); ?>>cane</option>
                    <option value="gatto" <?php selected($record->get("specie"), 'gatto'); ?>>gatto</option>
                </select>
            </div>
            
            <div class="one half mobile">
                <label for="genere">Genere</label>
                <select name="genere" id="genere">
                    <option value="M" <?php selected($record->get("genere"), 'M'); ?>>maschio</option>
                    <option value="F" <?php selected($record->get("genere"), 'F'); ?>>femmina</option>
                </select>
            </div>
        </div></td>
    </tr>
    
    <tr>
        <th><label for="foto1">Foto principale</label></th>
        <td><input type="file" value="" size="15" name="foto1" id="foto1" />
        <?php
        if (strlen($record->get("foto1")))
            echo "<img src='{$record->get("foto1")}' height='50px' />";
        ?>
        </td>
    </tr>
    
    <tr>
        <th><label for="foto2">Foto 2</label></th>
        <td><input type="file" value="" size="15" name="foto2" id="foto2" />
        <?php
        if (strlen($record->get("foto2")))
            echo "<img src='{$record->get("foto2")}' height='50px' />";
        ?>
        </td>
    </tr>
    
    <tr>
        <th><label for="foto3">Foto 3</label></th>
        <td><input type="file" value="" size="15" name="foto3" id="foto3" />
        <?php
        if (strlen($record->get("foto3")))
            echo "<img src='{$record->get("foto3")}' height='50px' />";
        ?>
        </td>
    </tr>
    
    <tr>
        <th><label for="foto4">Foto 4</label></th>
        <td><input type="file" value="" size="15" name="foto4" id="foto4" />
        <?php
        if (strlen($record->get("foto4")))
            echo "<img src='{$record->get("foto4")}' height='50px' />";
        ?>
        </td>
    </tr>
    
    <tr>
        <th><label for="foto5">Foto 5</label></th>
        <td><input type="file" value="" size="15" name="foto5" id="foto5" />
        <?php
        if (strlen($record->get("foto5")))
            echo "<img src='{$record->get("foto5")}' height='50px' />";
        ?>
        </td>
    </tr>
    
    <tr>
        <th><label for="code_canile">Attualmente presso</label></th>
        <td>
            <fieldset>
                <legend>Canile o struttura:</legend>
                <select name="code_canile" id="code_canile">
                    <option value=""></option>
                    <?php
                    foreach($canili as $item) {
                        $canile_denominazione = $item['nome']." - ".$item['comune'];
                        $selected = selected($record->get("code_canile"), $item['code'], false);
                        echo "<option value='{$item['code']}' {$selected}>{$canile_denominazione}</option>";
                    }
                    ?>
                </select>
            </fieldset>
            
            <fieldset>
                <legend>oppure in stallo presso un utente registrato:</legend>
                
                l'utente 
                <input type="text" name="stallo_username" id="stallo_username" value="<?php echo $record->get("stallo_username"); ?>" />
                
            </fieldset>
            
            <fieldset>
                <legend>oppure in stallo presso un utente NON registrato:</legend>
                
                Riferimento
                <input type="text" name="stallo_altro_riferimento" id="stallo_altro_riferimento" value="<?php echo $record->get("stallo_altro_riferimento"); ?>" />
                Comune
                <?php $utils->search_city("stallo_comune_codice", $record->get("stallo_comune_codice"), "stallo_comune", $record->get("stallo_comune"), "stallo_provincia", $record->get("stallo_provincia")); ?>
                
                
            </fieldset>
            
            Note sullo stallo
            <textarea type="text" rows="5" cols="50" name="stallo_note" id="stallo_note"><?php echo $record->get("stallo_note"); ?></textarea>
        </td>
    </tr>
    
    
    

    <tr>
        <th><label for="razza">Razza</label></th>
        <td><select name="razza" id="razza">
                <option value="N" <?php selected($record->get("razza"), 'N'); ?>>no</option>
                <option value="S" <?php selected($record->get("razza"), 'S'); ?>>si</option>
            </select></td>
    </tr>
    
    <tr>
        <th><label for="razza_principale">Razza principale</label></th>
        <td><input type="text" value="<?php echo $record->get("razza_principale"); ?>" size="50" name="razza_principale" id="razza_principale" /></td>
    </tr>
    
    <tr>
        <th><label for="razza_secondaria">Razza secondaria</label></th>
        <td><input type="text" value="<?php echo $record->get("razza_secondaria"); ?>" size="50" name="razza_secondaria" id="razza_secondaria" /></td>
    </tr>

    <tr>
        <th><label for="taglia">Taglia</label></th>
        <td><select name="taglia" id="taglia">
                <option value="P" <?php selected($record->get("taglia"), 'P'); ?>>piccola</option>
                <option value="M" <?php selected($record->get("taglia"), 'M'); ?>>media</option>
                <option value="G" <?php selected($record->get("taglia"), 'G'); ?>>grande</option>
            </select></td>
    </tr>
    
    <tr>
        <th><label for="mantello">Mantello</label></th>
        <td><input type="text" value="<?php echo $record->get("mantello"); ?>" size="50" name="mantello" id="mantello" /></td>
    </tr>

    <tr>
        <th><label for="pelo">Pelo</label></th>
        <td><select name="pelo" id="pelo">
                <option value="C" <?php selected($record->get("pelo"), 'C'); ?>>corto</option>
                <option value="M" <?php selected($record->get("pelo"), 'M'); ?>>medio-lungo</option>
                <option value="L" <?php selected($record->get("pelo"), 'L'); ?>>lungo</option>
            </select></td>
    </tr>
    
    <tr>
        <th><label for="sterilizzato">Sterilizzato</label></th>
        <td><select name="sterilizzato" id="sterilizzato">
                <option value="N" <?php selected($record->get("sterilizzato"), 'N'); ?>>no</option>
                <option value="S" <?php selected($record->get("sterilizzato"), 'S'); ?>>si</option>
            </select></td>
    </tr>

    <tr>
        <th><label for="carattere_descrizione">Descrizione</label></th>
        <td><textarea type="text" rows="5" cols="50" name="carattere_descrizione" id="carattere_descrizione"><?php echo $record->get("carattere_descrizione"); ?></textarea></td>
    </tr>
    
    <tr>
        <th><label for="carattere_dominante">Carattere dominante</label></th>
        <td><select name="carattere_dominante" id="carattere_dominante">
                <option value="N" <?php selected($record->get("carattere_dominante"), 'N'); ?>>no</option>
                <option value="S" <?php selected($record->get("carattere_dominante"), 'S'); ?>>si</option>
            </select></td>
    </tr>
    
    <tr>
        <th><label for="carattere_socevole">Socievole con</label></th>
        <td><textarea type="text" rows="5" cols="50" name="carattere_socevole" id="carattere_socevole"><?php echo $record->get("carattere_socevole"); ?></textarea></td>
    </tr>
  
    <tr>
        <th><label for="patologie">Patologie</label></th>
        <td><select name="patologie" id="patologie">
                <option value="N" <?php selected($record->get("patologie"), 'N'); ?>>no</option>
                <option value="S" <?php selected($record->get("patologie"), 'S'); ?>>si</option>
            </select><br />
            <textarea type="text" rows="5" cols="50" name="patologie_note" id="patologie_note"><?php echo $record->get("patologie_note"); ?></textarea></td>
    </tr>

    <tr>
        <th><label for="terapie">Terapie</label></th>
        <td><select name="terapie" id="terapie">
                <option value="N" <?php selected($record->get("terapie"), 'N'); ?>>no</option>
                <option value="S" <?php selected($record->get("terapie"), 'S'); ?>>si</option>
            </select><br />
            <textarea type="text" rows="5" cols="50" name="terapie_note" id="terapie_note"><?php echo $record->get("terapie_note"); ?></textarea></td>
    </tr>

    <tr>
        <th><label for="vaccinazioni">Vaccinazioni</label></th>
        <td><select name="vaccinazioni" id="vaccinazioni">
                <option value="N" <?php selected($record->get("vaccinazioni"), 'N'); ?>>no</option>
                <option value="S" <?php selected($record->get("vaccinazioni"), 'S'); ?>>si</option>
            </select><br />
            <textarea type="text" rows="5" cols="50" name="vaccinazioni_note" id="vaccinazioni_note"><?php echo $record->get("vaccinazioni_note"); ?></textarea></td>
    </tr>

    <tr>
        <th><label for="microchip">Microchip/Tatuaggio</label></th>
        <td><div class="row">
            <div class="one half half-padded"><input type="text" value="<?php echo $record->get("microcip"); ?>" placeholder="microcip" name="microcip" id="microcip" /></div>
            <div class="one half half-padded"><input type="text" value="<?php echo $record->get("tatuaggio"); ?>" placeholder="tatuaggio" name="tatuaggio" id="tatuaggio" /></div>
        </div></td>
    </tr>

    <tr>
        <th><label for="segni_particolari">Segni particolari</label></th>
        <td><textarea type="text" rows="5" cols="50" name="segni_particolari" id="segni_particolari"><?php echo $record->get("segni_particolari"); ?></textarea></td>
    </tr>

    <tr>
        <th><label for="">Disponibile per</label></th>
        <td>
            <div class="row">
                <div class="one third half-padded">Adozione <select name="flag_adotta" id="flag_adotta">
                    <option value="S" <?php selected($record->get("flag_adotta"), 'S'); ?>>si</option>
                    <option value="N" <?php selected($record->get("flag_adotta"), 'N'); ?>>no</option>
                </select></div>
                <div class="one third half-padded">Adozione a distanza <select name="flag_adottadist" id="flag_adottadist">
                    <option value="N" <?php selected($record->get("flag_adottadist"), 'N'); ?>>no</option>
                    <option value="S" <?php selected($record->get("flag_adottadist"), 'S'); ?>>si</option>
                </select></div>
                <div class="one third half-padded">Stallo <select name="flag_stallo" id="flag_stallo">
                    <option value="N" <?php selected($record->get("flag_stallo"), 'N'); ?>>no</option>
                    <option value="S" <?php selected($record->get("flag_stallo"), 'S'); ?>>si</option>
                </select></div>
            </div>
        </td>
    </tr>
    
    <tr>
        <th><label for="">Se adottato</label></th>
        <td style="background: #FCA">
                <div class="row">
                    <label for="adozione_data">Data</label>
                    <input type="text" value="<?php echo date_translate($record->get("adozione_data"), 'us', 'it'); ?>" size="12" name="adozione_data" id="adozione_data" />
                </div>
                
                <div class="row">
                    <label for="adozione_foto">Foto</label>
                    <input type="file" value="" size="15" name="adozione_foto" id="adozione_foto" />
                    <?php
                    if (strlen($record->get("adozione_foto")))
                        echo "<img src='{$record->get("adozione_foto")}' height='50px' />";
                    ?>
                </div>
                
                <label for="adozione_descrizione">Descrizione</label>
                <textarea type="text" rows="5" cols="50" name="adozione_descrizione" id="adozione_descrizione"><?php echo $record->get("adozione_descrizione"); ?></textarea>
                
                <label for="adozione_username">Username utente che ha adottato</label>
                <input type="text" name="adozione_username" id="adozione_username" value="<?php echo $record->get("adozione_username"); ?>" />

        </td>
    </tr>
    
    </table>
    <input type="hidden" name="ok_pelosetto" value="1" />
    <input type="hidden" name="code_pelosetto" value="<?php echo $record->code(); ?>" />
    <input type="hidden" name="code_utente" value="<?php echo $utente->code; ?>" />
    <button type="submit" class="mybutton">Salva</button>
</form>
<?php 
}

get_footer(); ?>
