<?php
require_once('common.inc.php');
get_header();

$code_questionario = getVar("GET", "questionario");
$sessione = getVar("GET", "sessione", getVar("POST", "sessione"));
$errori = array();

#---------------------------------------------------------------------------------------------------------------------------------
# CHECK LOGIN
#---------------------------------------------------------------------------------------------------------------------------------
$permalink = get_permalink() ."?questionario={$code_questionario}&sessione={$sessione}";
check_login($permalink);
#---------------------------------------------------------------------------------------------------------------------------------

if (strlen($sessione) == 0) {
    $sql = "SELECT *
            FROM questionari_risposte
            WHERE code_questionario='{$code_questionario}'
            AND cu='{$utente->username}'";
    $rs = $db->Esegui($sql);

    if ($rs != FALSE) {
        $sessione = $rs->Fields("sessione");
    }
    
    if (strlen($sessione) == 0)
        $sessione = md5(microtime());
}

#----- QUESTIONARIO ------------------------------------------------------------------------------------------------------------
$sql = "SELECT *
        FROM questionari
        WHERE code='{$code_questionario}'";
$rs = $db->Esegui($sql);

$questionario = array();
if ($rs != FALSE) {
    $questionario = $rs->FetchRow();
}

#----- DOMANDE -----------------------------------------------------------------------------------------------------------------
$sql = "SELECT *
        FROM questionari_domande
        WHERE code_questionario='{$code_questionario}'
        ORDER BY ordine, ident";
$rs = $db->Esegui($sql);

$domande = array();
if ($rs != FALSE) {
    while (!$rs->EOF) {
        $code_domanda = $rs->Fields("code");
        $domande[$code_domanda] = $rs->FetchRow();
    }
}

#----- RISPOSTE DA SALVARE -----------------------------------------------------------------------------------------------------
if (getVar("POST", "ok_risposte", 0) > 0) {
    foreach ($domande as $key => $item) {
        $risposta = getVar("POST", $key);
        $code_risposta = getVar("POST", "risposta_".$key);
        
        if ($item["risposta_obbligatoria"] == 'S' && strlen($risposta) == 0)
            $errori[$key] = "Risposta obbligatoria: &egrave; necessario fornire una risposta.";
        
        if (!isset($errori[$key])) {
            $record = Factory::crea("QuestionarioRisposta");
            if (strlen($code_risposta) > 0)
                $record->loadFromCode($code_risposta);
            $record->set('code_questionario', $code_questionario);
            $record->set('code_domanda', $key);
            $record->set('risposta', $risposta);
            $record->set('sessione', $sessione);
            if (strlen($code_risposta) > 0) {
                $record->set('lu', $utente->username);
                $azione = "modificato";
            }
            else {
                $record->set('cu', $utente->username);
                $azione = "compilato";
            }
            $res = Factory::salva($record);
        }
    }
    
    if (count($errori) == 0) {
        $msg = "L'utente {$utente->nome} {$utente->cognome} ha {$azione} il questionario {$questionario['nome']}.";
        send_mail("Modulo/questionario", "staff@amicidigiulita.it", $msg, $msg);
        $site_url = get_site_url();
        echo <<<EOT
<form action="page-questionari.php" method="GET">
    <div id="message" class="updated fade"><p><strong>Questionario salvato con successo.</strong></p></div>
    <button type="submit">OK</button>
</form>
EOT;
        get_footer();
        exit();
    }
}

#----- RISPOSTE ----------------------------------------------------------------------------------------------------------------
$sql = "SELECT *
        FROM questionari_risposte
        WHERE code_questionario='{$code_questionario}'
        AND sessione='{$sessione}'";
$rs = $db->Esegui($sql);

$risposte = array();
if ($rs != FALSE) {
    while (!$rs->EOF) {
        $code_domanda = $rs->Fields("code_domanda");
        $risposte[$code_domanda] = $rs->FetchRow();
    }
}

#-------------------------------------------------------------------------------------------------------------------------------
$smarty->assign('questionario', $questionario);
$smarty->assign('domande', $domande);
$smarty->assign('risposte', $risposte);
$smarty->assign('sessione', $sessione);
$smarty->assign('errori', $errori);
$smarty->display('form-questionario.tpl');
?>
