<?php
/**
 * Template Name: Form raccolta disponibile
 */

require_once('common.inc.php');
get_header();

$code_raccolta = getVar("GET", "raccolta", getVar("POST", "code_raccolta", getVar("POST", "raccolta")));
$tipo = getVar("POST", "tipo", getVar("GET", "tipo", 'CANILE'));

#---------------------------------------------------------------------------------------------------------------------------------
# CHECK LOGIN
#---------------------------------------------------------------------------------------------------------------------------------
$permalink = get_permalink() ."?raccolta=".$code_raccolta;
check_login($permalink);

#----- NEGOZI --------------------------------------------------------------------------------------------------------------------
$sql = "select * from vw_anagrafiche WHERE tipo='NEGOZIO' ORDER BY nome";
$rs = $db->Esegui($sql);
$negozi = array();
if ($rs != false)
    $negozi = $rs->GetArray();

#----- CANILI --------------------------------------------------------------------------------------------------------------------
$sql = "select * from vw_anagrafiche WHERE tipo='CANILE' ORDER BY nome";
$rs = $db->Esegui($sql);
$canili = array();
if ($rs != false)
    $canili = $rs->GetArray();

#---------------------------------------------------------------------------------------------------------------------------------
$ok_raccolta = false;
$errore = false;

class RecordRaccolte extends RecordBase {
    
	public function __construct($id=null) {
        parent::__construct("raccolte", "ident", $id);
    }
}
$record = Factory::crea("RecordRaccolte");
if (strlen($code_raccolta) > 0)
    $record->loadFromCode($code_raccolta);

if( 'POST' == $_SERVER['REQUEST_METHOD'] && !empty( $_POST['ok_raccolta'] ) &&  $_POST['ok_raccolta'] == "1") {
    $record->loadInput();
    
    # CHECK
    if (strlen($record->get('code_negozio')) == 0) {
        $errore = true;
        show_message(MSGERROR, "E' necessario indicare un negozio.", false);
    }
    elseif (strlen($record->get('code_canile')) == 0) {
        $errore = true;
        show_message(MSGERROR, "E' necessario indicare un canile.", false);
    }
    
    if(!$errore) {
        $res = Factory::salva($record);
        
        if ($res) {
            $ok_raccolta = true;
        }
    }
}

if (!$errore && $ok_raccolta) {
    echo <<<EOT
<form action="page-raccolte-disponibili.php" method="POST">
    <div id="message" class="updated fade"><p><strong>Raccolta salvata con successo.</strong></p></div>
    <button type="submit" class="mybutton">OK</button>
</form>
EOT;
}
    
if (!$ok_raccolta) {
?>

<script>
jQuery(document).ready(function() {
    jQuery( "#data_fine" ).datepicker({dateFormat : 'yy-mm-dd'});
});
</script>


<form action="page-raccolte-disponibili.php" method="POST">
    <button type="submit" class="mybutton">Indietro</button>
</form>

<h1 class="titolo_pagina">Raccolta</h1>

<form method="POST" action="<?php $permalink; ?>" id="form_raccolta" name="form_raccolta">

    <table class="mytable">

    <tr>
        <td><label for="code_negozio">Negozio</label></td>
        <td><select name="code_negozio" id="code_negozio"><?php
                foreach ($negozi as $negozio) {
                    $code = $negozio['code'];
                    $value = $negozio['nome']." - ".$negozio['comune']."";
                    $selected = selected($record->get("code_negozio"), $code);
                    echo "<option value='{$code}' {$selected}>{$value}</option>";
                }
            ?></select></td>
    </tr>

    <tr>
        <td><label for="code_canile">Canile</label></td>
        <td><select name="code_canile" id="code_canile"><?php
                foreach ($canili as $canile) {
                    $code = $canile['code'];
                    $value = $canile['nome']." - ".$canile['comune']."";
                    $selected = selected($record->get("code_canile"), $code);
                    echo "<option value='{$code}' {$selected}>{$value}</option>";
                }
            ?></select></td>
    </tr>

    <tr>
        <td><label for="orario">Orario</label></td>
        <td><textarea type="text" rows="5" cols="50" name="orario" id="orario"><?php echo $record->get("orario"); ?></textarea></td>
    </tr>

    <tr>
        <td><label for="descrizione">Descrizione</label></td>
        <td><textarea type="text" rows="5" cols="50" name="descrizione" id="descrizione"><?php echo $record->get("descrizione"); ?></textarea></td>
    </tr>

    <tr>
        <td><label for="data_fine">Termine</label></td>
        <td><input type="text" value="<?php echo $record->get("data_fine"); ?>" size="10" name="data_fine" id="data_fine" /></td>
    </tr>

    </table>
    <input type="hidden" name="ok_raccolta" value="1" />
    <input type="hidden" name="code_raccolta" value="<?php echo $record->code(); ?>" />
    <input type="hidden" name="code_utente" value="<?php echo $utente->code; ?>" />
    <button class="mybutton" type="submit">Salva</button>
</form>

<?php 
}

get_footer(); 
?>