<?php
/**
 * Template Name: Form interesse al ritiro della raccolta.
 */

require_once('common.inc.php');
get_header();

$code_raccolta = getVar("POST", "raccolta", getVar("POST", "code_raccolta", getVar("GET", "raccolta")));

#---------------------------------------------------------------------------------------------------------------------------------
# CHECK LOGIN
#---------------------------------------------------------------------------------------------------------------------------------
$permalink = get_permalink() ."?raccolta=".$code_raccolta;
check_login($permalink);

#---------------------------------------------------------------------------------------------------------------------------------

#----- RACCOLTA ------------------------------------------------------------------------------------------------------------------
$sql = "SELECT r.*, 
        n.regione as negozio_regione, 
        n.comune as negozio_comune, 
        n.nome as negozio_nome, 
        n.indirizzo as negozio_indirizzo, 
        n.localita as negozio_localita, 
        c.regione as canile_regione, 
        c.comune as canile_comune, 
        c.nome as canile_nome, 
        c.indirizzo as canile_indirizzo,
        c.localita as canile_localita 
        FROM raccolte r
        JOIN anagrafiche n ON n.code=r.code_negozio
        JOIN anagrafiche c ON c.code=r.code_canile
        WHERE r.code='{$code_raccolta}'";
$rs = $db->Esegui($sql);
$item = array();
if ($rs != FALSE) {
    $item = $rs->FetchRow();
}
#---------------------------------------------------------------------------------------------------------------------------------

$ok_raccolta_interesse = false;
$error = false;

class RecordRaccolteInteressati extends RecordBase {
    
	public function __construct($id=null) {
        parent::__construct("raccolte_interessati", "ident", $id);
    }
}
$record = Factory::crea("RecordRaccolteInteressati");

if( 'POST' == $_SERVER['REQUEST_METHOD'] && !empty( $_POST['ok_raccolta_interesse'] ) &&  $_POST['ok_raccolta_interesse'] == "1") {
    $record->loadInput();
    
    # CHECK
    if (strlen($record->get('email')) == 0) {
        $error = true;
        show_message(MSGERROR, "E' necessario indicare una email per contattarti.", false);
    }
    
    if( !$error ) {
        $res = Factory::salva($record);
        
        if ($res) {
            $ok_raccolta_interesse = true;
            
            // invio la mail per la conferma
            $msg = "Grazie per il tuo interessamento!";
            $msg_html = "<b>Grazie per il tuo interessamento!</b>";
            send_mail("Interessamento alla consegna di una raccolta.", $record->get('email'), $msg, $msg_html);
            
            $code_raccolta = $record->get('code_raccolta');
            $sql = "SELECT * FROM raccolte t JOIN iscritti i ON i.code=t.code_utente WHERE t.code='{$code_raccolta}'";
            $rs = $db->Esegui($sql);
            $row = $rs->FetchRow();
            
            $negozio = $item['negozio_nome'];
            $canile = $item['canile_nome'];
            $email = $record->get("email");
            $telefono = $record->get("telefono");
            
            $msg = <<<EOT
Ciao, sono {$utente->nominativo}.\r\n
Sono interessato alla consegna di una raccolta presso il negozio {$negozio} per il canile {$canile}.\r\n
Puoi contattarmi:\r\n
- email: {$email}\r\n
- telefono: {$telefono}\r\n

Aspetto tue indicazioni.
EOT;
            $msg_html = <<<EOT
<p>Ciao, sono <b>{$utente->nominativo}</b>.<br>
Sono interessato alla consegna di una raccolta presso il negozio <b>{$negozio}</b> per il canile <b>{$canile}</b>.<br>
Puoi contattarmi:<br>
- email: <b>{$email}</b><br>
- telefono: <b>{$telefono}</b>
</p>

<p>Aspetto tue indicazioni.</p>
EOT;
            
            // send email
            //mail("marcello@hermes.aspide.net,".$row['email'],"Sono interessato alla tua raccolta",$msg,$intestazioni);
            send_mail("Sono interessato alla tua raccolta", $row['email'], $msg, $msg_html);
        }
    }
}

if (!$error && $ok_raccolta_interesse) {
    $site_url = get_site_url();
    echo <<<EOT
<form action="{$site_url}/raccolte-disponibili/" method="POST">
    <div id="message" class="updated fade"><p><strong>Interessamento inserito con successo.</strong></p></div>
    <button type="submit">OK</button>
</form>
EOT;
}
    
if (!$ok_raccolta_interesse) {
?>
<script>
jQuery(document).ready(function() {
    //jQuery( "#data_inizio" ).datepicker({dateFormat : 'yy-mm-dd'});
    //jQuery( "#data_fine" ).datepicker({dateFormat : 'yy-mm-dd'});
});
</script>

<form method="POST" action="page-raccolta-disponibile.php?raccolta=<?php echo $code_raccolta; ?>">
    <button type="submit" class="mybutton">Indietro</button>
</form>

<form method="POST" action="form-raccolta-interesse.php">
<table>
<tr>
    <td><label for="email">Email</label></td>
    <td>Email per farti contattare: <?php echo $utente->email; ?>
    <input type="hidden" value="<?php echo $utente->email; ?>" size="50" name="email" id="email" /></td>
</tr>

<tr>
    <td><label for="telefono">Telefono</label></td>
    <td>Telefono per farti contattare (facoltativo):<br>
    <input type="text" value="" size="50" name="telefono" id="telefono" /><br>
    <h4>Nota</h4>
    <p>Il tuo numero di cellulare verr&agrave; mostrato solo al destinatario del messaggio. <br>
    Non verr&agrave; mostrato in nessun profilo pubblico. <br>
    Non verr&agrave; usato ne' per inviarti SMS, ne' per scopi commerciali, ne' sar&agrave; ceduto a terzi.</p>
    </td>
</tr>
</table>

    <input type="hidden" name="ok_raccolta_interesse" value="1" />
    <input type="hidden" name="code_raccolta" value="<?php echo $code_raccolta; ?>" />
    <input type="hidden" name="code_utente" value="<?php echo $utente->code; ?>" />
    <button type="submit" class="mybutton">Conferma</button>
</form>

<?
}
get_footer(); 
?>