<?php
/**
 * Template Name: Form raccolte negozio
 */

require_once('common.inc.php');
get_header();

$code_raccolte_negozio = getVar("GET", "negozio", getVar("POST", "code_raccolte_negozio", getVar("POST", "negozio")));

#---------------------------------------------------------------------------------------------------------------------------------
# CHECK LOGIN
#---------------------------------------------------------------------------------------------------------------------------------
$permalink = get_permalink() ."?negozio=".$code_raccolte_negozio;
check_login($permalink);
#---------------------------------------------------------------------------------------------------------------------------------

$ok_negozio = false;
$errore = false;
$negozio = "";

class RecordRaccolteNegozi extends RecordBase {
    
	public function __construct($id=null) {
        parent::__construct("raccolte_negozi", "ident", $id);
    }
}
$record = Factory::crea("RecordRaccolteNegozi");
if (strlen($code_raccolte_negozio) > 0) {
    $record->loadFromCode($code_raccolte_negozio);
    
    $sql = "select * from vw_anagrafiche WHERE code='{$record->get('code_negozio')}'";
    $rs = $db->Esegui($sql);
    $row = $rs->FetchRow();
    $negozio = $row['nome'];
}

if( 'POST' == $_SERVER['REQUEST_METHOD'] && !empty( $_POST['ok_negozio'] ) &&  $_POST['ok_negozio'] == "1") {
    $record->loadInput();
    
    # CHECK
    if (strlen($record->get('code_negozio')) == 0) {
        $errore = true;
        show_message(MSGERROR, "E' necessario indicare un negozio.", false);
    }
    
    if(!$errore) {
        $res = Factory::salva($record);
        
        if ($res) {
            $ok_negozio = true;
        }
    }
}

if (!$errore && $ok_negozio) {
    echo <<<EOT
<form action="page-raccolte-negozi.php" method="GET">
    <div id="message" class="updated fade"><p><strong>Negozio salvato con successo.</strong></p></div>
    <button type="submit" class="mybutton">OK</button>
</form>
EOT;
}
    
if (!$ok_negozio) {
?>

<script>
jQuery(document).ready(function() {
    jQuery( "#data_fine" ).datepicker({dateFormat : 'yy-mm-dd'});
    
    // NEGOZI
	jQuery( "#negozio_cerca" ).autocomplete({
        source: "/json-negozi.json.php",
        minLength: 2,
        select: function( event, ui ) {
            var codice = ui.item.value;
            var etichetta = ui.item.label;
            
            jQuery("#code_negozio").val(codice);
            jQuery("#negozio").val(etichetta);
            
            return false;
        }
    });
    
});
</script>


<form action="page-raccolte-negozi.php" method="GET">
    <button type="submit" class="mybutton">Indietro</button>
</form>

<h1 class="titolo_pagina">Negozio che effettua una raccolta permanente</h1>

<p>Deve essere gi&agrave; presente in anagrafica.</p>

<form method="POST" action="<?php $permalink; ?>" id="form_negozio" name="form_negozio">

    <table>
    <tr>
        <td><label for="partenza">Negozio</label></td>
        <td>Cerca: <input type="text" value="" size="50" name="negozio_cerca" id="negozio_cerca" style="background:#FFD;" /></td>
    </tr>

    <tr>
        <td>
            <input type="hidden" value="<?php echo $record->get("code_negozio"); ?>" size="10" name="code_negozio" id="code_negozio" readonly="readonly" />
        </td>
        <td>
            <input type="text" value="<?php echo $negozio; ?>" size="50" name="negozio" id="negozio" readonly="readonly" />
        </td>
    </tr>

    </table>
    <input type="hidden" name="ok_negozio" value="1" />
    <input type="hidden" name="code_utente" value="<?php echo $code_utente; ?>" />
    <input type="hidden" name="code_raccolte_negozio" value="<?php echo $code_raccolte_negozio; ?>" />
    <button type="submit" class="mybutton">Salva</button>
</form>

<?php 
}

get_footer(); 
?>