<?php
/**
 * Template Name: Form pelosetto smarrito
 */

require_once('common.inc.php');
get_header();

#---------------------------------------------------------------------------------------------------------------------------------
# CHECK LOGIN
#---------------------------------------------------------------------------------------------------------------------------------
check_login();
#---------------------------------------------------------------------------------------------------------------------------------
$errore = false;
$ok_smarrito = false;
$code_smarrito = getVar("POST", "code_smarrito", getVar("GET", "smarrito"));

$record = Factory::crea("Smarrito");
if (strlen($code_smarrito))
    $record->loadFromCode($code_smarrito);

if( 'POST' == $_SERVER['REQUEST_METHOD'] && !empty( $_POST['ok_smarrito'] ) &&  $_POST['ok_smarrito'] == "1") {
    $record->loadInput();
    
    for ($i=1; $i<=4; $i++) {
        $nome_campo = "immagine".$i;
        $path_base = BASE_DIR;
        $path_rel = "/uploads/smarriti/";
        $name = upload_image($nome_campo, $path_base, $path_rel, "SMARRITO_");
        if ($name !== false) {
            error_log($nome_campo." - ".$path_rel.$name);
            $record->set($nome_campo, $path_rel.$name);
        }
        
    }
    
    # CHECK
    if (strlen($record->get('nome')) == 0) {
        $errore = true;
        show_message(MSGERROR, "E' necessario indicare il nome del pelosetto smarrito.", false);
    }
    if (strlen($record->get('ultimo_avvistamento_data')) == 0) {
        $errore = true;
        show_message(MSGERROR, "E' necessario indicare la data di smarrimento.", false);
    }
    
    if( !$errore ) {
        $res = Factory::salva($record);
        
        if ($res) {
            $ok_smarrito = true;
        }
    }
}

if (!$errore && $ok_smarrito) {
    echo <<<EOT
<form action="indietro.php" method="GET">
    <div id="message" class="updated fade"><p><strong>Pelosetto smarrito salvato con successo.</strong></p></div>
    <button type="submit" class="mybutton">OK</button>
</form>
EOT;
}
    
if (!$ok_smarrito) {
?>

<script>
jQuery(document).ready(function() {
    jQuery( "#ultimo_avvistamento_data" ).datepicker({dateFormat : 'dd/mm/yy'});
    jQuery( "#ritrovato_data" ).datepicker({dateFormat : 'dd/mm/yy'}); 
});
</script>


<form action="indietro.php" method="GET">
    <button type="submit" class="mybutton">Indietro</button>
</form>

<h1 class="titolo_pagina">Pelosetto smarrito</h1>

<form method="POST" action="<?php get_permalink(); ?>" id="form_smarrito" name="form_smarrito" enctype="multipart/form-data">

    <table class="mytable">
    
    <tr>
        <th><label for="nome">Nome del pelosetto</label></th>
        <td><input type="text" value="<?php echo $record->get("nome"); ?>" size="50" name="nome" id="nome" /></td>
    </tr>
    
    <tr>
        <th><label for="">Specie e genere</label></th>
        <td><div class="row">
            <div class="one half mobile">
                <label for="specie">Specie</label>
                <select name="specie" id="specie">
                    <option value="cane" <?php selected($record->get("specie"), 'cane'); ?>>cane</option>
                    <option value="gatto" <?php selected($record->get("specie"), 'gatto'); ?>>gatto</option>
                </select>
            </div>
            
            <div class="one half mobile">
                <label for="genere">Genere</label>
                <select name="genere" id="genere">
                    <option value="maschio" <?php selected($record->get("genere"), 'maschio'); ?>>maschio</option>
                    <option value="femmina" <?php selected($record->get("genere"), 'femmina'); ?>>femmina</option>
                </select>
            </div>
        </div></td>
    </tr>
    
    <tr>
        <th><label for="ultimo_avvistamento_data">Data ultimo avvistamento</label></th>
        <td><input type="text" value="<?php echo date_translate($record->get("ultimo_avvistamento_data"), 'us', 'it'); ?>" size="10" name="ultimo_avvistamento_data" id="ultimo_avvistamento_data" />
        </td>
    </tr>
    
    <tr>
        <th><label for="ultimo_avvistamento">Ultimo avvistamento</label></th>
        <td><textarea type="text" rows="2" cols="50" name="ultimo_avvistamento" id="ultimo_avvistamento"><?php echo $record->get("ultimo_avvistamento"); ?></textarea></td>
    </tr>
    
<?php
    for ($i=1; $i<=4; $i++) {
        $nome_immagine = "immagine".$i;
        echo <<<EOT
    <tr>
        <th><label for="immagine{$i}">Immagine #{$i}</label></th>
        <td><input type="file" value="" size="15" name="immagine{$i}" id="immagine{$i}" />
EOT;
        if (strlen($record->get($nome_immagine)))
            echo "<img src='{$record->get($nome_immagine)}' height='50px' />";
        echo <<<EOT
        </td>
    </tr>
EOT;
}
?>
    <tr>
        <th><label for="video1">YouTube video</label></th>
        <td><input type="text" value="<?php echo $record->get("video1"); ?>" size="60" name="video1" id="video1" placeholder="https://www.youtube.com/embed/CODICEVIDEO" /></td>
    </tr>
    
    <tr>
        <th><label for="testo">Messaggio</label></th>
        <td><textarea type="text" rows="5" cols="50" name="testo" id="testo"><?php echo $record->get("testo"); ?></textarea></td>
    </tr>
    

    <tr>
        <th><label for="">Luogo</label></th>
        <td><?php $utils->search_city("comune_codice", $record->get("comune_codice"), "comune", $record->get("comune"), "provincia", $record->get("provincia")); ?></td>
    </tr>
 <?php if ($utente->publisher()) { ?>
    <tr>
        <th style="background: #FCA"><label for="">Ritrovato / in data</label></th>
        <td style="background: #FCA"><div class="row">
            <div class="one half mobile half-padded">
                <label for="ritrovato"></label>
                <select name="ritrovato" id="ritrovato">
                    <option value="N" <?php selected($record->get("ritrovato"), 'N'); ?>>no</option>
                    <option value="S" <?php selected($record->get("ritrovato"), 'S'); ?>>si</option>
                </select>
            </div>
            
            <div class="one half mobile half-padded">
                <label for="ritrovato_data"></label>
                <input type="text" value="<?php echo date_translate($record->get("ritrovato_data"), 'us', 'it'); ?>" size="10" name="ritrovato_data" id="ritrovato_data" />
            </div>
        </div></td>
    </tr>
 
 <?php } ?>
    
    </table>
    <input type="hidden" name="ok_smarrito" value="1" />
    <input type="hidden" name="code_utente" value="<?php echo $utente->code; ?>" />
    <input type="hidden" name="code_smarrito" value="<?php echo $record->code(); ?>" />
    <button type="submit" class="mybutton">Salva</button>
</form>

<?php 
}

get_footer(); 
?>