<?php
/**
 * Template Name: Form staffetta
 */
 
require_once('common.inc.php');
get_header();

$code_padre = getVar("POST", "padre", getVar("POST", "code_padre", getVar("GET", "padre")));
$tipo = getVar("POST", "tipo", getVar("GET", "tipo", 'O'));

#---------------------------------------------------------------------------------------------------------------------------------
# CHECK LOGIN
#---------------------------------------------------------------------------------------------------------------------------------
$permalink = get_permalink() ."?padre={$code_padre}&tipo={$tipo}";
check_login($permalink);

#----- CANILE --------------------------------------------------------------------------------------------------------------------
$sql = "Select * from vw_anagrafiche WHERE code='{$pelosetto['code_canile']}'";
$rs = $db->Esegui($sql);

$canile = array();
if ($rs != FALSE) {
    $canile = $rs->FetchRow();
}
#---------------------------------------------------------------------------------------------------------------------------------

$ok_nuovo_trasporto = false;
$errore = false;

class RecordStaffette extends RecordBase {
    
	public function __construct($id=null) {
        parent::__construct("staffette", "ident", $id);
    }
}
$record = Factory::crea("RecordStaffette");


if( 'POST' == $_SERVER['REQUEST_METHOD'] && !empty( $_POST['ok_nuovo_trasporto'] ) &&  $_POST['ok_nuovo_trasporto'] == "1") {
    $record->loadInput();
    $tipo = $record->get("tipo");
    
    # CHECK
    if (strlen($record->get('partenza_codice')) == 0) {
        $errore = true;
        show_message(MSGERROR, "E' necessario indicare la citt&agrave; di partenza.", false);
    }
    elseif (strlen($record->get('arrivo_codice')) == 0) {
        $errore = true;
        show_message(MSGERROR, "E' necessario indicare la citt&agrave; di arrivo.", false);
    }
    elseif ($record->get('tipo') == 'O') {
        if (strlen($record->get('data_fine')) == 0)
            $record->set('data_fine', $record->get('data_inizio'));
            
        if (strlen($record->get('data_inizio')) == 0) {
            $errore = true;
            show_message(MSGERROR, "E' necessario indicare la data di partenza.", false);
        }
    }
    elseif (strlen($record->get('data_inizio')) == 0 || strlen($record->get('data_fine')) == 0) {
        $errore = true;
        show_message(MSGERROR, "E' necessario indicare entrambe le date.", false);
    }
    
    if( !$errore ) {
        $res = Factory::salva($record);
        
        if ($res) {
            $ok_nuovo_trasporto = true;
        }
        else {
            $errore = true;
            show_message(MSGCRITICAL, "Salvataggio fallito!", false);
        }
    }
}

if (!$errore && $ok_nuovo_trasporto) {
    $site_url = get_site_url();
    echo <<<EOT
<form action="page-staffette.php" method="POST">
    <div id="message" class="updated fade"><p><strong>Staffetta salvata con successo.</strong></p></div>
    <button type="submit" class="mybutton">OK</button>
</form>
EOT;
}

if ($tipo == 'R') {
    $nome_data_inizio = "Data inizio";
    $nome_data_fine = "Data fine";
    $titolo_pagina = "Richiedo il trasferimento di un pelosetto";
}
else {
    $nome_data_inizio = "Data partenza";
    $nome_data_fine = "Data arrivo";
    $titolo_pagina = "Mi offro a trasferire un pelosetto";
}
    
if (!$ok_nuovo_trasporto) {
?>

<script>
jQuery(document).ready(function() {
    $( "#data_inizio" ).datepicker({dateFormat : 'dd/mm/yy'});
    $( "#data_fine" ).datepicker({dateFormat : 'dd/mm/yy'});
});
</script>


<form action="page-staffette.php" method="POST">
    <button type="submit" class="mybutton">Indietro</button>
</form>

<h1 class="titolo_pagina"><?php echo $titolo_pagina; ?></h1>

<form method="POST" action="<?php $permalink; ?>" id="form_nuovo_trasporto" name="form_nuovo_trasporto">

    <table class="mytable">
    <tr>
        <td><label for="partenza">Comune di partenza</label></td>
        <td><!--
            Cerca: <input type="text" value="" size="50" name="partenza_cerca" id="partenza_cerca" style="background:#FFD;" />
            <input type="text" value="<?php echo $record->get("partenza_comune"); ?>" size="50" name="partenza_comune" id="partenza_comune" readonly="readonly" />
            <input type="hidden" value="<?php echo $record->get("partenza_provincia"); ?>" size="4" name="partenza_provincia" id="partenza_provincia" readonly="readonly" />
            <input type="hidden" value="<?php echo $record->get("partenza_codice"); ?>" size="10" name="partenza_codice" id="partenza_codice" readonly="readonly" />
            -->
            <?php $utils->search_city("partenza_codice", $record->get("partenza_codice"), "partenza_comune", $record->get("partenza_comune"), "partenza_provincia", $record->get("partenza_provincia")); ?>
        </td>
    </tr>

    <tr>
        <td><label for="partenza">Localit&agrave; di partenza</label></td>
        <td><input type="text" value="<?php echo $record->get("partenza_localita"); ?>" size="50" name="partenza_localita" id="partenza_localita" /></td>
    </tr>

    <tr>
        <td><label for="arrivo">Comune di arrivo</label></td>
        <td><!--
            Cerca: <input type="text" value="" size="50" name="arrivo_cerca" id="arrivo_cerca" style="background:#FFD;" />
            <input type="text" value="<?php echo $record->get("arrivo_comune"); ?>" size="50" name="arrivo_comune" id="arrivo_comune" readonly="readonly" />
            <input type="hidden" value="<?php echo $record->get("arrivo_provincia"); ?>" size="4" name="arrivo_provincia" id="arrivo_provincia" readonly="readonly" />
            <input type="hidden" value="<?php echo $record->get("arrivo_codice"); ?>" size="10" name="arrivo_codice" id="arrivo_codice" readonly="readonly" />
            -->
            <?php $utils->search_city("arrivo_codice", $record->get("arrivo_codice"), "arrivo_comune", $record->get("arrivo_comune"), "arrivo_provincia", $record->get("arrivo_provincia")); ?>
        </td>
    </tr>

    <tr>
        <td><label for="arrivo">Localit&agrave; di arrivo</label></td>
        <td><input type="text" value="<?php echo $record->get("arrivo_localita"); ?>" size="50" name="arrivo_localita" id="arrivo_localita" /></td>
    </tr>
    
    <tr>
        <td><label for="">Date</label></td>
        <td>
            <div class="row">
                <div class="one eighth align-left">
                    <label for="specie"><?php echo $nome_data_inizio; ?></label>
                </div>
                <div class="three eighths">
                    <input type="text" value="<?php echo $record->get("data_inizio"); ?>" size="10" name="data_inizio" id="data_inizio" />
                </div>
                
                <div class="one eighth align-right">
                    <label for="taglia"><?php echo $nome_data_fine; ?></label>
                </div>
                
                <div class="three eighths">
                    <input type="text" value="<?php echo $record->get("data_fine"); ?>" size="10" name="data_fine" id="data_fine" />
                </div>
            </div>
        </td>
    </tr>
    
    <?php if ($tipo == 'R') { ?>
    <tr>
        <td><label for="partenza_referente">Referente alla partenza</label></td>
        <td><textarea type="text" rows="5" cols="50" name="partenza_referente" id="partenza_referente"><?php echo $record->get("partenza_referente"); ?></textarea></td>
    </tr>
    
    <tr>
        <td><label for="arrivo_referente">Referente all'arrivo</label></td>
        <td><textarea type="text" rows="5" cols="50" name="arrivo_referente" id="arrivo_referente"><?php echo $record->get("arrivo_referente"); ?></textarea></td>
    </tr>
    <?php } ?>
    
    <tr>
        <td><label for="">Pelosetto</label></td>
        <td>
            <div class="row">
                <div class="one eighth align-left">
                    <label for="specie">Specie</label>
                </div>
                <div class="three eighths">
                    <select name="specie" id="specie">
                        <?php if ($tipo == 'O') { ?>
                        <option value="I" <?php selected($record->get("specie"), 'I'); ?>>indifferente</option>
                        <?php } ?>
                        <option value="C" <?php selected($record->get("specie"), 'C'); ?>>cane</option>
                        <option value="G" <?php selected($record->get("specie"), 'G'); ?>>gatto</option>
                    </select>
                </div>
                
                <div class="one eighth align-right">
                    <label for="taglia">Taglia</label>
                </div>
                
                <div class="three eighths">
                    <select name="taglia" id="taglia">
                        <option value="P" <?php selected($record->get("taglia"), 'P'); ?>>piccola</option>
                        <option value="M" <?php selected($record->get("taglia"), 'M'); ?>>media</option>
                        <option value="G" <?php selected($record->get("taglia"), 'G'); ?>>grande</option>
                    </select>
                </div>
            </div>
        </td>
    </tr>
    
    <?php if ($tipo == 'O') { ?>
    <tr>
        <td><label for="mezzo_trasporto">Mezzo di trasporto</label></td>
        <td><select name="mezzo_trasporto" id="mezzo_trasporto">
                <option value="AUTO" <?php selected($record->get("mezzo_trasporto"), 'AUTO'); ?>>auto</option>
                <option value="TRENO" <?php selected($record->get("mezzo_trasporto"), 'TRENO'); ?>>treno</option>
                <option value="AEREO" <?php selected($record->get("mezzo_trasporto"), 'AEREO'); ?>>aereo</option>
                <option value="NAVE" <?php selected($record->get("mezzo_trasporto"), 'NAVE'); ?>>nave</option>
            </select></td>
    </tr>
    
    <tr>
        <td><label for="compagnia_trasporto">Eventuale Compagnia di trasporto</label></td>
        <td><input type="text" value="<?php echo $record->get("compagnia_trasporto"); ?>" size="50" name="compagnia_trasporto" id="compagnia_trasporto" /></td>
    </tr>
    <?php } ?>

    <tr>
        <td><label for="note">Note</label></td>
        <td><textarea type="text" rows="5" cols="50" name="note" id="note"><?php echo $record->get("note"); ?></textarea></td>
    </tr>

    </table>
    <input type="hidden" name="ok_nuovo_trasporto" value="1" />
    <input type="hidden" name="tipo" value="<?php echo $tipo; ?>" />
    <input type="hidden" name="code_padre" value="<?php echo $code_padre; ?>" />
    <input type="hidden" name="code_utente" value="<?php echo $utente->code; ?>" />
    <button type="submit" class="mybutton">Salva</button>
</form>



<script>
window.onload=function(){
    // = document.getElementById("versamento_modo");
    //alert(o.value);
    //change_VersamentoModo(o);
};
</script>
<?php 
}
?>
<?php get_footer(); ?>