<?php
/**
 * Template Name: Form interesse a un pelosetto in stallo.
 */

require_once('common.inc.php');
get_header();

$code_pelosetto = getVar("POST", "pelosetto", getVar("POST", "code_pelosetto", getVar("GET", "pelosetto")));

#---------------------------------------------------------------------------------------------------------------------------------
# CHECK LOGIN
#---------------------------------------------------------------------------------------------------------------------------------
$permalink = get_permalink() ."?pelosetto=".$code_pelosetto;
check_login($permalink);
#---------------------------------------------------------------------------------------------------------------------------------

$sql = "Select * from pelosetti WHERE code='{$code_pelosetto}'";
$rs = $db->Esegui($sql);

$pelosetto = array();
if ($rs != FALSE) {
    $pelosetto = $rs->FetchRow();
}

#---------------------------------------------------------------------------------------------------------------------------------

$ok_stallo_interesse = false;
$errore = false;

class RecordStalloInteressati extends RecordBase {
    
	public function __construct($id=null) {
        parent::__construct("stalli_interessati", "ident", $id);
    }
}
$record = Factory::crea("RecordStalloInteressati");

if( 'POST' == $_SERVER['REQUEST_METHOD'] && !empty( $_POST['ok_stallo_interesse'] ) &&  $_POST['ok_stallo_interesse'] == "1") {
    $record->loadInput();
    
    # CHECK
    if (strlen($record->get('email')) == 0) {
        $errore = true;
        show_message(MSGERROR, "E' necessario indicare una email per contattarti.", false);
    }
    
    $sql = "SELECT * FROM stalli_interessati WHERE code_utente='{$utente->code}'";
    $rs = $db->Esegui($sql);
    if ($rs == FALSE or $rs->RecordCount() > 0) {
        $errore = true;
        show_message(MSGERROR, "Hai gi&agrave; segnalato il tuo interesse.", false);
    } 
    
    if(!$errore) {
        $res = Factory::salva($record);
        
        if ($res) {
            $ok_stallo_interesse = true;
            
            // invio la mail per la conferma
            $intestazioni = "From: Amici di Giulita <staff@amicidigiulita.it>";

            $msg = "Grazie per il tuo interessamento!";
            $msg_html = "<b>Grazie per il tuo interessamento!</b>";
            
            // send email
            //mail("marcello@hermes.aspide.net,".$record->get('email'),"Interessamento ad uno stallo.",$msg,$intestazioni);
            send_mail("Interessamento ad uno stallo.", $record->get('email'), $msq, $msg_html);
            
            $code_raccolta = $record->get('code_raccolta');
            $sql = "SELECT *, t.nome as pelosetto_nome FROM pelosetti t JOIN iscritti i ON i.code=t.code_utente WHERE t.code='{$code_pelosetto}'";
            $rs = $db->Esegui($sql);
            $row = $rs->FetchRow();
            
            $pelosetto_nome = $row['pelosetto_nome'];
            $email = $record->get("email");
            $telefono = $record->get("telefono");
            
            $msg = <<<EOT
Ciao, sono {$utente->nominativo}.\r\n
Sono interessato allo stallo di {$pelosetto_nome}.\r\n
Puoi contattarmi:\r\n
- email: {$email}\r\n
- telefono: {$telefono}\r\n

Aspetto tue indicazioni.
EOT;
            $msg_html = <<<EOT
<p>Ciao, sono <b>{$utente->nominativo}</b>.<br>
Sono interessato allo stallo di <b>{$pelosetto_nome}</b>.<br>
Puoi contattarmi:<br>
- email: <b>{$email}</b><br>
- telefono: <b>{$telefono}</b>
</p>

<p>Aspetto tue indicazioni.</p>
EOT;
            // send email
            //mail("marcello@hermes.aspide.net,".$row['email'],"Sono interessato allo stallo",$msg,$intestazioni);
            send_mail("Sono interessato allo stallo", $record->get('email'), $msq, $msg_html);
        }
    }
}

if (!$errore && $ok_stallo_interesse) {
    $site_url = get_site_url();
    echo <<<EOT
<form action="page-gallery.php" method="POST">
    <div id="message" class="updated fade"><p><strong>Interessamento inserito con successo.</strong></p></div>
    <!--input type="hidden" name="code" value="{$code_pelosetto}" /-->
    <button type="submit" class="mybutton">OK</button>
</form>
EOT;
}
    
if (!$ok_stallo_interesse) {
?>
<script>
jQuery(document).ready(function() {
    //jQuery( "#data_inizio" ).datepicker({dateFormat : 'yy-mm-dd'});
    //jQuery( "#data_fine" ).datepicker({dateFormat : 'yy-mm-dd'});
});
</script>

<form method="GET" action="<?php echo $history->indietro(); ?>">
    <button type="submit" class="mybutton">Indietro</button>
</form>

<form method="POST" action="form-stallo-interesse.php">
<table>
<tr>
    <td><label for="email">Email</label></td>
    <td>Email per farti contattare: <br />
    <b><?php echo $utente->email; ?></b>
    <input type="hidden" value="<?php echo $utente->email; ?>" size="50" name="email" id="email" /></td>
</tr>

<tr>
    <td><label for="telefono">Telefono</label></td>
    <td>Telefono per farti contattare (facoltativo):<br>
    <input type="text" value="" size="50" name="telefono" id="telefono" /><br>
    <h4>Nota</h4>
    <p>Il tuo numero di cellulare verr&agrave; mostrato solo al destinatario del messaggio. <br>
    Non verr&agrave; mostrato in nessun profilo pubblico. <br>
    Non verr&agrave; usato ne' per inviarti SMS, ne' per scopi commerciali, ne' sar&agrave; ceduto a terzi.</p>
    </td>
</tr>
</table>

    <input type="hidden" name="ok_stallo_interesse" value="1" />
    <input type="hidden" name="code_pelosetto" value="<?php echo $code_pelosetto; ?>" />
    <input type="hidden" name="code_utente" value="<?php echo $utente->code; ?>" />
    <button type="submit" class="mybutton">Conferma</button>
</form>

<script>
window.onload=function(){
};
</script>

<?
}
?>
<?php get_footer(); ?>