<?php
/**
 * Template Name: Form nuova donazione
 */

require_once('common.inc.php');

get_header();

$code_padre = getVar("POST", "code_padre", getVar("POST", "padre", getVar("GET", "padre")));
$code_versamento = getVar("POST", "code_versamento", getVar("POST", "versamento", getVar("GET", "versamento")));

#---------------------------------------------------------------------------------------------------------------------------------
# CHECK LOGIN
#---------------------------------------------------------------------------------------------------------------------------------
$permalink = get_permalink() ."?padre=".$code_padre;
check_login($permalink);

$ok_versamento = false;
$errore = false;

class RecordVersamenti extends RecordBase {
    
	public function __construct($id=null) {
        parent::__construct("versamenti", "ident", $id);
    }
}
$record = Factory::crea("RecordVersamenti");
$iscritto = array(
    'code' => $utente->code,
    'nome' => $utente->nome,
    'cognome' => $utente->cognome,
    'email' => $utente->email
);
if (strlen($code_versamento)) {
    $record->loadFromCode($code_versamento);
    $code_padre = $record->get("code_padre");
    $iscritto = get_user_from_code($record->get('code_utente'));
}
if( 'POST' == $_SERVER['REQUEST_METHOD'] && !empty( $_POST['ok_versamento'] ) &&  $_POST['ok_versamento'] == "1") {
    $record->loadInput();
    
    /*$code_pelosetto = $_POST['code_pelosetto'];
    $code_utente = $_POST['code_utente'];
    $versamento_tipo = $_POST['versamento_tipo'];
    $versamento_modo = $_POST['versamento_modo'];
    $versamento_referente = $_POST['versamento_referente'];
    $importo_versamento = $_POST['importo_versamento'];
    $motivazione = $_POST['motivazione'];
    $info = $_POST['info'];*/
    
    /*if ($importo_annuale < 120) {
        $errore = true;
        show_message(MSGERROR, "L'importo annuale minimo &egrave; 120 euro.", false);
    }*/
    if ($record->get('versamento_data') <= 0) {
        $errore = true;
        show_message(MSGERROR, "Va indicata la data in cui &egrave; stato effettuato il versamento.", false);
    }
    if ($utente->publisher()) {
        # niente
    }
    else {
        if ($record->get('versamento_importo') <= 0) {
            $errore = true;
            show_message(MSGERROR, "L'importo deve essere indicato.", false);
        }
    }
    if ($record->get('versamento_modo') != 'I' && $record->get('versamento_modo') != 'D') {
        $errore = true;
        show_message(MSGERROR, "E' necessario indicare una modalit&agrave; di versamento.", false);
    }
    if ($record->get('versamento_modo') == 'I' && strlen($record->get('versamento_referente')) == 0) {
        $errore = true;
        show_message(MSGERROR, "E' necessario indicare un referente quando il versamento &egrave; indiretto.", false);
    }
    
    if(!$errore) {
        $record->set("tabella", "versamenti");
        
        $res = Factory::salva($record);
        
        if ($res) {
            $ok_versamento = true;
        }
    }
}

?>

<?php
if (!$errore && $ok_versamento) {
    echo <<<EOT
<form action="indietro" method="GET">
    <div id="message" class="updated fade"><p><strong>Versamento salvato con successo.</strong></p></div>
    <button type="submit" class="mybutton">OK</button>
</form>
EOT;
}
 
    
if (!$ok_versamento) {

?>

<form method="GET" action="<?php echo $history->indietro(); ?>">
    <button type="submit" class="mybutton">Indietro</button>
</form>

<br />

<h1 class="titolo_pagina">Versamento per la partecipazione ad un'iniziativa</h1>

<form method="POST" action="<?php $permalink; ?>" id="form_versamento" name="form_versamento">

    <table class="mytable">
    <tr>
        <th><label>Cognome e nome</label></th>
        <td><?php echo $iscritto['cognome']; ?> <?php echo $iscritto['nome']; ?></td>
    </tr>
    
    <tr>
        <th><label for="email">Email</label></th>
        <td><?php echo $iscritto['email']; ?><input type="hidden" value="<?php echo $iscritto['code']; ?>" name="code_utente" id="code_utente" /></td>
    </tr>
    
    <tr>
        <th><label for="versamento_data">Data</label></th>
        <td><input class="one fifth" type="date" value="<?php echo date_translate($record->get('versamento_data'), 'us', 'it'); ?>" name="versamento_data" id="versamento_data" /></td>
    </tr>
    
    <tr>
        <th><label for="versamento_tipo">Importo versamento</label></th>
        <td><div class="row">
            <div class="one seventh">
                <input type="number" value="<?php echo $record->get('versamento_importo'); ?>" placeholder="" name="versamento_importo" id="versamento_importo" />
            </div>
        </div></td>
    </tr>
    
    <tr>
        <th><label for="versamento_tipo">Tipo versamento</label></th>
        <td><div class="row">
            <div class="one third">
                <select name="versamento_tipo" id="versamento_tipo">
                    <option value="M" <?php selected( 'M', $record->get('versamento_tipo'), true); ?>>Mensile</option>
                    <option value="U" <?php selected( 'U', $record->get('versamento_tipo'), true); ?>>Unico</option>
                </select>
            </div>
        </div></td>
    </tr>

    <tr>
        <th><label for="versamento_modo">Modalit&agrave; di versamento</label></th>
        <td>
            <input type="radio" name="versamento_modo" value="D" <?php checked( 'D', $record->get('versamento_modo'), true); ?> onchange="change_VersamentoModo('D');">Diretto 
            <br>
            <input type="radio" name="versamento_modo" value="I" <?php checked( 'I', $record->get('versamento_modo'), true); ?> onchange="change_VersamentoModo('I');">Indiretto tramite 
            <input type="text" id="versamento_referente" name="versamento_referente" value="<?php echo $record->get('versamento_referente'); ?>" />
            
            <script>
            function change_VersamentoModo(o) {
                var refer = document.getElementById("versamento_referente");
                if (o == 'I') {
                    refer.disabled  = false;
                }
                else if (o == 'D') {
                    //refer.value = '';
                    refer.disabled  = true;
                }
                else {
                    //refer.value = '';
                    refer.disabled  = false;
                }
            }
            </script>
        </td>
    </tr>
    
<?php 
if (is_administrator()) {
?>
    <tr>
        <th><label for="verificato">verificato</label></th>
        <td><select name="verificato" id="verificato">
                <option value="N" <?php selected($record->get("verificato"), 'N'); ?>>no</option>
                <option value="S" <?php selected($record->get("verificato"), 'S'); ?>>si</option>
            </select></td>
    </tr>
<?php
}
?>

    <tr>
        <th><label for="note">Annotazioni</label></th>
        <td><textarea rows="5" cols="50" name="note" id="note"><?php echo $record->get('note'); ?></textarea></td>
    </tr>

    </table>
    <input type="hidden" name="ok_versamento" value="1" />
    <input type="hidden" value="<?php echo $code_padre; ?>" name="code_padre" id="code_padre" />
    <input type="hidden" value="<?php echo $code_versamento; ?>" name="code_versamento" id="code_versamento" />
    <button type="submit" class="mybutton">Salva</button>
</form>

<script>
window.onload=function(){
    $( "#versamento_data" ).datepicker({dateFormat : 'dd/mm/yy'});
    
    o = $('input[name=versamento_modo]').value;
    change_VersamentoModo(o);
};
</script>
<?php 
}

get_footer(); 
?>