<?php
/**
 * Template Name: Form staffetta
 */
 
require_once('common.inc.php');
get_header();

$code_padre = getVar("POST", "padre", getVar("POST", "code_padre", getVar("GET", "padre")));
$tipo = getVar("POST", "tipo", getVar("GET", "tipo", 'O'));

#---------------------------------------------------------------------------------------------------------------------------------
# CHECK LOGIN
#---------------------------------------------------------------------------------------------------------------------------------
$permalink = get_permalink() ."?padre={$code_padre}&tipo={$tipo}";
check_login($permalink);

#----- CANILE --------------------------------------------------------------------------------------------------------------------
$sql = "Select * from vw_anagrafiche WHERE code='{$pelosetto['code_canile']}'";
$rs = $db->Esegui($sql);

$canile = array();
if ($rs != FALSE) {
    $canile = $rs->FetchRow();
}
#---------------------------------------------------------------------------------------------------------------------------------

$ok_nuova_visita = false;
$errore = false;

class RecordVisite extends RecordBase {
    
	public function __construct($id=null) {
        parent::__construct("visite", "ident", $id);
    }
}
$record = Factory::crea("RecordVisite");


if( 'POST' == $_SERVER['REQUEST_METHOD'] && !empty( $_POST['ok_nuova_visita'] ) &&  $_POST['ok_nuova_visita'] == "1") {
    $record->loadInput();
    $tipo = $record->get("tipo");
    
    # CHECK
    if (strlen($record->get('comune_codice')) == 0) {
        $errore = true;
        show_message(MSGERROR, "E' necessario indicare il comune.", false);
    }
    if ($tipo == 'R') {
        if (strlen($record->get('data_inizio')) == 0 || strlen($record->get('data_fine')) == 0) {
            $errore = true;
            show_message(MSGERROR, "E' necessario indicare entrambe le date.", false);
        }
    }
    
    if( !$errore ) {
        $res = Factory::salva($record);
        
        if ($res) {
            $ok_nuova_visita = true;
        }
        else {
            $errore = true;
            show_message(MSGCRITICAL, "Salvataggio fallito!", false);
        }
    }
}

if (!$errore && $ok_nuova_visita) {
    echo <<<EOT
<form action="indietro.php" method="POST">
    <div id="message" class="updated fade"><p><strong>Visita salvata con successo.</strong></p></div>
    <button type="submit" class="mybutton">OK</button>
</form>
EOT;
}

if ($tipo == 'R') {
    $nome_data_inizio = "Data inizio";
    $nome_data_fine = "Data fine";
    $titolo_pagina = "Richiedo una visita pre/post affido";
}
else {
    $nome_data_inizio = "Data inizio";
    $nome_data_fine = "Data fine";
    $titolo_pagina = "Mi offro ad effettuare delle visite pre/post affido";
}
    
if (!$ok_nuova_visita) {
?>

<script>
jQuery(document).ready(function() {
    $( "#data_inizio" ).datepicker({dateFormat : 'dd/mm/yy'});
    $( "#data_fine" ).datepicker({dateFormat : 'dd/mm/yy'});
});
</script>


<form action="indietro.php" method="POST">
    <button type="submit" class="mybutton">Indietro</button>
</form>

<h1 class="titolo_pagina"><?php echo $titolo_pagina; ?></h1>

<form method="POST" action="<?php $permalink; ?>" id="form_nuovo_trasporto" name="form_nuovo_trasporto">

    <table class="mytable">
    <tr>
        <td><label for="partenza">Comune</label></td>
        <td>
        <?php $utils->search_city("comune_codice", $record->get("comune_codice"), "comune", $record->get("comune"), "provincia", $record->get("provincia")); ?>
        </td>
    </tr>

    <tr>
        <td><label for="localita">Localit&agrave; o zona</label></td>
        <td><input type="text" value="<?php echo $record->get("localita"); ?>" size="50" name="localita" id="localita" /></td>
    </tr>

    <?php if ($tipo == 'R') { ?>
    <tr>
        <td><label for="">Date</label></td>
        <td>
            <div class="row">
                <div class="one eighth align-left">
                    <label for="specie"><?php echo $nome_data_inizio; ?></label>
                </div>
                <div class="three eighths">
                    <input type="text" value="<?php echo date_translate($record->get("data_inizio"), 'us', 'it'); ?>" size="10" name="data_inizio" id="data_inizio" />
                </div>
                
                <div class="one eighth align-right">
                    <label for="taglia"><?php echo $nome_data_fine; ?></label>
                </div>
                
                <div class="three eighths">
                    <input type="text" value="<?php echo date_translate($record->get("data_fine"), 'us', 'it'); ?>" size="10" name="data_fine" id="data_fine" />
                </div>
            </div>
        </td>
    </tr>
    <?php } ?>
    
    <tr>
        <td><label for="note">Note</label></td>
        <td><textarea type="text" rows="5" cols="50" name="note" id="note"><?php echo $record->get("note"); ?></textarea></td>
    </tr>

    </table>
    <input type="hidden" name="ok_nuova_visita" value="1" />
    <input type="hidden" name="tipo" value="<?php echo $tipo; ?>" />
    <input type="hidden" name="code_padre" value="<?php echo $code_padre; ?>" />
    <input type="hidden" name="code_utente" value="<?php echo $utente->code; ?>" />
    <button type="submit" class="mybutton">Salva</button>
</form>

<?php 
}

get_footer(); 
?>