<?php
/*******************************************************************************
   FUNZIONI WORDPRESS
*******************************************************************************/
function get_header() {
    GLOBAL $smarty;
    $smarty->display("page-header.tpl");
}
function the_post() {
    
}
function get_footer() {
    GLOBAL $smarty, $history;
    $smarty->display("page-footer.tpl");
}
function get_permalink() {
    return $_SERVER['PHP_SELF']; #$_SERVER['REQUEST_URI'];
}
function homepage() {
    if ($_SERVER['PHP_SELF'] == '/index.php')
        return true;
    return false;
}
function get_current_page_url() {
    $pageURL = 'http';
    if ($_SERVER["HTTPS"] == "on") {$pageURL .= "s";}
        $pageURL .= "://";
    if ($_SERVER["SERVER_PORT"] != "80") {
        $pageURL .= $_SERVER["SERVER_NAME"].":".$_SERVER["SERVER_PORT"].$_SERVER["REQUEST_URI"];
    } else {
        $pageURL .= $_SERVER["SERVER_NAME"].$_SERVER["REQUEST_URI"];
    }
    return $pageURL;
}
function get_site_url() {
    #return $_SERVER['REQUEST_URI'];
    return "amicidigiulita.it/";
}
$site_url = "";
function is_user_logged_in() {
    if (isset($_SESSION['USER']))
        return true;
    return false;
}
function selected($a, $b, $echo=true) {
    $ret = "";
    if ($a == $b) 
        $ret = "selected='selected'";
    if ($echo)
        echo $ret;
    else
        return $ret;
}
function checked($a, $b, $echo=true) {
    $ret = "";
    if ($a == $b) 
        $ret = "checked='checked'";
    if ($echo)
        echo $ret;
    else
        return $ret;
}
/*******************************************************************************
   FUNZIONI CHECK
*******************************************************************************/
function check_login($permalink=null) {
    GLOBAL $login_url;
    
    if (is_user_logged_in())
        return true;
    if (!isset($permalink))
        $permalink = get_permalink();
        
    $_SESSION["URL_AFTER"] = $permalink;
        
    echo <<<EOT
    
    <p>Per continuare &egrave; necessario essere un <b>amico di Giulita</b>.</p>
    
    <p>Se sei gi&agrave; iscritto, effettua l'accesso.
    <form method="POST" action="form-login.php">
        <input type="hidden" name="url" value="{$permalink}" />
        <button type="submit">Accedi</button> oppure 
        <a class="noicon" href="{$login_url}">
        <button type="button" class="blue" style="padding:3px; background:#3b5997;"><i class="icon-facebook-sign"></i> Accedi</button>
        </a>
    </form></p>
    
    <p>Se invece vuoi aggiungerti agli amici, iscriviti qui.
    <form method="POST" action="form-nuovo-iscritto.php">
        <input type="hidden" name="url" value="{$permalink}" />
        <button type="submit">Diventa amico</button> oppure <a class="noicon" href="{$login_url}">
        <button type="button" class="blue" style="padding:3px; background:#3b5997;"><i class="icon-facebook-sign"></i> Usa Facebook</button>
        </a>
    </form></p>
EOT;
    
    get_footer();
    exit();
}
function check_admin() {
    if (is_administrator())
        return true;
    
    show_message(MSGCRITICAL, "Pagina riservata agli amministratori!", false);
    
    get_footer();
    exit();
}
function check_publisher() {
    GLOBAL $utente;
    if ($utente->publisher())
        return true;
    
    show_message(MSGCRITICAL, "Pagina riservata ai publisher!", false);
    
    get_footer();
    exit();
}
function check_anagrafica($cu, $nuova=false) {
    GLOBAL $utente;
    if ($utente->administrator())
        ; # OK
    elseif ($utente->publisher() && $nuova) 
        ; # OK
    elseif ($utente->publisher() && $cu == $utente->username) 
        ; # OK
    else {
        show_message(MSGCRITICAL, "Non hai accesso a questa anagrafica.", false);
        get_footer();
        exit();
    }
}
function is_administrator() {
    if (!is_user_logged_in())
        return false;
    if ($_SESSION['USER']['ruolo'] == "admin")
        return true;
    return false;
}
function check_username($username) {
    GLOBAL $db;
    
    $sql = "SELECT * FROM iscritti WHERE username='{$username}'";
    $rs = $db->Esegui($sql);
    if ($rs == false)
        return false;
    if ($rs->RecordCount() == 0)
        return true;
    return false;
}
function check_email($email) {
    GLOBAL $db;
    
    $sql = "SELECT * FROM iscritti WHERE email='{$email}'";
    $rs = $db->Esegui($sql);
    if ($rs == false)
        return false;
    if ($rs->RecordCount()== 0)
        return true;
    return false;
}
function is_bot() {
    $bots = array(
        'Googlebot', 'Baiduspider', 'ia_archiver',
        'R6_FeedFetcher', 'NetcraftSurveyAgent', 'Sogou web spider',
        'bingbot', 'Yahoo! Slurp', 'facebookexternalhit', 'facebook', 'PrintfulBot',
        'msnbot', 'Twitterbot', 'UnwindFetchor',
        'urlresolver', 'Butterfly', 'TweetmemeBot',
        'Mediapartners-Google', 'LinkpadBot',
        'AdvBot'
    );
 
    foreach($bots as $b){
        if( stripos( $_SERVER['HTTP_USER_AGENT'], $b ) !== false ) 
            return true;
    }
    return false;
}
/*******************************************************************************
   FUNZIONI
*******************************************************************************/
define("LOGIN_NO_PARAMS", "LOGIN_NO_PARAMS");
define("LOGIN_ERROR", "LOGIN_ERROR");
define("LOGIN_INVALID", "LOGIN_INVALID");
define("LOGIN_INCOMPLETE", "LOGIN_INCOMPLETE");
define("LOGIN_OK", "LOGIN_OK");
function try_login($params) {
    GLOBAL $db;
    
    if (isset($params['username']) && isset($params['password'])) {
        $sql = "SELECT * FROM iscritti WHERE validato='1' AND username='{$params['username']}' AND password='{$params['password']}'";
    }
    elseif (isset($params['fb_id'])) {
        $sql = "SELECT * FROM iscritti WHERE fb_id='{$params['fb_id']}'";
    }
    else
        return LOGIN_NO_PARAMS;
    
    $rs = $db->Esegui($sql);
    if ($rs == false)
        return LOGIN_ERROR;
        
    $row = $rs->FetchRow();
    if (strlen($row['code']) > 0) {
        $_SESSION['USER'] = $row;
        
        if (!is_administrator()) {
            $record = new Connessioni();
            $record->set("tabella", "connessioni");
            $record->set("cu", $row['username']);
            $record->set("username", $row['username']);
            $record->set("sessione", session_id());
            $record->set("ip", $_SERVER['REMOTE_ADDR']);
            $record->set("useragent", $_SERVER["HTTP_USER_AGENT"]);
            $record->insert();
        }
        return LOGIN_OK;
    }
    else {
        $sql = "SELECT * FROM iscritti WHERE validato='0' AND username='{$params['username']}' AND password='{$params['password']}'";
        $rs = $db->Esegui($sql);
        if ($rs == false)
            return LOGIN_ERROR;
        if ($rs->RecordCount() > 0)
            return LOGIN_INCOMPLETE;
    }
        
    return LOGIN_INVALID;
}
function get_user_from_code($code) {
    GLOBAL $db;
    
    $sql = "SELECT * FROM iscritti WHERE code='{$code}'";
    $rs = $db->Esegui($sql);
    if ($rs == false)
        return false;
    if ($rs->RecordCount() == 0)
        return false;
    return $rs->FetchRow();
}
function get_user_from_username($username) {
    GLOBAL $db;
    
    $sql = "SELECT * FROM iscritti WHERE username='{$username}'";
    $rs = $db->Esegui($sql);
    if ($rs == false)
        return false;
    if ($rs->RecordCount() == 0)
        return false;
    return $rs->FetchRow();
}
function get_user_from_email($email) {
    GLOBAL $db;
    
    $sql = "SELECT * FROM iscritti WHERE email='{$email}'";
    $rs = $db->Esegui($sql);
    if ($rs == false)
        return false;
    if ($rs->RecordCount() == 0)
        return false;
    return $rs->FetchRow();
}
function slug_simple($string){
   $slug=preg_replace('/[^A-Za-z0-9-]+/', '-', $string);
   return $slug;
}
/*******************************************************************************
   FUNZIONI SENDMAIL
*******************************************************************************/
function send_mail($subject, $arrayto, $body_text, $body_html=null, $toall='N') {
    GLOBAL $db;
    
    if (is_array($arrayto))
        $receiver = implode(",", $arrayto);
    else
        $receiver = $arrayto;
    $record = Factory::crea("Mail");
    $record->set("subject", $subject);
    $record->set("receiver", $receiver);
    $record->set("message_text", $body_text);
    $record->set("message_html", $body_html);
    $record->set("toall", $toall);
    
    $res = Factory::salva($record);
    return $res;
}
/*******************************************************************************
   FUNZIONI REAL-SENDMAIL
*******************************************************************************/
function real_send_mail($subject, $arrayto, $body_text, $body_html=null) {
    require_once 'mailer/swift_required.php';
    
    if (!is_array($arrayto))
        $arrayto = array($arrayto);

    // Create the Transport
    $transport = Swift_SmtpTransport::newInstance('ermes.aspide.net', 587, 'tls')
        ->setUsername('staff@amicidigiulita.it')
        ->setPassword('j76BkjR4Ka')
    ;
    /*$transport = Swift_SmtpTransport::newInstance('smtp.gmail.com', 465, 'ssl')
        ->setUsername('amicidigiulita@gmail.com')
        ->setPassword('Amici@230362')
    ;*/
    

    // Create the Mailer using your created Transport
    $mailer = Swift_Mailer::newInstance($transport);

    // Create the message
    $message = Swift_Message::newInstance()

        // Give the message a subject
        ->setSubject($subject)

        // Set the From address with an associative array
        ->setFrom(array('staff@amicidigiulita.it' => 'Staff Amici di Giulita'))

        // Set the To addresses with an associative array
        ->setTo($arrayto)

        // Set the To addresses with an associative array
        ->setBcc(array('staff@amicidigiulita.it' => 'Staff Amici di Giulita'))

        // Give it a body
        ->setBody($body_text)

        // And optionally an alternative body
        ->addPart($body_html, 'text/html')

        // Optionally add any attachments
        //->attach(Swift_Attachment::fromPath('my-document.pdf'))
    ;

    // Send the message
    $result = $mailer->send($message, $failures);
    return $failures;
}
/*******************************************************************************
   UPLOAD IMAGE
*******************************************************************************/
function upload_image($nome_campo, $path_base, $path_rel, $base_name="", $ext_enable=array('PNG', 'JPG')) {
    $errore = false;
    $name = "";
    
    if (is_uploaded_file($_FILES[$nome_campo]['tmp_name'])) {
        $originale = basename($_FILES[$nome_campo]['tmp_name']);
        $path_parts = pathinfo($_FILES[$nome_campo]['name']);
        $extension = strtoupper($path_parts['extension']);

        if (!in_array($extension, array('PNG', 'JPG'))) {
            $errore = true;
            show_message(MSGERROR, "Formato file foto {$i} non permesso!", false);
        }

        if (strlen($originale)) {
            $tipo = $_FILES[$nome_campo]['type'];
            $name = $base_name.substr(md5($originale), 0, 8)."__".$_FILES[$nome_campo]['name'];
            #$res = move_uploaded_file($_FILES[$nome_campo]['tmp_name'], $path_base.$path_rel.$name);
            $res = resize(800, 600, $_FILES[$nome_campo]['tmp_name'], $path_base.$path_rel.$name);
            if (!$res) {
                $errore = true;
                show_message(MSGERROR, "Upload foto {$nome_campo} fallito! (1)", false);
            }
        }
    }
    elseif (strlen(basename($_FILES[$nome_campo]['tmp_name'])) > 0) {
        $errore = true;
        show_message(MSGERROR, "Upload foto {$nome_campo} fallito! (2)", false);
    }
    # else non c'e' niente da uploadare...
    else
        return false;
    if ($errore)
        return false;
    return $name;
}
/*******************************************************************************
   UPLOAD GENERICO
*******************************************************************************/
function upload_file($nome_campo, $path_base, $path_rel, $base_name="", $ext_enable=array('PDF', 'PNG', 'JPG', 'DOC', 'DOCX')) {
    $errore = false;
    $ret = array();
    
    if (is_uploaded_file($_FILES[$nome_campo]['tmp_name'])) {
        $originale = basename($_FILES[$nome_campo]['tmp_name']);
        $path_parts = pathinfo($_FILES[$nome_campo]['name']);
        $extension = strtoupper($path_parts['extension']);

        if (!in_array($extension, $ext_enable)) {
            $errore = true;
            show_message(MSGERROR, "Formato file non permesso!", false);
        }

        if (strlen($originale)) {
            $tipo = $_FILES[$nome_campo]['type'];
            $name = $base_name.substr(md5($originale), 0, 8)."__".$_FILES[$nome_campo]['name'];
            $res = move_uploaded_file($_FILES[$nome_campo]['tmp_name'], $path_base.$path_rel.$name);
            if (!$res) {
                $errore = true;
                show_message(MSGERROR, "Upload file {$nome_campo} fallito! (1)", false);
            }
        }
        $ret["name"] = $name;
        $ret["extension"] = $extension;
    }
    elseif (strlen(basename($_FILES[$nome_campo]['tmp_name'])) > 0) {
        $errore = true;
        show_message(MSGERROR, "Upload file {$nome_campo} fallito! (2)", false);
    }
    # else non c'e' niente da uploadare...
    else {
        #DEBUG("else non c'e' niente da uploadare...");
        return false;
    }
    if ($errore) {
        #DEBUG("errore");
        return false;
    }
    return $ret;
}
/*******************************************************************************
   RESIZE IMAGE
*******************************************************************************/
function resize($width, $height, $original_image, $resized_image){
    /* Get original image x y*/
    list($w, $h) = getimagesize($original_image);
    if (($h/$w > 1 && $height/$width < 1) || ($h/$w < 1 && $height/$width > 1)) {
        $w2 = $width;
        $width = $height;
        $height = $w2;
    }
    /* calculate new image size with ratio */
    $ratio = max($width/$w, $height/$h);
    $h = ceil($height / $ratio);
    $x = ($w - $width / $ratio) / 2;
    $w = ceil($width / $ratio);
    /* new file name */
    $path = $resized_image;  #'uploads/'.$width.'x'.$height.'_'.$_FILES['image']['name'];
    /* read binary data from image file */
    $imgString = file_get_contents($original_image);
    /* create image from string */
    $image = imagecreatefromstring($imgString);
    $tmp = imagecreatetruecolor($width, $height);
    imagecopyresampled($tmp, $image,
        0, 0,
        $x, 0,
        $width, $height,
        $w, $h);
    /* Save image */
    switch (exif_imagetype($original_image)) {
        case IMAGETYPE_JPEG:
            imagejpeg($tmp, $path, 100);
            break;
        case IMAGETYPE_PNG:
            imagepng($tmp, $path, 0);
            break;
        case IMAGETYPE_GIF:
            imagegif($tmp, $path);
            break;
        default:
            return false;
            break;
    }
    /* cleanup memory */
    imagedestroy($image);
    imagedestroy($tmp);
    return $path;
}
/*******************************************************************************
   
*******************************************************************************/
function show_message($tipo, $testo, $bloccante=false) {
    switch ($tipo) {
        case MSGERROR:
            $type = "red";
            break;
        case MSGWARNING:
            $type = "warning";
            break;
        case MSGINFO:
            $type = "info";
            break;
        case MSGSUCCESS:
            $type = "success";
            break;
        case MSGQUESTION:
            $type = "question";
            break;
        case MSGCRITICAL:
            $type = "purple";
            break;
    }
    echo "<p class='{$type} box' style='border-color:#FFF;'>{$testo}</p>";
    if ($bloccante) {
        get_footer();
        exit();
    }
}
?>