<?php
/*

Template Name: Anagrafica

*/

require_once('common.inc.php');
get_header();
check_publisher();

$code_anagrafica = getVar("GET", "anagrafica", getVar("POST", "anagrafica", getVar("POST", "code_anagrafica", "")));

#----- ANAGRAFICA -----------------------------------------------------------------------------------------------------------------
class RecordAnagrafiche extends RecordBase {
    
	public function __construct($id=null) {
        parent::__construct("vw_anagrafiche", "ident", $id);
    }
}
$record = Factory::crea("RecordAnagrafiche");#, $code_anagrafica);
$record->loadFromCode($code_anagrafica);

#----- CHECK ANAGRAFICA
check_anagrafica($record->get('cu'));

#----- REFERENTI ------------------------------------------------------------------------------------------------------------------
$sql = "SELECT *, r.code as code_referente, r.ruolo as ruolo_referente
        FROM anagrafiche_referenti r
        JOIN iscritti i ON i.username=r.username
        WHERE code_anagrafica='{$code_anagrafica}'";
$rs = $db->Esegui($sql);

$referenti = array();
if ($rs != FALSE) {
    $referenti = $rs->GetArray();
}

#----------------------------------------------------------------------------------------------------------------------------------

echo <<<EOT
        <form method="GET" action="indietro.php">
            <button type="submit" class="mybutton">Indietro</button>
        </form>
EOT;
?> 
<h1 class="titolo_pagina">Anagrafica</h1>

<table class="mytable">

<tr>
    <td><label for="tipo">Tipo</label></td>
    <td><?php echo ($record->get("tipo") == "NEGOZIO") ? 'NEGOZIO' : 'CANILE'; ?></td>
</tr>

<tr>
    <td><label for="nome">Ragione sociale</label></td>
    <td><?php echo $record->get("nome"); ?></td>
</tr>

<tr>
    <td><label for="piva">Partita IVA</label></td>
    <td><?php echo $record->get("piva"); ?></td>
</tr>

<tr>
    <td><label for="cf">Codice fiscale</label></td>
    <td><?php echo $record->get("cf"); ?></td>
</tr>

<tr>
    <td><label for="comune">Comune</label></td>
    <td><?php echo $record->get("comune"); ?></td>
</tr>

<tr>
    <td><label for="partenza">Localit&agrave;</label></td>
    <td><?php echo $record->get("localita"); ?></td>
</tr>

<tr>
    <td><label for="regione">Regione</label></td>
    <td><?php echo $record->get("regione"); ?></td>
</tr>

<tr>
    <td><label for="indirizzo">Indirizzo</label></td>
    <td><?php echo $record->get("indirizzo"); ?></td>
</tr>

<tr>
    <td><label for="email">Email principale</label></td>
    <td><?php echo $record->get("email"); ?></td>
</tr>

<tr>
    <td><label for="telefono">Telefono principale</label></td>
    <td><?php echo $record->get("telefono"); ?></td>
</tr>

<tr>
    <td><label for="fax">Fax</label></td>
    <td><?php echo $record->get("fax"); ?></td>
</tr>

<tr>
    <td><label for="url_www">URL sito internet</label></td>
    <td><?php echo $record->get("url_www"); ?></td>
</tr>

<tr>
    <td><label for="url_coordinate_bancarie">URL coordinate bancarie</label></td>
    <td><?php echo $record->get("url_coordinate_bancarie"); ?></td>
</tr>

<tr>
    <td><label for="note">Note</label></td>
    <td><?php echo $record->get("note"); ?></td>
</tr>

</table>
<br>

<?php
echo <<<EOT
    <form method="POST" action="form-anagrafica.php">
        <input type="hidden" name="code_anagrafica" value="{$code_anagrafica}" />
        <button type="submit" class="mybutton">Modifica anagrafica</button>
    </form>
EOT;

echo <<<EOT
    <br>
    <form method="POST" action="form-anagrafica-referente.php">
        <input type="hidden" name="code_anagrafica" value="{$code_anagrafica}" />
        <button type="submit" class="mybutton">Nuovo referente</button>
    </form>
EOT;

echo <<<EOT
    <br />
    <h1 class="titolo_pagina">Referenti</h1>
EOT;

if (count($referenti) == 0) {
    echo "<p style='padding:5px;'>Nessun referente per questa anagrafica.</p>";
}
else {
    echo <<<EOT
    <br>
    <table style="background: #FFF; border: 2px solid #FFF;">
    <thead>
    <tr>
        <th>Ruolo</th>
        <th>Nominativo</th>
        <th>Username</th>
        <th>Email</th>
        <th>Comune</th>
        <th>Localit&agrave;</th>
        <th>&nbsp;</th>
    </tr>
    </thead>
EOT;
    
    foreach ($referenti as $key => $item) {
        
        $bg = "#FFFFFF";
        if ($key % 2) 
            $bg = "#DEDEDE";
            
        $pulsante_dettaglio = <<<EOT
        <form method="POST" action="form-anagrafica-referente.php">
            <input type="hidden" name="anagrafica" value="{$code_anagrafica}" />
            <input type="hidden" name="referente" value="{$item['code_referente']}" />
            <button type="submit" class="mybutton">Modifica</button>
        </form>
EOT;
        echo <<<EOT
    <tr style="background:{$bg}">
        <td style="text-align:center;"><b>{$item['ruolo_referente']}</b></td>
        <td>{$item['cognome']} {$item['nome']}</td>
        <td>{$item['username']}</td>
        <td>{$item['email']}</td>
        <td>{$item['comune']}</td>
        <td>{$item['localita']}</td>
        <td>{$pulsante_dettaglio}</td>
    </tr>    
EOT;
    }
    echo <<<EOT
    </table>
EOT;
}

?> 
    
<?php get_footer(); ?>
