<?php
/*

Template Name: Anagrafiche

*/

require_once('common.inc.php');
get_header();
check_publisher();

#----- RICHIESTE TRASPORTI -----------------------------------------------------------------------------------------------------------------
$sql = "SELECT *
        FROM vw_anagrafiche";
$rs = $db->Esegui($sql);

$anagrafiche = array();
if ($rs != FALSE) {
    $anagrafiche = $rs->GetArray();
}

echo <<<EOT
        <form method="POST" action="form-anagrafica.php">
            <button type="submit" class="mybutton">Nuova anagrafica</button>
        </form>
EOT;

echo <<<EOT
        <h1 class="titolo_pagina">Anagrafiche</h1>
EOT;

if (count($anagrafiche) == 0) {
    echo "<p style='padding:5px;'>Nessuna anagrafica.</p>";
}
else {
    echo <<<EOT
    <table style="background: #FFF; border: 2px solid #FFF;">
    <thead>
    <tr>
        <th>Tipo</th>
        <th>Ragione sociale</th>
        <th>P.IVA</th>
        <th>CF</th>
        <th>Comune</th>
        <th>Localit&agrave;</th>
        <th>&nbsp;</th>
    </tr>
    </thead>
EOT;
    
    $totale = 0;
    foreach ($anagrafiche as $key => $item) {
        
        $bg = "#FFFFFF";
        if ($key % 2) 
            $bg = "#DEDEDE";
            
        if (($utente->publisher() && $item['cu'] == $utente->username) || $utente->administrator())
            $pulsante_dettaglio = <<<EOT
<form method="GET" action="page-anagrafica.php">
    <input type="hidden" name="anagrafica" value="{$item['code']}" />
    <button type="submit" class="mybutton">Dettaglio</button>
</form>
EOT;
        else
            $pulsante_dettaglio = "";
            
        echo <<<EOT
    <tr style="background:{$bg}">
        <td style="text-align:center;"><b>{$item['tipo']}</b></td>
        <td>{$item['nome']}</td>
        <td>{$item['piva']}</td>
        <td>{$item['cf']}</td>
        <td>{$item['comune']}</td>
        <td>{$item['localita']}</td>
        <td>{$pulsante_dettaglio}</td>
    </tr>    
EOT;
    }
    echo <<<EOT
    </table>
EOT;
}
?> 

<?php get_footer(); ?>
