<?php
/*

Template Name: Bacheca

*/

require_once('common.inc.php');

get_header();

#---------------------------------------------------------------------------------------------------------------------------------
# CHECK LOGIN
#---------------------------------------------------------------------------------------------------------------------------------
check_login('page-bacheca.php');
#---------------------------------------------------------------------------------------------------------------------------------
?>
<div class="tabs">
<ul role="tablist">
    <li role="tab" aria-controls="#tab_adozioni_distanza">Adozioni a distanza</li>
    <li role="tab" aria-controls="#tab_richieste_adozione">Richieste di adozione</li>
    <li role="tab" aria-controls="#tab_richieste_stallo">Richieste di stallo</li>
    <li role="tab" aria-controls="#tab_richieste_staffetta">Richieste di staffetta</li>
    <li role="tab" aria-controls="#tab_offerte_staffetta">Offerte di staffetta</li>
    <li role="tab" aria-controls="#tab_raccolte">Raccolte</li>
    <li role="tab" aria-controls="#tab_partecipazioni_iniziative">Partecipazioni a iniziative</li>
    <li role="tab" aria-controls="#tab_richieste_visita">Richieste visita</li>
    <li role="tab" aria-controls="#tab_offerte_visita">Offerte visita</li>
</ul>


<div style="padding:10px;" role="tabpanel" id="tab_adozioni_distanza">
<h1 class="titolo_pagina">Le mie adozioni a distanza</h1>
<?php
##################################################################################################################################
# ADOZIONI A DISTANZA
##################################################################################################################################
$sql = "SELECT *
        FROM donazioni d
        JOIN pelosetti p ON p.code=d.code_pet
        where d.code_utente='{$utente->code}'";
$rs = $db->Esegui($sql); #DEBUG($sql);

$adozioni = array();
if ($rs != FALSE) {
    $adozioni = $rs->GetArray();
}

if (count($adozioni) == 0) {
    echo "Nessuna adozione a distanza effettuata.";
}
else 
    echo <<<EOT
    <table style="background: #FFF; border: 2px solid #FFF;">
    <thead>
    <tr>
        <th>Nome pelosetto</th>
        <th>Provenienza</th>
        <th>Data</th>
        <th style="text-align:right;">Importo annuale</th>
    </tr>
    </thead>
    <tbody>
EOT;
    
$totale = 0;
foreach ($adozioni as $key => $item) {
    $totale += $item['importo_versamento'] * $item['numero_versamenti'];
    $importo = number_format($item['importo_versamento'] * $item['numero_versamenti'], 2, ",", ".");
    $data_inizio = $item['data_inizio'];
    $data_inizio = date("d/m/Y", strtotime($data_inizio));
        
    echo <<<EOT
    <tr>
        <td><b>{$item['nome']}</b></td>
        <td>{$item['provenienza']}</td>
        <td>{$data_inizio}</td>
        <td style="text-align:right;">&euro; {$importo}</td>
    </tr>    
EOT;
}
if (count($adozioni) > 0) {
    $totale = number_format($totale, 2, ",", ".");
    echo <<<EOT
    </tbody>
    <tfoot>
    <tr>
        <td colspan="3">TOTALE ANNUO</td>
        <td class="red" style="text-align:right; font-weight: bold;">&euro; {$totale}</td>
    </tr>
    </tfoot>
    </table>
EOT;
}
?>
</div>


<div style="padding:10px;" role="tabpanel" id="tab_richieste_adozione">
<h1 class="titolo_pagina">Le mie richieste di adozione</h1>
<?php
##################################################################################################################################
# RICHIESTE DI ADOZIONE
##################################################################################################################################
$sql = "SELECT *
        FROM adozioni_interessati d
        JOIN pelosetti p ON p.code=d.code_pelosetto
        where d.code_utente='{$utente->code}'";
$rs = $db->Esegui($sql); #DEBUG($sql);

$adozioni = array();
if ($rs != FALSE) {
    $adozioni = $rs->GetArray();
}

if (count($adozioni) == 0) {
    echo "Nessuna adozione richiesta.";
}
else 
    echo <<<EOT
    <table style="background: #FFF; border: 2px solid #FFF;">
    <thead>
    <tr>
        <th>Nome pelosetto</th>
        <th>Provenienza</th>
    </tr>
    </thead>
    <tbody>
EOT;
    
foreach ($adozioni as $key => $item) {
    echo <<<EOT
    <tr>
        <td><b>{$item['nome']}</b></td>
        <td>{$item['provenienza']}</td>
    </tr>    
EOT;
}
if (count($adozioni) > 0) {
    echo <<<EOT
    </tbody>
    </table>
EOT;
}
?>
</div>


<div style="padding:10px;" role="tabpanel" id="tab_richieste_stallo">
<h1 class="titolo_pagina">Le mie richieste di stallo</h1>
<?php
##################################################################################################################################
# RICHIESTE DI STALLO
##################################################################################################################################
$sql = "SELECT *
        FROM stalli_interessati d
        JOIN pelosetti p ON p.code=d.code_pelosetto
        where d.code_utente='{$utente->code}'";
$rs = $db->Esegui($sql); #DEBUG($sql);

$stalli = array();
if ($rs != FALSE) {
    $stalli = $rs->GetArray();
}

if (count($stalli) == 0) {
    echo "Nessuna stallo richiesto.";
}
else 
    echo <<<EOT
    <table style="background: #FFF; border: 2px solid #FFF;">
    <thead>
    <tr>
        <th>Nome pelosetto</th>
        <th>Provenienza</th>
    </tr>
    </thead>
    <tbody>
EOT;
    
foreach ($stalli as $key => $item) {
    echo <<<EOT
    <tr>
        <td><b>{$item['nome']}</b></td>
        <td>{$item['provenienza']}</td>
    </tr>    
EOT;
}
if (count($stalli) > 0) {
    echo <<<EOT
    </tbody>
    </table>
EOT;
}
?>
</div>


<div style="padding:10px;" role="tabpanel" id="tab_richieste_staffetta">
<h1 class="titolo_pagina">Mie richieste di staffetta</h1>

<?php
##################################################################################################################################
# INTERESSATI STAFFETTA RICHIESTA DA ME 
##################################################################################################################################
$sql = "select i.cognome || ' ' || i.nome as nominativo, t.*, ti.*, t.code as staffetta_code
        FROM staffette t
        LEFT JOIN staffette_interessati ti ON t.code=ti.code_staffetta 
        LEFT JOIN iscritti i ON i.code=ti.code_utente
        where t.tipo='R' 
        AND t.code_utente='{$code_utente}'
        AND t.data_fine>=current_date
        ORDER BY ti.code_staffetta";
$rs = $db->Esegui($sql);

$interessati = array();
if ($rs != FALSE) {
    $interessati = $rs->GetArray();
}
if (count($interessati) == 0) {
    echo "Nessuna staffetta al momento.";
}
else 
    echo <<<EOT
    <table style="background: #FFF; border: 2px solid #FFF;">
    <thead>
    <tr>
        <th>Partenza/Arrivo</th>
        <th>Date</th>
        <th>Specie</th>
        <th>Taglia</th>
    </tr>
    </thead>
EOT;
    
$trasporto_precedente = "";
$i = 0;
foreach ($interessati as $key => $item) { 
    $data_inizio = date("d/m/Y", strtotime($item['data_inizio']));
    $data_fine = date("d/m/Y", strtotime($item['data_fine']));
    $nominativo = ucwords(strtolower($item['nominativo']));
    switch ($item['specie']) {
        case 'C': $specie = "cane"; break;
        case 'G': $specie = "gatto"; break;
        default:  $specie = "qualsiasi"; break;
    }
    switch ($item['taglia']) {
        case 'P': $taglia = "piccola"; break;
        case 'M': $taglia = "media"; break;
        case 'G': $taglia = "grande"; break;
    }
    
    if ($trasporto_precedente != $item['staffetta_code']) {
        $i = 0;
        echo <<<EOT
    <tr>
        <td><b>{$item['partenza_comune']}</b><br /><b>{$item['arrivo_comune']}</b></td>
        <td>{$data_inizio}<br />{$data_fine}</td>
        <td>{$specie}</td>
        <td>{$taglia}</td>
    </tr>    
EOT;
        $trasporto_precedente = $item['staffetta_code'];
    }
    
    $bg = "#E0D1C2";
    if ($i++ % 2) 
        $bg = "#F5F0EB";
        
    if (strlen($nominativo)) {
        echo <<<EOT
    <tr>
        <td style="background:{$bg}"></td>
        <td style="background:{$bg}" colspan="99">Si offre: <b>{$nominativo}</b>, email: <a href="mailto:{$item['email']}">{$item['email']}</a>, telefono: {$item['telefono']}</td>
    </tr>    
EOT;
    }
    else {
        echo <<<EOT
    <tr>
        <td style="background:{$bg}"></td>
        <td style="background:{$bg}" colspan="99">Nessuna offerta al momento.</td>
    </tr>    
EOT;
    }
}
if (count($interessati) > 0) {
    echo <<<EOT
    </table>
EOT;
}

?>
</div>


<div style="padding:10px;" role="tabpanel" id="tab_offerte_staffetta">
<h1 class="titolo_pagina">Mie offerte di staffetta</h1>
<?php
##################################################################################################################################
# INTERESSATI STAFFETTA OFFERTA DA ME 
##################################################################################################################################
$sql = "select i.cognome || ' ' || i.nome as nominativo, t.*, ti.*, t.code as staffetta_code
        FROM staffette t
        LEFT JOIN staffette_interessati ti ON t.code=ti.code_staffetta 
        LEFT JOIN iscritti i ON i.code=ti.code_utente
        where t.tipo='O' 
        AND t.code_utente='{$utente->code}'
        AND t.data_fine>=current_date
        ORDER BY t.code";
$rs = $db->Esegui($sql); #DEBUG($sql);

$interessati = array();
if ($rs != FALSE) {
    $interessati = $rs->GetArray();
}
if (count($interessati) == 0) {
    echo "Nessuna staffetta al momento.";
}
else 
    echo <<<EOT
    <table style="background: #FFF; border: 2px solid #FFF;">
    <thead>
    <tr>
        <th>Partenza/Arrivo</th>
        <th>Date</th>
        <th>Specie</th>
        <th>Taglia</th>
    </tr>
    </thead>
    <tbody>
EOT;
    
$trasporto_precedente = "";
foreach ($interessati as $key => $item) { 
    $data_inizio = date("d/m/Y", strtotime($item['data_inizio']));
    $data_fine = date("d/m/Y", strtotime($item['data_fine']));
    $nominativo = ucwords(strtolower($item['nominativo']));
    switch ($item['specie']) {
        case 'C': $specie = "cane"; break;
        case 'G': $specie = "gatto"; break;
        default:  $specie = "qualsiasi"; break;
    }
    switch ($item['taglia']) {
        case 'P': $taglia = "piccola"; break;
        case 'M': $taglia = "media"; break;
        case 'G': $taglia = "grande"; break;
    }
    
    if ($trasporto_precedente != $item['staffetta_code']) {
        $i = 0;
        echo <<<EOT
    <tr>
        <td><b>{$item['partenza_comune']}</b><br /><b>{$item['arrivo_comune']}</b></td>
        <td>{$data_inizio}<br />{$data_fine}</td>
        <td>{$specie}</td>
        <td>{$taglia}</td>
    </tr>    
EOT;
        $trasporto_precedente = $item['staffetta_code'];
    }
    
    $bg = "#E0D1C2";
    if ($i++ % 2) 
        $bg = "#F5F0EB";
        
    if (strlen($nominativo)) {
        echo <<<EOT
    <tr>
        <td style="background:{$bg}"></td>
        <td style="background:{$bg}" colspan="99">E' interessato: <b>{$nominativo}</b>, email: <a href="mailto:{$item['email']}">{$item['email']}</a>, telefono: {$item['telefono']}</td>
    </tr>    
EOT;
    }
    else {
        echo <<<EOT
    <tr>
        <td style="background:{$bg}"></td>
        <td style="background:{$bg}" colspan="99">Nessuna richiesta al momento.</td>
    </tr>    
EOT;
    }
}

if (count($interessati) > 0) {
    echo <<<EOT
    </tbody>
    </table>
EOT;
}
?> 
</div>


<div style="padding:10px;" role="tabpanel" id="tab_raccolte">
<h1 class="titolo_pagina">Mie raccolte disponibili</h1>
<?php
##################################################################################################################################
# INTERESSATI RACCOLTA ORGANIZZATA DA ME 
##################################################################################################################################
$sql = "select i.cognome || ' ' || i.nome as nominativo, t.*, ti.* ,
        t.code as raccolta_code,
        n.regione as negozio_regione, 
        n.comune as negozio_comune, 
        n.nome as negozio_nome, 
        n.indirizzo as negozio_indirizzo, 
        n.localita as negozio_localita, 
        c.regione as canile_regione, 
        c.comune as canile_comune, 
        c.nome as canile_nome, 
        c.indirizzo as canile_indirizzo,
        c.localita as canile_localita 
        FROM raccolte t
        JOIN vw_anagrafiche_negozi n ON n.code=t.code_negozio
        JOIN vw_anagrafiche_canili c ON c.code=t.code_canile
        LEFT JOIN raccolte_interessati ti ON t.code=ti.code_raccolta 
        LEFT JOIN iscritti i ON i.code=ti.code_utente
        WHERE t.code_utente='{$utente->code}'
        AND t.data_fine>=current_date";
$rs = $db->Esegui($sql); #DEBUG($sql);

$interessati = array();
if ($rs != FALSE) {
    $interessati = $rs->GetArray();
}
if (count($interessati) == 0) {
    echo "Nessuna raccolta al momento.";
}
else 
    echo <<<EOT
    <table style="background: #FFF; border: 2px solid #FFF;">
    <thead>
    <tr>
        <th>Negozio</th>
        <th>Canile</th>
        <th>Termine</th>
    </tr>
    </thead>
    <tbody>
EOT;
    
$raccolta_precedente = "";
$i = 0;
foreach ($interessati as $key => $item) { 
    $data_fine = date("d/m/Y", strtotime($item['data_fine']));
    $nominativo = ucwords(strtolower($item['nominativo']));
    
    if ($raccolta_precedente != $item['raccolta_code']) {
        $i = 0;
        echo <<<EOT
    <tr>
        <td><b>{$item['negozio_nome']}</b></td>
        <td><b>{$item['canile_nome']}</b></td>
        <td>{$data_fine}</td>
    </tr>    
EOT;
        $raccolta_precedente = $item['raccolta_code'];
    }
    
    $bg = "#E0D1C2";
    if ($i++ % 2) 
        $bg = "#F5F0EB";
        
    if (strlen($nominativo)) {
        echo <<<EOT
    <tr>
        <td style="background:{$bg}"></td>
        <td style="background:{$bg}" colspan="99">Si offre: <b>{$nominativo}</b>, email: <a href="mailto:{$item['email']}">{$item['email']}</a>, telefono: <i class="blue icon-phone"></i> {$item['telefono']}</td>
    </tr>    
EOT;
    }
    else {
        echo <<<EOT
    <tr>
        <td style="background:{$bg}"></td>
        <td style="background:{$bg}" colspan="99">Nessuna offerta al momento.</td>
    </tr>    
EOT;
    }
}
if (count($interessati) > 0) {
    echo <<<EOT
    </tbody>
    </table>
EOT;
}
?>
</div>


<div style="padding:10px;" role="tabpanel" id="tab_partecipazioni_iniziative">
<h1 class="titolo_pagina">Mie partecipazioni ad iniziative</h1>
<?php
##################################################################################################################################
# PARTECIPO A QUESTE INIZIATIVE
##################################################################################################################################
$sql = "SELECT i.titolo, i.costo_unitario, i.comune, ip.ct, ip.quantita, ip.importo, ip.versamento, ip.code
        FROM iniziative_partecipanti ip
        JOIN iniziative i ON i.code=ip.code_iniziativa
        WHERE ip.code_utente='{$utente->code}'
        --AND costo_unitario>0
        ORDER BY i.titolo";

$rs = $db->Esegui($sql); #DEBUG($sql);

$partecipazioni = array();
if ($rs != FALSE) {
    $partecipazioni = $rs->GetArray();
}
if (count($partecipazioni) == 0) {
    echo "Nessuna partecipazione al momento.";
}
else 
    echo <<<EOT
    <table style="background: #FFF; border: 2px solid #FFF;">
    <thead>
    <tr>
        <th>Iniziativa</th>
        <th>Costo unitario</th>
        <th>Data</th>
        <th>Q.t&agrave;</th>
        <th></th>
    </tr>
    </thead>
    <tbody>
EOT;
    
$trasporto_precedente = "";
foreach ($partecipazioni as $key => $item) { 
    $data = date("d/m/Y H:i", strtotime($item['ct']));
    
    if (strlen($item['quantita']) == 0) {
    	$importo = number_format($item['importo'], 2, ",", ".");
        $button_versamenti = "<form method='GET' action='page-versamenti.php'><input type='hidden' name='padre' value='{$item['code']}' /><button class='mybutton'>Versamenti</button></form>";
    	$versamento = $item['versamento'];
        if ($versamento != "")
            $versamento = ($versamento == 'U') ? "unico" : "mensile";
    }
    else {
        $importo = number_format($item['costo_unitario'], 2, ",", ".");
        $button_versamenti = $versamento = "";
    }
    
    echo <<<EOT
    <tr>
        <td><b>{$item['titolo']}</b><br />{$item['comune']}</td>
        <td>&euro; {$importo} {$versamento}</td>
        <td>{$data}</td>
        <td>{$item['quantita']}</td>
        <td>{$button_versamenti}</td>
    </tr>    
EOT;
        
}

if (count($partecipazioni) > 0) {
    echo <<<EOT
    </tbody>
    </table>
EOT;
}
?> 
</div>


<div style="padding:10px;" role="tabpanel" id="tab_richieste_visita">
<h1 class="titolo_pagina">Mie richieste di visita pre-affido</h1>

<?php
##################################################################################################################################
# INTERESSATI VISITA RICHIESTA DA ME 
##################################################################################################################################
$sql = "select i.cognome || ' ' || i.nome as nominativo, t.*, ti.*, t.code as visita_code
        FROM visite t
        LEFT JOIN visite_interessati ti ON t.code=ti.code_visita
        LEFT JOIN iscritti i ON i.code=ti.code_utente
        where t.tipo='R' 
        AND t.code_utente='{$code_utente}'
        AND t.data_fine>=current_date
        ORDER BY ti.code_visita";
$rs = $db->Esegui($sql);

$interessati = array();
if ($rs != FALSE) {
    $interessati = $rs->GetArray();
}
if (count($interessati) == 0) {
    echo "Nessuna offerta al momento.";
}
else 
    echo <<<EOT
    <table style="background: #FFF; border: 2px solid #FFF;">
    <thead>
    <tr>
        <th>Comune</th>
        <th>Date</th>
        <th>Note</th>
    </tr>
    </thead>
EOT;
    
$trasporto_precedente = "";
$i = 0;
foreach ($interessati as $key => $item) { 
    $data_inizio = date("d/m/Y", strtotime($item['data_inizio']));
    $data_fine = date("d/m/Y", strtotime($item['data_fine']));
    $nominativo = ucwords(strtolower($item['nominativo']));
    
    if ($trasporto_precedente != $item['visita_code']) {
        $i = 0;
        echo <<<EOT
    <tr>
        <td><b>{$item['comune']}</b><br /><b>{$item['regione']}</b></td>
        <td>{$data_inizio}<br />{$data_fine}</td>
        <td>{$item['note']}</td>
    </tr>    
EOT;
        $trasporto_precedente = $item['visita_code'];
    }
    
    $bg = "#E0D1C2";
    if ($i++ % 2) 
        $bg = "#F5F0EB";
        
    if (strlen($nominativo)) {
        echo <<<EOT
    <tr>
        <td style="background:{$bg}"></td>
        <td style="background:{$bg}" colspan="99">Si offre: <b>{$nominativo}</b>, email: <a href="mailto:{$item['email']}">{$item['email']}</a>, telefono: {$item['telefono']}</td>
    </tr>    
EOT;
    }
    else {
        echo <<<EOT
    <tr>
        <td style="background:{$bg}"></td>
        <td style="background:{$bg}" colspan="99">Nessuna offerta al momento.</td>
    </tr>    
EOT;
    }
}
if (count($interessati) > 0) {
    echo <<<EOT
    </table>
EOT;
}

?>
</div>


<div style="padding:10px;" role="tabpanel" id="tab_offerte_visita">
<h1 class="titolo_pagina">Mie offerte di disponibilit&agrave; ad effettuare una visita pre-affido</h1>
<?php
##################################################################################################################################
# INTERESSATI VISITA OFFERTA DA ME 
##################################################################################################################################
$sql = "select i.cognome || ' ' || i.nome as nominativo, t.*, ti.*, t.code as visita_code
        FROM visite t
        LEFT JOIN visite_interessati ti ON t.code=ti.code_visita
        LEFT JOIN iscritti i ON i.code=ti.code_utente
        where t.tipo='O' 
        AND t.code_utente='{$utente->code}'
        ORDER BY t.code";
$rs = $db->Esegui($sql); #DEBUG($sql);

$interessati = array();
if ($rs != FALSE) {
    $interessati = $rs->GetArray();
}
if (count($interessati) == 0) {
    echo "Nessuna richiesta al momento.";
}
else 
    echo <<<EOT
    <table style="background: #FFF; border: 2px solid #FFF;">
    <thead>
    <tr>
        <th colspan="99">Comune</th>
    </tr>
    </thead>
    <tbody>
EOT;
    
$trasporto_precedente = "";
foreach ($interessati as $key => $item) { 
    $nominativo = ucwords(strtolower($item['nominativo']));
    
    if ($trasporto_precedente != $item['visita_code']) {
        $i = 0;
        echo <<<EOT
    <tr>
        <td colspan="99"><b>{$item['comune']}</b></td>
    </tr>    
EOT;
        $trasporto_precedente = $item['visita_code'];
    }
    
    $bg = "#E0D1C2";
    if ($i++ % 2) 
        $bg = "#F5F0EB";
        
    if (strlen($nominativo)) {
        echo <<<EOT
    <tr>
        <td style="background:{$bg}"></td>
        <td style="background:{$bg}" colspan="99">E' interessato: <b>{$nominativo}</b>, email: <a href="mailto:{$item['email']}">{$item['email']}</a>, telefono: {$item['telefono']}</td>
    </tr>    
EOT;
    }
    else {
        echo <<<EOT
    <tr>
        <td style="background:{$bg}"></td>
        <td style="background:{$bg}" colspan="99">Nessuna richiesta al momento.</td>
    </tr>    
EOT;
    }
}

if (count($interessati) > 0) {
    echo <<<EOT
    </tbody>
    </table>
EOT;
}
?> 
</div>
</div>

<?php get_footer(); ?>
