<?php
/*

Template Name: Page Richieste di pelosetto

*/

require_once('common.inc.php');
get_header();

#----- CERCO -----------------------------------------------------------------------------------------------------------------
$sql = "SELECT c.*, 
        p.regione
        FROM cerco c
        JOIN province p ON p.sigla=c.provincia
        WHERE c.trovato='N'
        ORDER BY c.ct DESC";
$rs = $db->Esegui($sql);

$cerco = array();
if ($rs != FALSE) {
    $cerco = $rs->GetArray();
}

echo <<<EOT
<div>
    <form method="GET" action="form-cerco.php" style="margin-bottom:1em;">
        <button type="submit" class="mybutton">Nuova richiesta</button>
    </form>
</div>
EOT;

echo <<<EOT
        <h1 class="titolo_pagina">Cerchiamo un pelosetto</h1>
EOT;

if (count($cerco) == 0) {
    echo "<p style='padding:5px;'>Nessuna richiesta attiva.</p>";
}
else {
    echo <<<EOT
    <br>
    <table style="border: 2px solid #FFF;" class="source-sans-pro responsive" data-max="15">
    <thead>
    <tr>
        <th class="">Regione</th>
        <th class="">Comune</th>
        <th class="">Specie</th>
        <th class="">Taglia</th>
        <th class="">Et&agrave;</th>
        <th class="">Genere</th>
        <th class="">Data richiesta</th>
        <th class="">&nbsp;</th>
    </tr>
    </thead>
EOT;
    
    foreach ($cerco as $key => $item) {    
        $bg = "#FFFFFF";
        if ($key % 2) 
            $bg = "#DEDEDE";
            
        $pulsante_dettaglio = <<<EOT
        <form method="GET" action="/form-cerco.php">
            <input type="hidden" name="cerco" value="{$item['code']}" />
            <button type="submit" class="green">Modifica</button>
        </form>
EOT;
    
        $specie = (strlen($item['specie'])==0) ? "n.d." : $specie_pelosetti[$item['specie']];
        $taglia = (strlen($item['taglia'])==0) ? "n.d." : $taglie_pelosetti[$item['taglia']];
        $genere = (strlen($item['genere'])==0) ? "n.d." : $genere_pelosetti[$item['genere']];
        $eta = (strlen($item['eta'])==0) ? "n.d." : $eta_pelosetti[$item['eta']];


        $data_richiesta = date("d/m/Y", strtotime($item['ct']));
        echo <<<EOT
    <tr style="background:{$bg}">
        <td>{$item['regione']}</td>
        <td>{$item['comune']}</td>
        <td>{$specie}</td>
        <td>{$taglia}</td>
        <td>{$eta}</td>
        <td>{$genere}</td>
        <td style="text-align:center">{$data_richiesta}</td>
        <td>{$pulsante_dettaglio}</td>
    </tr>    
EOT;
    }
    echo <<<EOT
    </table>
EOT;
}
?> 

<?php get_footer(); ?>
