<?php
/*

Template Name: Galleria pelosetti

*/

require_once('common.inc.php');

$stato = getVar("GET", "stato", "");
if (strlen($stato) == 0)
    $flag_stato = "flag_stato='disponibile'";
else
    $flag_stato = "flag_stato='{$stato}'";
    
if (getVar("GET", "clear", 0) == 1) {
    unset($_SESSION["filtri"]);
}

/*
    [flt_dove_regione] => 
    [flt_dove_provincia] => 
    [flt_specie] => 
    [flt_genere] => 
    [flt_eta] => 
    [flt_taglia] => 
    [flt_nome] => 
    [flt_tipo_adozione] => on
    [flt_tipo_adozionedist] => on
    [flt_tipo_stallo] => on
*/
$filtri_attivi = false;
if (isset($_SESSION["filtri"])) {
    $filtri = $_SESSION["filtri"];
    $filtri_attivi = true;
}
else {
    $filtri = array(
        "flt_tipo_adozione" => 'S',
        "flt_tipo_adozionedist" => 'S',
        "flt_tipo_stallo" => 'S',
        "flt_dove_regione" => '',
        "flt_dove_provincia" => '',
        "flt_specie" => '',
        "flt_genere" => '',
        "flt_eta" => '',
        "flt_taglia" => '',
        "flt_nome" => ''
    );
}
$filtro = "";
if (getVar("POST", "ok_filtra", 0) == 1) {
    $filtri_attivi = true;
    $filtri["flt_tipo_adozione"] = getVar("POST", "flt_tipo_adozione", 'N');
    $filtri["flt_tipo_adozionedist"] = getVar("POST", "flt_tipo_adozionedist", 'N');
    $filtri["flt_tipo_stallo"] = getVar("POST", "flt_tipo_stallo", 'N');
    
    $filtri["flt_dove_regione"] = getVar("POST", "flt_dove_regione", '');
    $filtri["flt_dove_provincia"] = getVar("POST", "flt_dove_provincia", '');
    
    $filtri["flt_specie"] = getVar("POST", "flt_specie", '');
    $filtri["flt_genere"] = getVar("POST", "flt_genere", '');
    
    $filtri["flt_eta"] = getVar("POST", "flt_eta", '');
    $filtri["flt_taglia"] = getVar("POST", "flt_taglia", '');
    
    $filtri["flt_nome"] = getVar("POST", "flt_nome", '');
}
    
if ($filtri_attivi) {

    $filtro .= " AND (1=0 ";
    if ($filtri["flt_tipo_adozione"] == 'S')
        $filtro .= " OR flag_adotta='S' ";
    if ($filtri["flt_tipo_adozionedist"] == 'S')
        $filtro .= " OR flag_adottadist='S' ";
    if ($filtri["flt_tipo_stallo"] == 'S')
        $filtro .= " OR flag_stallo='S' ";
    $filtro .= ")";
        
    if (strlen($filtri["flt_dove_regione"]) > 0)
        $filtro .= " AND pr.regione='{$filtri["flt_dove_regione"]}' ";
    if (strlen($filtri["flt_dove_provincia"]) > 0)
        $filtro .= " AND pr.provincia='{$filtri["flt_dove_provincia"]}' ";
        
    if (strlen($filtri["flt_specie"]) > 0)
        $filtro .= " AND specie='{$filtri["flt_specie"]}' ";
    if (strlen($filtri["flt_genere"]) > 0)
        $filtro .= " AND genere='{$filtri["flt_genere"]}' ";
        
    if (strlen($filtri["flt_eta"]) > 0) {
        if ($filtri["flt_eta"] == 'C') 
            $filtro .= " AND current_date-COALESCE(nascita_data, date(nascita_anno ||'-07-01'))<=365 ";
        elseif ($filtri["flt_eta"] == 'A') 
            $filtro .= " AND current_date-COALESCE(nascita_data, date(nascita_anno ||'-07-01'))>365 ";
    }
    if (strlen($filtri["flt_taglia"]) > 0)
        $filtro .= " AND taglia='{$filtri["flt_taglia"]}' ";
        
    if (strlen($filtri["flt_nome"]) > 0)
        $filtro .= " AND nome ilike '%{$filtri["flt_nome"]}%' ";
        
    $_SESSION["filtri"] = $filtri;    
}
#print_r($filtri);

    
#---------------------------------------------------------------------------------------------------------------------------------

$sql = "SELECT p.*, pr.regione,
        (select sum(importo_versamento * numero_versamenti) FROM donazioni where code_pet=p.code) as importo
        FROM pelosetti p
        JOIN province pr ON p.provincia=pr.sigla
        WHERE {$flag_stato} {$filtro}
        
        
        /*WHERE p.code NOT IN (
            SELECT code_pelosetto FROM stalli_interessati WHERE valido=true AND deleted=false
            UNION
            SELECT code_pelosetto FROM adozioni_interessati WHERE valido=true AND deleted=false
        )*/
        ORDER BY ident desc";
$rs = $db->Esegui($sql); #DEBUG($sql);

$pelosetti = array();
if ($rs != FALSE) {
    $pelosetti = $rs->GetArray();
}
foreach ($pelosetti as $key => $item) {
    $genere_pelosetto = $genere_pelosetti[$item['genere']];
    $pelosetti[$key]["genere_pelosetto"] = $genere_pelosetto;
    $taglia_pelosetto = $taglie_pelosetti[$item['taglia']];
    $pelosetti[$key]["taglia_pelosetto"] = $taglia_pelosetto;
    
    # ----- FOTO -------------------------------------------------------------------------------------
    if (strlen($item['adozione_foto']))
        $pelosetti[$key]["foto1"] = $item['adozione_foto'];
    
    # ----- DESCRIZIONE ------------------------------------------------------------------------------
    if (strlen($item['adozione_descrizione']))
        $pelosetti[$key]["carattere_descrizione"] = $item['adozione_descrizione'];
    
    
    # ----- CALCOLO ETA' -----------------------------------------------------------------------------
    if (strlen($item['nascita_data']))
        $eta = intval(date_sottrazione(date('Y-m-d'), $item['nascita_data'], 'm')); 
    elseif (strlen($item['nascita_anno']))
        $eta = intval(date_sottrazione(date('Y-m-d'), $item['nascita_anno']."-07-01", 'm'));
    else
        $eta = "incerta";
    if ($eta > 24)
        $eta = intval($eta / 12)." anni";
    elseif ($eta == 1)
        $eta = "1 mese";
    elseif ($eta > 1)
        $eta .= " mesi";
        
    $pelosetti[$key]["eta"] = $eta;
        
    # ----- CALCOLO PRESSO CHI -----------------------------------------------------------------------
    $attualmente_dove = $item["comune"];
    
    if ($item['flag_stato'] == "adottato") {
        $attualmente_presso = "";
        $attualmente_dove = "";
        if (strlen($item['adozione_username']) > 0) {
            $u = get_user_from_username($item['adozione_username']);
            $attualmente_presso = "{$u["nome"]} {$u["cognome"]}";
            $attualmente_dove = "{$u["comune"]}";
        }
    }
    else {
        if (strlen($item['code_canile']) > 0) {
            $canile = new Anagrafica();
            $canile->loadFromCode($item['code_canile']);
            $attualmente_presso = "{$canile->get('nome')}";
        }
        elseif (strlen($item['stallo_username']) > 0) {
            $u = get_user_from_username($item['stallo_username']);
            $attualmente_presso = "{$u["nome"]} {$u["cognome"]}";
        }
        elseif (strlen($item['stallo_altro_riferimento']) > 0) {
            $attualmente_presso = "{$item['stallo_altro_riferimento']}";
        }
    }
       
    $pelosetti[$key]["attualmente_presso"] = $attualmente_presso;
    $pelosetti[$key]["attualmente_dove"] = $attualmente_dove;
    
    # FACEBOOK
    $slug = slug_simple($item['nome']);
    $regione = slug_simple($item['regione']);
    $comune = slug_simple($attualmente_dove);
    
    $pelosetti[$key]['url'] = "{$SYS['BASE_URL']}pelosetti/{$regione}/{$comune}/{$slug}/{$item['code']}";
    
    # ----- DISPONIBILE PER --------------------------------------------------------------------------
    $diponibile_per = "";
    if ($item['flag_adotta'] == 'S')
        $diponibile_per .= "adozione, "; 
    if ($item['flag_adottadist'] == 'S')
        $diponibile_per .= "adozione a distanza, "; 
    if ($item['flag_stallo'] == 'S')
        $diponibile_per .= "stallo, "; 
    if (strlen($diponibile_per) > 0)
        $diponibile_per = substr($diponibile_per, 0, -2);
    else
        $diponibile_per = "non disponibile";
    
    $pelosetti[$key]["diponibile_per"] = $diponibile_per;
}

#------------------------------------------------------------------------------------------------------
$smarty->assign("pelosetti", $pelosetti);
$smarty->assign("filtri", $filtri);
$smarty->assign("filtri_attivi", $filtri_attivi);
$smarty->assign("stato", $stato);
$smarty->display("page-gallery.tpl");
?>
