<?php
require_once('common.inc.php');

$code_iniziativa = getVar("POST", "iniziativa", getVar("POST", "code_iniziativa", getVar("GET", "iniziativa", getVar("GET", "iniziative"))));

#----- INIZIATIVE -----------------------------------------------------------------------------------------------------------------
$sql = "SELECT e.*, p.regione
        FROM iniziative e
        JOIN province p ON e.provincia=p.sigla
        WHERE e.code='{$code_iniziativa}'
        ORDER BY data_inizio";
$rs = $db->Esegui($sql);

$iniziativa = array();
if ($rs != FALSE) {
    $iniziativa = $rs->FetchRow();
    $slug = slug_simple($iniziativa['titolo']);
    $regione = slug_simple($iniziativa['regione']);
    $comune = slug_simple($iniziativa['comune']);
    
    $iniziativa['url'] = "{$SYS['BASE_URL']}iniziative/{$regione}/{$comune}/{$slug}/{$iniziativa['code']}";
}

#----- NOTIZIE -----------------------------------------------------------------------------------------------------------------
$sql = "SELECT *
        FROM notizie 
        WHERE code_padre='{$code_iniziativa}'
        ORDER BY data desc";
$rs = $db->Esegui($sql);

$notizie = array();
if ($rs != FALSE) {
    $notizie = $rs->GetArray();
}

#----- PARTECIPANTI -----------------------------------------------------------------------------------------------------------------
$sql = "SELECT i.*, p.quantita, p.importo, p.versamento
        FROM iniziative_partecipanti p
        JOIN iscritti i ON i.code=p.code_utente
        WHERE p.code_iniziativa='{$code_iniziativa}'
        ORDER BY p.ident desc";
$rs = $db->Esegui($sql);

$partecipanti = array();
if ($rs != FALSE) {
    $partecipanti = $rs->GetArray();
}

$iniziativa_testo = strip_tags($iniziativa['testo']);

$meta_tags = <<<EOT
<meta property="og:url" content="{$iniziativa['url']}" />
<meta property="og:title" content="{$iniziativa['titolo']}" />
<meta property="og:image" content="{$SYS['BASE_URL']}{$iniziativa['immagine']}" />
<meta property="og:description" content="{$iniziativa_testo}" />
EOT;

#---------------------------------------------------------------------------------------------------------------------------------
$smarty->assign("meta_tags", $meta_tags);
$smarty->assign('iniziativa', $iniziativa);
$smarty->assign('notizie', $notizie);
$smarty->assign('partecipanti', $partecipanti);
$smarty->display("page-iniziativa.tpl");
?>