<?php
/*

Template Name: Page Link utili

*/

require_once('common.inc.php');
get_header();

#----- LINK UTILI-----------------------------------------------------------------------------------------------------------------
$sql = "SELECT *
        FROM link_utili";
$rs = $db->Esegui($sql);

$cerco = array();
if ($rs != FALSE) {
    $cerco = $rs->GetArray();
}

if ($utente->publisher()) {
    echo <<<EOT
<div>
    <form method="POST" action="form-link-utile.php" style="margin-bottom:1em;">
        <button type="submit" class="mybutton">Nuovo link</button>
    </form>
</div>
EOT;
}

echo <<<EOT
        <h1 class="titolo_pagina">Link utili</h1>
EOT;

if (count($cerco) == 0) {
    echo "<p style='padding:5px;'>Nessun link presente.</p>";
}
else {
    echo <<<EOT
    <br>
    <table style="border: 2px solid #FFF;" class="source-sans-pro responsive" data-max="15">
    <thead>
    <tr>
        <th class="">Titolo</th>
        <th class="">Link</th>
        <th class="">&nbsp;</th>
    </tr>
    </thead>
EOT;
    
    foreach ($cerco as $key => $item) {    
        $bg = "#FFFFFF";
        if ($key % 2) 
            $bg = "#DEDEDE";
            
        $pulsante_dettaglio = <<<EOT
        <form method="GET" action="{$site_url}/form-link-utile.php">
            <input type="hidden" name="link" value="{$item['code']}" />
            <button type="submit" class="mybutton">Modifica</button>
        </form>
EOT;
    
        
        echo <<<EOT
    <tr style="background:{$bg}">
        <td>{$item['titolo']}</td>
        <td><a href="{$item['url_www']}" target="_blank" class="noicon">{$item['url_www']}</a></td>
        <td>{$pulsante_dettaglio}</td>
    </tr>    
EOT;
    }
    echo <<<EOT
    </table>
EOT;
}
?> 

<?php get_footer(); ?>
