<?php
/*

Template Name: Mie adozioni

*/

require_once('common.inc.php');


#----- DONAZIONI -----------------------------------------------------------------------------------------------------------------
$sql = "SELECT *
        FROM donazioni d
        JOIN pelosetti p ON p.code=d.code_pet
        where code_utente='{$code_utente}'";
$rs = $db->Esegui($sql);

$adozioni = array();
if ($rs != FALSE) {
    $adozioni = $rs->GetArray();
}

get_header(); ?>

	<?php
    /* Run the loop to output the pages.
	 * If you want to overload this in a child theme then include a file
	 * called loop-page.php and that will be used instead.
	*/
    the_post();
    #get_template_part( 'loop', 'page' );
    ?>
    
<?php
if (count($adozioni) == 0) {
    echo "Nessuna adozione a distanza effettuata.";
}
else 
    echo <<<EOT
    <h1>Le mie adozioni a distanza</h1><br>
    <table style="background: #FFF; border: 2px solid #FFF;">
    <tr style="background:#369; color:#FFF;">
        <td>Nome pelosetto</td>
        <td>Provenienza</td>
        <td>Data</td>
        <td>Importo annuale</td>
    </tr>
EOT;
    
$totale = 0;
foreach ($adozioni as $key => $item) {
    $totale += $item['importo_annuale'];
    $importo = number_format($item['importo_annuale'], 2, ",", ".");
    $data_inizio = $item['data_inizio'];
    $data_inizio = date("d/m/Y", strtotime($data_inizio));

    $bg = "#FFFFFF";
    if ($key % 2) 
        $bg = "#DEDEDE";
    
    echo <<<EOT
    <tr style="background:{$bg}">
        <td><h1>{$item['nome']}</h1></td>
        <td><h3>{$item['provenienza']}</h3></td>
        <td><h3>{$data_inizio}</h3></td>
        <td style="text-align:right;">{$importo}</td>
    </tr>    
EOT;
}
if (count($adozioni) > 0) {
    $totale = number_format($totale, 2, ",", ".");
    echo <<<EOT
    <tr style="background:#333; color:#FFF;">
        <td colspan="3">TOTALE ANNUO</td>
        <td style="text-align:right; font-weight: bold;">{$totale}</td>
    </tr>
    </table>
EOT;
}
?> 

<?php get_footer(); ?>
