<?php
/*

Template Name: Pelosetti in stand-by

*/

require_once('common.inc.php');
#---------------------------------------------------------------------------------------------------------------------------------

$sql = "SELECT p.*
        FROM pelosetti p
        WHERE p.code IN (
            SELECT code_pelosetto FROM stalli_interessati WHERE valido=true AND deleted=false
            UNION
            SELECT code_pelosetto FROM adozioni_interessati WHERE valido=true AND deleted=false
        )
        ORDER BY ident desc";
$rs = $db->Esegui($sql);

$pelosetti = array();
if ($rs != FALSE) {
    $pelosetti = $rs->GetArray();
}

get_header(); ?>

	<?php
    /* Run the loop to output the pages.
	 * If you want to overload this in a child theme then include a file
	 * called loop-page.php and that will be used instead.
	*/
    the_post();
    #get_template_part( 'loop', 'page' );
    ?>

<?php
if (in_array('administrator', $GLOBALS['current_user']->roles)) {
    echo <<<EOT
        
EOT;
}
if (count($pelosetti) == 0) {
    echo "Nessun pelosetto in attesa.";
}
else 

    echo <<<EOT
    <p>In questa sezione troverete pelosetti per cui sono presenti delle offerte di adozione o stallo.</p>
    <br />
    <table border='1'>
    
EOT;
    
foreach ($pelosetti as $key => $item) {
    $flag_adottadist = $item['flag_adottadist'];
    $urgente = "";
    if ($item['flag_urgente'] == 'S')
        $urgente = "<span style='font-size:1.4em; color:#A00; font-weight:bold;'>URGENTE</span>";
    
    echo <<<EOT
    <tr>
        <td><img src="{$item['foto1']}" height="50px" /></td>
        <td>{$urgente}</td>
        <td><h1>{$item['nome']}</h1></td>
        <td><h3>{$item['provenienza']}</h3></td>
EOT;
        
    echo <<<EOT
        <td><form method="POST" action="{$site_url}/presentazione-pelosetto/">
            <input type="hidden" name="code" value="{$item['code']}" />
            <button type="submit">Conferma</button>
        </form></td>
EOT;
    echo <<<EOT
        <td><form method="POST" action="{$site_url}/pelosetto/">
            <input type="hidden" name="code_pelosetto" value="{$item['code']}" />
            <button type="submit">Annulla</button>
        </form></td>
EOT;
    echo <<<EOT
        
    </tr>    
EOT;
 
}
if (count($pelosetti) > 0)
    echo "</table>";
?> 

<?php get_footer(); ?>
