<?php
/*

Template Name: Presentazione pelosetto

*/

require_once('common.inc.php');

$code_pelosetto = getVar("GET", "pelosetto", getVar("POST", "code", getVar("POST", "pelosetto")));
$sql = "SELECT p.*, pr.regione FROM pelosetti p
        JOIN province pr ON p.provincia=pr.sigla
        WHERE p.code='{$code_pelosetto}'";
$rs = $db->Esegui($sql);

$pelosetto = array();
if ($rs != FALSE) {
    $pelosetto = $rs->FetchRow();
}

$sql = "SELECT * FROM vw_anagrafiche WHERE code='{$pelosetto['code_canile']}'";
$rs = $db->Esegui($sql);

$canile = array();
if ($rs != FALSE) {
    $canile = $rs->FetchRow();
}

# FACEBOOK
$slug = slug_simple($pelosetto['nome']);
$regione = slug_simple($pelosetto['regione']);
$comune = slug_simple($pelosetto['comune']);
$url = "{$SYS['BASE_URL']}pelosetti/{$regione}/{$comune}/{$slug}/{$pelosetto['code']}";
$descrizione = strip_tags($pelosetto['carattere_descrizione']);

$meta_tags = <<<EOT
<meta property="og:url" content="{$url}" />
<meta property="og:title" content="{$pelosetto['nome']}" />
<meta property="og:description" content="{$descrizione}" />
<meta property="og:image" content="{$SYS['BASE_URL']}{$pelosetto['foto1']}" />
EOT;

$smarty->assign("meta_tags", $meta_tags);
get_header(); 

# ----- DISPONIBILE PER --------------------------------------------------------------------------
$diponibile_per = "";
if ($pelosetto['flag_adotta'] == 'S')
    $diponibile_per .= "adozione, "; 
if ($pelosetto['flag_adottadist'] == 'S')
    $diponibile_per .= "adozione a distanza, "; 
if ($pelosetto['flag_stallo'] == 'S')
    $diponibile_per .= "stallo, "; 
if (strlen($diponibile_per) > 0)
    $diponibile_per = substr($diponibile_per, 0, -2);
else
    $diponibile_per = "non disponibile";

$urgente = "";
if ($pelosetto['flag_urgente'] == 'S')
    $urgente = "<span style='font-size:1.4em; color:#A00; font-weight:bold;'>URGENTE</span>";
##################################
echo <<<EOT
<div class='row'>
        <form method="GET" action="{$history->indietro()}" style="float:left">
            <button class="mybutton" type="submit">Indietro</button>
        </form>
EOT;
if ($pelosetto["flag_stato"] != "adottato") {
    if ($pelosetto['flag_adotta'] == 'S')
        echo <<<EOT
            <form method="GET" action="/form-adozione-interesse.php" style="float:left">
                <input type="hidden" name="pelosetto" value="{$pelosetto['code']}" />
                <button type="submit" class="mybutton">Adottami</button>
            </form>
EOT;
    if ($pelosetto['flag_adottadist'] == 'S')
        echo <<<EOT
            <form method="GET" action="/form-nuova-donazione.php" style="float:left">
                <input type="hidden" name="pelosetto" value="{$pelosetto['code']}" />
                <button type="submit" class="mybutton">Adottami a distanza</button>
            </form>
EOT;
    if ($pelosetto['flag_stallo'] == 'S')
        echo <<<EOT
            <form method="GET" action="/form-stallo-interesse.php" style="float:left">
                <input type="hidden" name="pelosetto" value="{$pelosetto['code']}" />
                <button type="submit" class="mybutton">Ospitami in stallo</button>
            </form>
EOT;
}
if ($utente->publisher()) {
    echo <<<EOT
    <form method="GET" action="/form-notizia.php" style="float:left">
        <input type="hidden" name="padre" value="{$pelosetto['code']}" />
        <button class="blue" type="submit">Nuova notizia</button>
    </form>
EOT;
    if ($pelosetto["flag_stato"] == "adottato") 
        echo <<<EOT
    <form method="GET" action="/form-adottante.php" style="float:left">
        <input type="hidden" name="pelosetto" value="{$pelosetto['code']}" />
        <button class="blue" type="submit">Adottante</button>
    </form>
EOT;
}
if ($utente->publisher()) {
    echo <<<EOT
    <form method="GET" action="/form-allegato.php" style="float:left">
        <input type="hidden" name="padre" value="{$pelosetto['code']}" />
        <button class="blue" type="submit">Aggiungi allegato</button>
    </form>
EOT;
}
echo "</div>";
###################################
?>


<!-- Second, add the Timer and Easing plugins -->
<!--script type="text/javascript" src="js/plugins/jquery.timers-1.2.js"></script>
<script type="text/javascript" src="js/plugins/jquery.easing.1.3.js"></script-->

<!-- Third, add the GalleryView Javascript and CSS files -->
<link rel="stylesheet" href="/css/flexslider.css" type="text/css" media="screen" />
<script defer src="/js/plugins/jquery.flexslider-min.js"></script>

<!-- Lastly, call the galleryView() function on your unordered list(s) -->
<script type="text/javascript">
	$(function(){
		$('.flexslider').flexslider({
            animation: "slide",
            animationLoop: true,
            itemWidth: 210,
            itemMargin: 5,    
            minItems: 1,
            maxItems: 2,
            pausePlay: true,
            start: function(slider){
                $('body').removeClass('loading');
            }
        });
    });
</script>





<?php
$utils->CSS_set_backgrounds(array("#FFF", "#EFEFEF"));
echo <<<EOT
<h1 class="titolo_pagina">{$pelosetto['nome']}</h1>
EOT;
# ----- URGENTE ----------------------------------------------------------------------------------
if ($pelosetto['flag_urgente'] == 'S' && $pelosetto["flag_stato"] != "adottato")
    echo <<<EOT
    <div class='row' style='background:{$utils->CSS_alternate_background()}'>
        <div class='one sixth half-padded mytable_label'></div>
        <div class='five sixths half-padded'>{$urgente}</div>
    </div>
EOT;
# ----- NASCITA ----------------------------------------------------------------------------------
$data_nascita = date_translate($pelosetto['nascita_data'], 'us', 'it');
echo <<<EOT
    <div class='row' style='background:{$utils->CSS_alternate_background()}'>
        <div class='one sixth half-padded mytable_label'>Anno/data di nascita</div>
        <div class='five sixths half-padded'><span class="orange">{$pelosetto['nascita_anno']}</span> - {$data_nascita}</div>
    </div>
EOT;
# ----- GENERE -----------------------------------------------------------------------------------
echo <<<EOT
    <div class='row' style='background:{$utils->CSS_alternate_background()}'>
        <div class='one sixth half-padded mytable_label'>Genere</div>
        <div class='five sixths half-padded'>{$genere_pelosetti[$pelosetto['genere']]}</div>
    </div>
EOT;
# ----- PROVENIENZA ------------------------------------------------------------------------------
echo <<<EOT
    <div class='row' style='background:{$utils->CSS_alternate_background()}'>
        <div class='one sixth half-padded mytable_label'>Provenienza</div>
        <div class='five sixths half-padded'>{$pelosetto['provenienza']}</div>
    </div>
EOT;
if ($pelosetto["flag_stato"] != "adottato") {
    # ----- CANILE -----------------------------------------------------------------------------------
    if (strlen($pelosetto['code_canile']) > 0) {
        $indirizzo = (strlen($canile['indirizzo'])) ? $canile['indirizzo']."," : "";
        $localita = (strlen($canile['localita'])) ? "localit&agrave; ".$canile['localita']."," : "";
        $attualmente_presso = <<<EOT
            <h3>{$canile['nome']}</h3>
            <p>{$indirizzo} {$localita} {$canile['comune']} - {$canile['regione']}<br />
                <a href="{$canile['url_www']}" target="_blanc">{$canile['url_www']}</a>
            </p>
EOT;
    }
    # ----- UTENTE -----------------------------------------------------------------------------------
    elseif (strlen($pelosetto['stallo_username']) > 0) {
        $u = get_user_from_username($pelosetto['stallo_username']);
        $attualmente_presso = <<<EOT
            <h3>{$u["nome"]} {$u["cognome"]}</h3>
            <p>{$pelosetto["comune"]}</p>
EOT;
    }
    # ----- NON UTENTE -------------------------------------------------------------------------------
    elseif (strlen($pelosetto['stallo_altro_riferimento']) > 0) {
        $attualmente_presso = <<<EOT
            <h3>{$pelosetto["stallo_altro_riferimento"]}</h3>
            <p>{$pelosetto["comune"]}</p>
EOT;
    }
    # ----- ATTUALMENTE PRESSO -----------------------------------------------------------------------
    if (strlen($attualmente_presso) > 0) {
        echo <<<EOT
        <div class='row' style='background:{$utils->CSS_alternate_background()}'>
            <div class='one sixth half-padded mytable_label'>Attualmente presso</div>
            <div class='five sixths half-padded'>
                {$attualmente_presso}
                {$pelosetto['stallo_note']}
            </div>
        </div>
EOT;
    }
}
# ----- FOTO -------------------------------------------------------------------------------------
echo "<div class='row' style='background:{$utils->CSS_alternate_background()}'>
        <div class='one sixth half-padded mytable_label'>Foto</div>
        <div class='five sixths half-padded'><div class='flexslider'><ul class='slides'>";
for ($f=1; $f<=5; $f++) {
    $foto = "foto".$f;
    if (strlen($pelosetto[$foto]))
        echo "<li class='noicon' ><img src='{$pelosetto[$foto]}' alt='' /></li>";
}
echo "</ul></div></div></div>";

# ----- RAZZA ------------------------------------------------------------------------------------
if ($pelosetto['razza'] == 'S') {
    echo <<<EOT
    <div class='row' style='background:{$utils->CSS_alternate_background()}'>
        <div class='one sixth half-padded mytable_label'>Razza</div>
        <div class='five sixths half-padded'>{$pelosetto['razza_principale']}</div>
    </div>
EOT;
}
else {
    echo <<<EOT
    <div class='row' style='background:{$utils->CSS_alternate_background()}'>
        <div class='one sixth half-padded mytable_label'>Razza mista</div>
        <div class='five sixths half-padded'>{$pelosetto['razza_principale']} {$pelosetto['razza_secondaria']}</div>
    </div>
EOT;
}
# ----- TAGLIA -----------------------------------------------------------------------------------
echo <<<EOT
    <div class='row' style='background:{$utils->CSS_alternate_background()}'>
        <div class='one sixth half-padded mytable_label'>Taglia</div>
        <div class='five sixths half-padded'>{$taglie_pelosetti[$pelosetto['taglia']]}</div>
    </div>
EOT;
# ----- MANTELLO ---------------------------------------------------------------------------------
echo <<<EOT
    <div class='row' style='background:{$utils->CSS_alternate_background()}'>
        <div class='one sixth half-padded mytable_label'>Mantello</div>
        <div class='five sixths half-padded'>{$pelosetto['mantello']}</div>
    </div>
EOT;
# ----- PELO -------------------------------------------------------------------------------------
echo <<<EOT
    <div class='row' style='background:{$utils->CSS_alternate_background()}'>
        <div class='one sixth half-padded mytable_label'>Pelo</div>
        <div class='five sixths half-padded'>{$pelo_pelosetti[$pelosetto['pelo']]}</div>
    </div>
EOT;
# ----- STERILIZZATO -----------------------------------------------------------------------------
echo <<<EOT
    <div class='row' style='background:{$utils->CSS_alternate_background()}'>
        <div class='one sixth half-padded mytable_label'>Sterilizzato</div>
        <div class='five sixths half-padded'>{$sino[$pelosetto['sterilizzato']]}</div>
    </div>
EOT;
# ----- CARATTERE --------------------------------------------------------------------------------
if ($pelosetto["flag_stato"] != "adottato") {
    echo <<<EOT
    <div class='row' style='background:{$utils->CSS_alternate_background()}'>
        <div class='one sixth half-padded mytable_label'>Descrizione</div>
        <div class='five sixths half-padded'>{$pelosetto['carattere_descrizione']}</div>
    </div>
EOT;
}
# ----- CARATTERE DOMINANTE ----------------------------------------------------------------------
echo <<<EOT
    <div class='row' style='background:{$utils->CSS_alternate_background()}'>
        <div class='one sixth half-padded mytable_label'>Carattere dominante</div>
        <div class='five sixths half-padded'>{$sino[$pelosetto['carattere_dominante']]}</div>
    </div>
EOT;
# ----- CARATTERE SOCEVOLE -----------------------------------------------------------------------
echo <<<EOT
    <div class='row' style='background:{$utils->CSS_alternate_background()}'>
        <div class='one sixth half-padded mytable_label'>Carattere socievole con</div>
        <div class='five sixths half-padded'>{$pelosetto['carattere_socevole']}</div>
    </div>
EOT;
# ----- PATOLOGIE --------------------------------------------------------------------------------
$patologie_note = DefaultValue($pelosetto['patologie_note'], "nessuna patologia");
echo <<<EOT
    <div class='row' style='background:{$utils->CSS_alternate_background()}'>
        <div class='one sixth half-padded mytable_label'>Patologie</div>
        <div class='five sixths half-padded'>{$patologie_note}</div>
    </div>
EOT;
# ----- TERAPIE ----------------------------------------------------------------------------------
$terapie_note = DefaultValue($pelosetto['terapie_note'], "nessuna terapia");
echo <<<EOT
    <div class='row' style='background:{$utils->CSS_alternate_background()}'>
        <div class='one sixth half-padded mytable_label'>Terapie</div>
        <div class='five sixths half-padded'>{$terapie_note}</div>
    </div>
EOT;
# ----- VACCINAZIONI -----------------------------------------------------------------------------
if ($pelosetto['vaccinazioni'] == 'S')
    $vaccinazioni_note = DefaultValue($pelosetto['vaccinazioni_note'], "si");
else
    $vaccinazioni_note = DefaultValue($pelosetto['vaccinazioni_note'], "nessuna vaccinazione");
echo <<<EOT
    <div class='row' style='background:{$utils->CSS_alternate_background()}'>
        <div class='one sixth half-padded mytable_label'>Vaccinazioni</div>
        <div class='five sixths half-padded'>{$vaccinazioni_note}</div>
    </div>
EOT;
# ----- MICROCIP ---------------------------------------------------------------------------------
echo <<<EOT
    <div class='row' style='background:{$utils->CSS_alternate_background()}'>
        <div class='one sixth half-padded mytable_label'>Microchip</div>
        <div class='five sixths half-padded'>{$pelosetto['microcip']}</div>
    </div>
EOT;
# ----- TATUAGGIO --------------------------------------------------------------------------------
echo <<<EOT
    <div class='row' style='background:{$utils->CSS_alternate_background()}'>
        <div class='one sixth half-padded mytable_label'>Tatuaggio</div>
        <div class='five sixths half-padded'>{$pelosetto['tatuaggio']}</div>
    </div>
EOT;
# ----- SEGNI PARTICOLARI ------------------------------------------------------------------------
$segni_particolari = DefaultValue($pelosetto['segni_particolari'], "nessuno");
echo <<<EOT
    <div class='row' style='background:{$utils->CSS_alternate_background()}'>
        <div class='one sixth half-padded mytable_label'>Segni particolari</div>
        <div class='five sixths half-padded'>{$segni_particolari}</div>
    </div>
EOT;
# ----- DISPONIBILE PER --------------------------------------------------------------------------
if ($pelosetto["flag_stato"] != "adottato") {
    echo <<<EOT
    <div class='row' style='background:{$utils->CSS_alternate_background()}'>
        <div class='one sixth half-padded mytable_label'>Disponibile per</div>
        <div class='five sixths half-padded'>{$diponibile_per}</div>
    </div>
EOT;
}
# ----- SE ADOTTATO ------------------------------------------------------------------------------
if ($pelosetto["flag_stato"] == "adottato") {
    if (strlen($pelosetto['adozione_username']) > 0) {
        $u = get_user_from_username($pelosetto['adozione_username']);
        $attualmente_presso = "{$u["nome"]} {$u["cognome"]}";
        $attualmente_dove = "{$u["comune"]}";
        
        echo <<<EOT
    <div class='row' style='background:{$utils->CSS_alternate_background()}'>
        <div class='one sixth half-padded mytable_label'>Attualmente presso</div>
        <div class='five sixths half-padded'>{$attualmente_presso} - {$attualmente_dove}</div>
    </div>
EOT;
    }
    
    $adozione_data = date_translate($pelosetto['adozione_data'], 'us', 'it');
    echo <<<EOT
    <div class='row' style='background:{$utils->CSS_alternate_background()}'>
        <div class='one sixth half-padded mytable_label'>Data di adozione</div>
        <div class='five sixths half-padded'>{$adozione_data}</div>
    </div>
EOT;

    if (strlen($pelosetto['adozione_foto'])) {
        echo <<<EOT
    <div class='row' style='background:{$utils->CSS_alternate_background()}'>
        <div class='one sixth half-padded mytable_label'>Foto</div>
        <div class='five sixths half-padded'><img src="{$pelosetto['adozione_foto']}" /></div>
    </div>
EOT;
    }

    echo <<<EOT
    <div class='row' style='background:{$utils->CSS_alternate_background()}'>
        <div class='one sixth half-padded mytable_label'>Descrizione</div>
        <div class='five sixths half-padded'>{$pelosetto['adozione_descrizione']}</div>
    </div>
EOT;
}
# ------------------------------------------------------------------------------------------------
echo <<<EOT
<div class='row pad-top pad-bottom'>
    <form method="POST" action="{$history->indietro()}" style="float:left">
        <button class="mybutton" type="submit">Indietro</button>
    </form>
EOT;

if ($pelosetto["flag_stato"] != "adottato") {
    if ($pelosetto['flag_adotta'] == 'S')
        echo <<<EOT
            <form method="POST" action="form-adozione-interesse.php" style="float:left">
                <input type="hidden" name="pelosetto" value="{$pelosetto['code']}" />
                <button type="submit" class="mybutton">Adottami</button>
            </form>
EOT;
    if ($pelosetto['flag_adottadist'] == 'S')
        echo <<<EOT
            <form method="POST" action="form-nuova-donazione.php" style="float:left">
                <input type="hidden" name="code" value="{$pelosetto['code']}" />
                <button type="submit" class="mybutton">Adottami a distanza</button>
            </form>
EOT;
    if ($pelosetto['flag_stallo'] == 'S')
        echo <<<EOT
            <form method="POST" action="form-stallo-interesse.php" style="float:left">
                <input type="hidden" name="pelosetto" value="{$pelosetto['code']}" />
                <button type="submit" class="mybutton">Ospitami in stallo</button>
            </form>
EOT;
}
if ($utente->publisher()) {
    echo <<<EOT
    <form method="GET" action="form-notizia.php" style="float:left">
        <input type="hidden" name="padre" value="{$pelosetto['code']}" />
        <button class="blue" type="submit">Nuova notizia</button>
    </form>
EOT;
    if ($pelosetto["flag_stato"] == "adottato") 
        echo <<<EOT
    <form method="GET" action="/form-adottante.php" style="float:left">
        <input type="hidden" name="pelosetto" value="{$pelosetto['code']}" />
        <button class="blue" type="submit">Adottante</button>
    </form>
EOT;
}
if ($utente->publisher()) {
    echo <<<EOT
    <form method="GET" action="/form-allegato.php" style="float:left">
        <input type="hidden" name="padre" value="{$pelosetto['code']}" />
        <button class="blue" type="submit">Aggiungi allegato</button>
    </form>
EOT;
}
echo "</div>";  



if ($utente->publisher()) {
    #----- ALLEGATI -----------------------------------------------------------------------------------------------------------------
    $sql = "SELECT *
            FROM allegati 
            WHERE code_padre='{$code_pelosetto}'";
    $rs = $db->Esegui($sql);

    $allegati = array();
    if ($rs != FALSE) {
        $allegati = $rs->GetArray();
    }
    if (count($allegati))
        echo "<h2>Allegati:</h2>";
    foreach($allegati as $allegato) {
        
        echo <<<EOT
<div class="equalize row" style="border: 2px dotted #E0D1C2;">
    <div class="two fifths two-up-mobile two-up-small-tablet">
        <div class="hide-on-desktop head">Titolo</div>
        <span style="font-size:1.6em; font-style:italic;" class="asphalt">{$allegato['titolo']}</span></div>
    <div class="one fifth two-up-mobile two-up-small-tablet">
        <div class="hide-on-desktop head">Specie</div>
        <a class="noicon" href="{$allegato['percorso']}" target="_blank"><i class="icon-file icon-2x"></i></a></div>
        
    <div class="one fifth"><form method="GET" action="form-allegato.php">
        <input type="hidden" name="allegato" value="{$allegato['code']}" />
        <button type="submit" class="blue">Modifica</button>
    </form></div>
</div>
EOT;
    }
}



#----- NOTIZIE -----------------------------------------------------------------------------------------------------------------
$sql = "SELECT *
        FROM notizie 
        WHERE code_padre='{$code_pelosetto}'
        ORDER BY data desc";
$rs = $db->Esegui($sql);

$notizie = array();
if ($rs != FALSE) {
    $notizie = $rs->GetArray();
}

#----- DONATORI -----------------------------------------------------------------------------------------------------------------
$sql = "SELECT i.*, d.importo_versamento*d.numero_versamenti as importo_versamento, d.ct
        FROM donazioni d
        JOIN iscritti i ON i.code=d.code_utente
        WHERE d.code_pet='{$code_pelosetto}'
        ORDER BY d.ident desc";
$rs = $db->Esegui($sql);

$donatori = array();
if ($rs != FALSE) {
    $donatori = $rs->GetArray();
}

$smarty->assign("pelosetto", $pelosetto);
$smarty->assign("donatori", $donatori);
$smarty->assign("notizie", $notizie);
$smarty->display("page-presentazione-pelosetto.tpl");
get_footer(); 
?>