<?php
/**
 * Template Name: Raccolta disponibile
 */

require_once('common.inc.php');
?>

<?php get_header();?> 

	<?php
    /* Run the loop to output the pages.
	 * If you want to overload this in a child theme then include a file
	 * called loop-page.php and that will be used instead.
	*/
	the_post();
    #get_template_part( 'loop', 'page' );
    ?>


<?php
$code_raccolta = getVar("POST", "raccolta", getVar("POST", "code_raccolta", getVar("GET", "raccolta")));

#---------------------------------------------------------------------------------------------------------------------------------
# CHECK LOGIN
#---------------------------------------------------------------------------------------------------------------------------------
$permalink = get_permalink() ."?raccolta={$code_raccolta}";
#require_once('check-login.php');
#---------------------------------------------------------------------------------------------------------------------------------

#----- RACCOLTA ------------------------------------------------------------------------------------------------------------------
$sql = "SELECT r.*, 
        n.regione as negozio_regione, 
        n.comune as negozio_comune, 
        n.nome as negozio_nome, 
        n.indirizzo as negozio_indirizzo, 
        n.localita as negozio_localita, 
        c.regione as canile_regione, 
        c.comune as canile_comune, 
        c.nome as canile_nome, 
        c.indirizzo as canile_indirizzo,
        c.localita as canile_localita,
        (select count(*) from raccolte_interessati where code_raccolta=r.code) as offerte 
        FROM raccolte r
        JOIN vw_anagrafiche n ON n.code=r.code_negozio
        JOIN vw_anagrafiche c ON c.code=r.code_canile
        WHERE r.code='{$code_raccolta}'";
$rs = $db->Esegui($sql);
$item = $rs->FetchRow();

$canile_indirizzo = (strlen($item['canile_indirizzo'])) ? $item['canile_indirizzo'] : "";
$canile_localita = (strlen($item['canile_localita'])) ? "localit&agrave; ".$item['canile_localita'] : "";
$data_fine = date("d/m/Y", strtotime($item['data_fine']));

?>


<form method="POST" action="page-raccolte-disponibili.php">
    <button type="submit" class="mybutton">Indietro</button>
</form>

<h1 class="post-title entry-title">Raccolta</h1>

<table class="source-sans-pro">

<tr>
    <td><label for="">Negozio</label></td>
    <td><b><?php echo $item['negozio_nome']; ?></b><br /><?php echo $item['negozio_indirizzo']; ?><br /><?php echo $item['negozio_comune']; ?> - <?php echo $item['negozio_regione']; ?></td>
</tr>

<tr>
    <td><label for="">Orario</label></td>
    <td><?php echo $item['orario']; ?></td>
</tr>

<tr>
    <td><label for="">Descrizione</label></td>
    <td><?php echo $item['descrizione']; ?></td>
</tr>

<tr>
    <td><label for="">Destinata al canile</label></td>
    <td><?php echo "<b>".$item['canile_nome']."</b><br />".$canile_indirizzo." ".$canile_localita."<br />".$item['canile_comune']." - ".$item['canile_regione']; ?></td>
</tr>

<tr>
    <td><label for="data_fine">Termine</label></td>
    <td><?php echo $data_fine; ?></td>
</tr>

<tr>
    <td><label for="data_fine">Volontari che si sono offerti</label></td>
    <td><?php echo $item['offerte']; ?></td>
</tr>
</table>


<?php if ($code_utente != $item['code_utente'] || TRUE) { ?>
<form method="POST" action="form-raccolta-interesse.php">
    <input type="hidden" name="code_raccolta" value="<?php echo $code_raccolta; ?>" />
    <button type="submit" class="mybutton">Mi offro!</button>
</form>
<?php } ?>

<script>
window.onload=function(){
    // = document.getElementById("versamento_modo");
    //alert(o.value);
    //change_VersamentoModo(o);
};
</script>

<?php get_footer(); ?>