<?php
/*

Template Name: Page Raccolte disponibili

*/

require_once('common.inc.php');
get_header();

#----- RACCOLTE -----------------------------------------------------------------------------------------------------------------
$sql = "SELECT r.*, 
        n.regione as negozio_regione, 
        n.comune as negozio_comune, 
        n.nome as negozio_nome, 
        n.indirizzo as negozio_indirizzo, 
        n.localita as negozio_localita, 
        c.regione as canile_regione, 
        c.comune as canile_comune, 
        c.nome as canile_nome, 
        c.indirizzo as canile_indirizzo,
        c.localita as canile_localita,
        (select count(*) from raccolte_interessati where code_raccolta=r.code) as offerte
        FROM raccolte r
        JOIN vw_anagrafiche n ON n.code=r.code_negozio
        JOIN vw_anagrafiche c ON c.code=r.code_canile
        WHERE r.data_fine>=current_date";
$rs = $db->Esegui($sql);

$raccolte = array();
if ($rs != FALSE) {
    $raccolte = $rs->GetArray();
}

if ($utente->administrator()) {
    echo <<<EOT
    <div>
        <form method="POST" action="form-raccolta-disponibile.php" style="float:left;">
            <button type="submit" class="mybutton">Nuova raccolta</button>
        </form>
        <form method="POST" action="page-raccolte-negozi.php" style="float:left;">
            <button type="submit" class="mybutton">Negozi</button>
        </form>
    </div>
EOT;
}
echo <<<EOT
        <h1 class="titolo_pagina">Raccolte disponibili</h1>
EOT;

if (count($raccolte) == 0) {
    echo "<p style='padding:5px;'>Nessuna raccolta attiva.</p>";
}
else {
    echo <<<EOT
    <br>
    <table style="border: 2px solid #FFF;" class="source-sans-pro responsive" data-max="15">
    <thead>
    <tr>
        <th class="">Regione</th>
        <th class="">Comune</th>
        <th class="">Negozio</th>
        <th class="">Destinata al canile</th>
        <th class="">Termine</th>
        <th class="align-center">Offerte</th>
        <th class="">&nbsp;</th>
    </tr>
    </thead>
EOT;
    
    foreach ($raccolte as $key => $item) {    
        $bg = "#FFFFFF";
        if ($key % 2) 
            $bg = "#DEDEDE";
            
        $pulsante_dettaglio = <<<EOT
        <form method="POST" action="{$site_url}/page-raccolta-disponibile.php">
            <input type="hidden" name="code_raccolta" value="{$item['code']}" />
            <button type="submit" class="mybutton">Dettagli</button>
        </form>
EOT;
    
        $canile_indirizzo = (strlen($item['canile_indirizzo'])) ? $item['canile_indirizzo'] : "";
        $canile_localita = (strlen($item['canile_localita'])) ? "localit&agrave; ".$item['canile_localita'] : "";
        $data_fine = date("d/m/Y", strtotime($item['data_fine']));
        echo <<<EOT
    <tr style="background:{$bg}">
        <td>{$item['negozio_regione']}</td>
        <td>{$item['negozio_comune']}</td>
        <td><b>{$item['negozio_nome']}</b><br />{$item['negozio_indirizzo']}</td>
        <td><b>{$item['canile_nome']}</b><br />{$canile_indirizzo} {$canile_localita}<br />{$item['canile_comune']} - {$item['canile_regione']}</td>
        <td>{$data_fine}</td>
        <td style="text-align:center">{$item['offerte']}</td>
        <td>{$pulsante_dettaglio}</td>
    </tr>    
EOT;
    }
    echo <<<EOT
    </table>
EOT;
}
?> 

<?php get_footer(); ?>
