<?php
/*

Template Name: Page Raccolte negozi

*/

require_once('common.inc.php');
get_header();

#----- RACCOLTE -----------------------------------------------------------------------------------------------------------------
$sql = "SELECT *, r.code as code_raccolta
        FROM raccolte_negozi r
        JOIN vw_anagrafiche n ON n.code=r.code_negozio";
$rs = $db->Esegui($sql);

$raccolte = array();
if ($rs != FALSE) {
    $raccolte = $rs->GetArray();
}

if ($utente->administrator()) {
    echo <<<EOT
    <div>
        <form method="POST" action="page-raccolte-disponibili.php" style="float:left;">
            <button type="submit" class="mybutton">Indietro</button>
        </form>
        <form method="POST" action="form-raccolte-negozio.php" style="float:left;">
            <button type="submit" class="mybutton">Nuovo negozio</button>
        </form>
    </div>
EOT;
}
echo <<<EOT
        <h1 class="titolo_pagina">Negozi che effettuano raccolte permanenti</h1>
EOT;

if (count($raccolte) == 0) {
    echo "<p style='padding:5px;'>Nessun negozio inserito.</p>";
}
else {
    echo <<<EOT
    <br>
    <table style="background: #FFF; border: 2px solid #FFF;">
    <thead>
    <tr>
        <th>Regione</th>
        <th>Comune</th>
        <th>Negozio</th>
        <th>&nbsp;</th>
    </tr>
    </thead>
EOT;
    
    foreach ($raccolte as $key => $item) {    
        $bg = "#FFFFFF";
        if ($key % 2) 
            $bg = "#DEDEDE";
            
        $pulsante_dettaglio = <<<EOT
        <form method="GET" action="/form-raccolte-negozio.php">
            <input type="hidden" name="negozio" value="{$item['code_raccolta']}" />
            <button type="submit" class="mybutton">Dettagli</button>
        </form>
EOT;
    
        echo <<<EOT
    <tr style="background:{$bg}">
        <td>{$item['regione']}</td>
        <td>{$item['comune']}</td>
        <td><b>{$item['nome']}</b><br />{$item['indirizzo']}</td>
        <td>{$pulsante_dettaglio}</td>
    </tr>    
EOT;
    }
    echo <<<EOT
    </table>
EOT;
}

get_footer(); 
?>
