<?php
/**
 * Template Name: Interesse alla staffetta
 */

require_once('common.inc.php');
get_header();

$code_staffetta = getVar("POST", "staffetta", getVar("POST", "code_staffetta", getVar("GET", "staffetta")));

#---------------------------------------------------------------------------------------------------------------------------------
# CHECK LOGIN
#---------------------------------------------------------------------------------------------------------------------------------
$permalink = get_permalink() ."?staffetta={$code_staffetta}";
check_login($permalink);

#----- CANILE --------------------------------------------------------------------------------------------------------------------
$sql = "Select * from anagrafiche WHERE code='{$pelosetto['code_canile']}'";
$rs = $db->Esegui($sql);

$canile = array();
if ($rs != FALSE) {
    $canile = $rs->FetchRow();
}

#---------------------------------------------------------------------------------------------------------------------------------
$ok_staffetta_interesse = false;
$errore = false;

class RecordStaffetteInteressati extends RecordBase {
    
	public function __construct($id=null) {
        parent::__construct("staffette_interessati", "ident", $id);
    }
}
$record = Factory::crea("RecordStaffetteInteressati");

if( 'POST' == $_SERVER['REQUEST_METHOD'] && !empty( $_POST['ok_staffetta_interesse'] ) &&  $_POST['ok_staffetta_interesse'] == "1") {
    $record->loadInput();
    
    # CHECK
    if (strlen($record->get('email')) == 0) {
        $errore = true;
        show_message(MSGERROR, "E' necessario indicare una email per contattarti.", false);
    }
    
    if(!$errore) {
        $res = Factory::salva($record);
        
        if ($res) {
            $ok_staffetta_interesse = true;
            
            // invio la mail per la conferma
            $msg = "Grazie per il tuo interessamento!";
            $msg_html = "<b>{$msg}</b>";
            send_mail("Interessamento ad una staffetta", $record->get('email'), $msg, $msg_html);
            
            $code_staffetta = $record->get('code_staffetta');
            $sql = "SELECT * FROM staffette t JOIN iscritti i ON i.code=t.code_utente WHERE t.code='{$code_staffetta}'";
            $rs = $db->Esegui($sql);
            $row = $rs->FetchRow();
            
            switch ($row['specie']) {
                case 'C': $specie = "cane"; break;
                case 'G': $specie = "gatto"; break;
                default:  $specie = "qualsiasi"; break;
            }
            $partenza = $row['partenza_comune'];
            $arrivo = $row['arrivo_comune'];
            $email = $record->get("email");
            $telefono = $record->get("telefono");
            
            $msg = "Ciao, sono {$utente->nominativo}.\r\n
Sono interessato alla staffetta di un {$specie} da {$partenza} a {$arrivo}.\r\n
Puoi contattarmi:\r\n
- email: {$email}\r\n
- telefono: {$telefono}\r\n
\r\n
Aspetto tue indicazioni.";
            
            $msg_html = <<<EOT
Ciao, sono <b>{$utente->nominativo}</b>.<br>
Sono interessato alla staffetta di un {$specie} da {$partenza} a {$arrivo}.<br>
Puoi contattarmi:<br>
- email: <b><a href="mailto:{$email}">{$email}</a></b><br>
- telefono: <b>{$telefono}</b><br>
<br>
Aspetto tue indicazioni.
EOT;
            
            // send email
            send_mail("Sono interessato alla tua staffetta", $row['email'], $msg, $msg_html);
            
        }
    }
}

if (!$errore && $ok_staffetta_interesse) {
    echo <<<EOT
<form action="page-staffette.php" method="POST">
    <div id="message" class="updated fade"><p><strong>Interessamento inserito con successo.</strong></p></div>
    <button type="submit" class="mybutton">OK</button>
</form>
EOT;
}

if ($tipo == 'R') {
    $nome_data_inizio = "Data inizio";
    $nome_data_fine = "Data fine";
    $titolo_pagina = "Richiedo il trasferimento di un pelosetto";
}
else {
    $nome_data_inizio = "Data partenza";
    $nome_data_fine = "Data arrivo";
    $titolo_pagina = "Mi offro a trasferire un pelosetto";
}
    
if (!$ok_staffetta_interesse) {
?>
<script>
jQuery(document).ready(function() {
    //jQuery( "#data_inizio" ).datepicker({dateFormat : 'yy-mm-dd'});
    //jQuery( "#data_fine" ).datepicker({dateFormat : 'yy-mm-dd'});
});
</script>

<form method="POST" action="page-staffetta.php?staffetta=<?php echo $code_staffetta; ?>">
    <button type="submit" class="mybutton">Indietro</button>
</form>

<form method="POST" action="page-staffetta-interesse.php">
<table>
<tr>
    <td><label for="email">Email</label></td>
    <td>Email per farti contattare: <br />
    <b><?php echo $utente->email; ?></b>
    <input type="hidden" value="<?php echo $utente->email; ?>" size="50" name="email" id="email" /></td>
</tr>

<tr>
    <td><label for="telefono">Telefono</label></td>
    <td>Telefono per farti contattare (facoltativo):<br>
    <input type="text" value="" size="50" name="telefono" id="telefono" /><br>
    <h4>Nota</h4>
    <p>Il tuo numero di cellulare verr&agrave; mostrato solo al destinatario del messaggio. <br>
    Non verr&agrave; mostrato in nessun profilo pubblico. <br>
    Non verr&agrave; usato ne' per inviarti SMS, ne' per scopi commerciali, ne' sar&agrave; ceduto a terzi.</p>
    </td>
</tr>
</table>

    <input type="hidden" name="ok_staffetta_interesse" value="1" />
    <input type="hidden" name="code_staffetta" value="<?php echo $code_staffetta; ?>" />
    <input type="hidden" name="code_utente" value="<?php echo $utente->code; ?>" />
    <button type="submit" class="mybutton">Conferma</button>
</form>

<script>
window.onload=function(){
    // = document.getElementById("versamento_modo");
    //alert(o.value);
    //change_VersamentoModo(o);
};
</script>

<?
}
?>
<?php get_footer(); ?>