<?php
/**
 * Template Name: Staffetta
 */
require_once('common.inc.php');

$code_staffetta = getVar("POST", "staffetta", getVar("POST", "code_staffetta", getVar("GET", "staffetta")));

#---------------------------------------------------------------------------------------------------------------------------------
# CHECK LOGIN
#---------------------------------------------------------------------------------------------------------------------------------
$permalink = get_permalink() ."?staffetta={$code_staffetta}";
#check_login($permalink);
#---------------------------------------------------------------------------------------------------------------------------------

#----- CANILE --------------------------------------------------------------------------------------------------------------------
$sql = "Select * from vw_anagrafiche WHERE code='{$pelosetto['code_canile']}'";
$rs = $db->Esegui($sql);

$canile = array();
if ($rs != FALSE) {
    $canile = $rs->FetchRow();
}

#---------------------------------------------------------------------------------------------------------------------------------
class RecordStaffette extends RecordBase {
    
	public function __construct($id=null) {
        parent::__construct("staffette", "ident", $id);
    }
}
$record = Factory::crea("RecordStaffette");
$record->loadFromCode($code_staffetta);

$sql = "select * from iscritti where code='{$record->get('code_utente')}'";
$rs = $db->Esegui($sql);
$row = $rs->FetchRow();
$code_inserzionista = $row['code'];
$inserzionista = $row['cognome']." ".$row['nome'];

$tipo = $record->get("tipo");

if ($tipo == 'R') {
    $nome_data_inizio = "Data inizio";
    $nome_data_fine = "Data fine";
}
else {
    $nome_data_inizio = "Data partenza";
    $nome_data_fine = "Data arrivo";
}

$url = $SYS['BASE_URL'].$permalink;

$meta_tags = <<<EOT
<meta property="og:url" content="{$url}" />
<meta property="og:title" content="Staffetta da {$record->get("partenza_comune")} a {$record->get("arrivo_comune")}" />
<meta property="og:description" content="{$record->get("note")}" />
<meta property="og:image" content="{$SYS['BASE_URL']}images/sonoamicodigiulita.jpg" />
EOT;

$smarty->assign("meta_tags", $meta_tags);
get_header(); 
?>

<script>
jQuery(document).ready(function() {
    //jQuery( "#data_inizio" ).datepicker({dateFormat : 'yy-mm-dd'});
    //jQuery( "#data_fine" ).datepicker({dateFormat : 'yy-mm-dd'});
});
</script>

<form method="GET" action="page-staffette.php">
    <button type="submit" class="mybutton">Indietro</button>
</form>

<div class="align-left padded">
            <span class="fb-like"
                data-href="<?php echo $url; ?>" 
                data-layout="button_count" 
                data-action="like" 
                data-show-faces="false" 
                data-share="true"></span>
                
        </div>
        
<table class="mytable">
<tr>
    <td><label for="">Inserito da</label></td>
    <td><?php if ($utente->logged()) echo $inserzionista; else echo "***"; ?></td>
</tr>
<tr>
    <td><label for="">Comune di partenza</label></td>
    <td><?php echo $record->get("partenza_comune"); ?></td>
</tr>

<tr>
    <td><label for="">Localit&agrave; di partenza</label></td>
    <td><?php echo $record->get("partenza_localita"); ?></td>
</tr>

<tr>
    <td><label for="">Comune di arrivo</label></td>
    <td><?php echo $record->get("arrivo_comune"); ?></td>
</tr>

<tr>
    <td><label for="">Localit&agrave; di arrivo</label></td>
    <td><?php echo $record->get("arrivo_localita"); ?></td>
</tr>

<tr>
    <td><label for="data_inizio"><?php echo $nome_data_inizio; ?></label></td>
    <td><?php echo date_translate($record->get("data_inizio"), 'us', 'it'); ?></td>
</tr>

<tr>
    <td><label for="data_fine"><?php echo $nome_data_fine; ?></label></td>
    <td><?php echo date_translate($record->get("data_fine"), 'us', 'it'); ?></td>
</tr>

<tr>
    <td><label for="partenza_referente">Referente alla partenza</label></td>
    <td><?php if ($utente->logged()) echo $record->get("partenza_referente"); else echo "***"; ?></td>
</tr>

<tr>
    <td><label for="arrivo_referente">Referente all'arrivo</label></td>
    <td><?php if ($utente->logged()) echo $record->get("arrivo_referente"); else echo "***"; ?></td>
</tr>

<tr>
    <td><label for="specie">Specie</label></td>
    <td><?php 
$specie_pelosetti = array(
    'C' => "cane",
    'G' => "gatto"
);
echo $specie_pelosetti[$record->get("specie")]; ?></td>
</tr>

<tr>
    <td><label for="taglia">Taglia</label></td>
    <td><?php echo $taglie_pelosetti[$record->get("taglia")]; ?></td>
</tr>

<?php if ($tipo == 'O') { ?>
<tr>
    <td><label for="mezzo_staffetta">Mezzo di staffetta</label></td>
    <td><?php strtolower($record->get("mezzo_staffetta")); ?></td>
</tr>

<tr>
    <td><label for="compagnia_staffetta">Eventuale Compagnia di staffetta</label></td>
    <td><?php echo $record->get("compagnia_staffetta"); ?></td>
</tr>
<?php } ?>

<tr>
    <td><label for="note">Testo per Facebook</label></td>
    <td><?php echo $record->get("note"); ?></td>
</tr>
</table>

<?php 
if ($tipo == 'O') 
    $pulsante_interessato = "Sono interessato!";
else
    $pulsante_interessato = "Mi offro!";
?>
<?php if ($record->get("code_utente") != $code_utente) { ?>
<form method="POST" action="page-staffetta-interesse.php">
    <input type="hidden" name="code_staffetta" value="<?php echo $code_staffetta; ?>" />
    <button type="submit" class="mybutton"><?php echo $pulsante_interessato; ?></button>
</form>
<?php } ?>

<script>
window.onload=function(){
    // = document.getElementById("versamento_modo");
    //alert(o.value);
    //change_VersamentoModo(o);
};
</script>

<?php get_footer(); ?>