<?php
/*

Template Name: Staffette

*/

require_once('common.inc.php');


#----- RICHIESTE STAFFETTE -----------------------------------------------------------------------------------------------------------------
$sql = "SELECT t.*, p1.regione as partenza_regione, p2.regione as arrivo_regione
        FROM staffette t
        JOIN province p1 ON p1.sigla=t.partenza_provincia
        JOIN province p2 ON p2.sigla=t.arrivo_provincia
        where tipo='R' AND COALESCE(data_fine, data_inizio)>=current_date";
$rs = $db->Esegui($sql);

$richieste_trasporti = array();
if ($rs != FALSE) {
    $richieste_trasporti = $rs->GetArray();
}
foreach ($richieste_trasporti as $key => $item) {
    $specie = ($item['specie'] == 'C') ? "cane" : "gatto";
    $richieste_trasporti[$key]['specie'] = $specie;
    
    switch ($item['taglia']) {
        case 'P': $taglia = "piccola"; break;
        case 'M': $taglia = "media"; break;
        case 'G': $taglia = "grande"; break;
    }
    $richieste_trasporti[$key]['taglia'] = $taglia;
}

#----- OFFERTE STAFFETTE -----------------------------------------------------------------------------------------------------------------
$sql = "SELECT t.*, p1.regione as partenza_regione, p2.regione as arrivo_regione
        FROM staffette t
        JOIN province p1 ON p1.sigla=t.partenza_provincia
        JOIN province p2 ON p2.sigla=t.arrivo_provincia
        where tipo='O' AND COALESCE(data_fine, data_inizio)>=current_date";
$rs = $db->Esegui($sql);

$offerte_trasporti = array();
if ($rs != FALSE) {
    $offerte_trasporti = $rs->GetArray();
}
foreach ($offerte_trasporti as $key => $item) {
    switch ($item['specie']) {
        case 'C': $specie = "cane"; break;
        case 'G': $specie = "gatto"; break;
        default:  $specie = "qualsiasi"; break;
    }
    $offerte_trasporti[$key]['specie'] = $specie;
    
    switch ($item['taglia']) {
        case 'P': $taglia = "piccola"; break;
        case 'M': $taglia = "media"; break;
        case 'G': $taglia = "grande"; break;
    }
    $offerte_trasporti[$key]['taglia'] = $taglia;
}

$smarty->assign("richieste_trasporti", $richieste_trasporti);
$smarty->assign("offerte_trasporti", $offerte_trasporti);
$smarty->display("page-staffette.tpl");
exit();




/*
get_header(); 

echo <<<EOT
    <div>
        <form method="POST" action="form-staffetta.php" style="float:left;">
            <input type="hidden" name="tipo" value="R" />
            <button type="submit" class="mybutton">Nuova richiesta</button>
        </form>
        <form method="POST" action="form-staffetta.php" style="float:left;">
            <input type="hidden" name="tipo" value="O" />
            <button type="submit" class="mybutton">Nuova offerta</button>
        </form>
    </div>
EOT;

echo <<<EOT
        <h1 class="titolo_pagina">Richieste di staffetta</h1>
EOT;

if (count($richieste_trasporti) == 0) {
    echo "<p style='padding:5px;'>Nessuna richiesta di staffetta attiva.</p>";
}
else {
    echo <<<EOT
    <table class="responsive info responsiveTable" data-max="10" style="background: #FFF; border: 2px solid #FFF;">
    <thead>
    <tr>
        <th>Partenza</th>
        <th>Arrivo</th>
        <th>Data inizio</th>
        <th>Data fine</th>
        <th>Specie</th>
        <th>Taglia</th>
        <th>&nbsp;</th>
    </tr>
    </thead>
    <tbody>
EOT;
    
    $totale = 0;
    foreach ($richieste_trasporti as $key => $item) {
        $data_inizio = date("d/m/Y", strtotime($item['data_inizio']));
        $data_fine = date("d/m/Y", strtotime($item['data_fine']));

        $bg = "#FFFFFF";
        if ($key % 2) 
            $bg = "#DEDEDE";
            
        $pulsante_dettaglio = <<<EOT
        <form method="POST" action="page-staffetta.php">
            <input type="hidden" name="staffetta" value="{$item['code']}" />
            <button type="submit" class="mybutton">Dettaglio</button>
        </form>
EOT;
    
        $specie = ($item['specie'] == 'C') ? "cane" : "gatto";
        switch ($item['taglia']) {
            case 'P': $taglia = "piccola"; break;
            case 'M': $taglia = "media"; break;
            case 'G': $taglia = "grande"; break;
        }
        echo <<<EOT
    <tr style="background:{$bg}">
        <td>{$item['partenza_comune']}<br /><span style="font-size:0.8em;">{$item['partenza_regione']}</span></td>
        <td>{$item['arrivo_comune']}<br /><span style="font-size:0.8em;">{$item['arrivo_regione']}</span></td>
        <td style="text-align:center;">{$data_inizio}</td>
        <td style="text-align:center;">{$data_fine}</td>
        <td>{$specie}</td>
        <td>{$taglia}</td>
        <td>{$pulsante_dettaglio}</td>
    </tr>    
EOT;
    }
    echo <<<EOT
    </tbody>
    </table>
EOT;
}

echo "<br>";
echo "<h1 class='titolo_pagina'>Offerte di staffetta</h1>";

if (count($offerte_trasporti) == 0) {
    echo "<p style='padding:5px;'>Nessuna offerta di staffetta attiva.</p>";
}
else {
    echo <<<EOT
    <table class="responsive success responsiveTable" data-max="10" style="background: #FFF; border: 2px solid #FFF;">
    <thead>
    <tr>
        <th>Partenza</th>
        <th>Arrivo</th>
        <th>Data inizio</th>
        <th>Data fine</th>
        <th>Specie</td>
        <th>Taglia<br>(fino&nbsp;a)</th>
        <th>Mezzo trasporto</th>
        <th>Compagnia</th>
        <th>&nbsp;</th>
    </tr>
    </thead>
    <tbody>
EOT;
    
    $totale = 0;
    foreach ($offerte_trasporti as $key => $item) {
        $data_inizio = date("d/m/Y", strtotime($item['data_inizio']));
        $data_fine = date("d/m/Y", strtotime($item['data_fine']));

        $bg = "#FFFFFF";
        if ($key % 2) 
            $bg = "#DEDEDE";
            
        $pulsante_dettaglio = <<<EOT
        <form method="POST" action="page-staffetta.php">
            <input type="hidden" name="staffetta" value="{$item['code']}" />
            <button type="submit" class="mybutton">Dettaglio</button>
        </form>
EOT;
        
        switch ($item['specie']) {
            case 'C': $specie = "cane"; break;
            case 'G': $specie = "gatto"; break;
            default:  $specie = "qualsiasi"; break;
        }
        switch ($item['taglia']) {
            case 'P': $taglia = "piccola"; break;
            case 'M': $taglia = "media"; break;
            case 'G': $taglia = "grande"; break;
        }
        echo <<<EOT
    <tr style="background:{$bg}">
        <td>{$item['partenza_comune']}<br /><span style="font-size:0.8em;">{$item['partenza_regione']}</span></td>
        <td>{$item['arrivo_comune']}<br /><span style="font-size:0.8em;">{$item['arrivo_regione']}</span></td>
        <td style="text-align:center;">{$data_inizio}</td>
        <td style="text-align:center;">{$data_fine}</td>
        <td>{$specie}</td>
        <td>{$taglia}</td>
        <td>{$item['mezzo_trasporto']}</td>
        <td>{$item['compagnia_trasporto']}</td>
        <td>{$pulsante_dettaglio}</td>
    </tr>    
EOT;
    }
    echo <<<EOT
    </tbody>
    </table>
EOT;
}
?> 

<?php get_footer(); 
*/
?>
