<?php
/**
 * Template Name: Verifica login
 */

require_once('common.inc.php');
get_header();

class RecordIscrizioni extends RecordBase {}
$record = new RecordIscrizioni("iscritti", "ident");

$ok_nuovo_iscritto = false;
$code_verifica = getVar("GET", "code", "");

if(strlen($code_verifica) > 0) {
    $sql = "select * from iscritti where codice_verifica='{$code_verifica}'";
    $rs = $db->Esegui($sql);
    $row = $rs->FetchRow();
    $code_utente = $row['code'];

    $record->loadFromCode($code_utente);
    $record->set('valido', 1);
    $record->set('validato', '1');
    $res = Factory::salva($record);
    

    //On success
    if( $res !== false ) {
        $ok_nuovo_iscritto = true;
        
        $msg = <<<EOT
E' stata verificata l'email di {$record->get("nome")} {$record->get("cognome")}.\r\n
Email: {$record->get("email")}\r\n
Comune: {$record->get("comune")} 
EOT;
        $msg_html = <<<EOT
E' stata verificata l'email di <b>{$record->get("nome")} {$record->get("cognome")}</b>.<br />
Email: <b>{$record->get("email")}</b><br />
Comune: <b>{$record->get("comune")}</b>
EOT;
        send_mail(
            "Iscrizione ad Amici di Giulita", 
            "staff@amicidigiulita.it", 
            $msg, 
            $msg_html);
    }
}

if ($ok_nuovo_iscritto) {
    echo <<<EOT
<form action="form-login.php" method="POST">
    <div id="message" class="updated fade"><p><strong>Verifica avvenuta con successo.</strong></p></div>
    <button type="submit" class="mybutton">OK</button>
</form>
EOT;
}
else {
    echo <<<EOT
    <div id="message" class="updated fade"><p><strong>Codice di verifica nullo o non valido.</strong></p></div>
EOT;
}

get_footer(); ?>