<?php
/**
 * Template Name: Interesse alla visita
 */

require_once('common.inc.php');
get_header();

$code_visita = getVar("POST", "visita", getVar("POST", "code_visita", getVar("GET", "visita")));

#---------------------------------------------------------------------------------------------------------------------------------
# CHECK LOGIN
#---------------------------------------------------------------------------------------------------------------------------------
$permalink = get_permalink() ."?visita={$code_visita}";
check_login($permalink);

#----- CANILE --------------------------------------------------------------------------------------------------------------------
$sql = "Select * from anagrafiche WHERE code='{$pelosetto['code_canile']}'";
$rs = $db->Esegui($sql);

$canile = array();
if ($rs != FALSE) {
    $canile = $rs->FetchRow();
}

#---------------------------------------------------------------------------------------------------------------------------------
$ok_visita_interesse = false;
$errore = false;

class RecordVisiteInteressati extends RecordBase {
    
	public function __construct($id=null) {
        parent::__construct("visite_interessati", "ident", $id);
    }
}
$record = Factory::crea("RecordVisiteInteressati");

if( 'POST' == $_SERVER['REQUEST_METHOD'] && !empty( $_POST['ok_visita_interesse'] ) &&  $_POST['ok_visita_interesse'] == "1") {
    $record->loadInput();
    
    # CHECK
    if (strlen($record->get('email')) == 0) {
        $errore = true;
        show_message(MSGERROR, "E' necessario indicare una email per contattarti.", false);
    }
    
    if(!$errore) {
        $res = Factory::salva($record);
        
        if ($res) {
            $ok_visita_interesse = true;
            
            // invio la mail per la conferma
            $msg = "Grazie per il tuo interessamento!";
            $msg_html = "<b>{$msg}</b>";
            send_mail("Interessamento ad una visita", $record->get('email'), $msg, $msg_html);
            
            $code_visita = $record->get('code_visita');
            $sql = "SELECT * FROM visite t JOIN iscritti i ON i.code=t.code_utente WHERE t.code='{$code_visita}'";
            $rs = $db->Esegui($sql);
            $row = $rs->FetchRow();
            
            switch ($row['specie']) {
                case 'C': $specie = "cane"; break;
                case 'G': $specie = "gatto"; break;
                default:  $specie = "qualsiasi"; break;
            }
            $comune = $row['comune'];
            $email = $record->get("email");
            $telefono = $record->get("telefono");
            
            $msg = "Ciao, sono {$utente->nominativo}.\r\n
Sono interessato alla visita nel comune di {$comune}.\r\n
Puoi contattarmi:\r\n
- email: {$email}\r\n
- telefono: {$telefono}\r\n
\r\n
Aspetto tue indicazioni.";
            
            $msg_html = <<<EOT
Ciao, sono <b>{$utente->nominativo}</b>.<br>
Sono interessato alla visita nel comune di {$comune}.<br>
Puoi contattarmi:<br>
- email: <b><a href="mailto:{$email}">{$email}</a></b><br>
- telefono: <b>{$telefono}</b><br>
<br>
Aspetto tue indicazioni.
EOT;
            
            // send email
            send_mail("Sono interessato alla visita", $row['email'], $msg, $msg_html);
            
        }
    }
}

if (!$errore && $ok_visita_interesse) {
    echo <<<EOT
<form action="page-visite-pre-affidi.php" method="POST">
    <div id="message" class="updated fade"><p><strong>Interessamento inserito con successo.</strong></p></div>
    <button type="submit" class="mybutton">OK</button>
</form>
EOT;
}

if ($tipo == 'R') {
    $nome_data_inizio = "Data inizio";
    $nome_data_fine = "Data fine";
    $titolo_pagina = "Ho necessit&agrave; di effettuare una visita per l'affido di un pelosetto";
}
else {
    $nome_data_inizio = "Data partenza";
    $nome_data_fine = "Data arrivo";
    $titolo_pagina = "Mi offro a per una visita pre/post affido";
}
    
if (!$ok_visita_interesse) {
?>
<script>
jQuery(document).ready(function() {
    //jQuery( "#data_inizio" ).datepicker({dateFormat : 'yy-mm-dd'});
    //jQuery( "#data_fine" ).datepicker({dateFormat : 'yy-mm-dd'});
});
</script>

<form method="GET" action="page-visita.php">
    <input type="hidden" name="visita" value="<?php echo $code_visita; ?>" />
    <button type="submit" class="mybutton">Indietro</button>
</form>

<form method="POST" action="page-visita-interesse.php">
<table>
<tr>
    <td><label for="email">Email</label></td>
    <td>Email per farti contattare: <br />
    <b><?php echo $utente->email; ?></b>
    <input type="hidden" value="<?php echo $utente->email; ?>" size="50" name="email" id="email" /></td>
</tr>

<tr>
    <td><label for="telefono">Telefono</label></td>
    <td>Telefono per farti contattare (facoltativo):<br>
    <input type="text" value="" size="50" name="telefono" id="telefono" /><br>
    <h4>Nota</h4>
    <p>Il tuo numero di cellulare verr&agrave; mostrato solo al destinatario del messaggio. <br>
    Non verr&agrave; mostrato in nessun profilo pubblico. <br>
    Non verr&agrave; usato ne' per inviarti SMS, ne' per scopi commerciali, ne' sar&agrave; ceduto a terzi.</p>
    </td>
</tr>
</table>

    <input type="hidden" name="ok_visita_interesse" value="1" />
    <input type="hidden" name="code_visita" value="<?php echo $code_visita; ?>" />
    <input type="hidden" name="code_utente" value="<?php echo $utente->code; ?>" />
    <button type="submit" class="mybutton">Conferma</button>
</form>

<?
}

get_footer(); 
?>