<?php
/**
 * Template Name: Visita pre/post affido
 */

require_once('common.inc.php');
get_header();

$code_visita = getVar("POST", "visita", getVar("POST", "code_visita", getVar("GET", "visita")));

#---------------------------------------------------------------------------------------------------------------------------------
# CHECK LOGIN
#---------------------------------------------------------------------------------------------------------------------------------
$permalink = get_permalink() ."?visita={$code_visita}";
check_login($permalink);
#---------------------------------------------------------------------------------------------------------------------------------

#----- CANILE --------------------------------------------------------------------------------------------------------------------
$sql = "Select * from vw_anagrafiche WHERE code='{$pelosetto['code_canile']}'";
$rs = $db->Esegui($sql);

$canile = array();
if ($rs != FALSE) {
    $canile = $rs->FetchRow();
}

#---------------------------------------------------------------------------------------------------------------------------------
class RecordVisite extends RecordBase {
    
	public function __construct($id=null) {
        parent::__construct("visite", "ident", $id);
    }
}
$record = Factory::crea("RecordVisite");
$record->loadFromCode($code_visita);

$sql = "select * from iscritti where code='{$record->get('code_utente')}'";
$rs = $db->Esegui($sql);
$row = $rs->FetchRow();
$code_inserzionista = $row['code'];
$inserzionista = $row['cognome']." ".$row['nome'];

$tipo = $record->get("tipo");

if ($tipo == 'R') {
    $nome_data_inizio = "Data inizio";
    $nome_data_fine = "Data fine";
}
else {
    $nome_data_inizio = "Data partenza";
    $nome_data_fine = "Data arrivo";
}

?>

<script>
jQuery(document).ready(function() {
    //jQuery( "#data_inizio" ).datepicker({dateFormat : 'yy-mm-dd'});
    //jQuery( "#data_fine" ).datepicker({dateFormat : 'yy-mm-dd'});
});
</script>

<form method="GET" action="page-visite-pre-affidi.php">
    <button type="submit" class="mybutton">Indietro</button>
</form>

<table class="mytable">
<tr>
    <td><label for="">Inserito da</label></td>
    <td><?php echo $inserzionista; ?></td>
</tr>
<tr>
    <td><label for="">Comune</label></td>
    <td><?php echo $record->get("comune"); ?></td>
</tr>

<tr>
    <td><label for="">Localit&agrave; o zona</label></td>
    <td><?php echo $record->get("localita"); ?></td>
</tr>

<?php if ($tipo == 'R') { ?>
<tr>
    <td><label for="data_inizio"><?php echo $nome_data_inizio; ?></label></td>
    <td><?php echo date_translate($record->get("data_inizio"), 'us', 'it'); ?></td>
</tr>

<tr>
    <td><label for="data_fine"><?php echo $nome_data_fine; ?></label></td>
    <td><?php echo date_translate($record->get("data_fine"), 'us', 'it'); ?></td>
</tr>
<?php } ?>

<tr>
    <td><label for="note">Note</label></td>
    <td><textarea type="text" rows="5" cols="50" name="note" id="note"><?php echo $record->get("note"); ?></textarea></td>
</tr>
</table>

<?php 
if ($tipo == 'O') 
    $pulsante_interessato = "Sono interessato!";
else
    $pulsante_interessato = "Mi offro!";

if ($record->get("code_utente") != $code_utente) { ?>
<form method="GET" action="page-visita-interesse.php">
    <input type="hidden" name="visita" value="<?php echo $code_visita; ?>" />
    <button type="submit" class="mybutton"><?php echo $pulsante_interessato; ?></button>
</form>
<?php 
} 

get_footer(); 
?>