<?php
/*

Template Name: Presentazione pelosetto

*/

require_once('common.inc.php');

$code_pelosetto = getVar("GET", "pelosetto", getVar("POST", "code", getVar("POST", "pelosetto")));
$sql = "SELECT p.*, pr.regione FROM pelosetti p
        JOIN province pr ON p.provincia=pr.sigla
        WHERE p.code='{$code_pelosetto}'";
$rs = $db->Esegui($sql);

$pelosetto = array();
if ($rs != FALSE) {
    $pelosetto = $rs->FetchRow();
}

$sql = "SELECT * FROM vw_anagrafiche WHERE code='{$pelosetto['code_canile']}'";
$rs = $db->Esegui($sql);

$canile = array();
if ($rs != FALSE) {
    $canile = $rs->FetchRow();
}

# FACEBOOK
$slug = slug_simple($pelosetto['nome']);
$regione = slug_simple($pelosetto['regione']);
$comune = slug_simple($pelosetto['comune']);
$url = "{$SYS['BASE_URL']}pelosetti/{$regione}/{$comune}/{$slug}/{$pelosetto['code']}";
$descrizione = strip_tags($pelosetto['carattere_descrizione']);

# ----- DISPONIBILE PER --------------------------------------------------------------------------
$diponibile_per = "";
if ($pelosetto['flag_adotta'] == 'S')
    $diponibile_per .= "adozione, "; 
if ($pelosetto['flag_adottadist'] == 'S')
    $diponibile_per .= "adozione a distanza, "; 
if ($pelosetto['flag_stallo'] == 'S')
    $diponibile_per .= "stallo, "; 
if (strlen($diponibile_per) > 0)
    $diponibile_per = substr($diponibile_per, 0, -2);
else
    $diponibile_per = "non disponibile";

# ----- CALCOLO ETA' -----------------------------------------------------------------------------
if (strlen($pelosetto['nascita_data']))
    $eta = intval(date_sottrazione(date('Y-m-d'), $pelosetto['nascita_data'], 'm')); 
elseif (strlen($pelosetto['nascita_anno']))
    $eta = intval(date_sottrazione(date('Y-m-d'), $pelosetto['nascita_anno']."-07-01", 'm'));
else
    $eta = "incerta";
if ($eta > 24)
    $eta = intval($eta / 12)." anni";
elseif ($eta == 1)
    $eta = "1 mese";
elseif ($eta > 1)
    $eta .= " mesi";
        
    # ----- CALCOLO PRESSO CHI -----------------------------------------------------------------------
if ($pelosetto["flag_stato"] != "adottato") {
    # ----- CANILE -----------------------------------------------------------------------------------
    if (strlen($pelosetto['code_canile']) > 0) {
        $indirizzo = (strlen($canile['indirizzo'])) ? $canile['indirizzo']."," : "";
        $localita = (strlen($canile['localita'])) ? "localit&agrave; ".$canile['localita']."," : "";
        $attualmente_presso = <<<EOT
            <b>{$canile['nome']}</b>
            <p>{$indirizzo} {$localita} {$canile['comune']} - {$canile['regione']}<br />
                <a href="{$canile['url_www']}" target="_blanc">{$canile['url_www']}</a>
            </p>
EOT;
    }
    # ----- UTENTE -----------------------------------------------------------------------------------
    elseif (strlen($pelosetto['stallo_username']) > 0) {
        $u = get_user_from_username($pelosetto['stallo_username']);
        $attualmente_presso = <<<EOT
            <h3>{$u["nome"]} {$u["cognome"]}</h3>
            <p>{$pelosetto["comune"]}</p>
EOT;
    }
    # ----- NON UTENTE -------------------------------------------------------------------------------
    elseif (strlen($pelosetto['stallo_altro_riferimento']) > 0) {
        $attualmente_presso = <<<EOT
            <h3>{$pelosetto["stallo_altro_riferimento"]}</h3>
            <p>{$pelosetto["comune"]}</p>
EOT;
    }
}

$genere_pelosetto = $genere_pelosetti[$pelosetto['genere']];
$taglia_pelosetto = $taglie_pelosetti[$pelosetto['taglia']];
    
    
$urgente = "";
if ($pelosetto['flag_urgente'] == 'S')
    $urgente = "<span style='font-size:1.4em; color:#A00; font-weight:bold;'>URGENTE</span>";

echo $html = <<<EOT

<style>
.bold { font-weight: bold; }
body { font-size: 1.2em; }
</style>
<img src="/images/cuore.jpg" style="max-width:50%; float:right; right:0px; width: 20%; top: 0px;" />
<h1>WWW.AMICIDIGIULITA.IT</h1>
<div>
        <div>
            <img src="{$pelosetto['foto1']}" style="max-width:50%;" />
            
            
        </div>
        
        <div>
            {$urgente}
            
            <h2>{$pelosetto['nome']}</h2>
            
            <p>
                Specie: <span class="bold">{$pelosetto['specie']}</span><br />
                Disponibile per: <span class="bold">{$diponibile_per}</span><br />
                Provenienza: <span class="bold">{$pelosetto['provenienza']}</span><br />
                Attualmente presso: <span class="bold">{$attualmente_presso}</span>
                Genere: <span class="bold">{$genere_pelosetto}</span><br />
                Taglia: <span class="bold">{$taglia_pelosetto}</span><br />
                Et&agrave;: <span class="bold">{$eta}</span>
            </p>
            
            <p class="justify quicksand">{$pelosetto['carattere_descrizione']}</p>
        </div>
    </div>    
EOT;

include("mpdf/mpdf.php");
$mpdf=new mPDF('c'); 
$mpdf->mirrorMargins = true;
$mpdf->SetDisplayMode('fullpage','two');
$mpdf->WriteHTML($html);
$mpdf->Output();
?>