<?php
set_include_path(get_include_path().PATH_SEPARATOR.'/var/www/LIB/'.PATH_SEPARATOR.'/var/www/LIB/aspidenet/');
require_once("customize.inc.php");
require_once('aspidenet.inc.php');
require_once("funzioni.inc.php");
require_once("classes/db.class.php");
require_once("classes/recordinfo.class.php");
require_once("classes/recordbase.class.php");
require_once("classes/mail.class.php");

#----- AUTOLOAD ------------------------------------------------------------------------------------------------------------------
spl_autoload_register( 'autoloader' );
 
function autoloader( $class ) {
    #error_log ("Cerco '{$class}' in autoloader!", 0);
    $class = strtolower($class);
    if ( file_exists ('classes/' . $class . '.class.php' ) ){
        include_once('classes/' . $class . '.class.php' );
    }
}

/*******************************************************************************
*  DATABASE
*******************************************************************************/
function aspide_get_db() {
    $db = new DB(DB_TYPE); 
    $db->Connetti(DB_SERVER, DB_USER, DB_PASS, DB_DBNAME);
    return $db;
}
$db = aspide_get_db();

$sql = "SELECT * FROM mail WHERE processed='N' ORDER BY ident LIMIT 10";
$rs = $db->Esegui($sql);

if (!$rs) {
    $msg = $db->ErrorMsg();
    real_send_mail("check mail fallito", 'marcello@hermes.aspide.net', "check mail fallito! ({$msg})");
    exit();
}

$failures = array();
while (!$rs->EOF) {
    $code = $rs->Fields("code");
    $record = new Mail();
    $record->loadFromCode($code);
    $test = (TEST) ? "TEST: " : "";
    
    if ($record->get("toall") == 'N')
        $failures = real_send_mail($test.$record->get("subject"), $record->get("receiver"), $record->get("message_text"), $record->get("message_html"));
    else {
        $record->set("processed", "I");
        $record->update();
        
        if (!isset($iscritti)) {
            $sql = "SELECT * FROM iscritti WHERE validato=true";
            $rs2 = $db->Esegui($sql);
            $iscritti = $rs2->GetArray();
        }
        foreach($iscritti as $iscritto) {
            if (TEST) {
                $fails = real_send_mail($test.$record->get("subject"), 'marcello@hermes.aspide.net', $iscritto['email']."\r\n".$record->get("message_text"), $iscritto['email']."<br>".$record->get("message_html"));
                $failures = array_merge($failures, $fails);
            }
            else {
                $fails = real_send_mail($test.$record->get("subject"), $iscritto['email'], $record->get("message_text"), $record->get("message_html"));
                $failures = array_merge($failures, $fails);
            }
        }
    }
    
    if (count($failures) == 0)
        $result = "OK";
    else 
        $result = implode(", ", $failures);
        
    $record->set("dt_processed", "now()");
    $record->set("processed", "S");
    $record->set("result", $result);
    
    if (count($failures))
        real_send_mail($test."Email fallite", 'marcello@hermes.aspide.net', $result);
    
    $record->update();
    
    $rs->MoveNext();
}
?>