<?php
require_once('common.inc.php');

check_admin();



$BASEURL = "http://amicidigiulita.it";

############################################################################
### Pagine
DEBUG($BASEURL."/");
DEBUG($BASEURL."/giulita/");
DEBUG($BASEURL."/staffette/");
DEBUG($BASEURL."/raccolte-disponibili/");


############################################################################
### Pelosetti

$sql = "select x.*, p.regione from pelosetti x
        join province p ON x.provincia=p.sigla";
$rs = $db->Esegui($sql);

while (!$rs->EOF) {
    $code = slug_simple($rs->Fields("code"));
    $regione = slug_simple($rs->Fields("regione"));
    $comune = slug_simple(substr($rs->Fields("comune"), 0, -5));
    $url = $BASEURL."/pelosetti/{$regione}/{$comune}/{$code}";
    $rs->MoveNext();
    DEBUG($url);
}

############################################################################
### Iniziative

$sql = "select x.*, p.regione from iniziative x
        join province p ON x.provincia=p.sigla";
$rs = $db->Esegui($sql);

while (!$rs->EOF) {
    $code = slug_simple($rs->Fields("code"));
    $regione = slug_simple($rs->Fields("regione"));
    $comune = slug_simple(substr($rs->Fields("comune"), 0, -5));
    $titolo = slug_simple($rs->Fields("titolo"));
    $url = $BASEURL."/iniziative/{$regione}/{$comune}/{$titolo}/{$code}";
    $rs->MoveNext();
    DEBUG($url);
}

############################################################################
### Eventi

$sql = "select x.*, p.regione from eventi x
        join province p ON x.provincia=p.sigla";
$rs = $db->Esegui($sql);

while (!$rs->EOF) {
    $code = slug_simple($rs->Fields("code"));
    $regione = slug_simple($rs->Fields("regione"));
    $comune = slug_simple(substr($rs->Fields("comune"), 0, -5));
    $titolo = slug_simple($rs->Fields("titolo"));
    $url = $BASEURL."/eventi/{$regione}/{$comune}/{$titolo}/{$code}";
    $rs->MoveNext();
    DEBUG($url);
}
?>