<!DOCTYPE html><!--[if lt IE 7]><html class="no-js ie ie6 lt-ie7 lt-ie8 lt-ie9 lt-ie10"><![endif]-->
<!--[if IE 7]>   <html class="no-js ie ie7 lt-ie8 lt-ie9 lt-ie10"><![endif]-->
<!--[if IE 8]>   <html class="no-js ie ie8 lt-ie9 lt-ie10"><![endif]-->
<!--[if IE 9]>   <html class="no-js ie ie9 lt-ie10"><![endif]-->
<!--[if gt IE 9]><html class="no-js ie ie10"><![endif]-->
<!--[if !IE]><!-->
<html class="no-js"><!--<![endif]-->
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1">
    <title>GroundworkCSS 2 &hearts; A Responsive HTML5, CSS & Javascript Framework</title>
    <!-- Modernizr -->
    <script src="js/libs/modernizr-2.6.2.min.js"></script>
    <!-- jQuery-->
    <script type="text/javascript" src="js/libs/jquery-1.10.2.min.js"></script>
    <!-- framework css --><!--[if gt IE 9]><!-->
    <link type="text/css" rel="stylesheet" href="css/groundwork.css"><!--<![endif]--><!--[if lte IE 9]>
    <link type="text/css" rel="stylesheet" href="css/groundwork-core.css">
    <link type="text/css" rel="stylesheet" href="css/groundwork-type.css">
    <link type="text/css" rel="stylesheet" href="css/groundwork-ui.css">
    <link type="text/css" rel="stylesheet" href="css/groundwork-anim.css">
    <link type="text/css" rel="stylesheet" href="css/groundwork-ie.css"><![endif]-->
    
    <link href='http://fonts.googleapis.com/css?family=Montserrat:400,700' rel='stylesheet' type='text/css'>
    

    <script type="text/javascript" src="http://5.135.198.145:8000/mariobid/client.js"></script>
    <script src="js/plugins/jquery.plugin.min.js"></script>
    <script src="js/plugins/jquery.countdown.min.js"></script>
    
    <style type="text/css">
    body {
        background: #F3F3F3;
        font-family: 'Montserrat', sans-serif;
    }
    .montserrat {
        font-family: 'Montserrat', sans-serif;
    }
    .bold {
        font-weight: bold;
    }
    .logo {
        position: relative;
        top: -0.5em;
    }
    .logo a, .logo a:visited {
        text-decoration: none;
        color: #2B2B2D;
    }
    .logo img {
        height: 2em;
        position: relative;
        top: 0.55em;
        margin-right: 0.3em;
    }
    .myround {
        -webkit-border-radius: 5px;
        -moz-border-radius: 5px;
        border-radius: 5px;
        margin: 1px;
    }
    .mygap {
        margin: 1px;
    }
    .myborder {
        border: 0px solid #CCC;
        background: #FFF;
        -webkit-box-shadow: 0px 0px 3px 0px rgba(180, 180, 180, 0.7);
        -moz-box-shadow:    0px 0px 3px 0px rgba(180, 180, 180, 0.7);
        box-shadow:         0px 0px 3px 0px rgba(180, 180, 180, 0.7);
    }
    .mycenter {
        text-align: center; 
    }
    .btnPunta {
        background: linear-gradient(#39B44B, #308D3D) repeat scroll 0% 0% transparent;
        clear: both;
        display: block;
        margin: -4px;
    }
    .titolo_asta {
        font-size: 1.5em;
    }
    .costo_asta, .offerta_che_non_puoi_rifiutare {
        font-size: 2.0em;
        margin: 3px;
        font-weight: bold;
        color: #ff8400;
    }
    .vincitore_asta {
        font-size: 1.0em;
        margin: 0px;
        font-weight: bold;
        color: #747474;
    }
    .vincitore_corrente {
        color: #0eb3ea;
        font-weight: bold;
    }
    .tempo_asta {
        font-size: 2.5em;
        margin: 0px;
        margin-bottom: 3px;
    }
    .compralo_subito {
        color: #747474;
    }
    .ultimi_secondi {
        background: #ff272d; 
        color: white;
    }
    </style>
    <script type="text/javascript">
(function() {

  $(document).ready(function() {
    
  });

}).call(this);
</script>

<script type="text/javascript">
var counter = new Array();
var utente = '{$utente.utente}';
var utente_code = '{$utente.code}';
var client = new Faye.Client('http://5.135.198.145:8000/mariobid', {
    retry: 5
});
</script>

{literal}
<script type="text/javascript">
function highlightLast5(periods) { 
    if ($.countdown.periodsToSeconds(periods) === 5) { 
        $(this).addClass('ultimi_secondi'); 
    } 
} 

//-------------------------------------------------------------------------------
var subscription = client.subscribe('/update', function(message) {
    var id = message.auction;
    //alert(id + ' ' + message.auction_status);
    var vincente = document.getElementById("vincente_" + id);
    var puntata = document.getElementById("puntata_" + id);
    var valore = document.getElementById("valore_" + id);
    var btn_punta = document.getElementById("btn_punta_" + id);
    
    vincente.innerHTML = message.user;
    puntata.innerHTML = message.value.toFixed(3);
    valore.innerHTML = message.auction_value.toFixed(3);
    
    update_status(id, message.auction_status);

    if (message.auction_status == 'W') {
        var test1 = new Countdown({
            year	: 2014, 
            month	: 9, 
            day		: 19, 
            hour	: 3,
            ampm	: "pm",
            minute	: 0, 
            second	: 0,
            target: "counter_" + id,
            rangeHi:"hour"    // <- no comma on last item!!
		});
        
        if (btn_punta)
            btn_punta.innerHTML = "Iscriviti!";
    } 
    else if (message.auction_status == 'A') {
        /*if(typeof counter[id] != 'undefined')
            counter[id].init();
        else
            counter[id] = new Countdown({
                time: message.time, 
                width:150, 
                height:80, 
                target: "counter_" + id,
                rangeHi:"minute"	// <- no comma on last item!
            });*/
            
        if (utente != message.user) {
            if (btn_punta)
                btn_punta.innerHTML = "Punta!";
        }
    } 
    else if (message.auction_status == 'S') {
        if(typeof counter[id] != 'undefined') {
            $('#counter_' + id).removeClass('ultimi_secondi').countdown('option', { until: message.time });
        }
        else {
            counter[id] = true;
            $('#counter_' + id).countdown({
                until: message.time, 
                onTick: function (periods) { 
                    if ($.countdown.periodsToSeconds(periods) === 5) { 
                        $(this).addClass('ultimi_secondi'); 
                        $('#vincente_' + id).addClass('ultimi_secondi');
                    } 
                },
                layout: '{mn}:{sn}'
            });
        }

        if (utente != message.user) {
            if (btn_punta)
                btn_punta.innerHTML = "PUNTA!";
            $('#vincente_' + id).removeClass('ultimi_secondi');
            $('#vincente_' + id).removeClass('vincitore_corrente');
            $('#vincente_' + id).addClass('vincitore_asta');
        }
        else {
            if (btn_punta)
                btn_punta.innerHTML = "<img src='images/baffi.png' height='16px' />";
            $('#vincente_' + id).removeClass('ultimi_secondi');
            $('#vincente_' + id).removeClass('vincitore_asta');
            $('#vincente_' + id).addClass('vincitore_corrente');
        }
    } 
    /*else {
        var test1 = new Countdown({
            year	: 2014, 
            month	: 9, 
            day		: 12, 
            hour	: 3,
            ampm	: "pm",
            minute	: 0, 
            second	: 0,
            target: "counter_" + id,
            rangeHi:"hour"    // <- no comma on last item!!
		});
    }*/
});

//-------------------------------------------------------------------------------
var subscription2 = client.subscribe('/finish', function(message) {
    var id = message.auction;
    var counter = document.getElementById("counter_" + id);
    var vincente = document.getElementById("vincente_" + id);
    
    if (vincente.innerHTML == utente)
        counter.innerHTML = "<h3 style='color:red;'>HAI VINTO!!!</h3>";
    else
        counter.innerHTML = "<h3 style='color:green;'>FINITA!</h3>";
    
    var button = document.getElementById("button_punta_" + id);
    button.innerHTML = "";
    
    update_status(id, message.auction_status);
});

//-------------------------------------------------------------------------------
var subscription3 = client.subscribe('/users/' + utente_code, function(message) {
    var crediti = document.getElementById('crediti');
    
    crediti.innerHTML = message.crediti;
});

//-------------------------------------------------------------------------------
var subscription3 = client.subscribe('/errors', function(message) {
    var errors = document.getElementById('errors');
    
    errors.innerHTML = errors.innerHTML + '<br>' + message.error;
});

//-------------------------------------------------------------------------------
function punta(id) {
    var vincente = document.getElementById("vincente_" + id);
    
    if (vincente.innerHTML == utente)
        return;
        
    //$("btn_punta_" + id).html("<img src='images/baffi.png' height='16px' />");
        
    var publication = client.publish('/play', {auction: id, user: utente});

    publication.then(function() {
        console.debug('Message received by server!');
    }, function(error) {
        console.debug('There was a problem: ' + error.message);
    });
}

//-------------------------------------------------------------------------------
function iscriviti(id) {
    var publication = client.publish('/subscribe', {auction: id, user: utente});

    publication.then(function() {
        console.debug('Message received by server!');
    }, function(error) {
        console.debug('There was a problem: ' + error.message);
    });
    
    var button = document.getElementById("button_iscriviti_" + id);
    button.innerHTML = "";
}

//-------------------------------------------------------------------------------
function update_status(id, status) {
    var stato = document.getElementById("stato_" + id);
    stato.innerHTML = status;
}
</script>
{/literal}
  </head>
  <body>
    <header class="montserrat">
        <div class="container half-padded">
            <div class="half-padded row">
                <div class="two fifths two-up-small-tablet bounceInDown animated half-padded" style="">
                    
                </div>
                
                <div class="three fifths two-up-small-tablet bounceInDown animated half-padded" style="">
                    <p class="align-right">Ciao {$utente.utente} hai <button class="mygap green"><span id="crediti">{$utente.salvadanaio_crediti}</span> crediti</button>
                    Saldo disponibile <button class="mygap asphalt">&euro; 120,00</button>
                    <button class="mygap orange">Acquista crediti</button>
                    </p>
                </div>
            </div>
            
            <div class="half-padded row myround myborder">
                <div class="five elevenths two-up-small-tablet bounceInDown animated half-padded" style="text-align:center">
                    <img src="images/logo.png" style="margin-top:-80px;" width="60%" />
                </div>
                
                
                <div class="six elevenths two-up-small-tablet bounceInDown animated half-padded" style="">
                    <h2 class="offerta_che_non_puoi_rifiutare montserrat">Un'offerta che non potrai rifiutare.</h2>
                    <div class="equalize row">
                        <button class="two elevenths two-up-small-tablet bounceInDown animated half-padded mygap blue">Aste dal vivo</button>
                        <button class="two elevenths two-up-small-tablet bounceInDown animated half-padded mygap white">Aste vinte</button>
                        <button class="two elevenths two-up-small-tablet bounceInDown animated half-padded mygap white">Come funziona?</button>
                        <button class="two elevenths two-up-small-tablet bounceInDown animated half-padded mygap white">Testimonianze</button>
                        <button class="two elevenths two-up-small-tablet bounceInDown animated half-padded mygap white">FAQ</button>
                    </div>
                </div>
            </div>
        </div>
    </header>
    
    <div class="container montserrat">
      
        <div class="equalize row">
        {foreach item=asta key=key from=$aste}
            <div class="one fifth two-up-small-tablet padded bounceInDown animated">
            <div id="asta_{$asta.id}" class="half-padded myround myborder montserrat" style="">
                <div class="mycenter titolo_asta" data-truncate="1">{$asta.titolo}</div>
                <p class="mycenter"><img src="images/iphon6plus.jpg" class="" height="110px"></p>
                <div class="mycenter costo_asta">&euro; <span id="puntata_{$asta.code}">0</span></div>
                <div class="mycenter vincitore_asta" id="vincente_{$asta.code}">-</div>
                <div class="mycenter black tempo_asta"><div id="counter_{$asta.code}">-</div></div>
                 
                <div id="button_punta_{$asta.code}">
                <button type="button" id="btn_punta_{$asta.code}" onclick="punta('{$asta.code}');" class="blue block montserrat" style="color:white; background:#0eb3ea; border:0px; font-size:1.5em; padding:0px;">PUNTA!</button>
                </div>
                
                <div id="button_iscriviti_{$asta.code}">
                <button type="button" id="btn_iscriviti_{$asta.code}" onclick="iscriviti('{$asta.code}');" class="blue block montserrat" style="color:white; background:#ff8400; border:0px; font-size:1.5em; padding:0px;">ISCRIVITI!</button>
                </div>
        
                <p class="mycenter gap-top compralo_subito">Compralo subito: <span style="color:black;">&euro; {$asta.prezzo_listino|intval}</span></p>
                
            </div>
                <p>
                Crediti iscrizione: <span>{$asta.crediti_iscrizione}</span><br>
                Crediti per puntata: <span>{$asta.crediti_puntata}</span><br>
                Prezzo listino: <span>{$asta.prezzo_listino|money}</span><br>
                *Prezzo soglia*: <span>{$asta.prezzo_soglia|money}</span><br>
                *Valore raggiunto*: <span id="valore_{$asta.code}">{$asta.valore_puntate|money}</span><br>
                *Stato asta*: <span id="stato_{$asta.code}">{$asta.stato}</span><br>
                </p>
            </div>
        {/foreach}

            

            <div class="one fifth two-up-small-tablet padded bounceInDown animated">
            <div class="half-padded myround myborder montserrat" style="">
                <div class="mycenter titolo_asta">Samsung S5</div>
                <p class="mycenter"><img src="images/galaxys5.jpg" class="" height="110px"></p>
                <div class="mycenter orange costo_asta">&euro; 36,78</div>
                <div class="mycenter vincitore_asta" style="color:#0eb3ea">mario</div>
                <div class="mycenter black tempo_asta">00:14</div>
                <button class="blue block montserrat" style="color:white; background:#0eb3ea; border:0px; font-size:1.5em; padding:0px;">PUNTA! <img src="images/piccolocoin1.png" class="" height=""></button>
                <p class="mycenter gap-top">Compralo subito</p>
            </div>
            </div>

            <div class="one fifth two-up-small-tablet padded bounceInDown animated">
            <div class="half-padded myround myborder montserrat" style="">
                <div class="mycenter titolo_asta">Samsung S4</div>
                <p class="mycenter"><img src="images/galaxys5.jpg" class="" height="110px"></p>
                <div class="mycenter orange costo_asta">&euro; 26,78</div>
                <div class="mycenter asphalt vincitore_asta">cicciopasticcio</div>
                <div class="mycenter black tempo_asta">-</div>
                <div class="mycenter">100 X <img src="images/piccolocoin1.png" style="vertical-align: middle;">    5 x <img src="images/piccolocoin1.png" style="vertical-align: middle;"></div>
                <button class="orange block">ISCRIVITI!</button>
                <p class="mycenter gap-top">Compralo subito</p>
            </div>
            </div>

            <div class="one fifth two-up-small-tablet padded bounceInDown animated">
            <div class="half-padded myround myborder montserrat" style="">
                <div class="mycenter titolo_asta">Play Station 4</div>
                <p class="mycenter"><img src="images/ps4.jpg" class="" height="110px"></p>
                <div class="mycenter orange costo_asta">&euro; 16,78</div>
                <div class="mycenter asphalt vincitore_asta">carmelo</div>
                <div class="mycenter black tempo_asta">00:14</div>
                <div class="mycenter">
                    100 X <img src="images/piccolocoin1.png" style="vertical-align: middle;">&nbsp;&nbsp; <span style="color:#ff8400">5 x </span><img src="images/piccolocoin2.png" style="vertical-align: middle;">
                </div>
                <button class="orange block">ISCRIVITI!</button>
                <p class="mycenter gap-top">Compralo subito</p>
            </div>
            </div>

        </div>
      
        <div class="equalize row">
            <div class="one fifth two-up-small-tablet padded bounceInDown animated">
            <div class="half-padded myround myborder montserrat" style="">
                <div class="mycenter titolo_asta">Il phon 6</div>
                <p class="mycenter"><img src="images/iphon6plus.jpg" class="" height="110px"></p>
                <div class="mycenter costo_asta">&euro; 26,78</div>
                <div class="mycenter asphalt vincitore_asta">giannuzzo</div>
                <div class="mycenter black tempo_asta">00:14</div>
                <button class="blue block montserrat" style="color:white; background:#0eb3ea; border:0px; font-size:1.5em; padding:0px;">PUNTA!</button>
                <p class="mycenter gap-top">Compralo subito</p>
            </div>
            </div>

            <div class="one fifth two-up-small-tablet padded bounceInDown animated">
            <div class="half-padded myround myborder montserrat" style="">
                <div class="mycenter titolo_asta">Samsung S6</div>
                <p class="mycenter"><img src="images/galaxys5.jpg" class="" height="110px"></p>
                <div class="mycenter costo_asta">&euro; 46,78</div>
                <div class="mycenter asphalt vincitore_asta" style="background:#ff272d; color:white;">marcellinux</div>
                <div class="mycenter black tempo_asta" style="background:#ff272d; color:white;">00:04</div>
                <button class="block montserrat" style="color:white; background:#0eb3ea; border:0px; font-size:1.5em; padding:0px;"><img src="images/baffi.png" height="16px" /></button>
                <p class="mycenter gap-top">Compralo subito</p>
            </div>
            </div>

            <div class="one fifth two-up-small-tablet padded bounceInDown animated">
            <div class="half-padded myround myborder montserrat" style="">
                <div class="mycenter titolo_asta">Samsung S5</div>
                <p class="mycenter"><img src="images/galaxys5.jpg" class="" height="110px"></p>
                <div class="mycenter orange costo_asta">&euro; 36,78</div>
                <div class="mycenter vincitore_asta" style="color:#0eb3ea">mario</div>
                <div class="mycenter black tempo_asta">00:14</div>
                <button class="blue block montserrat" style="color:white; background:#0eb3ea; border:0px; font-size:1.5em; padding:0px;">PUNTA!</button>
                <p class="mycenter gap-top">Compralo subito</p>
            </div>
            </div>

            <div class="one fifth two-up-small-tablet padded bounceInDown animated">
            <div class="half-padded myround myborder montserrat" style="">
                <div class="mycenter titolo_asta">Samsung S4</div>
                <p class="mycenter"><img src="images/galaxys5.jpg" class="round" height="110px"></p>
                <div class="mycenter orange costo_asta">&euro; 26,78</div>
                <div class="mycenter asphalt vincitore_asta">cicciopasticcio</div>
                <div class="mycenter black tempo_asta">-</div>
                <button class="orange block">ISCRIVITI!</button>
                <p class="mycenter gap-top">Compralo subito</p>
            </div>
            </div>

            <div class="one fifth two-up-small-tablet padded bounceInDown animated">
            <div class="half-padded myround myborder montserrat" style="">
                <div class="mycenter titolo_asta">Play Station 4</div>
                <p class="mycenter"><img src="images/ps4.jpg" class="round" height="110px"></p>
                <div class="mycenter orange costo_asta">&euro; 16,78</div>
                <div class="mycenter asphalt vincitore_asta">carmelo</div>
                <div class="mycenter black tempo_asta">00:14</div>
                <button class="orange block">ISCRIVITI!</button>
                <p class="mycenter gap-top">Compralo subito</p>
            </div>
            </div>

        </div>
        
        <hr>
    
    <footer class="gap-top bounceInUp animated">
      <div class="box square charcoal">
        <div class="container padded">
          <div class="row">
            <div class="one small-tablet fourth padded">
              <h5 class="green">Example Layouts</h5>
              <ul class="unstyled">
                <li><a href="./layout-a.html">Web Page</a></li>
                <li><a href="./layout-b.html">Image Gallery</a></li>
                <li><a href="./layout-c.html">Ecommerce Page</a></li>
                <li><a href="./layout-d.html">Contact Page</a></li>
              </ul>
            </div>
            <div class="three small-tablet fourths padded">
              <h5 class="blue">Documentation</h5>
              <ul class="unstyled three-column two-column-mobile">
                <li><a href="./grid.html" title="Responsive grid system, grid adapters and helpers">Grid</a></li>
                <li><a href="./helpers.html" title="Layout helpers, spinners and much more">Helpers</a></li>
                <li><a href="./typography.html" title="Text elements, quotes, code and web fonts">Typography</a></li>
                <li><a href="./navigation.html" title="Navigation">Navigation</a></li>
                <li><a href="./buttons.html" title="Buttons, button groups, button menus">Buttons</a></li>
                <li><a href="./boxes.html" title="Boxes">Boxes</a></li>
                <li><a href="./messages.html" title="Message boxes">Message Boxes</a></li>
                <li><a href="./tables.html" title="Tables">Tables</a></li>
                <li><a href="./tabs.html" title="Tabs">Tabs</a></li>
                <li><a href="./forms.html" title="Form elements">Form Elements</a></li>
                <li><a href="./icons.html" title="Icons">Icons</a></li>
                <li><a href="./responsive-text.html" title="Responsive text and multi-line text block truncation">Responsive Text</a></li>
                <li><a href="./placeholder-text.html" title="Placeholder text and placeholder fonts for rapid prototyping and wireframes">Placeholder Text</a></li>
                <li><a href="./animations.html" title="Pure CSS3 Animations">Animations</a></li>
              </ul>
            </div>
          </div>
        </div>
      </div>
      <div class="box square">
        <div class="container padded">
          <div class="row">
            <div class="one half padded">
              <p>GroundworkCSS is <b>100% free</b> and <b>open source</b>. <a href="mailto:groundworkcss@gmail.com">Give a shout out</a> if you have any feedback.</p>
              <p>Find a bug? Help squash it by <a href="https://github.com/groundworkcss/groundwork/issues" target="_blank">filing an issue</a> on Github.</p>
            </div>
            <div class="one half padded">
              <p class="large padded align-right align-center-small-tablet"><a href="http://twitter.com/groundworkcss" target="_blank" title="@groundworkcss" style="text-decoration:none;" class="large inline gapped"></a><a href="http://github.com/groundworkcss" target="_blank" title="@groundworkcss" style="text-decoration:none;" class="large inline gapped"></a><a href="mailto:groundworkcss@gmail.com" title="groundworkcss@gmail.com" style="text-decoration:none;" class="large inline gapped"></a></p>
            </div>
          </div>
        </div>
      </div>
    </footer>
    <!-- javascript-->
    <script type="text/javascript" src="../js/groundwork.all.js"></script>
    
  </body>
</html>