{include file="page-header.tpl"}


<style>
.fonte { color: #888; font-size: 0.7; font-style: italic; }
.titolo_sezione { color: #360; font-weight: bold; padding-top: 1em; }
.em { font-size: 1.4em; }
</style>
<h1 class="titolo_pagina">PET therapy</h1>

<div class="triple-padded">
    <h2 class="titolo_sezione">1. UN PO' DI STORIA</h2>
    <p class="fonte">tratto da <a href="http://www.farminachannel.com/d_viewarticolo.php?articolo=912&pag=1" target="_blanc">http://www.farminachannel.com</a></p>
    
<p class="justify quicksand">Si parla di Pet Therapy sin dalla fine del 1700, quando in Inghilterra alcuni pazienti con disturbi mentali furono incoraggiati a prendersi cura di animali domestici. A met&agrave; del secolo scorso lo psichiatra infantile Boris Levinson scopr&igrave; che quando nel suo studio era presente il suo cane, i bambini con disturbi psichici da lui seguiti erano fortemente attratti dall'animale, agivano in maniera pi&ugrave; spontanea e si relazionavano pi&ugrave; facilmente con il terapeuta. Il cane svolgeva una funzione mediatrice agevolando gli scambi comunicativi. </p>
<p class="justify quicksand">Successivamente Levinson pubblica il libro Levinson B. M.,1962, "The dog as a co- therapist" nel quale descrive questi risultati. Afferma che l'animale ha un ruolo fondamentale nelle cure psicologiche come  co-terapeuta. E' lui che conia il termine Pet Therapy, per definire le terapie basate sui benefici della relazione uomo-animale.  Cosa importante da sottolineare &egrave; che la Pet Therapy non &egrave; un terapeuta, ma una co-terapeuta. Psichiatri, psicologi, operatori sociali, pedagoghi e cinofili lavorano congiuntamente ad un obiettivo.</p>
<p class="justify quicksand">I primi a progettare e ad applicare un vero programma di "Pet-facilitated therapy" furono gli psichiatri Sam e Elizabeth Corson, dell'universit&agrave; dell'Ohio, nel 1977.</p>
<p class="justify quicksand">Cinquanta pazienti furono autorizzati a scegliere un cane e ad interagire con lui, durante alcuni appuntamenti quotidiani: i cani catalizzavano il loro desiderio di socializzazione (sono stati poi definiti "lubrificanti sociali"), che senza la loro presenza restava invece trattenuto ed inespresso; fungevano inoltre da anello di congiunzione tra lo staff ed i pazienti i quali, man mano, aumentarono gradualmente il rispetto verso se stessi, la capacit&agrave; di essere indipendenti e quella di entrare in confidenza con gli altri.</p>
<p class="justify quicksand">Nel 1981 a Melbourne, in Australia, fu introdotto in un ospedale un cane addestrato (un Golden Retriever di nome Honey). Si not&ograve; che, grazie alla sua presenza e alla relazione che instaurarono con lui, i sessanta pazienti ricoverati mutarono il loro umore di base: ridevano e sorridevano molto di pi&ugrave; di prima. La loro attenzione verso il mondo esterno aument&ograve; e, soprattutto, diventarono pi&ugrave; ottimisti verso il futuro. Coloro che invece non erano stati messi in contatto con il cane, continuarono a mostrare molto minor interesse verso le relazioni umane, restando riservati e schivi nei confronti del prossimo.</p>
<p class="justify quicksand">In Italia la Pet Therapy &egrave; arrivata nel 1987 in occasione del convegno interdisciplinare "Il ruolo degli animali nella societ&agrave; moderna". Nel 2003, il Ministro della Salute, Girolamo Sirchia, ha firmato "l'accordo Stato-Regioni sul benessere degli animali da compagnia e Pet Therapy" finalizzato a diffondere, seguire e valutare tutti i programmi di Pet Therapy che hanno luogo in Italia. </p>

    
    <h2 class="titolo_sezione">2. Campi di applicazione</h2>
    
<p class="justify quicksand">In Svizzera, nel 1999 anno Internazionale dell'Anziano, l'Ufficio Federale di Statistica di Zurigo ha svolto uno studio che ha rilevato che 7 anziani su 10 tra quelli che avevano la percezione di una buona salute nonostante gli acciacchi dovuti all'et&agrave;, vivevano in casa in compagnia di un cane o di un gatto. </p>
<p class="justify quicksand">Viene impiegata nelle terapie con bambini autistici o che soffrano di difficolt&agrave; di relazione e comunicazione; con persone affette da sindrome di Down; con persone che presentino malformazioni fisiche congenite o causate da incidenti; con i videolesi; con i soggetti fobici, ansiosi, iperattivi o sofferenti di nevrosi depressiva, pi&ugrave; o meno grave e persistente; con persone anziane che abbiano subito lutti; con adolescenti "difficili" o "a rischio" , con i detenuti nelle  carceri. Il loro impiego &egrave; utile anche per le persone anziane non autosufficienti, affette dal Morbo di Alzheimer e quelle che vivono in Istituto.</p>
<p class="justify quicksand">Secondo uno studio effettuato dalla Virginia Commonwealth University, chi porta il proprio animale domestico sul lavoro &egrave; pi&ugrave; soddisfatto e produttivo professionalmente e anche i colleghi ne traggono dei benefici. Durante questo studio, i ricercatori hanno confrontato i dati psicofisici relativi a coloro che portano i animali domestici in ufficio, comparandoli con coloro che invece non ne hanno, valutandone diversi fattori tra i quali lo stress, la soddisfazione, l'impegno e il supporto organizzativo. Ci&ograve; che &egrave; emerso &egrave; che vi sono significative differenze di livelli di stress nei giorni in cui l'animale era presente al lavoro e quelli in cui era assente.</p>
    

    <h2 class="titolo_sezione">3. Animali considerati co-terapeuti</h2>
    <p class="fonte">tratto da <a href="http://psicologia.tesionline.it/psicologia/article.jsp?id=23676" target="_blanc">http://psicologia.tesionline.it</a></p>
    
<p class="justify quicksand"><span class="em bold">Cani</span>, di cui alcune razze vengono ormai considerate "da Pet Therapy" per eccellenza (Golden e Labrador Retriever soprattutto, in considerazione della loro docilit&agrave; e socievolezza), amici dell'uomo per definizione, coinvolti in interventi con anziani ospiti di case di riposo, disabili, persone con sindrome autistica, bambini con difficolt&agrave; comportamentali, singolarmente o in gruppo; con il cane si instaura un rapporto di profonda complicit&agrave; ed affetto, in cui imparare le regole di base per una relazione gratificante, la tendenza genetica della specie canina ad assoggettarsi e seguire un capobranco fa s&igrave; che, se ben impostato, l'intervento di Pet Therapy con il cane funga da rafforzatore dell'autostima, da catalizzatore nelle cure dei disturbi emotivi e come base affettiva sicura in situazioni di disagio sociale o relazionale, inoltre pu&ograve; aiutare nella cura di disturbi psico-fisici se impiegato in attivit&agrave; di dog-agility assieme all'utente. </p>

<p class="justify quicksand"><span class="em bold">Gatti</span>, i principali benefici ottenibili dalla compagnia e dal contatto fisico con un gatto riguardano la sfera dei disturbi stress-correlati, disturbi depressivi, sindrome ansiogena e problematiche comunicativo-relazionali. A differenza del cane, la difficolt&agrave; del gatto a fidarsi ed affidarsi all'essere umano stimola la costanza nei rapporti, l'autocontrollo (raramente la specie felina apprezza contatti invadenti), l'impegno prolungato per ottenere risultati tangibili. Il contatto con il pelo del gatto &egrave; piacevole e distensivo, agisce sul battito cardiaco e sulla pressione sanguigna, l'emissione delle fusa dona un immediato riscontro delle attenzioni rivolte all'animale, ma non &egrave; l'unico modo di interagire con esso, interventi di Pet Therapy con gatti possono essere sviluppati anche gestendo gruppi felini dei gattili, a cui somministrare cibo e cure e da cui ottenere, con il tempo, fiducia ed avvicinamento graduali. </p>

<p class="justify quicksand"><span class="em bold">Cavalli</span>, l'ippoterapia (il movimento del cavallo viene utilizzato come strumento riabilitativo), o rieducazione equestre (intervento pi&ugrave; attivo dell'utente, anche nella guida del cavallo) &egrave; forse il settore pi&ugrave; noto all'interno della Pet Therapy, il cavallo &egrave; un animale dall'indubbio fascino, ed anche con esso la relazione che si pu&ograve; creare produce intense gratificazioni da ambo le parti; la rieducazione equestre (di cui l'ippoterapia &egrave; una branca) viene utilizzata soprattutto come aiuto nella cura di disturbi muscolari, neurologici, post-trauma e nelle disabilit&agrave; con forte componente fisica, anche se, in virt&ugrave; del rapporto instaurabile con il cavallo, si possono prevedere anche interventi per casi di disagio e disturbi emotivo-relazionali. Fare Pet therapy con i cavalli non significa necessariamente (o non solo) montarci sopra, l'intervento generalmente (se il caso lo consente) parte dall'acquisizione delle nozioni di base per la cura dell'animale, e prevede spazzolature, pulizia dei box e vicinanza con il cavallo al fine di raggiungere quella fiduccia di base che permetter&agrave; l'eventuale monta in sella. </p>

<p class="justify quicksand"><span class="em bold">Asini</span>, l'onoterapia sfrutta alcune caratteristiche proprie dell'asino, quali la piacevolezza al tatto, la taglia ridotta, la pazienza, la lentezza dei movimenti, che tendono alla ripetizione monotona, per creare un tipo di relazione rassicurante e progressiva, motivo per cui viene destinata principalmente a persone con disturbi psichiatrici o comportamentali e disabili motori, ma non mancano i risvolti pi&ugrave; specificamente educativi (come in genere per qualunque progetto che implichi la presa in cura di un essere vivente) per cui l'asino pu&ograve; essere agevolmente impiegato in attivit&agrave; ricreative (passeggiate) o inserito in progetti educativi, anche di gruppo. </p>

<p class="justify quicksand"><span class="em bold">Uccelli</span>, principalmente pappagallini e canarini, in virt&ugrave; della potenzialit&agrave; a stimolare l'allegria e a migliorare l'umore, vengono impiegati in progetti rivolti ad anziani e per la riduzione dell'aggressivit&agrave; (ad esempio nelle carceri), anche in funzione delle cure ridotte di cui necessitano e della possibilit&agrave; di alloggio anche in ambienti chiusi. </p>

<p class="justify quicksand"><span class="em bold">Delfini</span>, anche per essi la funzione principale &egrave; quella di destare gioia ed allegria, soprattutto per soggetti in et&agrave; evolutiva, possono essere inseriti in interventi destinati a persone con disturbi emotivi e relazionali, a persone con sindrome autistica, a persone con problemi nella sfera affettiva (il delfino &egrave; un mammifero estremamente evoluto, in gradi di riconoscere e interpretare il linguaggio del corpo e soddisfare i bisogni comunicativi anche quando problematici). Il grado di avvicinamento all'animale pu&ograve; variare dall'osservazione con interazione minima (ad esempio in interventi di gruppo) al contatto fisico (in questo caso &egrave; necessario saper nuotare). </p>

<p class="justify quicksand"><span class="em bold">Mammiferi di piccola taglia</span>, perlopi&ugrave; criceti, conigli e porcellini d'india, adatti a persone con problemi psicologici lievi, e in generale come facilitatori relazionali (come per gli uccelli, vengono impiegati negli interventi nelle carceri). 

<p class="justify quicksand"><span class="em bold">Pesci e tartarughe</span>, impiegati nelle sindromi collegate allo stress, come calmanti in gradi di ridurre ansia e sintomi depressivi, in generale il loro accadimento facilita una presa in carico di responsabilit&agrave; e riduce il senso di inadeguatezza."

    
    <h2 class="titolo_sezione">4. I 3 diversi tipi di programmi assistiti da animali</h2>

    <p class="justify quicksand">La Delta Society lavora in Australia sulla pet therapy sin dall'agosto del 1997 (autorizzata in tal senso dall'Animal Welfare League of Australia) 
    ha coniato le tre sigle che descrivono i tre diversi tipi di programmi di pet therapy:</p>
    <ol class="list orange">
        <li>Le <b>AAA</b> (Animal-Assistede Activities - Attivit&agrave; Assistite da Animali)</li>
        <li>Le <b>AAT</b> (Animal-Assisted Therapy - Terapie Assistite da Animali)</li>
        <li>La <b>AAE</b> (Animal-Assisted Education - Educazione Assistita da Animali)</li>
    </ol>
   
<p class="justify quicksand"><span class="em bold">A.A.A</span>: Attivit&agrave; Assistite con Animali. Prevedono interventi educativo-ricreativi e di supporto psico-relazionale con varie tipologie di utenti, non hanno valenza prettamente terapeutica e di conseguenza non necessitano di prescrizione medica e sono meno vincolate, nei tempi e nelle modalit&agrave;, delle attivit&agrave; a scopo terapeutico. </p>
<p class="justify quicksand"><span class="em bold">AAT</span>: Le Terapie Assistite con Animali seguono un programma costituito da obiettivi specifici predeterminati ed hanno come scopo quello di migliorare la salute dei pazienti, sofferenti di vari tipi di patologie. Si prefigge di migliorare le attitudini sia comportamentali, mentali ed emotive dei pazienti, sia le sue condizioni fisiche. Il programma terapeutico &egrave; personalizzato per ciascun paziente. </p>
<p class="justify quicksand"><span class="em bold">AAE</span>: L'Educazione Assistita da Animali si dedica in modo esclusivo al miglioramento delle capacit&agrave; cognitive del paziente relativamente a: le facolt&agrave; linguistiche, la capacit&agrave; di rappresentazione, il ragionamento, l'abilit&agrave; nella risoluzione di un problema, le capacit&agrave; mnemoniche ed il loro uso, l'utilizzo della comunicazione non verbale etc.</p>

    
    <h2 class="titolo_sezione">5. Un caso pratico. I BAMBINI CHE LEGGONO AI GATTI</h2>
<p class="justify quicksand">In Pennsylvania (Stati Uniti) un'associazione si occupa di recuperare i gatti abbandonati e maltrattati e di riavvicinarli all'uomo, per farli poi adottare a chi se ne vuole prendere cura. Una specie di canile per gatti disperati che non hanno pi&ugrave; fiducia negli esseri umani.</p>
<p class="justify quicksand">I bambini devono leggere dei libri ai gatti, con voce pacata e tranquilla. Si siedono nelle varie stanzine, e leggono ad alta voce libri per bambini. I gatti si abituano al suono ritmico della loro voce e tornano ad avere fiducia, si avvicinano e iniziano a fare amicizia e a ricevere coccole.</p>
<p class="justify quicksand">L'inventore del metodo si chiama Kristi Rodriguez, e afferma che questa modalit&agrave; di interazione aiuta sia il gatto che il bambino: il gatto torna ad essere socievoli, il bambino migliora la propria capacit&agrave; espressiva e la sua autostima </p>
<p class="fonte"><b>Guardate le foto che ritraggono questa bellissima iniziativa:</b><br />
<a target="_blanc" href="http://www.dailybest.it/2014/02/12/questi-bambini-leggono-i-libri-ai-gatti-sembra-stupido-finche-non-sai-il-perche/">http://www.dailybest.it/2014/02/12/questi-bambini-leggono-i-libri-ai-gatti-sembra-stupido-finche-non-sai-il-perche</a></p>

   
   <h2 class="titolo_sezione">6. ALCUNI LIBRI SULL'ARGOMENTO</h2>
    <ul id="sezione_libri">
<li>Levinson B. M.,1962, <b>"The dog as a co- therapist"</b> Mental Hygiene,pp. 59-65.</li>
<li>Lee D.,1976, <b>"Pets are therapist at Lima State Hospital"</b> America Human Magazine, pp. 19-20.</li>
<li>Marcuzzi G, Vanozzi A.,1981 <b>"L'origine degli animali domestici"</b> Edagricole, Bologna.</li>
<li>Friedmann E.,1983, <b>"Interaction and blood pressure: influence of animal companions"</b> J. Nerv. Ment. Disease, n o171, pp. 461-465.</li>
<li>Edefonti A. e coll., 1985, <b>"Il destino riabilitativo e sociale del bambino con malattia cronica"</b>, Crescita, 13, pp. 43-50.</li>
<li>Nicolas Citterio D., 1985, "Il cavallo come strumento nella rieducazione di disturbi neuromotori", Mursia, Milano.</li>
<li>Schizer S.,1988 "Gli animali come strumento di recupero psicologico e sociale per i portatori di handicap fisico e mentale" Tesi di laurea, facolt&agrave; di Medicina Veterinaria di Parma.</li>
<li>Mainardi D.,1989, "Animali ed uomini" Il Cigno Galileo Galilei,Roma.</li>
<li>Stewart A., Harris J.,1992 "The importance of pets and prevention of zoonotic disease in immunocompromised individuals" Atti della 6th  Conferenza Internazionale "Animal et us" Montreal.</li>
<li>Ballarini G., 1996, "Animali amici della salute" Xenia Edizioni, Milano.</li>
<li>Busatti S.,1996, "Pet Therapy: programmi terapeutici con l'ausilio degli animali domestici" H. D. Giornale Italiano di Psicologia e Pedagogia dell' Handicap e della Disabilit&agrave; nell'apprendimento.</li>
<li>Honies A. R.,2000, "Animals helping people, people helping animals" Delta Society, M. Cobey, trad. it. 2000 "La valutazione della struttura"G. Caporale, Teramo.</li>
<li>Attiani G., 2002, "Il rapporto tra l'uomo e il suo animale, antidoto contro la solitudine" Sinequanon, Roma.</li>
    </ul>

    <h3>Fonti:</h3>
    <p class="fonte"><a target="_blanc" href="http://www.dailybest.it/2014/02/12/questi-bambini-leggono-i-libri-ai-gatti-sembra-stupido-finche-non-sai-il-perche/">http://www.dailybest.it/2014/02/12/questi-bambini-leggono-i-libri-ai-gatti-sembra-stupido-finche-non-sai-il-perche/</a></p>
    <p class="fonte"><a target="_blanc" href="http://www.farminachannel.com/d_viewarticolo.php?articolo=1827">http://www.farminachannel.com</a></p>
    <p class="fonte"><a target="_blanc" href="http://www.care2.com/causes/10-animals-using-their-smile-to-change-the-world.html">http://www.care2.com/causes/10-animals-using-their-smile-to-change-the-world.html</a></p>

</div>

{include file="page-footer.tpl"}
