{include file="page-header.tpl"}

{if $utente->publisher() && $stato != "adottato"}
    <form method="POST" action="form-pelosetto.php">
        <button type="submit" class="blue">Nuovo pelosetto</button>
    </form><br>
{/if}

{if $stato != "adottato"}
    <p>In questa sezione troverete pelosetti da adottare a distanza, da adottare e per i quali chiediamo uno stallo.</p>    
{else}
    <p>Qui troverete pelosetti che hanno trovato una nuova casa.</p>    
{/if}
    
{if $filtri_attivi}
<p>Sono presenti filtri di ricarca attivi. <button onclick="window.location='page-gallery.php?clear=1'">Eliminali</button></p>
{/if}

{foreach key=key item=item from=$pelosetti}
    
    {cycle name="d" assign="dispari" values="1,0"}
    {cycle name="b" assign="background" values="#E0D1C2,#F5F0EB"}
    
    {if $dispari}
    
    <div class="row myround myborder" style="background:{$background}">
        <div class="one fourths padded">
            <img class="myimage" src="{$item['foto1']}" />
            <form method="GET" action="page-presentazione-pelosetto.php">
                <input type="hidden" name="pelosetto" value="{$item['code']}" />
                <button class="block mybutton" type="submit" style="font-size:1.0em">Mi presento</button>
            </form>
            
            {if $item.flag_stato != "adottato"}
            {if $item.flag_adotta == 'S'}
                <form method="POST" action="form-adozione-interesse.php">
                    <input type="hidden" name="pelosetto" value="{$item['code']}" />
                    <button type="submit" class="block mybutton">Adottami</button>
                </form>{/if}

            {if $item.flag_adottadist == 'S'}
                <form method="POST" action="form-nuova-donazione.php">
                    <input type="hidden" name="code" value="{$item['code']}" />
                    <button type="submit" class="block mybutton">Adottami a distanza</button>
                </form>{/if}

            {if $item.flag_stallo == 'S'}
                <form method="POST" action="form-stallo-interesse.php">
                    <input type="hidden" name="pelosetto" value="{$item['code']}" />
                    <button type="submit" class="block mybutton">Ospitami in stallo</button>
                </form>{/if}
            {/if}
            {if $utente->publisher()}
            <form method="GET" action="form-pelosetto.php">
                <input type="hidden" name="pelosetto" value="{$item['code']}" />
                <button type="submit" class="block blue">Modifica</button>
            </form>
            {/if}
            {if $utente->administrator()}
            <form method="GET" action="stampa-scheda-pelosetto.php">
                <input type="hidden" name="pelosetto" value="{$item['code']}" />
                <button type="submit" class="block green">Stampa</button>
            </form>
            {/if}
            
            <div class="fb-like" 
                data-href="{$item['url']}" 
                data-layout="button_count" 
                data-action="like" 
                data-show-faces="false" 
                data-share="true"></div>
        </div>
        <div class="three fourths padded">
            
            {if $item.flag_urgente == 'S' and $item.flag_stato != "adottato"}
            <span style='font-size:1.4em; color:#A00; font-weight:bold;'>URGENTE</span>{/if}
            
            <h1 class="titolo_pagina">{$item['nome']}</h1>
            
            <p>
                Specie: <span class="bold">{$item['specie']}</span><br />
                {if $item.flag_stato != "adottato"}
                Disponibile per: <span class="bold">{$item.diponibile_per}</span><br />
                {else}
                Stato: <span class="bold">Adottato</span><br />
                {/if}
                Provenienza: <span class="bold">{$item['provenienza']}</span><br />
                {if $item.flag_stato != "adottato"}
                Attualmente presso: <span class="bold">{$item.attualmente_presso} - {$item.attualmente_dove}</span><br />
                {elseif $item.attualmente_presso|count_characters > 0}
                Adottato da: <span class="bold">{$item.attualmente_presso} - {$item.attualmente_dove}</span><br />
                {/if}
                Genere: <span class="bold">{$item.genere_pelosetto}</span><br />
                Taglia: <span class="bold">{$item.taglia_pelosetto}</span><br />
                Et&agrave;: <span class="bold">{$item.eta}</span>
            </p>
            
            <p class="justify quicksand">{$item['carattere_descrizione']}</p>

            {if $item.flag_stato != "adottato"}
            {*if $item.flag_adottadist == 'S'}<h4>Adottato a distanza al {$perc}%</h4>{/if*}
            {/if}
            Inserito il {$item.ct|date_format:"%d/%m/%Y"}
        </div>
    </div>    

    {else}
    
    <div class="row myround myborder" style="background:{$background}">
        <div class="three fourths padded">
            {if $item.flag_urgente == 'S' and $item.flag_stato != "adottato"}
            <span style='font-size:1.4em; color:#A00; font-weight:bold;'>URGENTE</span>{/if}
            
            <h1 class="titolo_pagina">{$item['nome']}</h1>
            
            <p>
                Specie: <span class="bold">{$item['specie']}</span><br />
                {if $item.flag_stato != "adottato"}
                Disponibile per: <span class="bold">{$item.diponibile_per}</span><br />
                {else}
                Stato: <span class="bold">Adottato</span><br />
                {/if}
                Provenienza: <span class="bold">{$item['provenienza']}</span><br />
                Attualmente presso: <span class="bold">{$item.attualmente_presso} - {$item.attualmente_dove}</span><br />
                Genere: <span class="bold">{$item.genere_pelosetto}</span><br />
                Taglia: <span class="bold">{$item.taglia_pelosetto}</span><br />
                Et&agrave;: <span class="bold">{$item.eta}</span>
            </p>
            <p class="justify quicksand">{$item['carattere_descrizione']}</p>

            {if $item.flag_stato != "adottato"}
            {*if $item.flag_adottadist == 'S'}<h4>Adottato a distanza al {$perc}%</h4>{/if*}
            {/if}
            Inserito il {$item.ct|date_format:"%d/%m/%Y"}
        </div>
        <div class="one fourths padded">
            <img class="myimage" src="{$item['foto1']}" />
            
            <form method="GET" action="page-presentazione-pelosetto.php">
                <input type="hidden" name="pelosetto" value="{$item['code']}" />
                <button class="block mybutton" type="submit" style="font-size:1.0em">Mi presento</button>
            </form>
            
            {if $item.flag_stato != "adottato"}
            {if $item.flag_adotta == 'S'}
                <form method="POST" action="form-adozione-interesse.php">
                    <input type="hidden" name="pelosetto" value="{$item['code']}" />
                    <button type="submit" class="block mybutton">Adottami</button>
                </form>{/if}

            {if $item.flag_adottadist == 'S'}
                <form method="POST" action="form-nuova-donazione.php">
                    <input type="hidden" name="code" value="{$item['code']}" />
                    <button type="submit" class="block mybutton">Adottami a distanza</button>
                </form>{/if}

            {if $item.flag_stallo == 'S'}
                <form method="POST" action="form-stallo-interesse.php">
                    <input type="hidden" name="pelosetto" value="{$item['code']}" />
                    <button type="submit" class="block mybutton">Ospitami in stallo</button>
                </form>{/if}
            {/if}
            {if $utente->publisher()}
            <form method="GET" action="form-pelosetto.php">
                <input type="hidden" name="pelosetto" value="{$item['code']}" />
                <button type="submit" class="block blue">Modifica</button>
            </form>
            {/if}
            {if $utente->administrator()}
            <form method="GET" action="stampa-scheda-pelosetto.php">
                <input type="hidden" name="pelosetto" value="{$item['code']}" />
                <button type="submit" class="block green">Stampa</button>
            </form>
            {/if}
            
            <div class="fb-like" 
                data-href="{$item['url']}" 
                data-layout="button_count" 
                data-action="like" 
                data-show-faces="false" 
                data-share="true"></div>
        </div>
    </div>    

    {/if}


{foreachelse}
    Nessun pelosetto presente.
{/foreach}

 
{include file="page-footer.tpl"}