{include file="page-header.tpl"}

<link rel="stylesheet" href="css/flexslider.css" type="text/css" media="screen" />
<script defer src="js/plugins/jquery.flexslider-min.js"></script>

<!-- Lastly, call the galleryView() function on your unordered list(s) -->
<script type="text/javascript">
	$(function(){
		$('.flexslider').flexslider({
            animation: "slide",
            animationLoop: true,
            itemWidth: 210,
            itemMargin: 5,    
            minItems: 1,
            maxItems: 2,
            pausePlay: true,
            start: function(slider){
                $('body').removeClass('loading');
            }
        });
    });
</script>

<div class="equalize row">
        <form method="GET" action="/indietro.php" style="float:left">
            <button type="submit" class="mybutton">Indietro</button>
        </form>
        <form method="GET" action="form-iniziativa-partecipa.php" style="float:left">
            <input type="hidden" name="iniziativa" value="{$iniziativa.code}" />
            <button type="submit" class="mybutton">Partecipa</button>
        </form>
    {*if $utente->administrator()}
    <div class="one fifths">
        <form method="GET" action="form-iniziativa.php" style="float:left">
            <input type="hidden" name="iniziativa" value="{$iniziativa.code}" />
            <button type="submit" class="mybutton blue">Modifica</button>
        </form>
    </div>
    {/if*}
    {if $utente->publisher()}
    <form method="GET" action="form-notizia.php" style="float:left">
        <input type="hidden" name="padre" value="{$iniziativa['code']}" />
        <button class="blue" type="submit">Nuova notizia</button>
    </form>
    {/if}
</div>

<br>
<h1 class="titolo_pagina">{$iniziativa.titolo}</h1>

<div class="padded myborder myround" style="background:#fffaec">
    <div class="pull-right pull-none-small-tablet gap-right no-gap-small-tablet padded align-center">{if $iniziativa.immagine|count_characters}
        <img src='{$iniziativa.immagine}' class='myround' style='max-width:300px'>{/if}
    </div>
    
    <p class="asphalt quicksand padded">
    dal <b>{$iniziativa.data_inizio|date_format:"%d/%m/%Y"}</b> al <b>{$iniziativa.data_fine|date_format:"%d/%m/%Y"}</b><br>
    a <b>{$iniziativa.comune} - {$iniziativa.regione}</b>
    {if $iniziativa.localita|count_characters > 0}<br>{$iniziativa.localita}{/if}</p>
    
    <p class="pad-left">
    {if $iniziativa.costo_unitario|count_characters==0}
    {elseif $iniziativa.costo_unitario==0}
    Costo unitario: <b>offerta libera</b><br />
    {else}
    Costo unitario: <b>&euro; {$iniziativa.costo_unitario|money_format}</b><br />
    {if $iniziativa.costo_supplementare_descrizione|count_characters}{$iniziativa.costo_supplementare_descrizione}: <b>&euro; {$iniziativa.costo_supplementare|money_format}</b>{/if}
    {/if}
    </p>
    
    <div class="fb-like pad-left"
        data-href="{$iniziativa.url}" 
        data-layout="button_count" 
        data-action="like" 
        data-show-faces="false" 
        data-share="true">
    </div>
    
    <p class="padded justify">{$iniziativa.testo}</p>
    <p class="padded justify">{if $iniziativa.url_www|count_characters}E' possibile avere maggiori informazioni sul sito dell'iniziativa:<br />
        <a href='{$iniziativa.url_www}' target='_blanc'>{$iniziativa.url_www}</a>{/if}</p>
</div>

<div class="equalize row">
    <div class="one fifth padded" style="border-right: 2px dotted #E0D1C2;">
        <h3>Partecipanti</h3>
        
        {if $utente->logged()}
            {foreach item=item key=key from=$partecipanti}

                {cycle assign="bg" values="#E0D1C2,#F5F0EB"}

                <div class="padded myborder myround" style="background:{$bg}">
                    <div>{$item.nome} {$item.cognome}</div>
                    <div class="asphalt" style="font-size:0.8em;">{$item.comune}</div>
                    {if $iniziativa.costo_unitario|count_characters==0}
                    {elseif $iniziativa.costo_unitario==0}
                    <div class="" style="font-size:0.8em; color:#777"><b>&euro; {$item.importo|money_format} {if $item.versamento=='M'}mensili{/if}</b></div>
                    {else}
                    <div class="" style="font-size:0.8em; color:#777">quantit&agrave;: <b>{$item.quantita}</b></div>
                    {/if}
                </div>
            {foreachelse}
            <p style='padding:5px;'>Attualmente nessun partecipante. Potresti essere il primo!</p>
            {/foreach}
        {else}
        E' necessario essere un amico di Giulita...
        {/if}
    </div>

    
    <div class="four fifths padded">
        <h3>Ultime notizie</h3>
        
        {foreach item=item key=key from=$notizie}

            {cycle assign="bg" values="#E0D1C2,#F5F0EB"}

            <div class="padded myborder myround" style="background:{$bg}">
                <h3>{$item.titolo}</h3>
                <p>{$item.data|date_format:"%d/%m/%Y"}</p>
                
                <div class='flexslider'><ul class='slides'>
                {section loop=5 start=1 name=f}
                    {assign var="foto" value="immagine"|cat:$smarty.section.f.index}
                    {if $item.$foto|count_characters > 0}
                    <li class='noicon' ><img src='{$item.$foto}' alt='' /></li>
                    {/if}
                {/section}
                </ul></div>
                
                <p>{$item.testo}</p>
                <p class="padded justify">{if $item.url_www|count_characters}E' possibile avere maggiori informazioni all'indirizzo web:<br />
                    <a href='{$item.url_www}' target='_blanc'>{$item.url_www}</a>{/if}
                </p>
                
                <div class="fb-like" 
                    data-href="/page-notizia.php?notizia={$item.code}" 
                    data-layout="button_count" 
                    data-action="like" 
                    data-show-faces="false" 
                    data-share="true"></div>
                
                {if $utente->publisher()}
                <form method="GET" action="form-notizia.php">
                    <input type="hidden" name="notizia" value="{$item.code}" />
                    <button class="blue" type="submit">Modifica</button>
                </form>
                {/if}
            </div>
        {foreachelse}
        <p style='padding:5px;'>Nessuna notizia fin ora.</p>
        {/foreach}
    </div>
</div>
{include file="page-footer.tpl"}