{include file="page-header.tpl"}

{if $utente->publisher()}
<form method="GET" action="form-iniziativa.php">
    <button type="submit" class="mybutton">Nuova iniziativa</button>
</form><br>
{/if}

<h1 class="titolo_pagina">Iniziative</h1>

<div class="nopad">
    {foreach item=item key=key from=$iniziative}

        {cycle assign="bg" values="#E0D1C2,#F5F0EB"}

        <div id="{$item.code}" class="padded myborder myround" style="background:{$bg}">
            
            <form method="GET" action="page-iniziativa.php" style="float:left">
                <input type="hidden" name="iniziativa" value="{$item['code']}" />
                <button type="submit" class="mybutton">Dettagli</button>
            </form>
            
            <form method="GET" action="form-iniziativa-partecipa.php" style="float:left">
                <input type="hidden" name="iniziativa" value="{$item.code}" />
                <button type="submit" class="mybutton">Partecipa</button>
            </form>
        
            {if $utente->publisher()}
            <form method="GET" action="form-iniziativa.php" style="float:left">
                <input type="hidden" name="iniziativa" value="{$item['code']}" />
                <button type="submit" class="mybutton blue">Modifica</button>
            </form>
            {/if}
        
            <h1 class="quicksand bold" style="clear:both;">{$item.titolo}</h1>
            <div class="pull-right pull-none-small-tablet gap-right no-gap-small-tablet align-center">{if $item.immagine|count_characters}
                <img src='{$item.immagine}' class='myround' style='max-width:300px'>{/if}
            </div>
            
            <p class="asphalt quicksand padded">
            dal <b>{$item.data_inizio|date_format:"%d/%m/%Y"}</b> al <b>{$item.data_fine|date_format:"%d/%m/%Y"}</b><br>
            a <b>{$item.comune} - {$item.regione}</b>
            {if $item.localita|count_characters > 0}<br>{$item.localita}{/if}</p>
            
            <p class="pad-left">
            {if $item.costo_unitario|count_characters==0}
            {elseif $item.costo_unitario==0}
            Costo unitario: <b>offerta libera</b><br />
            {else}
            Costo unitario: <b>&euro; {$item.costo_unitario|money_format}</b><br />
            {if $item.costo_supplementare_descrizione|count_characters}{$item.costo_supplementare_descrizione}: <b>&euro; {$item.costo_supplementare|money_format}</b>{/if}
            {/if}
            </p>
            
            <div class="fb-like pad-left"
                data-href="/page-iniziativa.php?iniziativa={$item['code']}" 
                data-layout="button_count" 
                data-action="like" 
                data-show-faces="false" 
                data-share="true">
            </div>
            
            <p class="padded justify">{$item.testo}</p>
            <p class="padded justify">{if $item.url_www|count_characters}E' possibile avere maggiori informazioni sul sito dell'iniziativa:<br />
                <a href='{$item.url_www}' target='_blanc'>{$item.url_www}</a>{/if}</p>
        </div>
    {foreachelse}
    <p style='padding:5px;'>Nessuna iniziativa attualmente in corso.</p>
    {/foreach}
    
</div>

{include file="page-footer.tpl"}