{include file="header.tpl"}
{include file="menu.tpl"}

<style>
#info-container {
    height: 570px;
    width: 100%;
    text-align: center;
    padding-top: 45px;
    padding-bottom: 63px;
    font-weight: 300; 
    font-size: 25px;
    color: #585c5d;
}
.bg-gradient {
    background: white url('images/bg.png') repeat-x top left; 
}
.btn, .btn:hover {
    background: #57b3f0;
    background-image: -webkit-linear-gradient(top, #57b3f0, #459bd1);
    background-image: -moz-linear-gradient(top, #57b3f0, #459bd1);
    background-image: -ms-linear-gradient(top, #57b3f0, #459bd1);
    background-image: -o-linear-gradient(top, #57b3f0, #459bd1);
    background-image: linear-gradient(to bottom, #57b3f0, #459bd1);
    -webkit-border-radius: 28;
    -moz-border-radius: 28;
    border-radius: 28px;
    color: #ffffff;
    font-family: 'Raleway', sans-serif !important;
    font-size: 20px;
    font-weight: 400; 
    padding: 10px 20px 10px 20px;
    text-decoration: none;
    cursor: pointer;
}
/*
.btn:hover {
  background: #3cb0fd;
  background-image: -webkit-linear-gradient(top, #3cb0fd, #3498db);
  background-image: -moz-linear-gradient(top, #3cb0fd, #3498db);
  background-image: -ms-linear-gradient(top, #3cb0fd, #3498db);
  background-image: -o-linear-gradient(top, #3cb0fd, #3498db);
  background-image: linear-gradient(to bottom, #3cb0fd, #3498db);
  text-decoration: none;
}*/
#title-aree-intervento {
    font-weight: 100; 
    font-size: 46px;
    color: #585c5d;
    padding: 40px;
}
.immagine {
    height: 385px;
    text-align: center;
    cursor: pointer;
}
#ambiente {
    background-image: url('images/ambiente.png');
    background-repeat: no-repeat;
    background-attachment: scroll;
    background-position: center center;
    background-size: cover;
    background-color: rgba(0, 0, 0, 0.5);
}
#alimentare {
    background-image: url('images/alimentare.png');
    background-repeat: no-repeat;
    background-attachment: local;
    background-position: center center;
    background-size: cover;
}
#pesi {
    background-image: url('images/pesi.png');
    background-repeat: no-repeat;
    background-attachment: local;
    background-position: center center;
    background-size: cover;
}
#volumi {
    background-image: url('images/volumi.png');
    background-repeat: no-repeat;
    background-attachment: local;
    background-position: center center;
    background-size: cover;
}
    
.layer-oscuro {
    background: rgba(0, 0, 0, 0.7);
    position: absolute;
    width: 100%;
    height: 100%;
    border: 0px solid #369;
    top: 0px;
    z-index: 1;
}
.layer-testo {
    position: absolute;
    z-index: 99;
    border: 0px solid #F33;
    width: 100%;
}
    .layer-testo span {
        color: white;
        font-size: 74px;
        font-weight: 300;
        
        line-height: 385px; 
        vertical-align: middle; 
    }
.service {
    font-size: 18px;
    color: #585c5d;
}
    .service p, .service li {
        margin-left: 20%;
        margin-right: 20%;
    }
    .service h3 {
        margin-top: 10px;
        text-align: center;
        font-weight: 300;
    }
</style>

<script type="text/javascript">
var slider_service, slider_vertical;
$(document).ready(function() {

    $( ".immagine" )
        .mouseleave(function() {
            console.log("mouseleave");
            $( this ).children( '.layer-oscuro' ).css({
                "background" : "rgba(0, 0, 0, 0.7)"});
        })
        .mouseenter(function() {
            console.log("mouseenter");
            $( this ).children( '.layer-oscuro' ).css({
                "background" : "rgba(0, 0, 0, 0.0)"});
        });
    
    $('#btn-servizi').click(function() {
        slider_vertical.goToNextSlide();
    });

    slider_service = $('#slider-service').bxSlider({
        minSlides: 1,
        maxSlides: 1,
        slideMargin: 0,
        pager: false
    });
    slider_vertical = $('#slider-vertical').bxSlider({
        mode: 'vertical',
        minSlides: 1,
        maxSlides: 1,
        slideMargin: 0,
        pager: false,
        controls: false
    });
    
    $( "#ambiente" ).click(function(){
        window.location = 'ambiente.php';
    });
    
    $( "#alimentare" ).click(function(){
        window.location = 'alimentare.php';
    });
    
    $( "#pesi" ).click(function(){
        window.location = 'pesi.php';
    });
    
    $( "#volumi" ).click(function(){
        window.location = 'volumi.php';
    });
    
});
</script>

<div>
    <div id="slider-vertical">
        <div class="slide">
            <div id="info-container" class="align-center bg-gradient">
                <div><img src="images/logo.png" /></div>
                <div class="triple-padded"><img src="images/separazione.png" /></div>
                <div>
                Laboratorio di analisi Microbiologiche, 
                Chimiche, Consulenza HACPP e Metrologia legale{*<br>
                Certificazione UNI EN ISO 9001:2008 N. IT-48715*}
                </div>
                <div style="margin: 40px;">
                    <span class="btn" id="btn-servizi">I nostri servizi</span>
                </div>
            </div>
        </div>
        
        <div class="slide">
    
            
            
            <div id="slider-service">
                <div class="slide">
                <div id="service-haccp" class="service">
                    <div id="service-container" class="align-center bg-gradient">
                        <div class="triple-padded"><img src="images/simbolo1.png" /></div>
                    </div>   
                    <h3>Consulenza HACCP</h3>
                    <p>Le attivit&agrave; che operano nel settore alimentare, a qualsiasi livello, devono monitorare i propri processi produttivi 
                    realizzando un sistema di autocontrollo HACCP (Hazard Analysis and Critical Control Points) 
                    come previsto dal regolamento CE 852/04 al fine di garantire il rispetto delle norme igieniche e la salute del consumatore.<br>
                    Il laboratorio possiede il personale e le competenze tecniche necessarie per:<br>
                    <ul>
                        <li>realizzare la stesura del manuale HACCP</li>
                        <li>effettuare sopralluoghi per nuove attivit&agrave; o variazioni delle stesse;</li>
                        <li>formazione del personale;</li>
                        <li>analisi di alimenti, acque e tamponi superficiali per monitorare i punti critici e valutare la conformit&agrave; alle disposizioni igienico sanitarie richieste dalla normativa. </li>
                    </ul>
                    </p>
                </div>
                </div>
                <div class="slide">
                <div id="service-microbiologia" class="service">
                    <div id="service-container" class="align-center bg-gradient">
                        <div class="triple-padded"><img src="images/simbolo2.png" /></div>
                    </div>   
                    <h3>Analisi Microbiologiche</h3>
                    <p>L'analisi microbiologica ricade in vari settori come quello alimentare e ambientale. &Egrave; noto il ruolo svolto dai microrganismi nella produzione, 
                    alterazione e conservazione degli alimenti, nella potabilit&agrave; delle acque, e in generale nelle malattie microbiche trasmesse attraverso varie matrici con cui siamo in contatto.<br>
                    Il laboratorio MicroLab grazie a personale qualificato &egrave; in grado di svolgere attivit&agrave; di campionamento e successiva analisi in laboratorio secondo metodiche standard.
                    </p>
                </div>
                </div>
                <div class="slide">
                <div id="service-chimica" class="service">
                    <div id="service-container" class="align-center bg-gradient">
                        <div class="triple-padded"><img src="images/simbolo3.png" /></div>
                    </div>   
                    <h3>Analisi Chimiche</h3>
                    <p>Le analisi chimiche forniscono il profilo chimico-fisico di un dato campione analitico e determinano quantitativamente i componenti in esso contenuti.<br>
                    Per svolgere al meglio tale compito, sempre pi&ugrave; importante se pensiamo alla maggiore sensibilit&agrave; dell'opinione pubblica e delle istituzioni 
                    all'inquinamento delle acque e del suolo e alle problematiche ambientali in genere, abbiamo dotato il laboratorio di macchinari di ultima generazione che ci consentono 
                    tecniche di analisi chimiche strumentali innovative, precise e rapide.
                    </p>
                </div>
                </div>
                <div class="slide">
                <div id="service-metrologia" class="service">
                    <div id="service-container" class="align-center bg-gradient">
                        <div class="triple-padded"><img src="images/simbolo2.png" /></div>
                    </div>   
                    <h3>Metrologia legale</h3>
                    <p>La metrologia legale &egrave; il servizio che permette di garantire l'affidabilit&agrave; nel tempo di determinati strumenti di misura; 
                    tale servizio pu&ograve; essere svolto dalle Camere di Commercio territoriali o da Laboratori privati riconosciuti.<br>
                    <br>
                    Il laboratorio MicroLab &egrave; in grado di compiere i seguenti servizi:<br>
                    <ul>
                        <li>verifica periodica bilance;</li>
                        <li>verifica periodica pompe di carburante;</li>
                    </ul>
                    </p>
                    
                    <p>Per maggiori informazioni consultare le sezioni "PESI" o "VOLUMI", oppure contattaci.</p>
                </div>
                </div>
            </div>
        </div>
</div>

<div id="title-aree-intervento" class="align-center">
    <span>Aree di intervento</span>
</div>

<div class="equalize row">
    <div class="equalize row">
        <div class="one half" style="border: 0px solid red;">
            <div id="ambiente" class="immagine" style="border: 0px solid red;">
                <div class="layer-oscuro"></div>
                <div class="layer-testo"><span>AMBIENTE</span></div>
            </div>
        </div>
        <div class="one half align-left" style="border: 0px solid red;">
            <div id="alimentare" class="immagine">
                <div class="layer-oscuro"></div>
                <div class="layer-testo"><span>ALIMENTARE</span></div>
            </div>
        </div>
    </div>
</div>

<div class="equalize row">
    <div class="equalize row">
        <div class="one half align-right">
            <div id="pesi" class="immagine">
                <div class="layer-oscuro"></div>
                <div class="layer-testo"><span>PESI</span></div>
            </div>
        </div>
        <div class="one half align-left">
            <div id="volumi" class="immagine">
                <div class="layer-oscuro"></div>
                <div class="layer-testo"><span>VOLUMI</span></div>
            </div>
        </div>
    </div>
</div>

{include file="page-footer.tpl"}