<?php
/*
 * Classe che gestisce il planning.
 */
class PlannerCardiologia {
    
    public function impostaGuardia($data, $tipo_turno, $code_giornata, $trovato=false) {
        GLOBAL $db;
        
        $obj_planning = Planning::getInstance();
        $obj_calendario = Calendario::getInstance();

        # Vediamo se un turno è già stabilito
        if ($obj_planning->getGiornataGuardie($data, $tipo_turno) !== false) {
            DEBUG("Giornata {$data}, {$tipo_turno} gia' impostata!");
            $giornata = $obj_planning->getGiornataGuardie($data, $tipo_turno);
            return $giornata["code_anagrafica"];
        }
        
        $severita = array('BIANCO', 'GIALLO', 'ARANCIO', 'ROSSO');
        
        foreach ($severita as $s) {
            # Cerchiamo un candidato al turno
            if ($trovato === false)
                $trovato = $obj_planning->trova_candidato_guardia($data, $tipo_turno, $code_giornata, $s);
            
            if ($trovato === false) {
                DEBUG('NESSUN CANDIDATO TROVATO!!!');
                $obj_planning->logGuardieVerificaCandidati($data, $tipo_turno, $code_giornata, null, "N", "NESSUN CANDIDATO TROVATO!!!", $s);
            }
            else {
                $obj_planning->logGuardieVerificaCandidati($data, $tipo_turno, $code_giornata, $trovato, "S", "TROVATO {$trovato}", $s);
                break;
            }
        }
        if ($trovato === false)
            return false;
            
        $code_anagrafica = $trovato;
        DEBUG("Candidato al {$tipo_turno} del {$data}: ".$code_anagrafica);
        #$obj_planning->insertGuardia($data, $tipo_turno, $code_giornata, $code_anagrafica);
        
        
        # Se NOTTE, metto il RIPOSO obbligatorio
        if ($tipo_turno == 'CARDIO_NOTTE') {
            $legante = md5(microtime());
            # dico che il candidato è di Guardia nel piano di lavoro
            $obj_planning->insertTurno($data, $tipo_turno/*'G'*/, $code_giornata, $code_anagrafica, $legante);
            $data_successiva = $obj_calendario->getData($data, +1);
            $sql = "DELETE FROM turni
                    WHERE data='{$data_successiva}' AND code_anagrafica='{$code_anagrafica}' AND stato='B'";
            $db->Esegui($sql); #echo $sql;
            $obj_planning->insertTurno($data_successiva, 'R', $code_giornata, $code_anagrafica, $legante);
        }
        else {
            # dico che il candidato è di Guardia nel piano di lavoro
            $obj_planning->insertTurno($data, $tipo_turno/*'G'*/, $code_giornata, $code_anagrafica);
        }
        return $code_anagrafica;
    }
    
    /*public function impostaTurno($data, $tipo_turno, $code_giornata, $code_anagrafica, $forza=false) {
        $obj_planning = Planning::getInstance();
        
        # Vediamo se un turno è già stabilito
        if ($forza == false && $obj_planning->getGiornataGuardie($data, $tipo_turno) !== false) {
            return $obj_planning->getGiornataGuardie($data, $tipo_turno);
        }
        
        # dico che il candidato è di Guardia nel piano di lavoro
        $obj_planning->insertTurno($data, 'G', $code_giornata, $code_anagrafica);
        
        # Se NOTTE, metto il RIPOSO obbligatorio
        if ($tipo_turno == 'CARDIO_NOTTE')
            $obj_planning->insertTurno($data, 'R', '', $code_anagrafica);
            
        
    }*/
    
    public function impostaDestinazionePianoLavoro($data, $tipo_destinazione, $code_destinazione, $pool, $severita, $trovato=false) {
        $obj_planning = Planning::getInstance();
        $obj_calendario = Calendario::getInstance();
        
        # Vediamo se un turno è già stabilito
        $giornata = $obj_planning->getGiornataPianoLavoro($data, $code_destinazione);
        if ($giornata !== false) {
            DEBUG("Giornata {$data}, {$code_destinazione} gia' impostata!");
            return $giornata["code_anagrafica"];
        }

        # Cerchiamo un candidato al turno
        if ($trovato === false)
            $trovato = $obj_planning->trova_candidato_destinazione($data, $tipo_destinazione, $code_destinazione, $pool, $severita);
        else {
            $giornata = $obj_planning->getGiornataTurni($trovato, $data);
            DEBUG("impostaDestinazionePianoLavoro() getGiornataTurni() = ".$giornata);
            if ($giornata !== false) {
                DEBUG("Ritorno: ".$trovato);
                return $trovato;
            }
        }
        
        /*if ($trovato !== false) {
            
        }
        else {
            DEBUG("{$severita}: NESSUN CANDIDATO TROVATO!!!");
            $obj_planning->logGuardieVerificaCandidati($data, $tipo_destinazione, $code_destinazione, null, "N", "NESSUN CANDIDATO TROVATO!!!", $severita);
        }*/
        
        if ($trovato === false)
            return false;
            
        $code_anagrafica = $trovato;
        DEBUG("Candidato {$code_destinazione} del {$data}: ".$code_anagrafica);
        $obj_planning->logGuardieVerificaCandidati($data, $code_destinazione, $tipo_destinazione, $trovato, "S", "TROVATO {$trovato}", $severita);
        
        #$obj_planning->insertDestinazione($data, $tipo_destinazione, $code_destinazione, $code_anagrafica);
        
        # dico che il candidato è nel piano di lavoro
        $obj_planning->insertTurno($data, /*'L'*/$code_destinazione, 'FERIALE', $code_anagrafica);
        
        return $code_anagrafica;
    }
    
    
    public function impostaFerie($code_anagrafica, $data_inizio, $data_fine, $tipo_ferie='F') {
        GLOBAL $db;
        
        $sql = "INSERT INTO ferie(code_anagrafica, data_inizio, data_fine, tipo_ferie, stato)
                VALUES('{$code_anagrafica}', '{$data_inizio}', '{$data_fine}', '{$tipo_ferie}', 'B')";
        $res = $db->Esegui($sql);

        $datetime1 = date_create($data_inizio);
        $datetime2 = date_create($data_fine);
        $interval = date_diff($datetime1, $datetime2);
        $giorni = intval($interval->format('%a')) + 1;
        
        $obj_calendario = Calendario::getInstance();
        $obj_calendario->setDataInizio($data_inizio);
        $obj_calendario->setGiorni($giorni);
        $obj_calendario->init();

        $obj_planning = Planning::getInstance();
        $obj_planning->setDB($db);
        $obj_planning->setStato('B');
        
        $calendario = $obj_calendario->getCalendario();
        
        foreach ($calendario as $giorno) {
            $data = $giorno['data'];
            if ($giorno['festa'] == 0)
                $obj_planning->insertTurno($data, $tipo_ferie, 'FERIALE', $code_anagrafica);
            else {
                if ($giorno['prefestivita']==0 && $giorno['festivita']==0)
                    $code_giornata = 'FESTIVO';
                else
                    $code_giornata = 'FESTIVITA';
                    
                $obj_planning->insertTurno($data, $tipo_ferie/*'I'*/, $code_giornata, $code_anagrafica);
            }
        }
    
    }
}

