<?php
/*
 * Classe che gestisce il planning.
 */
class Planning {
    private $guardie;
    private $turni;
    private $piano_lavoro;
    private $avvisi;
    private $init;
    private $data_inizio;
    private $data_fine;
    private $giorni;
    private $tipi_turno_guardie;
    private $m_db;
    private $stato;

    #*****************************************************************************
    # Parte STATICA
    #*****************************************************************************
    private static $instance = null;
    protected static $session_name = "OBJ-PLANNING";

    #------------------------------------------
    public static function getInstance() {
        if (self::$instance == null) {
            if (isset($_SESSION[self::$session_name]))
                self::$instance = unserialize($_SESSION[self::$session_name]);
            else {
                $c = __CLASS__;
                self::$instance = new $c;
            }
        }
        return self::$instance;
    }

    #------------------------------------------
    public static function save() {
        $_SESSION[self::$session_name] = serialize(self::$instance);
    }

    #------------------------------------------
    public static function erase() {
        if (isset($_SESSION[self::$session_name])) {
                self::$instance = null;
                unset($_SESSION[self::$session_name]);
                #self::getInstance();
        }
    }

    #*****************************************************************************
    # Parte DINAMICA
    #*****************************************************************************

    #-----------------------------------------------------------------------------
    private function __construct() {
        $this->guardie = array();
        $this->turni = array();
        $this->avvisi = array();
        $this->piano_lavoro = array();
        $this->giorni = 0;
        $this->init = false;
    }

    #-----------------------------------------------------------------------------
    # INIT
    #-----------------------------------------------------------------------------
    public function init() {
        GLOBAL $tipi_turno;
        
        $t = strtotime($this->data_inizio);
        $arr_t = getdate($t);
        $giorno_zero = intval($arr_t['mday']);
        $mese_zero = $arr_t['mon'];
        $anno_zero = $arr_t['year'];
        
        for ($i=0; $i<$this->giorni; $i++) {
            $t = mktime(0, 0, 0, $mese_zero, $giorno_zero + $i, $anno_zero);
            
            $data = date("Y-m-d", $t);
			
            foreach ($this->tipi_turno_guardie as $key => $item) {
                $turno = array(
                    'code_anagrafica' => '',
                    'data' => $data,
                    'tipo_turno' => $key,
                    'stato' => '',
                    'tipo_giornata' => ''
                );
                $this->guardie[$data][$key] = $turno;
            }
	} 
    }

    #-----------------------------------------------------------------------------
    # GET
    #-----------------------------------------------------------------------------
    public function getGuardie() {
        return $this->guardie;
    }
    #-----------------------------------------------------------------------------
    public function getPianoLavoro() {
        return $this->piano_lavoro;
    }
    #-----------------------------------------------------------------------------
    public function getTurni() {
        return $this->turni;
    }
    #-----------------------------------------------------------------------------
    public function getAvvisi() {
        return $this->avvisi;
    }
    #-----------------------------------------------------------------------------
    public function getGiornataTurni($code_anagrafica, $data, $tipo_turno=null) {
        if (is_null($tipo_turno)) {
            if (isset($this->turni[$code_anagrafica][$data]))
                return $this->turni[$code_anagrafica][$data];
        }
        else {
            if (isset($this->turni[$code_anagrafica][$data][$tipo_turno]))
                return $this->turni[$code_anagrafica][$data][$tipo_turno];
        }
        return false;
    }
    public function getGiornataGuardie($data, $tipo_turno=null) {
        if (is_null($tipo_turno)) {
            if (isset($this->guardie[$data]))
                return $this->guardie[$data];
        }
        else {
            if (isset($this->guardie[$data][$tipo_turno]))
                return $this->guardie[$data][$tipo_turno];
        }
        return false;
    }
    #-----------------------------------------------------------------------------
    public function getGiornataPianoLavoro($data, $code_destinazione=null) {
        if (is_null($code_destinazione)) {
            if (isset($this->piano_lavoro[$data]))
                return $this->piano_lavoro[$data];
        }
        else {
            if (isset($this->piano_lavoro[$data][$code_destinazione]))
                return $this->piano_lavoro[$data][$code_destinazione];
        }
        return false;
    }

    #-----------------------------------------------------------------------------
    # SET
    #-----------------------------------------------------------------------------
    
    public function setDB($db) {
        $this->m_db = $db;
    }
    public function setStato($stato) {
        $this->stato = $stato;
    }
    public function setGiorni($giorni) {
        $this->giorni = $giorni;
    }
    public function setDataInizio($data) {
        $this->data_inizio = $data;
    }
    public function setDataFine($data) {
        $this->data_fine = $data;
    }
    public function setTipiTurnoGuardie($arrayTipi) {
        $this->tipi_turno_guardie = $arrayTipi;
    }
    
    #-----------------------------------------------------------------------------
    # LOAD 
    #-----------------------------------------------------------------------------
    public function load() {
        $this->loadGuardie();
        $this->loadTurni();
        $this->loadAvvisi();
        $this->loadPianoLavoro();
    }

    #-----------------------------------------------------------------------------
    # LOAD GUARDIE
    #-----------------------------------------------------------------------------
    public function loadGuardie() {
        $data_inizio = $this->data_inizio;
        $data_fine = $this->data_fine;
        $stato = $this->stato;

        $sql = "SELECT code_anagrafica, data, tipo_turno, stato, tipo_giornata
                FROM guardie
                WHERE data BETWEEN date '{$data_inizio}' AND date '{$data_fine}' 
                AND stato IN('{$stato}', 'P')
                ORDER BY data, tipo_turno, tipo_giornata";
        $rs = $this->m_db->Esegui($sql);
        $guardie = array();

        if ($rs) {
            while (!$rs->EOF) {
                $code_anagrafica = $rs->Fields("code_anagrafica");
                $data = $rs->Fields("data");
                $tipo_turno = $rs->Fields("tipo_turno");
                $stato = $rs->Fields("stato");
                $tipo_giornata = $rs->Fields("tipo_giornata");

                $guardie[$data][$tipo_turno] = $rs->FetchRow();
            }
            $this->guardie = $guardie;
        }
        else
            DEBUG($this->m_db->ErrorMsg());
    }

    #-----------------------------------------------------------------------------
    # LOAD TURNI
    #-----------------------------------------------------------------------------
    public function loadTurni() {
        $data_inizio = $this->data_inizio;
        $data_fine = $this->data_fine;
        
        # Carichiamo PRIMA i turni P che vanno SEMPRE presi
        $sql = "SELECT code, 
                code_anagrafica, data, tipo_turno, stato, tipo_giornata
                FROM turni
                WHERE data BETWEEN date '{$data_inizio}' AND date '{$data_fine}' AND stato='P'
                ORDER BY data, tipo_turno, tipo_giornata";
        $rs = $this->m_db->Esegui($sql);

        $turni = array();

        if ($rs) {
            while (!$rs->EOF) {
                $code_anagrafica = $rs->Fields("code_anagrafica");
                $data = $rs->Fields("data");
                $tipo_turno = $rs->Fields("tipo_turno");
                $stato = $rs->Fields("stato");
                $tipo_giornata = $rs->Fields("tipo_giornata");

                $turni[$code_anagrafica][$data][$tipo_turno] = $rs->FetchRow();
                #$rs->MoveNext();
            }
        }
        else
            DEBUG($this->m_db->ErrorMsg());
            
       
        # Carichiamo POI i turni 'stato corrente' se non P
        if ($this->stato != 'P') {  
            $sql = "SELECT code, 
                    code_anagrafica, data, tipo_turno, stato, tipo_giornata
                    FROM turni
                    WHERE data BETWEEN date '{$data_inizio}' AND date '{$data_fine}' AND stato='{$this->stato}'
                    AND id NOT IN (
                        SELECT id
                        FROM turni
                        WHERE data BETWEEN date '{$data_inizio}' AND date '{$data_fine}' AND stato='P'
                    )
                    ORDER BY data, tipo_turno, tipo_giornata";
            $rs = $this->m_db->Esegui($sql);

            if ($rs) {
                while (!$rs->EOF) {
                    $code_anagrafica = $rs->Fields("code_anagrafica");
                    $data = $rs->Fields("data");
                    $tipo_turno = $rs->Fields("tipo_turno");
                    $stato = $rs->Fields("stato");
                    $tipo_giornata = $rs->Fields("tipo_giornata");

                    $turni[$code_anagrafica][$data][$tipo_turno] = $rs->FetchRow();
                    #$rs->MoveNext();
                }
            }
            else
                DEBUG($this->m_db->ErrorMsg());
        }
        
        $this->turni = $turni;
    }

    #-----------------------------------------------------------------------------
    # LOAD PIANO LAVORO
    #-----------------------------------------------------------------------------
    public function loadPianoLavoro() {
        $data_inizio = $this->data_inizio;
        $data_fine = $this->data_fine;
        $stato = $this->stato;

        $sql = "SELECT *
                FROM pianolavoro
                WHERE data BETWEEN date '{$data_inizio}' AND date '{$data_fine}' 
                and stato IN ('{$stato}', 'P')
                ORDER BY data, code_destinazione";
        $rs = $this->m_db->Esegui($sql);

        
        if ($rs) {
            while (!$rs->EOF) {
                $code_anagrafica = $rs->Fields("code_anagrafica");
                $data = $rs->Fields("data");
                $tipo_destinazione = $rs->Fields("tipo_destinazione");
                $stato = $rs->Fields("stato");
                $code_destinazione = $rs->Fields("code_destinazione");
                
                $piano = array(
                    'code_anagrafica' => $code_anagrafica,
                    'data' => $data,
                    'tipo_destinazione' => $tipo_destinazione,
                    'stato' => $stato,
                    'code_destinazione' => $code_destinazione
                );
                $this->piano_lavoro[$data][$code_destinazione] = $piano;
                $rs->MoveNext();
            }
        }
        else
            DEBUG($this->m_db->ErrorMsg());
    }
    
    #-----------------------------------------------------------------------------
    # LOAD AVVISI
    #-----------------------------------------------------------------------------
    public function loadAvvisi() {
        $data_inizio = $this->data_inizio;
        $data_fine = $this->data_fine;
        $stato = $this->stato;

        $sql = "SELECT *
                FROM log_guardie_verifiche
                WHERE stato IN ('{$stato}', 'P')
                AND data BETWEEN date '{$data_inizio}' AND date '{$data_fine}' 
                ORDER BY data";
        $rs = $this->m_db->Esegui($sql);

        $avvisi = array();

        if ($rs) {
            while (!$rs->EOF) {
                $data = $rs->Fields("data");
                $severita = $rs->Fields("severita");
                $tipo_turno = $rs->Fields("tipo_turno");

                $avvisi[$data][$tipo_turno][$severita] = $rs->FetchRow();
                #$rs->MoveNext();
            }
            $this->avvisi = $avvisi;
        }
        else
            DEBUG($this->m_db->ErrorMsg());
    }
    
    #-----------------------------------------------------------------------------
    # LOG GUARDIE
    #-----------------------------------------------------------------------------
    private function logGuardie($data, $tipo_turno, $code_giornata, $lista, $severita='BIANCO') {
        $lista = json_encode($lista);
        $sql = "INSERT INTO log_guardie(tipo_turno, code_giornata, data, lista, severita)
                VALUES ('{$tipo_turno}', '{$code_giornata}', '{$data}', '{$lista}', '{$severita}')";
        return $this->m_db->Esegui($sql);
    }

    #-----------------------------------------------------------------------------
    # LOG GUARDIE - VERIFICHE CANDIDATI
    #-----------------------------------------------------------------------------
    public function logGuardieVerificaCandidati($data, $tipo_turno, $code_giornata, $code_anagrafica, $ok, $esito, $severita='BIANCO') {
        $esito = str_replace("'", "''", $esito);
        $sql = "INSERT INTO log_guardie_verifiche(tipo_turno, code_giornata, code_anagrafica, data, ok, esito, severita)
                VALUES ('{$tipo_turno}', '{$code_giornata}', '{$code_anagrafica}', '{$data}', '{$ok}', '{$esito}', '{$severita}')";
        return $this->m_db->Esegui($sql);
    }

    
    
    #-----------------------------------------------------------------------------
    # TROVA CANDIDATURA GUARDIA
    #-----------------------------------------------------------------------------
    public function trova_candidato_guardia($data, $tipo_turno, $code_giornata, $severita='BIANCO') {
        if ($tipo_turno == 'CARDIO_NOTTE')
            $turno_tipo = 'NOTTE';
        else
            $turno_tipo = 'GIORNO';
        /*$sql = "SELECT g.code as code_giornata, t.code as tipo_turno, a.code as code_anagrafica, coalesce(count, 0), max
                from tipo_giornate g
                cross join tipo_turni_guardia t 
                cross join anagrafiche a
                left join temp ON temp.code_anagrafica=a.code AND temp.tipo_turno=t.code AND temp.tipo_giornata=g.code
                where t.code='{$tipo_turno}'
                AND g.code='{$code_giornata}' AND a.guardia='S' AND a.code_uo='cardiologia'
                order by g.code, t.code, coalesce(count, 0), coalesce(max, '2000-01-01'), random()";*/
        # ordiniamo per "coefficiente guardia" calcolato come numero di turni fatti su giorni di servizio
        
        
        $coeff = "";
        if (($tipo_turno == 'CARDIO_POM_INT' || $tipo_turno == 'CARDIO_POM_UTIC') && $code_giornata == 'FERIALE') 
            $coeff = " / a.coef_pomeriggio ";
        
        $filtro_pool = "";
        $filtro_guardia = "";
        $obj_calendario = Calendario::getInstance();
        if ($obj_calendario->festivita($data) || $obj_calendario->domenica($data)) {
            $filtro_pool = " AND gp.festivita=1 ";
            $filtro_guardia = " AND t.festivita=1 ";
        }
        elseif ($obj_calendario->sabato($data)) {
            $filtro_pool = " AND gp.sabato=1 ";
            $filtro_guardia = " AND t.sabato=1 ";
        }
        else {
            $filtro_pool = " AND gp.feriale=1 ";
            $filtro_guardia = " AND t.feriale=1 ";
        }
        
        
        $sql = "SELECT g.code as code_giornata, t.code as tipo_turno, a.code as code_anagrafica, coalesce(count, 0) as numero, max
                , (coalesce(count, 0) / (date_part('day', to_timestamp('{$data}', 'YYY-MM-DD') - GREATEST(a.data_inizio::date, t.data_inizio::date))+1)) {$coeff} as coeff_guardia
                , gp.sabato, gp.festivita, gp.feriale
                from tipo_giornate g
                cross join tipo_turni_guardia t 
                cross join anagrafiche a
                left join temp ON temp.code_anagrafica=a.code AND temp.tipo_turno=t.code AND temp.tipo_giornata=g.code
                join guardie_pool gp ON gp.turno=t.code AND a.pool=gp.pool
                where t.code='{$tipo_turno}' 
                AND g.code='{$code_giornata}' AND a.guardia='S' AND a.code_uo='cardiologia'
                AND '{$data}' BETWEEN a.data_inizio AND coalesce(a.data_fine, '2100-12-31')
                {$filtro_pool} {$filtro_guardia}
                order by g.code, t.code, coeff_guardia, coalesce(count, 0), coalesce(max, '2000-01-01'), random()";
                #error_log($sql);
        $rs = $this->m_db->Esegui($sql);
        if ($rs) {
            if ($rs->RecordCount() == 0)
                return false;
        }
        else
            error_log($sql);
        
        $candidati = $rs->GetArray();
        
        
        # SOLO una volta, tanto al momento gli elenchi sono tutti uguali e indipendenti dalla severita'.
        if ($severita == 'BIANCO')
            $this->logGuardie($data, $tipo_turno, $code_giornata, $candidati, '-');
        $result = false;
        foreach ($candidati as $candidato) {
            $code_anagrafica = $candidato['code_anagrafica'];
            if ($this->verifica_candidato_guardia($data, $tipo_turno, $code_giornata, $code_anagrafica, $severita)) {
                $result = $code_anagrafica;
                break;
            }
        }
        return $result;
    }
    
    #-----------------------------------------------------------------------------
    # VERIFICA CANDIDATURA GUARDIA
    #-----------------------------------------------------------------------------
    public function verifica_candidato_guardia($data, $tipo_turno, $code_giornata, $code_anagrafica, $severita='') {
        GLOBAL $anagrafiche, $pools, $count_destinazioni_pool, $guardiani, $tipi_turno;
        
        #
        # Verifichiamo siano attivi
        #
        $data_inizio = $anagrafiche[$code_anagrafica]["data_inizio"];
        $data_fine = $anagrafiche[$code_anagrafica]["data_fine"];
        if (strlen($data_fine) == 0)
            $data_fine = '2100-12-31';
        
        if ($data < $data_inizio || $data > $data_fine) {
            DEBUG("   {$code_anagrafica} NON e' attivo.");
            $this->logGuardieVerificaCandidati($data, $tipo_turno, $code_giornata, $code_anagrafica, 'N', "{$code_anagrafica} NON e' attivo.", $severita); 
            return false;
        }
        
        $t = strtotime($data);
        $dow = date('w', $t);
        switch($dow) {
            case 1:
                $nome_giorno = "lunedi"; break;
            case 2:
                $nome_giorno = "martedi"; break;
            case 3:
                $nome_giorno = "mercoledi"; break;
            case 4:
                $nome_giorno = "giovedi"; break;
            case 5:
                $nome_giorno = "venerdi"; break;
            case 6:
                $nome_giorno = "sabato"; break;
            default:
                $nome_giorno = "domenica"; break;
        }
        $domani = date("Y-m-d", $t + 24*3600);
        
        
        $guardie = $this->guardie;
        $turni = $this->turni;
        $count_guardiani = count($guardiani);
        
        DEBUG("Verifico: $data, $tipo_turno, $code_giornata, $code_anagrafica, $severita");

        $pool = $anagrafiche[$code_anagrafica]["pool"];
        DEBUG("   {$code_anagrafica} e' {$pool}");
        
        if (isset($turni[$code_anagrafica][$data])) {
            foreach($turni[$code_anagrafica][$data] as $item) {
                # Verifichiamo se è di riposo
                if ($item["tipo_turno"] == 'R') {
                    DEBUG("   {$code_anagrafica} e' di riposo.");
                    $this->logGuardieVerificaCandidati($data, $tipo_turno, $code_giornata, $code_anagrafica, 'N', "{$code_anagrafica} e' di riposo.", $severita); 
                    return false;
                }
                
                # Verifichiamo se è in ferie
                elseif ($item["tipo_turno"] == 'F') {
                    DEBUG("   {$code_anagrafica} e' in ferie.");
                    $this->logGuardieVerificaCandidati($data, $tipo_turno, $code_giornata, $code_anagrafica, 'N', "{$code_anagrafica} e' in ferie.", $severita); 
                    return false;
                }
                
                # Verifichiamo se ha un convegno
                elseif ($item["tipo_turno"] == 'C') {
                    DEBUG("   {$code_anagrafica} ha un convegno.");
                    $this->logGuardieVerificaCandidati($data, $tipo_turno, $code_giornata, $code_anagrafica, 'N', "{$code_anagrafica} ha un convegno.", $severita); 
                    return false;
                }
                
                # Verifichiamo se fa già altra guardia
                elseif (array_key_exists($item["tipo_turno"], $tipi_turno)) {
                    DEBUG("   {$code_anagrafica} e' gia' di guardia.");
                    $this->logGuardieVerificaCandidati($data, $tipo_turno, $code_giornata, $code_anagrafica, 'N', "{$code_anagrafica} e' gia' di guardia.", $severita); 
                    return false;
                }
                
                # diversamente è comunque impegnato in qualcos'altro (EMO-REP non conta perché è una reperibilità)
                elseif (strlen($item["tipo_turno"]) && $item["tipo_turno"] != 'EMOREP') {
                    DEBUG("   {$code_anagrafica} e' gia' impegnato.");
                    $this->logGuardieVerificaCandidati($data, $tipo_turno, $code_giornata, $code_anagrafica, 'N', "{$code_anagrafica} e' gia' impegnato.", $severita); 
                    return false;
                }
            }
        }
        # Se il turno da riempire è NOTTE, guardiamo anche il giorno successivo
        if ($tipo_turno == "CARDIO_NOTTE") {
            if (isset($turni[$code_anagrafica][$domani])) {
                foreach($turni[$code_anagrafica][$domani] as $item) {
                    # Verifichiamo se è di riposo
                    if ($item["tipo_turno"] == 'R') {
                        DEBUG("   {$code_anagrafica} e' di riposo il giorno dopo.");
                        $this->logGuardieVerificaCandidati($domani, $tipo_turno, $code_giornata, $code_anagrafica, 'N', "{$code_anagrafica} e' di riposo il giorno dopo.", $severita); 
                        return false;
                    }
                    
                    # Verifichiamo se è in ferie
                    elseif ($item["tipo_turno"] == 'F') {
                        DEBUG("   {$code_anagrafica} e' in ferie il giorno dopo.");
                        $this->logGuardieVerificaCandidati($domani, $tipo_turno, $code_giornata, $code_anagrafica, 'N', "{$code_anagrafica} e' in ferie il giorno dopo.", $severita); 
                        return false;
                    }
                    
                    # Verifichiamo se ha un convegno
                    elseif ($item["tipo_turno"] == 'C') {
                        DEBUG("   {$code_anagrafica} ha un convegno il giorno dopo.");
                        $this->logGuardieVerificaCandidati($domani, $tipo_turno, $code_giornata, $code_anagrafica, 'N', "{$code_anagrafica} ha un convegno il giorno dopo.", $severita); 
                        return false;
                    }
                    
                    # Verifichiamo se fa già altra guardia
                    elseif (array_key_exists($item["tipo_turno"], $tipi_turno)) {
                        DEBUG("   {$code_anagrafica} e' gia' di guardia il giorno dopo.");
                        $this->logGuardieVerificaCandidati($domani, $tipo_turno, $code_giornata, $code_anagrafica, 'N', "{$code_anagrafica} e' gia' di guardia il giorno dopo.", $severita); 
                        return false;
                    }
                    
                    # diversamente è comunque impegnato in qualcos'altro
                    elseif (strlen($item["tipo_turno"])) {
                        DEBUG("   {$code_anagrafica} e' gia' impegnato il giorno dopo.");
                        $this->logGuardieVerificaCandidati($domani, $tipo_turno, $code_giornata, $code_anagrafica, 'N', "{$code_anagrafica} e' gia' impegnato il giorno dopo.", $severita); 
                        return false;
                    }
                }
            }
        }
        $obj_calendario = Calendario::getInstance();
        
        # TEMP
        if ($code_anagrafica == 'SEC') {
            $this->logGuardieVerificaCandidati($data, $tipo_turno, $code_giornata, $code_anagrafica, 'N', "{$code_anagrafica} per ora non può fare guardie.", $severita); 
            return false;
        }
        
        
        #
        # Se VENERDI, PAP non fa guardie che è in 104 PAP pensione
        #
        // if ($dow == 5 && $code_anagrafica == 'PAP') {
            // $this->logGuardieVerificaCandidati($data, $tipo_turno, $code_giornata, $code_anagrafica, 'N', "{$code_anagrafica} al venerdi è in 104.", $severita); 
            // return false;
        // }
        
        
        #
        # Se non è VENERDI, gli elettrofisiologi non fanno notti
        #
        if ($dow >= 1 && $dow <= 4 && $tipo_turno == "CARDIO_NOTTE" && $pool == 'POOL_ELETTROFISIOLOGIA') {
            $this->logGuardieVerificaCandidati($data, $tipo_turno, $code_giornata, $code_anagrafica, 'N', "{$code_anagrafica} (POOL EF) fanno notti solo al venerdi.", $severita); 
            return false;
        }
        
        
        
        
        
        
        
        #
        # Se SABATO o DOMENICA, verifichiamo che il candidato NON abbia lavorato già lo scorso weekend
        #
        if ($dow == 6 || $dow == 7 || $dow == 0) {
            if ($dow == 6) {
                $weekend_scorso_data_sabato = $obj_calendario->getData($data, -7);
                $weekend_scorso_data_domenica = $obj_calendario->getData($data, -6);
            }
            else {
                $weekend_scorso_data_sabato = $obj_calendario->getData($data, -8);
                $weekend_scorso_data_domenica = $obj_calendario->getData($data, -7);
            }
            DEBUG("Verifico weekend scordo: {$weekend_scorso_data_sabato}-{$weekend_scorso_data_domenica} (considero: {$data}");
            
            # Verifichiamo se c'e' stata una guardia recente
            $sql = "SELECT code_anagrafica, data 
                    FROM guardie 
                    WHERE code_anagrafica='{$code_anagrafica}'
                    AND data BETWEEN date '{$weekend_scorso_data_sabato}' AND date '{$weekend_scorso_data_domenica}'
                    AND stato IN ('{$this->stato}', 'P')";
            $rs = $this->m_db->Esegui($sql);
            if ($rs->RecordCount() > 0) {
                $d = $rs->Fields('data');
                DEBUG("   {$code_anagrafica} era di guardia anche weekend scorso ({$d}). Deve riposare.");
                $this->logGuardieVerificaCandidati($data, $tipo_turno, $code_giornata, $code_anagrafica, 'N', "{$code_anagrafica} era di guardia anche weekend scorso ({$d}). Deve riposare.", $severita); 
                return false;
            }
        }
        
        #
        # TEMP
        #
        if ($tipo_turno == 'CARDIO_NOTTE' && in_array($code_anagrafica, array('DELF', 'BORZ'))) {
            DEBUG("   {$code_anagrafica} al momento non fa notti.");
            $this->logGuardieVerificaCandidati($data, $tipo_turno, $code_giornata, $code_anagrafica, 'N', "{$code_anagrafica} al momento non fa notti.", $severita); 
            return false;
        }
        
        #
        # Se NOTTE, verifichiamo che il candidato non ne abbia già fatte 3 in questo mese
        #
        if ($tipo_turno == 'CARDIO_NOTTE') {
            $month = date("m", strtotime($data));
            $year = date("Y", strtotime($data));
            $sql = "SELECT *
                    FROM turni
                    WHERE code_anagrafica='{$code_anagrafica}'
                    AND tipo_turno='CARDIO_NOTTE'
                    AND EXTRACT(MONTH FROM data)={$month}
                    AND EXTRACT(YEAR FROM data)={$year}";
            $rs = $this->m_db->Esegui($sql);
            if ($rs->RecordCount() >= 3) {
                DEBUG("   {$code_anagrafica} fa già 3 notti in questo mese.");
                $this->logGuardieVerificaCandidati($data, $tipo_turno, $code_giornata, $code_anagrafica, 'N', "{$code_anagrafica} fa già 3 notti in questo mese.", $severita); 
                return false;
            }
        }
        
        #
        # SOLO se severità è BIANCO, riduciamo le notti di chi deve farne meno
        #
        # il calcolo è fatto su tutte le notti (feriali, festive e festività) ma solo le notti feriali vengono, all'occorrenza, tolte.
        # quindi le notti festive e festività se le fa tutte.
        if ($severita == 'BIANCO' && $tipo_turno == 'CARDIO_NOTTE' && $code_giornata == 'FERIALE' && $anagrafiche[$code_anagrafica]["coef_notte"]<1) {
            # Calcoliamo il coefficiente medio degli altri:
            $sql = "select avg(c) as media from (
                        SELECT 
                            t.code_anagrafica, t.tipo_turno,
                            count(*) as c
                            FROM turni t
                            where tipo_turno='CARDIO_NOTTE'
                            AND code_anagrafica<>'{$code_anagrafica}'
                            /*AND stato IN ('{$this->stato}', 'P')*/
                            AND data >= '2016-02-01'
                            group by t.code_anagrafica, t.tipo_turno
                            order by t.tipo_turno, c
                    ) as src";
            $rs = $this->m_db->Esegui($sql);
            $media_altri = $rs->Fields('media');


            # Calcoliamo il coefficiente medio del candidato:
            $sql = "SELECT 
                        count(*) as c
                        FROM turni t
                        where tipo_turno='CARDIO_NOTTE' 
                        AND code_anagrafica='{$code_anagrafica}'
                        /*AND stato IN ('{$this->stato}', 'P')*/
                        AND data >= '2016-02-01'
                        group by t.code_anagrafica, t.tipo_turno
                        order by t.tipo_turno, c";
            $rs = $this->m_db->Esegui($sql);
            $media_candidato = strlen($rs->Fields('c')) ? $rs->Fields('c') : 0;
            
            # Se media del candidato è al di sopra rispetto alla media altrui, modulata dal coefficiente, allora salta il turno
            if ($media_candidato > ceil($media_altri * $anagrafiche[$code_anagrafica]["coef_notte"])) {
                $coef = $anagrafiche[$code_anagrafica]["coef_notte"];
                $mcp = $media_altri * $anagrafiche[$code_anagrafica]["coef_notte"];
                DEBUG("   {$code_anagrafica} ha una media ({$media_candidato}) piu' alta rispetto a quanto dovrebbe avere ({$media_altri} * {$coef} = {$mcp}).");
                $this->logGuardieVerificaCandidati($data, $tipo_turno, $code_giornata, $code_anagrafica, 'N', "{$code_anagrafica} ha una media ({$media_candidato}) piu' alta rispetto a quanto dovrebbe avere ({$media_altri} * {$coef} = {$mcp}).", $severita); 
                return false;
            }
        }
        
        
        
        #
        # Per i giorni feriali, chi deve fare più o meno pomeriggi
        #
        /*if (($tipo_turno == 'CARDIO_POM_INT' || $tipo_turno == 'CARDIO_POM_UTIC') && $code_giornata == 'FERIALE' && $anagrafiche[$code_anagrafica]["coef_pomeriggio"]<1) {
            # Calcoliamo il coefficiente medio degli altri:
            $sql = "select avg(c) as media from (
                        SELECT 
                            t.code_anagrafica, t.tipo_turno,
                            count(*) as c
                            FROM turni t
                            where tipo_turno='CARDIO_NOTTE'
                            AND code_anagrafica<>'{$code_anagrafica}'
                            AND data >= '2016-02-01'
                            group by t.code_anagrafica, t.tipo_turno
                            order by t.tipo_turno, c
                    ) as src";
            $rs = $this->m_db->Esegui($sql);
            $media_altri = $rs->Fields('media');


            # Calcoliamo il coefficiente medio del candidato:
            $sql = "SELECT 
                        count(*) as c
                        FROM turni t
                        where tipo_turno='CARDIO_NOTTE' 
                        AND code_anagrafica='{$code_anagrafica}'
                        AND data >= '2016-02-01'
                        group by t.code_anagrafica, t.tipo_turno
                        order by t.tipo_turno, c";
            $rs = $this->m_db->Esegui($sql);
            $media_candidato = strlen($rs->Fields('c')) ? $rs->Fields('c') : 0;
            
            # Se media del candidato è al di sopra rispetto alla media altrui, modulata dal coefficiente, allora salta il turno
            if ($media_candidato > ceil($media_altri * $anagrafiche[$code_anagrafica]["coef_notte"])) {
                $coef = $anagrafiche[$code_anagrafica]["coef_notte"];
                $mcp = $media_altri * $anagrafiche[$code_anagrafica]["coef_notte"];
                DEBUG("   {$code_anagrafica} ha una media ({$media_candidato}) piu' alta rispetto a quanto dovrebbe avere ({$media_altri} * {$coef} = {$mcp}).");
                $this->logGuardieVerificaCandidati($data, $tipo_turno, $code_giornata, $code_anagrafica, 'N', "{$code_anagrafica} ha una media ({$media_candidato}) piu' alta rispetto a quanto dovrebbe avere ({$media_altri} * {$coef} = {$mcp}).", $severita); 
                return false;
            }
        }*/
        
        #
        # Per adesso basta musse, a chi tocca, tocca!
        #
        #return true;
        
        
        #
        # SOLO se severità è BIANCO, cerchiamo di distanziare le proprie guardie.
        #
        if ($severita == 'BIANCO' && $tipo_turno == 'CARDIO_NOTTE') {# && $code_anagrafica != "GIU" && $code_anagrafica != "SEC" && $code_anagrafica != "MAS" && $code_anagrafica != "GNE") {
            $giorni_fa = $obj_calendario->getData($data, -4);
            $giorni_dopo = $obj_calendario->getData($data, +4);
            
            # Verifichiamo se c'e' stata una guardia recente
            $sql = "SELECT code_anagrafica, data 
                    FROM guardie 
                    WHERE code_anagrafica='{$code_anagrafica}'
                    AND data >= date '{$giorni_fa}' 
                    AND data <= date '{$giorni_dopo}' 
                    AND stato IN ('{$this->stato}', 'P')
                    AND tipo_turno='CARDIO_NOTTE'";
            $rs = $this->m_db->Esegui($sql);
            if ($rs->RecordCount() > 0) {
                $d = $rs->Fields('data');
                DEBUG("   {$code_anagrafica} ha una guardia vicina ({$d}).");
                $this->logGuardieVerificaCandidati($data, $tipo_turno, $code_giornata, $code_anagrafica, 'N', "{$code_anagrafica} ha una guardia vicina ({$d}).", $severita); 
                return false;
            }
        }
        
        #
        # SOLO se severità è GIALLO-ARANCIO, cerchiamo di impedire guardie consecutive.
        #
        if (FALSE && ($severita == 'GIALLO' || $severita == 'ARANCIO') && $code_anagrafica != "GIU" && $code_anagrafica != "SEC" && $code_anagrafica != "MAS" && $code_anagrafica != "GNE") {
            $giorni_fa = $obj_calendario->getData($data, -2);
            $giorni_dopo = $obj_calendario->getData($data, +2);
            
            # Verifichiamo se c'e' stata una guardia recente
            $sql = "SELECT code_anagrafica, data 
                    FROM guardie 
                    WHERE code_anagrafica='{$code_anagrafica}'
                    AND data >= date '{$giorni_fa}' 
                    AND data <= date '{$giorni_dopo}' 
                    AND stato IN ('{$this->stato}', 'P')";
            $rs = $this->m_db->Esegui($sql);
            if ($rs->RecordCount() > 0) {
                $d = $rs->Fields('data');
                DEBUG("   {$code_anagrafica} ha una guardia attaccata ({$d}).");
                $this->logGuardieVerificaCandidati($data, $tipo_turno, $code_giornata, $code_anagrafica, 'N', "{$code_anagrafica} ha una guardia attaccata ({$d}).", $severita); 
                return false;
            }
        }
        
        #
        # SOLO se severità è BIANCO, cerchiamo di non programmare guardie consecutive per i pool degenza e ambulatoriale.
        #
        if (FALSE && ($severita == 'BIANCO' || $severita == 'GIALLO') && $pool != 'POOL_AMBULATORIALE' && $pool != 'POOL_DEGENZA' && $code_anagrafica != "GIU" && $code_anagrafica != "SEC" && $code_anagrafica != "MAS" && $code_anagrafica != "GNE") {
            $giorni_fa = $obj_calendario->getData($data, -1);
            $giorni_dopo = $obj_calendario->getData($data, +1);
            
            # Verifichiamo se c'e' stata una guardia recente
            $sql = "SELECT g.code_anagrafica, g.data 
                    FROM guardie g
                    JOIN anagrafiche a ON a.code=g.code_anagrafica
                    WHERE a.pool='{$pool}'
                    AND g.data >= date '{$giorni_fa}' 
                    AND g.data <= date '{$giorni_dopo}' 
                    AND g.stato IN ('{$this->stato}', 'P')";
            $rs = $this->m_db->Esegui($sql);
            if ($rs->RecordCount() > 0) {
                $d = $rs->Fields('data');
                DEBUG("   {$code_anagrafica} ha un collega del pool con una guardia troppo vicina ({$d}).");
                $this->logGuardieVerificaCandidati($data, $tipo_turno, $code_giornata, $code_anagrafica, 'N', "{$code_anagrafica} ha un collega del pool con una guardia troppo vicina ({$d}).", $severita); 
                return false;
            }
        }
        
        # Il numero sul pool lo verifichiamo sempre che è meglio 
        # A quale pool appartiene?
        if (false) {
            /* Verifichiamo che per le guardie non ci siano più di 2 medici del pool
              degenti e abulatorio e più di 1 medico per tutti gli altri pool*/
            $sql = "SELECT pool, count(*) as c 
                    FROM guardie g
                    JOIN anagrafiche a ON a.code=g.code_anagrafica
                    WHERE a.pool='{$pool}'
                    AND data='{$data}'
                    AND stato IN ('{$this->stato}', 'P')
                    GROUP BY pool";
            $rs = $this->m_db->Esegui($sql);
            $count = $rs->Fields("c");
            if ($pool == 'POOL_AMBULATORIALE' || $pool == 'POOL_DEGENZA') {
                if ($count >= 2) {
                    DEBUG("   Gia' troppi dal pool {$pool}");
                    $this->logGuardieVerificaCandidati($data, $tipo_turno, $code_giornata, $code_anagrafica, 'N', "{$code_anagrafica}: Gia' troppi dal pool {$pool}.", $severita); 
                    return false;
                }
            }
            else {
                if ($count >= 1) {
                    DEBUG("   Gia' troppi dal pool {$pool}");
                    $this->logGuardieVerificaCandidati($data, $tipo_turno, $code_giornata, $code_anagrafica, 'N', "{$code_anagrafica}: Gia' troppi dal pool {$pool}.", $severita); 
                    return false;
                }
            }
                
            # solo se è un giorno feriale
            if (false && $obj_calendario->festa($data) == 0) {
                #
                # SOLO se severità è BIANCO o GIALLO
                #
                if ($severita == 'BIANCO' || $severita == 'GIALLO') {
                    # Verifichiamo se ci sono abbastanza medici del pool disponibili
                    $sql = "select count(*) as c
                            from anagrafiche a
                            where a.pool='{$pool}' and a.code NOT IN (
                                select code_anagrafica from turni where data='{$data}' AND stato IN ('{$this->stato}', 'P')
                            )";
                    $rs = $this->m_db->Esegui($sql);
                    $medici_liberi = $rs->Fields("c") - 1; # il meno 1 è dovuto al fatto che quello corrente lo stiamo verificando quindi dopo ci sarà un libero in meno.
                    
                    $sql = "select count(*) as c
                            from destinazioni d
                            where d.pool='{$pool}' AND obbligatoria='S'";
                    $rs = $this->m_db->Esegui($sql);
                    $destinazioni_da_occupare = $rs->Fields("c"); 
                    
                    #$destinazioni_da_occupare = $count_destinazioni_pool[$pool];
                    DEBUG("   * Medici liberi: {$medici_liberi}, postazioni da occupare: {$destinazioni_da_occupare}");
                    if ($destinazioni_da_occupare > $medici_liberi) {
                        DEBUG("   Impossibile coprire tutte le destinazioni del pool {$pool}");
                        $this->logGuardieVerificaCandidati($data, $tipo_turno, $code_giornata, $code_anagrafica, 'N', "{$code_anagrafica}: Impossibile coprire tutte le destinazioni del pool {$pool}.", $severita); 
                        return false;
                    }
                }
            }
        }
        
        #
        # SOLO se severità è BIANCO, cerchiamo di non superare le medie degli altri
        #
        if (FALSE && $severita == 'BIANCO'/* && $tipo_turno == 'CARDIO_NOTTE' && $code_giornata == 'FERIALE' && $anagrafiche[$code_anagrafica]["coef_notte"]<1*/) {
            # Calcoliamo il coefficiente medio degli altri:
            $sql = "select avg(c) as media from (
                        SELECT 
                        code_anagrafica, tipo_turno, tipo_giornata,
                        count(*) as c
                        FROM (
	                        SELECT  t.code_anagrafica, t.tipo_turno, t.tipo_giornata, data
	                        from turni t
	                        where tipo_turno='{$tipo_turno}' AND tipo_giornata='{$code_giornata}'
	                        and t.tipo_turno<>'R'
	                        AND stato IN ('{$this->stato}', 'P')
	                        order by data desc
	                        limit {$count_guardiani}*2
                        ) as src
                        WHERE code_anagrafica<>'{$code_anagrafica}'
                        group by code_anagrafica, tipo_turno, tipo_giornata
                        order by tipo_giornata, tipo_turno, c
                    ) as src";
            $rs = $this->m_db->Esegui($sql);
            $media_altri = $rs->Fields('media');

            # Calcoliamo il coefficiente medio del candidato:
            $sql = "select avg(c) as media from (
                        SELECT 
                        code_anagrafica, tipo_turno, tipo_giornata,
                        count(*) as c
                        FROM (
	                        SELECT  t.code_anagrafica, t.tipo_turno, t.tipo_giornata, data
	                        from turni t
	                        where tipo_turno='{$tipo_turno}' AND tipo_giornata='{$code_giornata}'
	                        and t.tipo_turno<>'R'
	                        AND stato IN ('{$this->stato}', 'P')
	                        order by data desc
	                        limit {$count_guardiani}*2
                        ) as src
                        WHERE code_anagrafica='{$code_anagrafica}'
                        group by code_anagrafica, tipo_turno, tipo_giornata
                        order by tipo_giornata, tipo_turno, c
                    ) as src";
            $rs = $this->m_db->Esegui($sql);
            $media_candidato = $rs->Fields('media');
            
            # Se media del candidato è al di sopra rispetto alla media altrui, modulata dal coefficiente, allora salta il turno
            if ($media_candidato > ceil($media_altri)) {
                DEBUG("   {$code_anagrafica} ha una media ({$media_candidato}) piu' alta rispetto agli altri ({$media_altri}).");
                $this->logGuardieVerificaCandidati($data, $tipo_turno, $code_giornata, $code_anagrafica, 'N', "{$code_anagrafica} ha una media ({$media_candidato}) piu' alta rispetto agli altri  ({$media_altri}).", $severita); 
                return false;
            }
        }
        
        
        #
        # SOLO se severità è BIANCO, facciamo in modo che le NOTTI di lunedi e venerdi siano omogenee
        #
        if (FALSE && $severita == 'BIANCO' && $tipo_turno == 'CARDIO_NOTTE' && $code_giornata == 'FERIALE' && ($dow == 1 || $dow == 5)) {
            #$this->logGuardieVerificaCandidati($data, $tipo_turno, $code_giornata, $code_anagrafica, 'N', "{$code_anagrafica}, verifica in corso... ({$nome_giorno})", $severita); 
            
            # Calcoliamo il coefficiente medio degli altri:
            $sql = "select dow, avg(c) as media from (
	                    select code_anagrafica, dow, count(*) as c
	                    from (
		                    select code_anagrafica, date_part('dow', data) as dow from turni
		                    where tipo_turno like 'CARDIO_NOTTE' and tipo_giornata='FERIALE'
		                    and stato IN ('{$this->stato}', 'P')
		                    and date_part('dow', data)={$dow}
		                    order by data desc
		                    limit {$count_guardiani}*2
	                    ) as src
	                    WHERE code_anagrafica<>'{$code_anagrafica}'
	                    group by code_anagrafica, dow
	                    order by dow, count(*)
                    ) as s
                    GROUP BY dow";
            $rs = $this->m_db->Esegui($sql);
            $media_altri = $rs->Fields('media');

            # Calcoliamo il coefficiente medio del candidato:
            $sql = "select dow, avg(c) as media from (
	                    select code_anagrafica, dow, count(*) as c
	                    from (
		                    select code_anagrafica, date_part('dow', data) as dow from turni
		                    where tipo_turno like 'CARDIO_NOTTE' and tipo_giornata='FERIALE'
		                    and stato IN ('{$this->stato}', 'P')
		                    and date_part('dow', data)={$dow}
		                    order by data desc
		                    limit {$count_guardiani}*2
	                    ) as src
	                    where code_anagrafica='{$code_anagrafica}'
	                    group by code_anagrafica, dow
	                    order by dow, count(*)
                    ) as s
                    GROUP BY dow";
            $rs = $this->m_db->Esegui($sql);
            $media_candidato = $rs->Fields('media');
            
            # Se media del candidato è al di sopra rispetto alla media altrui, modulata dal coefficiente, allora salta il turno
            if ($media_candidato > $media_altri) {
                DEBUG("   {$code_anagrafica} ha una media ({$media_candidato}) piu' alta rispetto a quanto dovrebbe avere ({$media_altri}) il {$nome_giorno}.");
                $this->logGuardieVerificaCandidati($data, $tipo_turno, $code_giornata, $code_anagrafica, 'N', "{$code_anagrafica} ha una media ({$media_candidato}) piu' alta rispetto a quanto dovrebbe avere ({$media_altri}) il {$nome_giorno}.", $severita); 
                return false;
            }
            #else
            #    $this->logGuardieVerificaCandidati($data, $tipo_turno, $code_giornata, $code_anagrafica, 'N', "{$code_anagrafica} ha una media ({$media_candidato}) piu' bassa rispetto a quanto dovrebbe avere ({$media_altri}) il {$nome_giorno}.", $severita); 
        }
        
        
        
        return true;
    }
    
    #-----------------------------------------------------------------------------
    # INSERT GUARDIA
    #-----------------------------------------------------------------------------
    public function insertGuardia($data, $tipo_turno, $code_giornata, $code_anagrafica) {
        /*$sql = "INSERT INTO guardie(
                code_anagrafica, data, tipo_turno, tipo_giornata)
                VALUES('{$code_anagrafica}', '{$data}', '{$tipo_turno}', '{$code_giornata}')";
        $res = $this->m_db->Esegui($sql);
        if ($res) {
            $guardia = array(
                'code_anagrafica' => $code_anagrafica,
                'data' => $data,
                'tipo_turno' => $tipo_turno,
                'stato' => 'B',
                'tipo_giornata' => $code_giornata
            );
            $this->guardie[$data][$tipo_turno] = $guardia;
        }
        return $res;
        */
        return false;
    }
    
    #-----------------------------------------------------------------------------
    # INSERT TURNO
    #-----------------------------------------------------------------------------
    public function insertTurno($data, $tipo_turno, $code_giornata, $code_anagrafica, $legante="") {
        GLOBAL $ore_dei_turni, $tipi_turno;
        /*$obj_calendario = Calendario::getInstance();
        if ($tipo_turno == 'R') {
            if ($obj_calendario->festa($data))
                $tipo_turno = '-';
        }*/
        $ore = (isset($ore_dei_turni[$tipo_turno])) ? $ore_dei_turni[$tipo_turno] : '00:00:00';
        
        $sql = "INSERT INTO turni (code_anagrafica, data, tipo_turno, tipo_giornata, ore, legante)
                VALUES('{$code_anagrafica}', '{$data}', '{$tipo_turno}', '{$code_giornata}', '{$ore}', '{$legante}')";
        $res = $this->m_db->Esegui($sql);
        if ($res) {
            $turno = array(
                'code_anagrafica' => $code_anagrafica,
                'data' => $data,
                'tipo_turno' => $tipo_turno,
                'stato' => 'B',
                'tipo_giornata' => $code_giornata,
                'ore' => $ore
            );
            $this->turni[$code_anagrafica][$data][$tipo_turno] = $turno;
            
            # se TURNO e' GUARDIA
            if (array_key_exists($tipo_turno, $tipi_turno))
                $this->guardie[$data][$tipo_turno] = $turno;
            # altrim e' DESTINAZIONE PIANO LAVORO
            else
                $this->piano_lavoro[$data][$tipo_turno] = $turno;
        }
        /*else {
            DEBUG($sql." --- ".$this->m_db->ErrorMsg());
            exit();
        }*/
        return $res;
    }
    
    #-----------------------------------------------------------------------------
    # TROVA CANDIDATURA DESTINAZIONE PIANO LAVORO
    #-----------------------------------------------------------------------------
    public function trova_candidato_destinazione($data, $tipo_destinazione, $code_destinazione, $pool, $severita='BIANCO') {
        if ($severita == 'BIANCO') {
            $sql = "SELECT code_anagrafica, tipo_destinazione, ad.pool, livello
                    FROM anagrafiche_destinazioni ad
                    JOIN anagrafiche a ON a.code=ad.code_anagrafica
                    where ad.code_uo='cardiologia' AND ad.pool='{$pool}' 
                    AND tipo_destinazione IN ('{$tipo_destinazione}', '{$code_destinazione}') AND livello=1
                    AND '{$data}' BETWEEN a.data_inizio AND coalesce(a.data_fine, '2100-12-31')
                    ORDER BY livello, random()";
        }
        elseif ($severita == 'GIALLO') {
            $sql = "SELECT code_anagrafica, tipo_destinazione, ad.pool, livello
                    FROM anagrafiche_destinazioni ad
                    JOIN anagrafiche a ON a.code=ad.code_anagrafica
                    where ad.code_uo='cardiologia' AND (ad.pool<>'{$pool}' OR (ad.pool='{$pool}' AND livello>1))
                    AND tipo_destinazione IN ('{$tipo_destinazione}', '{$code_destinazione}')
                    AND '{$data}' BETWEEN a.data_inizio AND coalesce(a.data_fine, '2100-12-31')
                    ORDER BY livello, random()";
        }
        elseif ($severita == 'ARANCIO') {
            $sql = "SELECT DISTINCT code_anagrafica FROM (
                        SELECT code_anagrafica, ad.pool
                        FROM anagrafiche_destinazioni ad
                        JOIN anagrafiche a ON a.code=ad.code_anagrafica
                        where ad.code_uo='cardiologia' AND ad.pool='{$pool}'
                        AND '{$data}' BETWEEN a.data_inizio AND coalesce(a.data_fine, '2100-12-31')
                        ORDER BY random()
                    ) as src";
        }
        else {
            /*$sql = "SELECT DISTINCT code_anagrafica FROM (
                        SELECT code_anagrafica, pool
                        FROM anagrafiche_destinazioni ad
                        where code_uo='cardiologia' AND pool<>'{$pool}'
                        ORDER BY random()
                    ) as src";*/
            # se non c'è nessuno del pool, rimane vuoto!
            return false;
        }
        
        $rs = $this->m_db->Esegui($sql);
        $candidati = $rs->GetArray();
        $this->logGuardie($data, $code_destinazione, $tipo_destinazione, $candidati, $severita);
        $result = false;
        foreach ($candidati as $candidato) {
            $code_anagrafica = $candidato['code_anagrafica'];
            if ($this->verifica_candidato_destinazione($data, $tipo_destinazione, $code_destinazione, $code_anagrafica, $severita)) {
                $result = $code_anagrafica;
                break;
            }
        }
        return $result;
    }
    
    #-----------------------------------------------------------------------------
    # VERIFICA CANDIDATURA DESTINAZIONE PIANO LAVORO
    #-----------------------------------------------------------------------------
    public function verifica_candidato_destinazione($data, $tipo_destinazione, $code_destinazione, $code_anagrafica, $severita) {
        GLOBAL $tipi_turno, $destinazioni;
        
        $turni = $this->turni;
        #if ($code_anagrafica == 'ZIN')
        #    return false;
    

        
        DEBUG("Verifico: $data, $tipo_destinazione, $code_destinazione, $code_anagrafica, $severita");

        if (isset($turni[$code_anagrafica][$data])) {
            foreach ($turni[$code_anagrafica][$data] as $item) {
                # Verifichiamo se è di riposo
                if ($item["tipo_turno"] == 'R') {
                    DEBUG("   {$code_anagrafica} e' di riposo.");
                    $this->logGuardieVerificaCandidati($data, $code_destinazione, $tipo_destinazione, $code_anagrafica, 'N', "{$code_anagrafica} e' di riposo.", $severita); 
                    return false;
                }
                
                # Verifichiamo se è in ferie
                elseif ($item["tipo_turno"] == 'F') {
                    DEBUG("   {$code_anagrafica} e' in ferie.");
                    $this->logGuardieVerificaCandidati($data, $code_destinazione, $tipo_destinazione, $code_anagrafica, 'N', "{$code_anagrafica} e' in ferie.", $severita); 
                    return false;
                }
                
                # Verifichiamo se ha un convegno
                elseif ($item["tipo_turno"] == 'C') {
                    DEBUG("   {$code_anagrafica} ha un convegno.");
                    $this->logGuardieVerificaCandidati($data, $code_destinazione, $tipo_destinazione, $code_anagrafica, 'N', "{$code_anagrafica} ha un convegno.", $severita); 
                    return false;
                }
                
                # Verifichiamo se fa una guardia
                elseif (array_key_exists($item["tipo_turno"], $tipi_turno)) {
                    DEBUG("   {$code_anagrafica} e' di guardia.");
                    $this->logGuardieVerificaCandidati($data, $code_destinazione, $tipo_destinazione, $code_anagrafica, 'N', "{$code_anagrafica} e' di guardia.", $severita); 
                    return false;
                }

                # Verifichiamo se è già nel piano di lavoro
                elseif (array_key_exists($item["tipo_turno"], $destinazioni)) {
                    DEBUG("   {$code_anagrafica} e' gia' nel piano di lavoro.");
                    $this->logGuardieVerificaCandidati($data, $code_destinazione, $tipo_destinazione, $code_anagrafica, 'N', "{$code_anagrafica} e' gia' nel piano di lavoro.", $severita); 
                    return false;
                }

                # diversamente è comunque impegnato in qualcos'altro
                elseif (strlen($item["tipo_turno"])) {
                    DEBUG("   {$code_anagrafica} e' gia' impegnato.");
                    $this->logGuardieVerificaCandidati($data, $code_destinazione, $tipo_destinazione, $code_anagrafica, 'N', "{$code_anagrafica} e' gia' impegnato.", $severita); 
                    return false;
                }
            }
        }
        
        // if ($code_destinazione == 'UTIC1' && $code_anagrafica == 'VAL') { # era MAS
            // # GNE e VAL si alternano se sono entrambi disponibili
            // # VAL è disponibile, verifichiamo GNE
            // if (count($turni['GNE'][$data]) == 0) {
                // $sql = "select count(*), code_anagrafica
                        // from turni
                        // where code_anagrafica IN ('GNE', 'VAL')
                        // and tipo_turno='UTIC1'
                        // and data>='2019-10-01'
                        // group by code_anagrafica
                        // order by count(*)";
                // $rs = $this->m_db->Esegui($sql);
                // $candidato = $rs->Fields("code_anagrafica");
                // if ($candidato != "VAL") {
                    // DEBUG("   {$code_anagrafica} ha fatto troppi turni in UTIC 1.");
                    // $this->logGuardieVerificaCandidati($data, $code_destinazione, $tipo_destinazione, $code_anagrafica, 'N', "{$code_anagrafica} ha fatto troppi turni in UTIC 1.", $severita); 
                    // return false;
                // }
            // }    
        // }
        
        # Impediamo 7 gg lavorative consecutive (sostituita da: MAI 2 settimane di guarda consecutive)
        if (FALSE && ($severita == 'BIANCO' || $severita == 'GIALLO' || $severita == 'ARANCIO' || $severita == 'ROSSO')) {
            $giorni_consecutivi = 0;
            $obj_calendario = Calendario::getInstance();
            
            # Guardiamo prima quelli successivi:
            $sql = "select code_anagrafica, data, tipo_turno  from turni
                    where code_anagrafica='{$code_anagrafica}' 
                    and data between date '{$data}' + interval '1 day' and date '{$data}' +6 * interval '1 day'
                    and tipo_turno not in ('CARDIO_MAT_INT')
                    order by data ASC";
            $rs = $this->m_db->Esegui($sql);
            $i = 1;
            while (!$rs->EOF) {
                $tipo_turno = $rs->Fields("tipo_turno");
                $data_corrente = $rs->Fields("data");
                $data_presunta = $obj_calendario->getData($data, $i);
                
                DEBUG("------ verifico $data_corrente $data_presunta $tipo_turno");
                if ($data_corrente != $data_presunta)
                    break;
                    
                switch($tipo_turno) {
                    case 'R':
                    case 'F':
                    case 'I':
                    case 'C':
                        break 2;
                    default:
                        $giorni_consecutivi++;
                }
                $i++;
                $rs->MoveNext();
            }
            
            # E poi quelli precedenti:
            $sql = "select code_anagrafica, data, tipo_turno  from turni
                    where code_anagrafica='{$code_anagrafica}' 
                    and data between date '{$data}' -6 * interval '1 day' and date '{$data}' - interval '1 day'
                    and tipo_turno not in ('CARDIO_MAT_INT')
                    order by data DESC";
            $rs = $this->m_db->Esegui($sql);
            $i = -1;
            while (!$rs->EOF) {
                $tipo_turno = $rs->Fields("tipo_turno");
                $data_corrente = $rs->Fields("data");
                $data_presunta = $obj_calendario->getData($data, $i);
                
                DEBUG("------ verifico $data_corrente $data_presunta $tipo_turno");
                if ($data_corrente != $data_presunta)
                    break;
                    
                switch($tipo_turno) {
                    case 'R':
                    case 'F':
                    case 'I':
                    case 'C':
                        break 2;
                    default:
                        $giorni_consecutivi++;
                }
                $i--;
                $rs->MoveNext();
            }
            
            # Il giorno corrente è ancora escluso percui i giorni attaccati devono essere non oltre i 5.
            if ($giorni_consecutivi >= 6) {
                DEBUG("   {$code_anagrafica} supererebbe il limite di 7 giorni consecutivi => RIPOSO FORZATO.");
                $this->logGuardieVerificaCandidati($data, $code_destinazione, $tipo_destinazione, $code_anagrafica, 'N', "{$code_anagrafica} supererebbe il limite di 7 giorni consecutivi.", $severita); 
                # forzo comunque il riposo
                $this->insertTurno($data, 'R', 'FERIALE', $code_anagrafica);
                return false;
            }
        }
            
        return true;
    }
    
    #-----------------------------------------------------------------------------
    # TROVO CANDIDATURA CONTINUITA'
    #-----------------------------------------------------------------------------
    public function verifica_candidato_continuita($data, $candidati, $escluso='') {
        GLOBAL $tipi_turno, $destinazioni;
        
        $turni = $this->turni;
        
        $obj_calendario = Calendario::getInstance();
        
        for($i=0; $i>-7; $i--)
            if ($obj_calendario->lunedi($data, $i))
                break;
        $lunedi = $obj_calendario->getData($data, $i);
        $martedi = $obj_calendario->getData($data, $i + 1);
        $giovedi = $obj_calendario->getData($data, $i + 3);
        $venerdi = $obj_calendario->getData($data, $i + 4);
        
        foreach($candidati as $candidato) {
            if ($candidato == $escluso)
                continue;
            DEBUG("   Verifico continuita {$candidato}");
            $sql = "SELECT * FROM turni WHERE code_anagrafica='{$candidato}' AND data BETWEEN '{$lunedi}' AND '{$giovedi}'";
            $rs = $this->m_db->Esegui($sql);
            if ($rs->RecordCount() == 0)
                return $candidato;
            $sql = "SELECT * FROM turni WHERE code_anagrafica='{$candidato}' AND data BETWEEN '{$martedi}' AND '{$venerdi}'";
            $rs = $this->m_db->Esegui($sql);
            if ($rs->RecordCount() == 0)
                return $candidato;
        }
        return false;
    }
    
    #-----------------------------------------------------------------------------
    # INSERT DESTINAZIONE PIANO LAVORO
    #-----------------------------------------------------------------------------
    public function insertDestinazione($data, $tipo_destinazione, $code_destinazione, $code_anagrafica) {
        /*$sql = "INSERT INTO pianolavoro(
                code_anagrafica, data, tipo_destinazione, code_destinazione)
                VALUES('{$code_anagrafica}', '{$data}', '{$tipo_destinazione}', '{$code_destinazione}')";
        $res = $this->m_db->Esegui($sql);
        if ($res) {
            $piano = array(
                'code_anagrafica' => $code_anagrafica,
                'data' => $data,
                'tipo_destinazione' => $tipo_destinazione,
                'stato' => 'B',
                'code_destinazione' => $code_destinazione
            );
            $this->piano_lavoro[$data][$code_destinazione] = $piano;
        }
        return $res;
        */
        return false;
    }
}
