<?php
/*
 * Classe Singleton
 */
class Singleton {
    
    #*****************************************************************************
    # Parte STATICA
    #*****************************************************************************
    private static $instance = null;
    protected static $session_name = "OBJ-SINGLETON";

    #------------------------------------------
    public static function getInstance() {
        error_log(self::$session_name);
                
        if (self::$instance == null) {
            if (isset($_SESSION[self::$session_name]))
                self::$instance = unserialize($_SESSION[self::$session_name]);
            else {
                error_log(__CLASS__);
                $c = __CLASS__;
                self::$instance = new $c;
            }
        }
        return self::$instance;
    }

    #------------------------------------------
    public static function save() {
        $_SESSION[self::$session_name] = serialize(self::$instance);
    }

    #------------------------------------------
    public static function erase() {
        if (isset($_SESSION[self::$session_name])) {
                self::$instance = null;
                unset($_SESSION[self::$session_name]);
                #self::getInstance();
        }
    }

}
?>
