<?php
//***************************************************************
require_once("include/common.inc.php");

$code = getVar("GET", "code");
$del = getVar("GET", "del", 0);
$si = getVar("GET", "si", 0);
$versione = 2;

#***************************************************************
# DELETE OGGETTO - versione 2
#***************************************************************
if ($versione == 2) {
	$titolo = "Eliminazione record";

	$messaggio = new Messaggio();
	$messaggio->setHeaders(true);
	$messaggio->setTitolo($titolo);

	if ($del == 0) {
		$messaggio->setTipo(MSG_ASK);
		$messaggio->setMessaggio("Vuoi eliminare il record?", "<br />");
		$messaggio->setLink(0, "NO", $_SESSION["ULTIMO_OGGETTO"]["link_indietro"]);
		$messaggio->setLink(1, "SI", "elimina.php?del=1&ver=2");
		$messaggio->show();
	}

	if ($si != 1)
		Factory::pulisci($_SESSION["ULTIMO_OGGETTO"]["classe"], $_SESSION["ULTIMO_OGGETTO"]["code"]);
	$oggetto = Factory::crea($_SESSION["ULTIMO_OGGETTO"]["classe"], $_SESSION["ULTIMO_OGGETTO"]["code"]);

	#-----------------------------------------------------------------------------
	# CHECK OGGETTO
	#-----------------------------------------------------------------------------
	if ($si == 1) {
		$check = true;
		$oggetto->setEludiCheck(true);
	}
	else
		$check = $oggetto->check($messaggio, 'D');


	if ($check == false) {
		$messaggio->setTitolo($titolo);
		if ($messaggio->tipo() == MSG_ERROR)
			$messaggio->setLink(0, "Indietro", $_SESSION["ULTIMO_OGGETTO"]["link_indietro"]);
		elseif ($messaggio->tipo() == MSG_WARNING) {
			$msg = $messaggio->messaggio();
			$msg .= "<p><b>Vuoi eliminare ugualmente?</b></p><br>";
			$messaggio->setMessaggio($msg);
			$messaggio->setLink(0, "NO", $_SESSION["ULTIMO_OGGETTO"]["link_indietro"]);
			$messaggio->setLink(1, "SI", "elimina.php?ver=2&del=1&si=1");
		}
		$messaggio->show();
	}

	#-----------------------------------------------------------------------------
	# DELETE OGGETTO
	#-----------------------------------------------------------------------------
	$res = $oggetto->invalidate(true);

	if ($res == FALSE) {
		$messaggio->setTipo(MSG_ERROR);
		$messaggio->setMessaggio("Impossibile continuare.", "<br />");
		$messaggio->setLink(0, "Indietro", $_SESSION["ULTIMO_OGGETTO"]["link_indietro"]);
	}
	else {
		$oggetto->notifica();

		$messaggio->setTipo(MSG_INFO);
		$messaggio->setMessaggio("Record eliminato con successo.", "<br />");
		$messaggio->setLink(0, "Indietro", $_SESSION["ULTIMO_OGGETTO"]["link_ok"]);

		header("Location:".$_SESSION["ULTIMO_OGGETTO"]["link_ok"]);
		exit();
	}
	$messaggio->show();
}
header("Location:".$_SESSION["ULTIMO_OGGETTO"]["link_indietro"]);
?>