<?php
require_once('include/common.inc.php');
include_once('classes/planning.class.php');

$obj_calendario = Calendario::getInstance();

$data_inizio = getVar("GET", "inizio");
$data_fine = getVar("GET", "fine");

if (strlen($data_inizio) > 0)
    ;
elseif (isset($_SESSION['PLANNING_data_inizio']))
    $data_inizio = $_SESSION['PLANNING_data_inizio'];
else
    $data_inizio = '2016-06-01';

if (strlen($data_fine) > 0)
    ;
elseif (isset($_SESSION['PLANNING_data_fine']))
    $data_fine = $_SESSION['PLANNING_data_fine'];
else
    $data_fine = '2016-10-02';
    

#$data_inizio = '2016-06-03';
#$data_fine = '2016-10-03';

$datetime1 = date_create($data_inizio);
$datetime2 = date_create($data_fine);
$interval = date_diff($datetime1, $datetime2);

$giorni_planning = intval($interval->format('%a'));
if (strlen($data_fine) == 0)
    $data_fine = $obj_calendario->getData($data_inizio, $giorni_planning);
DEBUG("INIZIO: ".$data_inizio);

$obj_calendario->setDataInizio($data_inizio);
$obj_calendario->setGiorni($giorni_planning);
$obj_calendario->init();

$obj_planning = Planning::getInstance();
$obj_planning->setDB($db);
$obj_planning->setStato('B');
$obj_planning->setGiorni($giorni_planning+1);
$obj_planning->setDataInizio($data_inizio);
$obj_planning->setDataFine($data_fine);
$obj_planning->setTipiTurnoGuardie($tipi_turno);
# INIT
$obj_planning->init();
# LOAD
$obj_planning->load();


$calendario = $obj_calendario->getCalendario();
$guardie = $obj_planning->getGuardie();
$planner = new PlannerCardiologia();

$RIPOSI_DOPO_18 = 0;
$RIPOSI_PRIMA_12 = 0;




/*
 * FASE 0: PIANO DI LAVORO GIORNI FERIALI - SOLO DEG1 e DEG2 che sono "speciali"
 */
$turno_extra = 0;
$pool_deg1 = poolDestinazione("DEG1"); #array('GIU', 'CAS');
$pool_deg2 = poolDestinazione("DEG2"); #array('SEC', 'BEZ');
$titolari_deg1 = titolariDestinazione("DEG1"); # GIU
$titolari_deg2 = titolariDestinazione("DEG2"); # DELL
$continuita = array('DEG1', 'DEG2'); # $continuita[DEG][WOY] = $anag;
foreach ($calendario as $giorno) {
    $data = $giorno['data'];
    if ($giorno['festa']) {
        continue;
    }
    
    $severita = "BIANCO";
    $pool = "POOL_DEGENZA";
    $tipo_destinazione = "DEG";
    $code_giornata = 'FERIALE';
    $obj_planning = Planning::getInstance();  
    $woy = $giorno["woy"];
    
    # In DEG dobbiamo assicurare la continuità nel modo più assoluto. Vuol dire che se uno dei titolari o entrambi
    # non possono coprire l'intera settimana, lo farà il primo sostituto disponibile
    
    # GIU salta la settimana su DEG1
    if ($woy % 4 == 0) {
        #$candidato = $obj_planning->verifica_candidato_destinazione($data, $tipo_destinazione, "DEG2", "SEC", $severita);
        #if ($candidato != false)
        #    $planner->impostaDestinazionePianoLavoro($data, $tipo_destinazione, "DEG2", $pool, $severita, "SEC");
        
        # DEG 1
        if (isset($continuita['DEG1'][$woy]))
            $candidato = $continuita['DEG1'][$woy];
        else
            $candidato = $obj_planning->verifica_candidato_continuita($data, $pool_deg1, $titolari_deg1[0]); #GIU
        if ($candidato != false) {
            $continuita['DEG1'][$woy] = $candidato;
            $planner->impostaDestinazionePianoLavoro($data, $tipo_destinazione, "DEG1", $pool, $severita, $candidato);
        }
        # DEG 2
        if (isset($continuita['DEG2'][$woy]))
            $candidato = $continuita['DEG2'][$woy];
        else
            $candidato = $obj_planning->verifica_candidato_continuita($data, $pool_deg2);
        if ($candidato != false) {
            $continuita['DEG2'][$woy] = $candidato;
            $planner->impostaDestinazionePianoLavoro($data, $tipo_destinazione, "DEG2", $pool, $severita, $candidato);
        }
    }
    # SEC salta la settimana su DEG2
    elseif ($woy % 4 == 2) {
        #$candidato = $obj_planning->verifica_candidato_destinazione($data, $tipo_destinazione, "DEG1", "GIU", $severita);
        #if ($candidato != false)
        #    $planner->impostaDestinazionePianoLavoro($data, $tipo_destinazione, "DEG1", $pool, $severita, "GIU");
        
        # DEG 1
        if (isset($continuita['DEG1'][$woy]))
            $candidato = $continuita['DEG1'][$woy];
        else
            $candidato = $obj_planning->verifica_candidato_continuita($data, $pool_deg1);
        if ($candidato != false) {
            $continuita['DEG1'][$woy] = $candidato;
            $planner->impostaDestinazionePianoLavoro($data, $tipo_destinazione, "DEG1", $pool, $severita, $candidato);
        }
        # DEG 2
        if (isset($continuita['DEG2'][$woy]))
            $candidato = $continuita['DEG2'][$woy];
        else
            $candidato = $obj_planning->verifica_candidato_continuita($data, $pool_deg2, $titolari_deg2[0]); #SEC
        if ($candidato != false) {
            $continuita['DEG2'][$woy] = $candidato;
            $planner->impostaDestinazionePianoLavoro($data, $tipo_destinazione, "DEG2", $pool, $severita, $candidato);
        }
    }
    # Non salta nessuno
    else {
        #$candidato = $obj_planning->verifica_candidato_destinazione($data, $tipo_destinazione, "DEG1", "GIU", $severita);
        #if ($candidato != false)
        #    $planner->impostaDestinazionePianoLavoro($data, $tipo_destinazione, "DEG1", $pool, $severita, "GIU");
        #-------------------------------------------------------------------------------------------------------------------
        #$candidato = $obj_planning->verifica_candidato_destinazione($data, $tipo_destinazione, "DEG2", "SEC", $severita);
        #if ($candidato != false)
        #    $planner->impostaDestinazionePianoLavoro($data, $tipo_destinazione, "DEG2", $pool, $severita, "SEC");
        
        # DEG 1
        if (isset($continuita['DEG1'][$woy]))
            $candidato = $continuita['DEG1'][$woy];
        else
            $candidato = $obj_planning->verifica_candidato_continuita($data, $pool_deg1);
        if ($candidato != false) {
            $continuita['DEG1'][$woy] = $candidato;
            $planner->impostaDestinazionePianoLavoro($data, $tipo_destinazione, "DEG1", $pool, $severita, $candidato);
        }
        # DEG 2
        if (isset($continuita['DEG2'][$woy]))
            $candidato = $continuita['DEG2'][$woy];
        else
            $candidato = $obj_planning->verifica_candidato_continuita($data, $pool_deg2);
        if ($candidato != false) {
            $continuita['DEG2'][$woy] = $candidato;
            $planner->impostaDestinazionePianoLavoro($data, $tipo_destinazione, "DEG2", $pool, $severita, $candidato);
        }
    }
}

/*
 * FASE 0.5: PIANO DI LAVORO GIORNI FERIALI - SOLO UTIC1 che sono "speciali"
 */
error_log("------------------------ FASE 0.5 UTIC");
$pool_utic1 = poolDestinazione("UTIC1"); #array('GNE', 'VAL', 'DEFE');
$titolari_utic1 = titolariDestinazione("UTIC1"); #('GNE');
$titolari_utic2 = titolariDestinazione("UTIC2"); #
$continuita = array('UTIC1'); # $continuita[UTIC][WOY] = $anag;
foreach ($calendario as $giorno) {
    $data = $giorno['data'];
    if ($giorno['festa']) {
        continue;
    }
    
    $severita = "BIANCO";
    $pool = "POOL_DEGENZA";
    $tipo_destinazione = "DEG";
    $code_giornata = 'FERIALE';
    $obj_planning = Planning::getInstance();  
    $woy = $giorno["woy"];
    
    # In UTIC1 dobbiamo assicurare la continuità. Vuol dire che se uno dei titolari o entrambi
    # non possono coprire l'intera settimana, lo farà il primo sostituto disponibile
    
    # do per scontato che i titolari siano 1 per postazione
    $titolare_utic1 = $titolari_utic1[0];
    $titolare_utic2 = $titolari_utic2[0];
        
    // $sql = "select count(*), code_anagrafica
            // from turni
            // where code_anagrafica IN ('{$titolare_utic1}', '{$titolare_utic2}')
            // and tipo_turno='UTIC1'
            // and data>='2019-10-01'
            // group by code_anagrafica
            // order by count(*) DESC";
    // $rs = $db->Esegui($sql);
    // $candidato_con_piu_utic1 = $rs->Fields("code_anagrafica");


    # creo dei buchi per fargli fare ai titolari anche altro
    // if ($woy % 3)
        // $candidato_con_piu_utic1 = '';
    
    
    if (isset($continuita['UTIC1'][$woy]))
        $candidato = $continuita['UTIC1'][$woy];
    else {
        # creo dei buchi per fargli fare ai titolari anche altro
        if ($woy % 4 == 2)
            $candidato1 = false;
        else
            $candidato1 = $obj_planning->verifica_candidato_continuita($data, $titolari_utic1, $candidato_con_piu_utic1);
        
        if ($candidato1 != false) {
            $candidato = $candidato1;
        }
        else {
            # Tolgo il titolare per fare fare turno ad altri
            if (($key = array_search($titolare_utic1, $pool_utic1)) !== false) {
                unset($pool_utic1[$key]);
            }
            $candidato2 = $obj_planning->verifica_candidato_continuita($data, $pool_utic1);
            if ($candidato2 != false) {
                $candidato = $candidato2;
            }
        }
    }
    
    if ($candidato != false) {
        $continuita['UTIC1'][$woy] = $candidato;
        $planner->impostaDestinazionePianoLavoro($data, $tipo_destinazione, "UTIC1", $pool, $severita, $candidato);
    }
}

/*
 * FASE 0.7: PIANO DI LAVORO GIORNI FERIALI - SOLO AMBSC1 e EF1 che devono averne sempre 1
 */
$turno_extra = 0;
$obj_planning = Planning::getInstance();  
$obj_calendario = Calendario::getInstance();  
$calendario = $obj_calendario->getCalendario();
$sql = "SELECT * FROM destinazioni WHERE code_uo='cardiologia' AND code IN ('AMBSC1', 'EF1') ORDER BY ordine"; #'DEGP', 'AMBSC1', 'EF1', 'EF3', 'AMBG1', 'ECO1', 'ECO3'
$rs = $db->Esegui($sql);
$destinazioni_AMBSC1_EF1 = array();
while (!$rs->EOF) {
    $code = $rs->Fields("code");
    $destinazioni_AMBSC1_EF1[$code] = $rs->FetchRow();
}
foreach ($calendario as $giorno) {
    $data = $giorno['data'];
    if ($giorno['festa'])
        continue;
    
    $code_giornata = 'FERIALE';
    
    
    # Il piano di lavoro va calcolato diversamente dalle guardie.
    # Qui prima dobbiamo fare tutte le destinazioni in BIANCO, poi tutte in GIALLO 
    # e così via.
    # NON PIU'!!!
    
    $severita = array('BIANCO', 'GIALLO'/*, 'ARANCIO'*/, 'ROSSO');
    foreach ($destinazioni_AMBSC1_EF1 as $key => $destinazione) {
        if ($key == 'DISP') # non dovrebbe esserci ma meglio verificare.
            continue;
        
        # Se è già impostato, salto:
        $giornata_pl = $obj_planning->getGiornataPianoLavoro($data, $key);
        if (strlen($giornata_pl['code_anagrafica']) > 0) {
            DEBUG("giornata {$data} impostata ({$key}): ".$giornata_pl['code_anagrafica']);
            continue;
        }
        
        $ne_manca_qualcuno = false;
        foreach ($severita as $s) {
            DEBUG("-- cerco x ".$key." ({$s})");
            $candidato = $planner->impostaDestinazionePianoLavoro($data, $destinazione["tipo"], $key, $destinazione["pool"], $s);
            if ($candidato === false) {
                $ne_manca_qualcuno = true;
                # Se è l'ultimo tentativo (ROSSO), segnaliamo errore!
                if ($s == 'ROSSO') 
                    $obj_planning->logGuardieVerificaCandidati($data, $key, $destinazione["tipo"], null, "N", "NESSUN CANDIDATO TROVATO!!!", $s);
            }
        }
        #if ($ne_manca_qualcuno === false)
        #    break;
    }
}


/*
 * FASE 0.8: PIANO DI LAVORO - EMO
 */
foreach ($calendario as $giorno) {
    $data = $giorno['data'];
    if ($giorno['festa'])
        continue;
    
    $code_giornata = 'FERIALE';
    $postazioni_emo = array('EMO1', 'EMO2', 'EMO3', 'EMOREP');
    $t = strtotime($data);
    $dow = date('w', $t);
    
    foreach ($postazioni_emo as $destinazione) {
        
        $candidato = "";
        # Se è già impostato, salto: NO! Gli EMO sono strani e poi hanno reperibilità
        $giornata_pl = $obj_planning->getGiornataPianoLavoro($data, $destinazione);
        if ($giornata_pl !== false) {
            DEBUG("giornata {$data} impostata ({$destinazione}): ".$giornata_pl['code_anagrafica']);
            continue;
        }
        
        if ($destinazione == 'EMO1') {
            switch($dow) {
                case 1:
                    $candidato = "GIA"; break;
                case 2:
                    $candidato = "MAC"; break;
                case 3:
                    $candidato = "CRI"; break;
                case 4:
                    $candidato = "MAC"; break;
                case 5:
                    $candidato = "VER"; break;
            }
        }
        elseif ($destinazione == 'EMO2') {
            switch($dow) {
                case 1:
                    $candidato = "MAC"; break;
                case 2:
                    $candidato = "GIA"; break;
                case 3:
                    $candidato = "MAC"; break;
                case 4:
                    $candidato = "VER"; break;
                case 5:
                    $candidato = "MAC"; break;
            }
        }
        elseif ($destinazione == 'EMO3') {
            switch($dow) {
                case 1:
                    $candidato = "CRI"; break;
                case 2:
                    $candidato = "CRI"; break;
                case 3:
                    $candidato = false; break;
                case 4:
                    $candidato = "MAC"; break;
                case 5:
                    $candidato = "GIA"; break;
            }
        }
        elseif ($destinazione == 'EMOREP') {
            switch($dow) {
                case 1:
                    $candidato = "GIA"; break;
                case 2:
                    $candidato = "MAC"; break;
                case 3:
                    $candidato = "VER"; break;
                case 4:
                    $candidato = "CRI"; break;
                case 5:
                    $candidato = "CRI"; break;
            }
        }
        DEBUG("giornata {$data} ({$dow}): ".$destinazione." = ".$candidato);
        
        #$planner->impostaDestinazionePianoLavoro($data, "EMO", $destinazione, "POOL_EMODINAMICA", "BIANCO", $candidato);
        if (strlen($candidato))
            $obj_planning->insertTurno($data, /*'L'*/$destinazione, 'FERIALE', $candidato);
    }
}

/*
 * FASE 1: GUARDIE
 */
foreach ($calendario as $giorno) {
    $data = $giorno['data'];
    if ($giorno['prefestivita'] || $giorno['festivita'])
        $code_giornata = 'FESTIVITA';
    elseif ($giorno['festa']==1)
        $code_giornata = 'FESTIVO';
    else
        continue;
    
    $t = strtotime($data);
    $dow = date('w', $t);
    $s = "BIANCO";
    // error_log($data." -> ".$code_giornata);
    // continue;
    
    # Dobbiamo fare lo "schema" nei festivi per minimizzare il numero di medici impegnati
    
    if ($dow == 6) {
        
        # Sabato
        $tipo_turno = 'CARDIO_NOTTE';
        $candidato_notte = $obj_planning->trova_candidato_guardia($data, "CARDIO_NOTTE", $code_giornata, $s);
        $cardiologo_notte = $planner->impostaGuardia($data, $tipo_turno, $code_giornata, $candidato_notte);
        
        $tipo_turno = 'CARDIO_INTERDIV';
        $candidato_intsab = $obj_planning->trova_candidato_guardia($data, "CARDIO_INTERDIV", $code_giornata, $s);
        $cardiologo_interdiv = $planner->impostaGuardia($data, $tipo_turno, $code_giornata, $candidato_intsab);
        
        $tipo_turno = 'CARDIO_MAT_UTIC';
        $candidato_mattina = $obj_planning->trova_candidato_guardia($data, "CARDIO_MAT_UTIC", $code_giornata, $s);
        $cardiologo_mattino_utic = $planner->impostaGuardia($data, $tipo_turno, $code_giornata, $candidato_mattina);
        
        $tipo_turno = 'CARDIO_POM_UTIC';
        $candidato_pomeriggio = $obj_planning->trova_candidato_guardia($data, "CARDIO_POM_UTIC", $code_giornata, $s);
        $cardiologo_pome_utic = $planner->impostaGuardia($data, $tipo_turno, $code_giornata, $candidato_pomeriggio);
        
        # Domenica
        $domenica = date("Y-m-d", $t + 24*3600);
        $candidato_intdom = $obj_planning->trova_candidato_guardia($domenica, "CARDIO_INTERDIV", $code_giornata, $s);
        
        $tipo_turno = 'CARDIO_NOTTE';
        $cardiologo_notte = $planner->impostaGuardia($domenica, $tipo_turno, $code_giornata, $candidato_pomeriggio);
        
        $tipo_turno = 'CARDIO_INTERDIV';
        $cardiologo_interdiv = $planner->impostaGuardia($domenica, $tipo_turno, $code_giornata, $candidato_intdom );
        
        $tipo_turno = 'CARDIO_MAT_UTIC';
        $cardiologo_mattino_utic = $planner->impostaGuardia($domenica, $tipo_turno, $code_giornata, $candidato_intsab);
        
        $tipo_turno = 'CARDIO_POM_UTIC';
        $cardiologo_pome_utic = $planner->impostaGuardia($domenica, $tipo_turno, $code_giornata, $candidato_mattina);
        
    }
    elseif ($dow == 7 || $dow == 0) {
        continue;
    }
    else {
        # --------------------------------------------------------------------------
        # CARDIO_NOTTE
        # --------------------------------------------------------------------------
        $tipo_turno = 'CARDIO_NOTTE';
        DEBUG("-- cerco ".$tipo_turno);
        $cardiologo_notte = $planner->impostaGuardia($data, $tipo_turno, $code_giornata);
        
        # --------------------------------------------------------------------------
        # CARDIO_INTERDIV
        # --------------------------------------------------------------------------
        $tipo_turno = 'CARDIO_INTERDIV';
        DEBUG("-- cerco ".$tipo_turno);
        $cardiologo_interdiv = $planner->impostaGuardia($data, $tipo_turno, $code_giornata);
        
        # --------------------------------------------------------------------------
        # CARDIO_INTERDIV_MAT
        # --------------------------------------------------------------------------
        $tipo_turno = 'CARDIO_INTERDIV_MAT';
        DEBUG("-- cerco ".$tipo_turno);
        $cardiologo_interdiv_mat = $planner->impostaGuardia($data, $tipo_turno, $code_giornata);
        
        # --------------------------------------------------------------------------
        # CARDIO_MAT_UTIC
        # --------------------------------------------------------------------------
        $tipo_turno = 'CARDIO_MAT_UTIC';
        DEBUG("-- cerco ".$tipo_turno);
        $cardiologo_mattino_utic = $planner->impostaGuardia($data, $tipo_turno, $code_giornata);
        
        # --------------------------------------------------------------------------
        # CARDIO_POM_UTIC
        # --------------------------------------------------------------------------
        $tipo_turno = 'CARDIO_POM_UTIC';
        DEBUG("-- cerco ".$tipo_turno);
        $cardiologo_pome_utic = $planner->impostaGuardia($data, $tipo_turno, $code_giornata);
        
        # --------------------------------------------------------------------------
        # CARDIO_POM_INT
        # --------------------------------------------------------------------------
        // $tipo_turno = 'CARDIO_POM_INT';
        // DEBUG("-- cerco ".$tipo_turno);
        // $cardiologo_pome_int = $planner->impostaGuardia($data, $tipo_turno, $code_giornata);
        
        # --------------------------------------------------------------------------
        # CARDIO_MAT_INT
        # --------------------------------------------------------------------------
        // $tipo_turno = 'CARDIO_MAT_INT';
        // DEBUG("-- cerco ".$tipo_turno);
        // $cardiologo_mat_int = $planner->impostaGuardia($data, $tipo_turno, $code_giornata);
    }
}

/*
 * FASE 2: GUARDIE FERIALI
 */
foreach ($calendario as $giorno) {
    $data = $giorno['data'];
    if ($giorno['prefestivita'] || $giorno['festivita'])
        continue;
    elseif ($giorno['festa']==1)
        continue;
    else
        $code_giornata = 'FERIALE';
    
    $t = strtotime($data);
    $dow = date('w', $t);
    $s = "BIANCO";
    $candidato = null;
    // error_log($data." -> ".$code_giornata);
    // continue;
    
    # --------------------------------------------------------------------------
    # CARDIO_NOTTE
    # --------------------------------------------------------------------------
    $tipo_turno = 'CARDIO_NOTTE';
    DEBUG("-- cerco ".$tipo_turno);
    $cardiologo_notte = $planner->impostaGuardia($data, $tipo_turno, $code_giornata);
    
    # --------------------------------------------------------------------------
    # CARDIO_INTERDIV
    # --------------------------------------------------------------------------
    $tipo_turno = 'CARDIO_INTERDIV';
    DEBUG("-- cerco ".$tipo_turno);
    $cardiologo_interdiv = $planner->impostaGuardia($data, $tipo_turno, $code_giornata);
    
    # --------------------------------------------------------------------------
    # CARDIO_INTERDIV_MAT
    # --------------------------------------------------------------------------
    $tipo_turno = 'CARDIO_INTERDIV_MAT';
    DEBUG("-- cerco ".$tipo_turno);
    $cardiologo_interdiv_mat = $planner->impostaGuardia($data, $tipo_turno, $code_giornata);
    
    # --------------------------------------------------------------------------
    # CARDIO_MAT_UTIC
    # --------------------------------------------------------------------------
    $tipo_turno = 'CARDIO_MAT_UTIC';
    DEBUG("-- cerco ".$tipo_turno);
    $cardiologo_mattino_utic = $planner->impostaGuardia($data, $tipo_turno, $code_giornata);
    
    # --------------------------------------------------------------------------
    # CARDIO_POM_UTIC
    # --------------------------------------------------------------------------
    $tipo_turno = 'CARDIO_POM_UTIC';
    DEBUG("-- cerco ".$tipo_turno);
    switch($dow) {
        case 1:
            $candidato = "VAL"; break;
        case 2:
            $candidato = "ZIN"; break;
        case 3:
            $candidato = "DEFE"; break;
        case 4:
            $candidato = "MUS"; break;
        case 5:
            $candidato = "GNE"; break;
    }
    $ok = $obj_planning->verifica_candidato_guardia($data, $tipo_turno, $code_giornata, $candidato, $s);
    if ($ok !== false)
        $cardiologo_pome_utic = $planner->impostaGuardia($data, $tipo_turno, $code_giornata, $candidato);
    
    # --------------------------------------------------------------------------
    # CARDIO_POM_INT
    # --------------------------------------------------------------------------
    // $tipo_turno = 'CARDIO_POM_INT';
    // DEBUG("-- cerco ".$tipo_turno);
    // $cardiologo_pome_int = $planner->impostaGuardia($data, $tipo_turno, $code_giornata);
    
    # --------------------------------------------------------------------------
    # CARDIO_MAT_INT
    # --------------------------------------------------------------------------
    // $tipo_turno = 'CARDIO_MAT_INT';
    // DEBUG("-- cerco ".$tipo_turno);
    // $cardiologo_mat_int = $planner->impostaGuardia($data, $tipo_turno, $code_giornata);

}


// DEBUG('FINE GUARDIE');
// exit();


/*
 * FASE 4.1: PIANO DI LAVORO (SOLO GIORNI FERIALI) - POSTAZIONI OBBLIGATORIE
 */

$sql = "SELECT * FROM destinazioni WHERE code_uo='cardiologia' ORDER BY obbligatoria DESC, ordine";
$rs = $db->Esegui($sql);
$destinazioni_ordinate_priorita = array();
while (!$rs->EOF) {
    $code = $rs->Fields("code");
    $destinazioni_ordinate_priorita[$code] = $rs->FetchRow();
}

$turno_extra = 0;
$obj_planning = Planning::getInstance();  
$obj_calendario = Calendario::getInstance();  
$calendario = $obj_calendario->getCalendario();
foreach ($calendario as $giorno) {
    $data = $giorno['data'];
    if ($giorno['festa'])
        continue;
    
    $code_giornata = 'FERIALE';
    
    
    # Il piano di lavoro va calcolato diversamente dalle guardie.
    # Qui prima dobbiamo fare tutte le destinazioni in BIANCO, poi tutte in GIALLO 
    # e così via.
    # NON PIU'!!!
    
    $severita = array('BIANCO', 'GIALLO'/*, 'ARANCIO'*/, 'ROSSO');
    foreach ($destinazioni_ordinate_priorita as $key => $destinazione) {
        if ($key == 'DISP') # non dovrebbe esserci ma meglio verificare.
            continue;
        #if ($key == "DEGDS" && ($calendario[$data]['gsettimana'] == 'Mer' || $calendario[$data]['gsettimana'] == 'Gio' || $calendario[$data]['gsettimana'] == 'Ven')) {
        #    $planner->impostaDestinazionePianoLavoro($data, $destinazione["tipo"], $key, $destinazione["pool"], 'BIANCO', 'ABB');
        #    continue;
        #}
            
        if ($destinazione["obbligatoria"] != 'S')
            continue;
            
        # Se è già impostato, salto:
        $giornata_pl = $obj_planning->getGiornataPianoLavoro($data, $key);
        if (strlen($giornata_pl['code_anagrafica']) > 0)
            continue;
                
        $ne_manca_qualcuno = false;
        foreach ($severita as $s) {
            
            DEBUG("-- cerco x ".$key." ({$s})");
            $candidato = $planner->impostaDestinazionePianoLavoro($data, $destinazione["tipo"], $key, $destinazione["pool"], $s);
            if ($candidato === false) {
                $ne_manca_qualcuno = true;
                # Se è l'ultimo tentativo (ROSSO), segnaliamo errore!
                if ($s == 'ROSSO') 
                    $obj_planning->logGuardieVerificaCandidati($data, $key, $destinazione["tipo"], null, "N", "NESSUN CANDIDATO TROVATO!!!", $s);
            }
        }
        #if ($ne_manca_qualcuno === false)
        #    break;
    }
}

/*
 * FASE 4.2: PIANO DI LAVORO (SOLO GIORNI FERIALI) - POSTAZIONI NON OBBLIGATORIE
 */
 
$turno_extra = 0;
foreach ($calendario as $giorno) {
    $data = $giorno['data'];
    if ($giorno['festa'])
        continue;
    
    $code_giornata = 'FERIALE';
    $obj_planning = Planning::getInstance();  
    
    # Il piano di lavoro va calcolato diversamente dalle guardie.
    # Qui prima dobbiamo fare tutte le destinazioni in BIANCO, poi tutte in GIALLO 
    # e così via.
    
    $severita = array('BIANCO', 'GIALLO', /*'ARANCIO',*/ 'ROSSO');
    foreach ($severita as $s) {
        $ne_manca_qualcuno = false;
        foreach ($destinazioni as $key => $destinazione) {
            if ($key == 'DISP') # non dovrebbe esserci ma meglio verificare.
                continue;
            if ($destinazione["obbligatoria"] == 'S')
                continue;
            DEBUG("-- cerco x ".$key." ({$s})");
            $candidato = $planner->impostaDestinazionePianoLavoro($data, $destinazione["tipo"], $key, $destinazione["pool"], $s);
            if ($candidato === false) {
                $ne_manca_qualcuno = true;
                # Se è l'ultimo tentativo (ROSSO), segnaliamo errore!
                if ($s == 'ROSSO') 
                    $obj_planning->logGuardieVerificaCandidati($data, $key, $destinazione["tipo"], null, "N", "NESSUN CANDIDATO TROVATO!!!", $s);
            }
        }
        if ($ne_manca_qualcuno === false)
            break;
    }
}

/*
 * FASE 5: MEDICI DISPONIBILI (SOLO GIORNI FERIALI)
 */
$turni = $obj_planning->getTurni();
foreach ($calendario as $giorno) {
    $data = $giorno['data'];
    if ($giorno['festa'])
        continue;
    foreach($anagrafiche as $code => $anag) {
        $data_inizio = $anag["data_inizio"];
        $data_fine = $anag["data_fine"];
        if (strlen($data_fine) == 0)
            $data_fine = '2100-12-31';
        
        if ($data < $data_inizio || $data > $data_fine) 
            continue;
        if (!isset($turni[$code][$data])) {
            $obj_planning->insertTurno($data, 'DISP', 'FERIALE', $code); 
        }
    }
}


DEBUG("FINE");
