<?php
require_once('include/common.inc.php');
include_once('classes/planning.class.php');
/*
  SELECT 
        tipo_giornata, tipo, t.code_anagrafica, 
        sum(ttg.ore) as ore_guardia, count(*) as c
        FROM turni t
        left join tipo_turni_guardia ttg ON t.tipo_turno=ttg.code
        --left join destinazioni d ON t.tipo_turno=d.code
        where data BETWEEN date '2016-02-01' AND date '2016-09-30'
        and tipo_turno like 'CARDIO\_%'
        group by t.code_anagrafica, tipo_giornata, tipo
        order by tipo_giornata, tipo, count(*) desc, code_anagrafica;
*/

$obj_calendario = Calendario::getInstance();

$data_inizio = getVar("GET", "inizio");
$data_fine = getVar("GET", "fine");

if (strlen($data_inizio) > 0)
    ;
elseif (isset($_SESSION['PLANNING_data_inizio']))
    $data_inizio = $_SESSION['PLANNING_data_inizio'];
else
    $data_inizio = '2016-06-01';

if (strlen($data_fine) > 0)
    ;
elseif (isset($_SESSION['PLANNING_data_fine']))
    $data_fine = $_SESSION['PLANNING_data_fine'];
else
    $data_fine = '2016-10-02';
    

#$data_inizio = '2016-06-03';
#$data_fine = '2016-10-03';

$datetime1 = date_create($data_inizio);
$datetime2 = date_create($data_fine);
$interval = date_diff($datetime1, $datetime2);

$giorni_planning = intval($interval->format('%a'));
if (strlen($data_fine) == 0)
    $data_fine = $obj_calendario->getData($data_inizio, $giorni_planning);
DEBUG("INIZIO: ".$data_inizio);

$obj_calendario->setDataInizio($data_inizio);
$obj_calendario->setGiorni($giorni_planning);
$obj_calendario->init();

$obj_planning = Planning::getInstance();
$obj_planning->setDB($db);
$obj_planning->setStato('B');
$obj_planning->setGiorni($giorni_planning+1);
$obj_planning->setDataInizio($data_inizio);
$obj_planning->setDataFine($data_fine);
# INIT
$obj_planning->init();
# LOAD
$obj_planning->load();


$calendario = $obj_calendario->getCalendario();
$guardie = $obj_planning->getGuardie();
$planner = new PlannerCardiologia();

$RIPOSI_DOPO_18 = 0;
$RIPOSI_PRIMA_12 = 0;




/*
 * GUARDIE 
 * Procediamo prima con tutte le festività, poi passiamo ai festivi.
 * Facciamo infine tutti lgi altri giorni (feriali).
 */

/*
 * TURNO EXTRA
 * Ogni volta che c'è un turno durante le festività,
 * sono ore che si fanno in più e vanno recuperate.
 * Su Cardiologia:
 * - se 12 ore le recupero i 2 giorni prima (tipicamente giovedi e venerdi)
 * - se 18 ore le recupero i 3 giorni dopo (tip. lunedi-mercoledi)
 */
$turno_extra = 0;

/*
 * FASE 0: PIANO DI LAVORO GIORNI FERIALI - SOLO DEG1 e DEG2 che sono "speciali"
 */
$turno_extra = 0;
$pool_deg1 = poolDestinazione("DEG1"); #array('GIU', 'CAS');
$pool_deg2 = poolDestinazione("DEG2"); #array('SEC', 'BEZ');
$continuita = array('DEG1', 'DEG2'); # $continuita[DEG][WOY] = $anag;
foreach ($calendario as $giorno) {
    $data = $giorno['data'];
    if ($giorno['festa']) {
        continue;
    }
    
    $severita = "BIANCO";
    $pool = "POOL_DEGENZA";
    $tipo_destinazione = "DEG";
    $code_giornata = 'FERIALE';
    $obj_planning = Planning::getInstance();  
    $woy = $giorno["woy"];
    
    # In DEG dobbiamo assicurare la continuità nel modo più assoluto. Vuol dire che se uno dei titolari o entrambi
    # non possono coprire l'intera settimana, lo farà il primo sostituto disponibile
    
    # GIU salta la settimana su DEG1
    if ($woy % 4 == 0) {
        #$candidato = $obj_planning->verifica_candidato_destinazione($data, $tipo_destinazione, "DEG2", "SEC", $severita);
        #if ($candidato != false)
        #    $planner->impostaDestinazionePianoLavoro($data, $tipo_destinazione, "DEG2", $pool, $severita, "SEC");
        
        # DEG 1
        if (isset($continuita['DEG1'][$woy]))
            $candidato = $continuita['DEG1'][$woy];
        else
            $candidato = $obj_planning->verifica_candidato_continuita($data, $pool_deg1, 'GIU');
        if ($candidato != false) {
            $continuita['DEG1'][$woy] = $candidato;
            $planner->impostaDestinazionePianoLavoro($data, $tipo_destinazione, "DEG1", $pool, $severita, $candidato);
        }
        # DEG 2
        if (isset($continuita['DEG2'][$woy]))
            $candidato = $continuita['DEG2'][$woy];
        else
            $candidato = $obj_planning->verifica_candidato_continuita($data, $pool_deg2);
        if ($candidato != false) {
            $continuita['DEG2'][$woy] = $candidato;
            $planner->impostaDestinazionePianoLavoro($data, $tipo_destinazione, "DEG2", $pool, $severita, $candidato);
        }
    }
    # SEC salta la settimana su DEG2
    elseif ($woy % 4 == 2) {
        #$candidato = $obj_planning->verifica_candidato_destinazione($data, $tipo_destinazione, "DEG1", "GIU", $severita);
        #if ($candidato != false)
        #    $planner->impostaDestinazionePianoLavoro($data, $tipo_destinazione, "DEG1", $pool, $severita, "GIU");
        
        # DEG 1
        if (isset($continuita['DEG1'][$woy]))
            $candidato = $continuita['DEG1'][$woy];
        else
            $candidato = $obj_planning->verifica_candidato_continuita($data, $pool_deg1);
        if ($candidato != false) {
            $continuita['DEG1'][$woy] = $candidato;
            $planner->impostaDestinazionePianoLavoro($data, $tipo_destinazione, "DEG1", $pool, $severita, $candidato);
        }
        # DEG 2
        if (isset($continuita['DEG2'][$woy]))
            $candidato = $continuita['DEG2'][$woy];
        else
            $candidato = $obj_planning->verifica_candidato_continuita($data, $pool_deg2, 'SEC');
        if ($candidato != false) {
            $continuita['DEG2'][$woy] = $candidato;
            $planner->impostaDestinazionePianoLavoro($data, $tipo_destinazione, "DEG2", $pool, $severita, $candidato);
        }
    }
    # Non salta nessuno
    else {
        #$candidato = $obj_planning->verifica_candidato_destinazione($data, $tipo_destinazione, "DEG1", "GIU", $severita);
        #if ($candidato != false)
        #    $planner->impostaDestinazionePianoLavoro($data, $tipo_destinazione, "DEG1", $pool, $severita, "GIU");
        #-------------------------------------------------------------------------------------------------------------------
        #$candidato = $obj_planning->verifica_candidato_destinazione($data, $tipo_destinazione, "DEG2", "SEC", $severita);
        #if ($candidato != false)
        #    $planner->impostaDestinazionePianoLavoro($data, $tipo_destinazione, "DEG2", $pool, $severita, "SEC");
        
        # DEG 1
        if (isset($continuita['DEG1'][$woy]))
            $candidato = $continuita['DEG1'][$woy];
        else
            $candidato = $obj_planning->verifica_candidato_continuita($data, $pool_deg1);
        if ($candidato != false) {
            $continuita['DEG1'][$woy] = $candidato;
            $planner->impostaDestinazionePianoLavoro($data, $tipo_destinazione, "DEG1", $pool, $severita, $candidato);
        }
        # DEG 2
        if (isset($continuita['DEG2'][$woy]))
            $candidato = $continuita['DEG2'][$woy];
        else
            $candidato = $obj_planning->verifica_candidato_continuita($data, $pool_deg2);
        if ($candidato != false) {
            $continuita['DEG2'][$woy] = $candidato;
            $planner->impostaDestinazionePianoLavoro($data, $tipo_destinazione, "DEG2", $pool, $severita, $candidato);
        }
    }
}

/*
 * FASE 0.5: PIANO DI LAVORO GIORNI FERIALI - SOLO UTIC1 che sono "speciali"
 */
$pool_utic1 = poolDestinazione("UTIC1"); #array('GNE', 'VAL', 'DEFE');
$titolari_utic1 = titolariDestinazione("UTIC1"); #('GNE');
$continuita = array('UTIC1'); # $continuita[UTIC][WOY] = $anag;
foreach ($calendario as $giorno) {
    $data = $giorno['data'];
    if ($giorno['festa']) {
        continue;
    }
    
    $severita = "BIANCO";
    $pool = "POOL_DEGENZA";
    $tipo_destinazione = "DEG";
    $code_giornata = 'FERIALE';
    $obj_planning = Planning::getInstance();  
    $woy = $giorno["woy"];
    
    # In UTIC1 dobbiamo assicurare la continuità. Vuol dire che se uno dei titolari o entrambi
    # non possono coprire l'intera settimana, lo farà il primo sostituto disponibile
    
    $sql = "select count(*), code_anagrafica
            from turni
            where code_anagrafica IN ('GNE', 'MAS')
            and tipo_turno='UTIC1'
            and data>='2019-10-01'
            group by code_anagrafica
            order by count(*) DESC";
    $rs = $db->Esegui($sql);
    $candidato_con_piu_utic1 = $rs->Fields("code_anagrafica");
    
    if (isset($continuita['UTIC1'][$woy]))
        $candidato = $continuita['UTIC1'][$woy];
    else {
        $candidato1 = $obj_planning->verifica_candidato_continuita($data, $titolari_utic1, $candidato_con_piu_utic1);
        if ($candidato1 != false) {
            $candidato = $candidato1;
        }
        else {
            $candidato2 = $obj_planning->verifica_candidato_continuita($data, $pool_utic1);
            if ($candidato2 != false) {
                $candidato = $candidato2;
            }
        }
    }
    
    if ($candidato != false) {
        $continuita['UTIC1'][$woy] = $candidato;
        $planner->impostaDestinazionePianoLavoro($data, $tipo_destinazione, "UTIC1", $pool, $severita, $candidato);
    }
}

/*
 * FASE 0.7: PIANO DI LAVORO GIORNI FERIALI - SOLO AMBSC1 e EF1 che devono averne sempre 1
 */
$turno_extra = 0;
$obj_planning = Planning::getInstance();  
$obj_calendario = Calendario::getInstance();  
$calendario = $obj_calendario->getCalendario();
$sql = "SELECT * FROM destinazioni WHERE code_uo='cardiologia' AND code IN ('AMBSC1', 'EF1')";
$rs = $db->Esegui($sql);
$destinazioni_AMBSC1_EF1 = array();
while (!$rs->EOF) {
    $code = $rs->Fields("code");
    $destinazioni_AMBSC1_EF1[$code] = $rs->FetchRow();
}
foreach ($calendario as $giorno) {
    $data = $giorno['data'];
    if ($giorno['festa'])
        continue;
    
    $code_giornata = 'FERIALE';
    
    
    # Il piano di lavoro va calcolato diversamente dalle guardie.
    # Qui prima dobbiamo fare tutte le destinazioni in BIANCO, poi tutte in GIALLO 
    # e così via.
    # NON PIU'!!!
    
    $severita = array('BIANCO'); #, 'GIALLO'/*, 'ARANCIO'*/, 'ROSSO');
    foreach ($destinazioni_AMBSC1_EF1 as $key => $destinazione) {
        if ($key == 'DISP') # non dovrebbe esserci ma meglio verificare.
            continue;
        
        # Se è già impostato, salto:
        $giornata_pl = $obj_planning->getGiornataPianoLavoro($data, $key);
        if (strlen($giornata_pl['code_anagrafica']) > 0) {
            DEBUG("giornata {$data} impostata ({$key}): ".$giornata_pl['code_anagrafica']);
            continue;
        }
        
        $ne_manca_qualcuno = false;
        foreach ($severita as $s) {
            DEBUG("-- cerco x ".$key." ({$s})");
            $candidato = $planner->impostaDestinazionePianoLavoro($data, $destinazione["tipo"], $key, $destinazione["pool"], $s);
            if ($candidato === false) {
                $ne_manca_qualcuno = true;
                # Se è l'ultimo tentativo (ROSSO), segnaliamo errore!
                if ($s == 'ROSSO') 
                    $obj_planning->logGuardieVerificaCandidati($data, $key, $destinazione["tipo"], null, "N", "NESSUN CANDIDATO TROVATO!!!", $s);
            }
        }
        #if ($ne_manca_qualcuno === false)
        #    break;
    }
}

#############################################################################
# GURADIE
#############################################################################


/*
 * FASE 1: FESTIVITA'
 */
foreach ($calendario as $giorno) {
    $data = $giorno['data'];
    if ($giorno['prefestivita']==0 && $giorno['festivita']==0)
        continue;
    
    $code_giornata = 'FESTIVITA';
    
    # I turni nei giorni di festa hanno un formato "canonico": calcolato il 
    # primo giorno, viene fatto anche il secondo seguendo uno schema.
    # Verifichiamo ogni 2 turni di festa o quantomeno se oggi è festa mentre
    # l'indomani non è festa.
    # Esempio: 3 giorni di festa, prefestivo o prefestività compresi.
    # I primi 2 giorni fanno un conto, l'ultimo un altro.
    # I giorni singoli vanno sempre in POST.
    if ($giorno['festa'])
        $turno_extra++;
    DEBUG("{$data} --> {$code_giornata} ({$turno_extra})");
    
    # Secondo giorno di festa
    if ($turno_extra == 2) {
        DEBUG("TURNO EXTRA = 2");
        $turno_extra = 0;
        #Prendo i turni del giorno precedente per calcolare i turni
        $ieri = $obj_calendario->getData($data, -1);
        $cardiologo1 = $obj_planning->getGiornataGuardie($ieri, 'CARDIO_POM_UTIC'); #1
        $cardiologo1 = $cardiologo1["code_anagrafica"]; #1
        $cardiologo2 = $obj_planning->getGiornataGuardie($ieri, 'CARDIO_NOTTE');    #2
        $cardiologo2 = $cardiologo2["code_anagrafica"];    #2
        $cardiologo3 = $obj_planning->getGiornataGuardie($ieri, 'CARDIO_POM_INT');  #3
        $cardiologo3 = $cardiologo3["code_anagrafica"];  #3
        $cardiologo4 = $obj_planning->getGiornataGuardie($ieri, 'CARDIO_MAT_UTIC'); #4
        $cardiologo4 = $cardiologo4["code_anagrafica"]; #4
        DEBUG("Cardiologo #1: ".$cardiologo1);
        DEBUG("Cardiologo #2: ".$cardiologo2);
        DEBUG("Cardiologo #3: ".$cardiologo3);
        DEBUG("Cardiologo #4: ".$cardiologo4);
        
        # numero 2 riposa
        # numero 1 fa la notte
        /*$planner->impostaGuardia($data, 'CARDIO_NOTTE', $code_giornata, $cardiologo1);  
        # numero 3 fa la mattina UTIC
        if (strlen($cardiologo3) == 0)
            $cardiologo3 = false;
        $planner->impostaGuardia($data, 'CARDIO_MAT_UTIC', $code_giornata, $cardiologo3);
        # numero 4 fa il pomeriggio UTIC
        $planner->impostaGuardia($data, 'CARDIO_POM_UTIC', $code_giornata, $cardiologo4); */
        
        
        $ok = $obj_planning->verifica_candidato_guardia($data, 'CARDIO_NOTTE', $code_giornata, $cardiologo1);
        if (!$ok)
            $cardiologo1 = false;
        $planner->impostaGuardia($data, 'CARDIO_NOTTE', $code_giornata, $cardiologo1);
        
        # numero 3 fa la mattina UTIC
        if (strlen($cardiologo3) == 0)
            $cardiologo3 = false;
        else {
            $ok = $obj_planning->verifica_candidato_guardia($data, 'CARDIO_MAT_UTIC', $code_giornata, $cardiologo3);
            if (!$ok)
                $cardiologo3 = false;
        }
        $planner->impostaGuardia($data, 'CARDIO_MAT_UTIC', $code_giornata, $cardiologo3);
        
        # numero 4 fa il pomeriggio UTIC
        $ok = $obj_planning->verifica_candidato_guardia($data, 'CARDIO_POM_UTIC', $code_giornata, $cardiologo4);
        if (!$ok)
            $cardiologo4 = false;
        $planner->impostaGuardia($data, 'CARDIO_POM_UTIC', $code_giornata, $cardiologo4); 
            
        
        
        
        
        
        # Calcoliamo i riposi di recupero (12=pre, 18=post)
        # 1 e 3 hanno fatto 18 ore
        # 2 e 4 hanno fatto 12 ore
        $riposi = 0;
        $i = 0;
        DEBUG("-- calcolo riposi post");
        while ($riposi < $RIPOSI_DOPO_18) {
            $i++;
            $festa = $obj_calendario->festa($data, $i);
            DEBUG($obj_calendario->getData($data, $i)." ".$festa);
            if (!$festa) {
                $g = $obj_calendario->getData($data, $i);
                $obj_planning->insertTurno($g, 'R', '', $cardiologo1);
                $obj_planning->insertTurno($g, 'R', '', $cardiologo3);
                $riposi++;
            }
            if ($i>10) {
                DEBUG("qualcosa è andato storto!!!!!!");
                break;
            }
               
        }
        $riposi = 0;
        $i = 0;
        DEBUG("-- calcolo riposi pre");
        while ($riposi < $RIPOSI_PRIMA_12) {
            $i--;
            $festa = $obj_calendario->festa($data, $i);
            DEBUG($obj_calendario->getData($data, $i)." ".$festa);
            if (!$festa) {
                $g = $obj_calendario->getData($data, $i);
                $obj_planning->insertTurno($g, 'R', '', $cardiologo2);
                $obj_planning->insertTurno($g, 'R', '', $cardiologo4);
                $riposi++;
            }
            if ($i<-10) {
                DEBUG("qualcosa è andato storto!!!!!!");
                break;
            }
        }
        continue;
    }
               
		
    # --------------------------------------------------------------------------
    # CARDIO_NOTTE
    # --------------------------------------------------------------------------
    $tipo_turno = 'CARDIO_NOTTE';
    DEBUG("-- cerco ".$tipo_turno);
    $cardiologo_notte = $planner->impostaGuardia($data, $tipo_turno, $code_giornata);
    
    # --------------------------------------------------------------------------
    # CARDIO_MAT_UTIC
    # --------------------------------------------------------------------------
    $tipo_turno = 'CARDIO_MAT_UTIC';
    $cardiologo_mattino_utic = false;
    if ($giorno['festa']) {
        DEBUG("-- cerco ".$tipo_turno);
        $cardiologo_mattino_utic = $planner->impostaGuardia($data, $tipo_turno, $code_giornata);
    }
    
    # --------------------------------------------------------------------------
    # CARDIO_POM_UTIC
    # --------------------------------------------------------------------------
    $tipo_turno = 'CARDIO_POM_UTIC';
    DEBUG("-- cerco ".$tipo_turno);
    $cardiologo_pome_utic = $planner->impostaGuardia($data, $tipo_turno, $code_giornata);
    
    # --------------------------------------------------------------------------
    # CARDIO_POM_INT
    # --------------------------------------------------------------------------
    $tipo_turno = 'CARDIO_POM_INT';
    if (($giorno['sabato'] && $giorno['festivita']==0) || $giorno['prefestivita']) {
        DEBUG("-- cerco ".$tipo_turno);
        $cardiologo_pome_int = $planner->impostaGuardia($data, $tipo_turno, $code_giornata);
    }
    
    # --------------------------------------------------------------------------
    # CARDIO_MAT_INT: solo al SABATO e PREFESTIVITA. Se la fa chi fa il pomeriggio
    # --------------------------------------------------------------------------
    $tipo_turno = 'CARDIO_MAT_INT';
    if (($giorno['sabato'] && $giorno['festivita']==0) || $giorno['prefestivita']) {
        $planner->impostaGuardia($data, $tipo_turno, $code_giornata, $cardiologo_pome_int);
    }
    
    
    # --------------------------------------------------------------------------
    # Se è un giorno di festa spaiato, i riposi vanno calcolati subito
    # --------------------------------------------------------------------------
    # NESSUN RIPOSO!!! (per ora)
    if ($obj_calendario->festa($data) == 1 && $obj_calendario->festa($data, +1) == 0) {
        $turno_extra = 0;
        $riposi = 0;
        $i = 0;
        /*while ($riposi < 1) {
            $i++;
            $festa = $obj_calendario->festa($data, $i);
            if (!$festa) {
                $g = $obj_calendario->getData($data, $i);
                $obj_planning->insertTurno($g, 'R', '', $cardiologo_mattino_utic);
                $obj_planning->insertTurno($g, 'R', '', $cardiologo_pome_utic);
                $obj_planning->insertTurno($g, 'R', '', $cardiologo_pome_int);
                $obj_planning->insertTurno($g, 'R', '', $cardiologo_notte); # dovrebbe essere già settato
                $j = $i;
                while (true) {
                    $j++;
                    if (!$obj_calendario->festa($data, $j)) {
                        $g2 = $obj_calendario->getData($data, $j);
                        $obj_planning->insertTurno($g2, 'R', '', $cardiologo_notte); # secondo giorno non festivo
                        break;
                    }
                }
                $riposi++;
            }
        }*/
    }
}

/*
 * FASE 2: FESTIVI SABATI e DOMENICHE
 */
$turno_extra = 0;
foreach ($calendario as $giorno) {
    $data = $giorno['data'];
    if ($giorno['prefestivita']==1 || $giorno['festivita']==1)
        continue;
    if ($giorno['festa']==0)
        continue;
    $code_giornata = 'FESTIVO';
    
    # I turni nei giorni di festa hanno un formato "canonico": calcolato il 
    # primo giorno, viene fatto anche il secondo seguendo uno schema.
    # Verifichiamo ogni 2 turni di festa o quantomeno se oggi è festa mentre
    # l'indomani non è festa.
    # Esempio: 3 giorni di festa, prefestivo o prefestività compresi.
    # I primi 2 giorni fanno un conto, l'ultimo un altro.
    # I giorni singoli vanno sempre in POST.
    if ($giorno['festa'])
        $turno_extra++;
    DEBUG("{$data} --> {$code_giornata} ({$turno_extra})");
    
    # Secondo giorno di festa
    if ($turno_extra == 2) {
        DEBUG("TURNO EXTRA = 2");
        $turno_extra = 0;
        #Prendo i turni del giorno precedente per calcolare i turni
        $ieri = $obj_calendario->getData($data, -1);
        $cardiologo1 = $obj_planning->getGiornataGuardie($ieri, 'CARDIO_POM_UTIC'); #1
        $cardiologo1 = $cardiologo1["code_anagrafica"]; #1
        $cardiologo2 = $obj_planning->getGiornataGuardie($ieri, 'CARDIO_NOTTE');    #2
        $cardiologo2 = $cardiologo2["code_anagrafica"];    #2
        $cardiologo3 = $obj_planning->getGiornataGuardie($ieri, 'CARDIO_POM_INT');  #3
        $cardiologo3 = $cardiologo3["code_anagrafica"];  #3
        $cardiologo4 = $obj_planning->getGiornataGuardie($ieri, 'CARDIO_MAT_UTIC'); #4
        $cardiologo4 = $cardiologo4["code_anagrafica"]; #4
        DEBUG("Cardiologo #1: ".$cardiologo1);
        DEBUG("Cardiologo #2: ".$cardiologo2);
        DEBUG("Cardiologo #3: ".$cardiologo3);
        DEBUG("Cardiologo #4: ".$cardiologo4);
        # numero 2 riposa
        # numero 1 fa la notte
        /*$planner->impostaGuardia($data, 'CARDIO_NOTTE', $code_giornata, $cardiologo1);  
        # numero 3 fa la mattina UTIC
        if (strlen($cardiologo3) == 0)
            $cardiologo3 = false;
        $planner->impostaGuardia($data, 'CARDIO_MAT_UTIC', $code_giornata, $cardiologo3);
        # numero 4 fa il pomeriggio UTIC
        $planner->impostaGuardia($data, 'CARDIO_POM_UTIC', $code_giornata, $cardiologo4); */
        
        $ok = $obj_planning->verifica_candidato_guardia($data, 'CARDIO_NOTTE', $code_giornata, $cardiologo1);
        if (!$ok)
            $cardiologo1 = false;
        $planner->impostaGuardia($data, 'CARDIO_NOTTE', $code_giornata, $cardiologo1);
        
        # numero 3 fa la mattina UTIC
        if (strlen($cardiologo3) == 0)
            $cardiologo3 = false;
        else {
            $ok = $obj_planning->verifica_candidato_guardia($data, 'CARDIO_MAT_UTIC', $code_giornata, $cardiologo3);
            if (!$ok)
                $cardiologo3 = false;
        }
        $planner->impostaGuardia($data, 'CARDIO_MAT_UTIC', $code_giornata, $cardiologo3);
        
        # numero 4 fa il pomeriggio UTIC
        $ok = $obj_planning->verifica_candidato_guardia($data, 'CARDIO_POM_UTIC', $code_giornata, $cardiologo4);
        if (!$ok)
            $cardiologo4 = false;
        $planner->impostaGuardia($data, 'CARDIO_POM_UTIC', $code_giornata, $cardiologo4); 
            
            
            
        
        # Calcoliamo i riposi di recupero (12=pre, 18=post)
        # 1 e 3 hanno fatto 18 ore
        # 2 e 4 hanno fatto 12 ore
        $riposi = 0;
        $i = 0;
        DEBUG("-- calcolo riposi post");
        while ($riposi < $RIPOSI_DOPO_18) {
            $i++;
            $festa = $obj_calendario->festa($data, $i);
            DEBUG($obj_calendario->getData($data, $i)." ".$festa);
            if (!$festa) {
                $g = $obj_calendario->getData($data, $i);
                $obj_planning->insertTurno($g, 'R', '', $cardiologo1);
                $obj_planning->insertTurno($g, 'R', '', $cardiologo3);
                $riposi++;
            }
            if ($i>10) {
                DEBUG("qualcosa è andato storto!!!!!!");
                break;
            }
               
        }
        $riposi = 0;
        $i = 0;
        DEBUG("-- calcolo riposi pre");
        while ($riposi < $RIPOSI_PRIMA_12) {
            $i--;
            $festa = $obj_calendario->festa($data, $i);
            DEBUG($obj_calendario->getData($data, $i)." ".$festa);
            if (!$festa) {
                $g = $obj_calendario->getData($data, $i);
                $obj_planning->insertTurno($g, 'R', '', $cardiologo2);
                $obj_planning->insertTurno($g, 'R', '', $cardiologo4);
                $riposi++;
            }
            if ($i<-10) {
                DEBUG("qualcosa è andato storto!!!!!!");
                break;
            }
        }
        continue;
    }
               
		
    # --------------------------------------------------------------------------
    # CARDIO_NOTTE
    # --------------------------------------------------------------------------
    $tipo_turno = 'CARDIO_NOTTE';
    DEBUG("-- cerco ".$tipo_turno);
    $cardiologo_notte = $planner->impostaGuardia($data, $tipo_turno, $code_giornata);
    
    # --------------------------------------------------------------------------
    # CARDIO_MAT_UTIC
    # --------------------------------------------------------------------------
    $tipo_turno = 'CARDIO_MAT_UTIC';
    $cardiologo_mattino_utic = false;
    if ($giorno['festa']) {
        DEBUG("-- cerco ".$tipo_turno);
        $cardiologo_mattino_utic = $planner->impostaGuardia($data, $tipo_turno, $code_giornata);
    }
    
    # --------------------------------------------------------------------------
    # CARDIO_POM_UTIC
    # --------------------------------------------------------------------------
    $tipo_turno = 'CARDIO_POM_UTIC';
    DEBUG("-- cerco ".$tipo_turno);
    $cardiologo_pome_utic = $planner->impostaGuardia($data, $tipo_turno, $code_giornata);
    
    # --------------------------------------------------------------------------
    # CARDIO_POM_INT
    # --------------------------------------------------------------------------
    $tipo_turno = 'CARDIO_POM_INT';
    if (($giorno['sabato'] && $giorno['festivita']==0) || $giorno['prefestivita']) {
        DEBUG("-- cerco ".$tipo_turno);
        $cardiologo_pome_int = $planner->impostaGuardia($data, $tipo_turno, $code_giornata);
    }
    
    # --------------------------------------------------------------------------
    # CARDIO_MAT_INT: solo al SABATO e PREFESTIVITA. Se la fa chi fa il pomeriggio
    # --------------------------------------------------------------------------
    $tipo_turno = 'CARDIO_MAT_INT';
    if (($giorno['sabato'] && $giorno['festivita']==0) || $giorno['prefestivita']) {
        $planner->impostaGuardia($data, $tipo_turno, $code_giornata, $cardiologo_pome_int);
    }
    
    
    # --------------------------------------------------------------------------
    # Se è un giorno di festa spaiato, i riposi vanno calcolati subito
    # --------------------------------------------------------------------------
    # NESSUN RIPOSO !!! (per ora)
    if ($obj_calendario->festa($data) == 1 && $obj_calendario->festa($data, +1) == 0) {
        $turno_extra = 0;
        $riposi = 0;
        $i = 0;
        /*while ($riposi < 1) {
            $i++;
            $festa = $obj_calendario->festa($data, $i);
            if (!$festa) {
                $g = $obj_calendario->getData($data, $i);
                $obj_planning->insertTurno($g, 'R', '', $cardiologo_mattino_utic);
                $obj_planning->insertTurno($g, 'R', '', $cardiologo_pome_utic);
                $obj_planning->insertTurno($g, 'R', '', $cardiologo_pome_int);
                $obj_planning->insertTurno($g, 'R', '', $cardiologo_notte); # dovrebbe essere già settato
                $j = $i;
                while (true) {
                    $j++;
                    if (!$obj_calendario->festa($data, $j)) {
                        $g2 = $obj_calendario->getData($data, $j);
                        $obj_planning->insertTurno($g2, 'R', '', $cardiologo_notte); # secondo giorno non festivo
                        break;
                    }
                }
                $riposi++;
            }
        }*/
    }
}






/*
 * FASE 3: GIORNI FERIALI
 */
$turno_extra = 0;
foreach ($calendario as $giorno) {
    $data = $giorno['data'];
    if ($giorno['festa'])
        continue;
    
    $code_giornata = 'FERIALE';
    
    # --------------------------------------------------------------------------
    # CARDIO_NOTTE
    # --------------------------------------------------------------------------
    $tipo_turno = 'CARDIO_NOTTE';
    DEBUG("-- cerco ".$tipo_turno);
    $cardiologo_notte = $planner->impostaGuardia($data, $tipo_turno, $code_giornata);
    
    # RIPOSO DI RECUPERO ORE dopo la notte
    # per ora solo il giorno successivo. Se festivo, non lo trasliamo.
    /*$riposi = 0;
    $i = 0;
    while ($riposi < 1) {
        $i++;
        $festa = $obj_calendario->festa($data, $i);
        if (!$festa) {
            $g = $obj_calendario->getData($data, $i);
            $obj_planning->insertTurno($g, 'R', '', $cardiologo_notte); # dovrebbe essere già settato
            $riposi++;
        }
    }*/
    
    # --------------------------------------------------------------------------
    # CARDIO_POM_UTIC
    # --------------------------------------------------------------------------
    $tipo_turno = 'CARDIO_POM_UTIC';
    DEBUG("-- cerco ".$tipo_turno);
    $cardiologo_pome_utic = $planner->impostaGuardia($data, $tipo_turno, $code_giornata);
    
    # --------------------------------------------------------------------------
    # CARDIO_POM_INT
    # --------------------------------------------------------------------------
    $tipo_turno = 'CARDIO_POM_INT';
    DEBUG("-- cerco ".$tipo_turno);
    $cardiologo_pome_int = $planner->impostaGuardia($data, $tipo_turno, $code_giornata);
}

DEBUG('FINE GUARDIE');
#exit();


/*
 * FASE 4.1: PIANO DI LAVORO (SOLO GIORNI FERIALI) - POSTAZIONI OBBLIGATORIE
 */

$sql = "SELECT * FROM destinazioni WHERE code_uo='cardiologia' ORDER BY obbligatoria DESC, ordine";
$rs = $db->Esegui($sql);
$destinazioni_ordinate_priorita = array();
while (!$rs->EOF) {
    $code = $rs->Fields("code");
    $destinazioni_ordinate_priorita[$code] = $rs->FetchRow();
}

$turno_extra = 0;
$obj_planning = Planning::getInstance();  
$obj_calendario = Calendario::getInstance();  
$calendario = $obj_calendario->getCalendario();
foreach ($calendario as $giorno) {
    $data = $giorno['data'];
    if ($giorno['festa'])
        continue;
    
    $code_giornata = 'FERIALE';
    
    
    # Il piano di lavoro va calcolato diversamente dalle guardie.
    # Qui prima dobbiamo fare tutte le destinazioni in BIANCO, poi tutte in GIALLO 
    # e così via.
    # NON PIU'!!!
    
    $severita = array('BIANCO', 'GIALLO'/*, 'ARANCIO'*/, 'ROSSO');
    foreach ($destinazioni_ordinate_priorita as $key => $destinazione) {
        if ($key == 'DISP') # non dovrebbe esserci ma meglio verificare.
            continue;
        #if ($key == "DEGDS" && ($calendario[$data]['gsettimana'] == 'Mer' || $calendario[$data]['gsettimana'] == 'Gio' || $calendario[$data]['gsettimana'] == 'Ven')) {
        #    $planner->impostaDestinazionePianoLavoro($data, $destinazione["tipo"], $key, $destinazione["pool"], 'BIANCO', 'ABB');
        #    continue;
        #}
            
        if ($destinazione["obbligatoria"] != 'S')
            continue;
            
        # Se è già impostato, salto:
        $giornata_pl = $obj_planning->getGiornataPianoLavoro($data, $key);
        if (strlen($giornata_pl['code_anagrafica']) > 0)
            continue;
                
        $ne_manca_qualcuno = false;
        foreach ($severita as $s) {
            
            DEBUG("-- cerco x ".$key." ({$s})");
            $candidato = $planner->impostaDestinazionePianoLavoro($data, $destinazione["tipo"], $key, $destinazione["pool"], $s);
            if ($candidato === false) {
                $ne_manca_qualcuno = true;
                # Se è l'ultimo tentativo (ROSSO), segnaliamo errore!
                if ($s == 'ROSSO') 
                    $obj_planning->logGuardieVerificaCandidati($data, $key, $destinazione["tipo"], null, "N", "NESSUN CANDIDATO TROVATO!!!", $s);
            }
        }
        #if ($ne_manca_qualcuno === false)
        #    break;
    }
}

/*
 * FASE 4.2: PIANO DI LAVORO (SOLO GIORNI FERIALI) - POSTAZIONI NON OBBLIGATORIE
 */
 
$turno_extra = 0;
foreach ($calendario as $giorno) {
    $data = $giorno['data'];
    if ($giorno['festa'])
        continue;
    
    $code_giornata = 'FERIALE';
    $obj_planning = Planning::getInstance();  
    
    # Il piano di lavoro va calcolato diversamente dalle guardie.
    # Qui prima dobbiamo fare tutte le destinazioni in BIANCO, poi tutte in GIALLO 
    # e così via.
    
    $severita = array('BIANCO', 'GIALLO', /*'ARANCIO',*/ 'ROSSO');
    foreach ($severita as $s) {
        $ne_manca_qualcuno = false;
        foreach ($destinazioni as $key => $destinazione) {
            if ($key == 'DISP') # non dovrebbe esserci ma meglio verificare.
                continue;
            if ($destinazione["obbligatoria"] == 'S')
                continue;
            DEBUG("-- cerco x ".$key." ({$s})");
            $candidato = $planner->impostaDestinazionePianoLavoro($data, $destinazione["tipo"], $key, $destinazione["pool"], $s);
            if ($candidato === false) {
                $ne_manca_qualcuno = true;
                # Se è l'ultimo tentativo (ROSSO), segnaliamo errore!
                if ($s == 'ROSSO') 
                    $obj_planning->logGuardieVerificaCandidati($data, $key, $destinazione["tipo"], null, "N", "NESSUN CANDIDATO TROVATO!!!", $s);
            }
        }
        if ($ne_manca_qualcuno === false)
            break;
    }
}

/*
 * FASE 5: MEDICI DISPONIBILI (SOLO GIORNI FERIALI)
 */
$turni = $obj_planning->getTurni();
foreach ($calendario as $giorno) {
    $data = $giorno['data'];
    if ($giorno['festa'])
        continue;
    foreach($anagrafiche as $code => $anag) {
        $data_inizio = $anag["data_inizio"];
        $data_fine = $anag["data_fine"];
        if (strlen($data_fine) == 0)
            $data_fine = '2100-12-31';
        
        if ($data < $data_inizio || $data > $data_fine) 
            continue;
        if (!isset($turni[$code][$data])) {
            $obj_planning->insertTurno($data, 'DISP', 'FERIALE', $code); 
        }
    }
}


DEBUG("FINE");
?>
