<?php
require_once('include/common.inc.php');
include_once('classes/planning.class.php');
/*
  SELECT 
        tipo_giornata, tipo, t.code_anagrafica, 
        sum(ttg.ore) as ore_guardia, count(*) as c
        FROM turni t
        left join tipo_turni_guardia ttg ON t.tipo_turno=ttg.code
        --left join destinazioni d ON t.tipo_turno=d.code
        where data BETWEEN date '2016-02-01' AND date '2016-09-30'
        and tipo_turno like 'CARDIO\_%'
        group by t.code_anagrafica, tipo_giornata, tipo
        order by tipo_giornata, tipo, count(*) desc, code_anagrafica;
*/

$obj_calendario = Calendario::getInstance();

$data_inizio = '2016-06-03';
$data_fine = '2016-10-03';

$datetime1 = date_create($data_inizio);
$datetime2 = date_create($data_fine);
$interval = date_diff($datetime1, $datetime2);

$giorni_planning = intval($interval->format('%a'));
if (strlen($data_fine) == 0)
    $data_fine = $obj_calendario->getData($data_inizio, $giorni_planning);
DEBUG("INIZIO: ".$data_inizio);

$obj_calendario->setDataInizio($data_inizio);
$obj_calendario->setGiorni($giorni_planning);
$obj_calendario->init();

$obj_planning = Planning::getInstance();
$obj_planning->setDB($db);
$obj_planning->setStato('B');
$obj_planning->setGiorni($giorni_planning);
$obj_planning->setDataInizio($data_inizio);
$obj_planning->setDataFine($data_fine);
# INIT
$obj_planning->init();
# LOAD
$obj_planning->load();


$calendario = $obj_calendario->getCalendario();
$guardie = $obj_planning->getGuardie();
$planner = new PlannerCardiologia();

$RIPOSI_DOPO_18 = 0;
$RIPOSI_PRIMA_12 = 0;




foreach ($calendario as $giorno) {
    $data = $giorno['data'];
    
    /*
     * FASE 1: FESTIVITA
     */
    
    if ($giorno['prefestivita']>0 || $giorno['festivita']>0) {
        $code_giornata = 'FESTIVITA';

        # I turni nei giorni di festa hanno un formato "canonico": calcolato il 
        # primo giorno, viene fatto anche il secondo seguendo uno schema.
        # Verifichiamo ogni 2 turni di festa o quantomeno se oggi è festa mentre
        # l'indomani non è festa.
        # Esempio: 3 giorni di festa, prefestivo o prefestività compresi.
        # I primi 2 giorni fanno un conto, l'ultimo un altro.
        # I giorni singoli vanno sempre in POST.
        if ($giorno['festa'])
            $turno_extra++;
        DEBUG("{$data} --> {$code_giornata} ({$turno_extra})");
        
        # Secondo giorno di festa
        if ($turno_extra == 2) {
            DEBUG("TURNO EXTRA = 2");
            $turno_extra = 0;
            #Prendo i turni del giorno precedente per calcolare i turni
            $ieri = $obj_calendario->getData($data, -1);
            $cardiologo1 = $obj_planning->getGiornataGuardie($ieri, 'CARDIO_POM_UTIC'); #1
            $cardiologo1 = $cardiologo1["code_anagrafica"]; #1
            $cardiologo2 = $obj_planning->getGiornataGuardie($ieri, 'CARDIO_NOTTE');    #2
            $cardiologo2 = $cardiologo2["code_anagrafica"];    #2
            $cardiologo3 = $obj_planning->getGiornataGuardie($ieri, 'CARDIO_POM_INT');  #3
            $cardiologo3 = $cardiologo3["code_anagrafica"];  #3
            $cardiologo4 = $obj_planning->getGiornataGuardie($ieri, 'CARDIO_MAT_UTIC'); #4
            $cardiologo4 = $cardiologo4["code_anagrafica"]; #4
            DEBUG("Cardiologo #1: ".$cardiologo1);
            DEBUG("Cardiologo #2: ".$cardiologo2);
            DEBUG("Cardiologo #3: ".$cardiologo3);
            DEBUG("Cardiologo #4: ".$cardiologo4);
            # numero 2 riposa
            # numero 1 fa la notte
            
            
            $ok = $obj_planning->verifica_candidato_guardia($data, 'CARDIO_NOTTE', $code_giornata, $cardiologo1);
            if (!$ok)
                $cardiologo1 = false;
            $planner->impostaGuardia($data, 'CARDIO_NOTTE', $code_giornata, $cardiologo1);
            
            # numero 3 fa la mattina UTIC
            if (strlen($cardiologo3) == 0)
                $cardiologo3 = false;
            else {
                $ok = $obj_planning->verifica_candidato_guardia($data, 'CARDIO_MAT_UTIC', $code_giornata, $cardiologo3);
                if (!$ok)
                    $cardiologo3 = false;
            }
            $planner->impostaGuardia($data, 'CARDIO_MAT_UTIC', $code_giornata, $cardiologo3);
            
            # numero 4 fa il pomeriggio UTIC
            $ok = $obj_planning->verifica_candidato_guardia($data, 'CARDIO_POM_UTIC', $code_giornata, $cardiologo4);
            if (!$ok)
                $cardiologo4 = false;
            $planner->impostaGuardia($data, 'CARDIO_POM_UTIC', $code_giornata, $cardiologo4); 
            
            # Calcoliamo i riposi di recupero (12=pre, 18=post)
            # 1 e 3 hanno fatto 18 ore
            # 2 e 4 hanno fatto 12 ore
            $riposi = 0;
            $i = 0;
            DEBUG("-- calcolo riposi post");
            while ($riposi < $RIPOSI_DOPO_18) {
                $i++;
                $festa = $obj_calendario->festa($data, $i);
                DEBUG($obj_calendario->getData($data, $i)." ".$festa);
                if (!$festa) {
                    $g = $obj_calendario->getData($data, $i);
                    $obj_planning->insertTurno($g, 'R', '', $cardiologo1);
                    $obj_planning->insertTurno($g, 'R', '', $cardiologo3);
                    $riposi++;
                }
                if ($i>10) {
                    DEBUG("qualcosa è andato storto!!!!!!");
                    break;
                }
                   
            }
            $riposi = 0;
            $i = 0;
            DEBUG("-- calcolo riposi pre");
            while ($riposi < $RIPOSI_PRIMA_12) {
                $i--;
                $festa = $obj_calendario->festa($data, $i);
                DEBUG($obj_calendario->getData($data, $i)." ".$festa);
                if (!$festa) {
                    $g = $obj_calendario->getData($data, $i);
                    $obj_planning->insertTurno($g, 'R', '', $cardiologo2);
                    $obj_planning->insertTurno($g, 'R', '', $cardiologo4);
                    $riposi++;
                }
                if ($i<-10) {
                    DEBUG("qualcosa è andato storto!!!!!!");
                    break;
                }
            }
            continue;
        }
                   
            
        # --------------------------------------------------------------------------
        # CARDIO_NOTTE
        # --------------------------------------------------------------------------
        $tipo_turno = 'CARDIO_NOTTE';
        DEBUG("-- cerco ".$tipo_turno);
        $cardiologo_notte = $planner->impostaGuardia($data, $tipo_turno, $code_giornata);
        
        # --------------------------------------------------------------------------
        # CARDIO_MAT_UTIC
        # --------------------------------------------------------------------------
        $tipo_turno = 'CARDIO_MAT_UTIC';
        $cardiologo_mattino_utic = false;
        if ($giorno['festa']) {
            DEBUG("-- cerco ".$tipo_turno);
            $cardiologo_mattino_utic = $planner->impostaGuardia($data, $tipo_turno, $code_giornata);
        }
        
        # --------------------------------------------------------------------------
        # CARDIO_POM_UTIC
        # --------------------------------------------------------------------------
        $tipo_turno = 'CARDIO_POM_UTIC';
        DEBUG("-- cerco ".$tipo_turno);
        $cardiologo_pome_utic = $planner->impostaGuardia($data, $tipo_turno, $code_giornata);
        
        # --------------------------------------------------------------------------
        # CARDIO_POM_INT
        # --------------------------------------------------------------------------
        $tipo_turno = 'CARDIO_POM_INT';
        if (($giorno['sabato'] && $giorno['festivita']==0) || $giorno['prefestivita']) {
            DEBUG("-- cerco ".$tipo_turno);
            $cardiologo_pome_int = $planner->impostaGuardia($data, $tipo_turno, $code_giornata);
        }
        
        # --------------------------------------------------------------------------
        # CARDIO_MAT_INT: solo al SABATO e PREFESTIVITA. Se la fa chi fa il pomeriggio
        # --------------------------------------------------------------------------
        $tipo_turno = 'CARDIO_MAT_INT';
        if (($giorno['sabato'] && $giorno['festivita']==0) || $giorno['prefestivita']) {
            $planner->impostaGuardia($data, $tipo_turno, $code_giornata, $cardiologo_pome_int);
        }
        
        
        # --------------------------------------------------------------------------
        # Se è un giorno di festa spaiato, i riposi vanno calcolati subito
        # --------------------------------------------------------------------------
        # NESSUN RIPOSO!!! (per ora)
        if ($obj_calendario->festa($data) == 1 && $obj_calendario->festa($data, +1) == 0) {
            $turno_extra = 0;
            $riposi = 0;
            $i = 0;
            /*while ($riposi < 1) {
                $i++;
                $festa = $obj_calendario->festa($data, $i);
                if (!$festa) {
                    $g = $obj_calendario->getData($data, $i);
                    $obj_planning->insertTurno($g, 'R', '', $cardiologo_mattino_utic);
                    $obj_planning->insertTurno($g, 'R', '', $cardiologo_pome_utic);
                    $obj_planning->insertTurno($g, 'R', '', $cardiologo_pome_int);
                    $obj_planning->insertTurno($g, 'R', '', $cardiologo_notte); # dovrebbe essere già settato
                    $j = $i;
                    while (true) {
                        $j++;
                        if (!$obj_calendario->festa($data, $j)) {
                            $g2 = $obj_calendario->getData($data, $j);
                            $obj_planning->insertTurno($g2, 'R', '', $cardiologo_notte); # secondo giorno non festivo
                            break;
                        }
                    }
                    $riposi++;
                }
            }*/
        }
    }
    
    
    
    
    /*
     * FASE 2: FESTIVI SABATI e DOMENICHE
     */
    if ($giorno['prefestivita']==0 && $giorno['festivita']==0 && $giorno['festa']==1) {
        $code_giornata = 'FESTIVO';
    

            
            # I turni nei giorni di festa hanno un formato "canonico": calcolato il 
            # primo giorno, viene fatto anche il secondo seguendo uno schema.
            # Verifichiamo ogni 2 turni di festa o quantomeno se oggi è festa mentre
            # l'indomani non è festa.
            # Esempio: 3 giorni di festa, prefestivo o prefestività compresi.
            # I primi 2 giorni fanno un conto, l'ultimo un altro.
            # I giorni singoli vanno sempre in POST.
            if ($giorno['festa'])
                $turno_extra++;
            DEBUG("{$data} --> {$code_giornata} ({$turno_extra})");
            
            # Secondo giorno di festa
            if ($turno_extra == 2) {
                DEBUG("TURNO EXTRA = 2");
                $turno_extra = 0;
                #Prendo i turni del giorno precedente per calcolare i turni
                $ieri = $obj_calendario->getData($data, -1);
                $cardiologo1 = $obj_planning->getGiornataGuardie($ieri, 'CARDIO_POM_UTIC'); #1
                $cardiologo1 = $cardiologo1["code_anagrafica"]; #1
                $cardiologo2 = $obj_planning->getGiornataGuardie($ieri, 'CARDIO_NOTTE');    #2
                $cardiologo2 = $cardiologo2["code_anagrafica"];    #2
                $cardiologo3 = $obj_planning->getGiornataGuardie($ieri, 'CARDIO_POM_INT');  #3
                $cardiologo3 = $cardiologo3["code_anagrafica"];  #3
                $cardiologo4 = $obj_planning->getGiornataGuardie($ieri, 'CARDIO_MAT_UTIC'); #4
                $cardiologo4 = $cardiologo4["code_anagrafica"]; #4
                DEBUG("Cardiologo #1: ".$cardiologo1);
                DEBUG("Cardiologo #2: ".$cardiologo2);
                DEBUG("Cardiologo #3: ".$cardiologo3);
                DEBUG("Cardiologo #4: ".$cardiologo4);
                # numero 2 riposa
                # numero 1 fa la notte
                $planner->impostaGuardia($data, 'CARDIO_NOTTE', $code_giornata, $cardiologo1);  
                # numero 3 fa la mattina UTIC
                if (strlen($cardiologo3) == 0)
                    $cardiologo3 = false;
                $planner->impostaGuardia($data, 'CARDIO_MAT_UTIC', $code_giornata, $cardiologo3);
                # numero 4 fa il pomeriggio UTIC
                $planner->impostaGuardia($data, 'CARDIO_POM_UTIC', $code_giornata, $cardiologo4); 
                
                # Calcoliamo i riposi di recupero (12=pre, 18=post)
                # 1 e 3 hanno fatto 18 ore
                # 2 e 4 hanno fatto 12 ore
                $riposi = 0;
                $i = 0;
                DEBUG("-- calcolo riposi post");
                while ($riposi < $RIPOSI_DOPO_18) {
                    $i++;
                    $festa = $obj_calendario->festa($data, $i);
                    DEBUG($obj_calendario->getData($data, $i)." ".$festa);
                    if (!$festa) {
                        $g = $obj_calendario->getData($data, $i);
                        $obj_planning->insertTurno($g, 'R', '', $cardiologo1);
                        $obj_planning->insertTurno($g, 'R', '', $cardiologo3);
                        $riposi++;
                    }
                    if ($i>10) {
                        DEBUG("qualcosa è andato storto!!!!!!");
                        break;
                    }
                       
                }
                /*$riposi = 0;
                $i = 0;
                DEBUG("-- calcolo riposi pre");
                while ($riposi < $RIPOSI_PRIMA_12) {
                    $i--;
                    $festa = $obj_calendario->festa($data, $i);
                    DEBUG($obj_calendario->getData($data, $i)." ".$festa);
                    if (!$festa) {
                        $g = $obj_calendario->getData($data, $i);
                        $obj_planning->insertTurno($g, 'R', '', $cardiologo2);
                        $obj_planning->insertTurno($g, 'R', '', $cardiologo4);
                        $riposi++;
                    }
                    if ($i<-10) {
                        DEBUG("qualcosa è andato storto!!!!!!");
                        break;
                    }
                }*/
                
            }
            else {
                
                # --------------------------------------------------------------------------
                # CARDIO_NOTTE
                # --------------------------------------------------------------------------
                $tipo_turno = 'CARDIO_NOTTE';
                DEBUG("-- cerco ".$tipo_turno);
                $cardiologo_notte = $planner->impostaGuardia($data, $tipo_turno, $code_giornata);
                
                # --------------------------------------------------------------------------
                # CARDIO_MAT_UTIC
                # --------------------------------------------------------------------------
                $tipo_turno = 'CARDIO_MAT_UTIC';
                $cardiologo_mattino_utic = false;
                if ($giorno['festa']) {
                    DEBUG("-- cerco ".$tipo_turno);
                    $cardiologo_mattino_utic = $planner->impostaGuardia($data, $tipo_turno, $code_giornata);
                }
                
                # --------------------------------------------------------------------------
                # CARDIO_POM_UTIC
                # --------------------------------------------------------------------------
                $tipo_turno = 'CARDIO_POM_UTIC';
                DEBUG("-- cerco ".$tipo_turno);
                $cardiologo_pome_utic = $planner->impostaGuardia($data, $tipo_turno, $code_giornata);
                
                # --------------------------------------------------------------------------
                # CARDIO_POM_INT
                # --------------------------------------------------------------------------
                $tipo_turno = 'CARDIO_POM_INT';
                if (($giorno['sabato'] && $giorno['festivita']==0) || $giorno['prefestivita']) {
                    DEBUG("-- cerco ".$tipo_turno);
                    $cardiologo_pome_int = $planner->impostaGuardia($data, $tipo_turno, $code_giornata);
                }
                
                # --------------------------------------------------------------------------
                # CARDIO_MAT_INT: solo al SABATO e PREFESTIVITA. Se la fa chi fa il pomeriggio
                # --------------------------------------------------------------------------
                $tipo_turno = 'CARDIO_MAT_INT';
                if (($giorno['sabato'] && $giorno['festivita']==0) || $giorno['prefestivita']) {
                    $planner->impostaGuardia($data, $tipo_turno, $code_giornata, $cardiologo_pome_int);
                }
                
                
                # --------------------------------------------------------------------------
                # Se è un giorno di festa spaiato, i riposi vanno calcolati subito
                # --------------------------------------------------------------------------
                # NESSUN RIPOSO !!! (per ora)
                if ($obj_calendario->festa($data) == 1 && $obj_calendario->festa($data, +1) == 0) {
                    $turno_extra = 0;
                    $riposi = 0;
                    $i = 0;
                    /*while ($riposi < 1) {
                        $i++;
                        $festa = $obj_calendario->festa($data, $i);
                        if (!$festa) {
                            $g = $obj_calendario->getData($data, $i);
                            $obj_planning->insertTurno($g, 'R', '', $cardiologo_mattino_utic);
                            $obj_planning->insertTurno($g, 'R', '', $cardiologo_pome_utic);
                            $obj_planning->insertTurno($g, 'R', '', $cardiologo_pome_int);
                            $obj_planning->insertTurno($g, 'R', '', $cardiologo_notte); # dovrebbe essere già settato
                            $j = $i;
                            while (true) {
                                $j++;
                                if (!$obj_calendario->festa($data, $j)) {
                                    $g2 = $obj_calendario->getData($data, $j);
                                    $obj_planning->insertTurno($g2, 'R', '', $cardiologo_notte); # secondo giorno non festivo
                                    break;
                                }
                            }
                            $riposi++;
                        }
                    }*/
                }

            }
    }
    
    
    
    
    
    /*
     * FASE 0: PIANO DI LAVORO GIORNI FERIALI - SOLO DEG1 e DEG2 che sono "speciali"
     */
    if ($giorno['festa']==0) {
        $turno_extra = 0;
        
            $severita = "BIANCO";
            $pool = "POOL_DEGENZA";
            $tipo_destinazione = "DEG";
            $code_giornata = 'FERIALE';
            $obj_planning = Planning::getInstance();  
            $woy = $giorno["woy"];
            
            # GIU salta la settimana su DEG1
            if ($woy % 2 == 1) {
                $candidato = $obj_planning->verifica_candidato_destinazione($data, $tipo_destinazione, "DEG2", "SEC", $severita);
                if ($candidato != false)
                    $planner->impostaDestinazionePianoLavoro($data, $tipo_destinazione, "DEG2", $pool, $severita, "SEC");
            }
            # SEC salta la settimana su DEG2
            elseif ($woy % 2 == 0) {
                $candidato = $obj_planning->verifica_candidato_destinazione($data, $tipo_destinazione, "DEG1", "GIU", $severita);
                if ($candidato != false)
                    $planner->impostaDestinazionePianoLavoro($data, $tipo_destinazione, "DEG1", $pool, $severita, "GIU");
            }
            # Non salta nessuno
            else {
                $candidato = $obj_planning->verifica_candidato_destinazione($data, $tipo_destinazione, "DEG1", "GIU", $severita);
                if ($candidato != false)
                    $planner->impostaDestinazionePianoLavoro($data, $tipo_destinazione, "DEG1", $pool, $severita, "GIU");
                #-------------------------------------------------------------------------------------------------------------------
                $candidato = $obj_planning->verifica_candidato_destinazione($data, $tipo_destinazione, "DEG2", "SEC", $severita);
                if ($candidato != false)
                    $planner->impostaDestinazionePianoLavoro($data, $tipo_destinazione, "DEG2", $pool, $severita, "SEC");
            }

    }

    
    /*
     * FASE 3: GIORNI FERIALI
     */
    if ($giorno['festa']==0) {
        $code_giornata = 'FERIALE';
        
        # --------------------------------------------------------------------------
        # CARDIO_NOTTE
        # --------------------------------------------------------------------------
        $tipo_turno = 'CARDIO_NOTTE';
        DEBUG("-- cerco ".$tipo_turno);
        $cardiologo_notte = $planner->impostaGuardia($data, $tipo_turno, $code_giornata);
        
        # RIPOSO DI RECUPERO ORE dopo la notte
        # per ora solo il giorno successivo. Se festivo, non lo trasliamo.
        /*$riposi = 0;
        $i = 0;
        while ($riposi < 1) {
            $i++;
            $festa = $obj_calendario->festa($data, $i);
            if (!$festa) {
                $g = $obj_calendario->getData($data, $i);
                $obj_planning->insertTurno($g, 'R', '', $cardiologo_notte); # dovrebbe essere già settato
                $riposi++;
            }
        }*/
        
        # --------------------------------------------------------------------------
        # CARDIO_POM_UTIC
        # --------------------------------------------------------------------------
        $tipo_turno = 'CARDIO_POM_UTIC';
        DEBUG("-- cerco ".$tipo_turno);
        $cardiologo_pome_utic = $planner->impostaGuardia($data, $tipo_turno, $code_giornata);
        
        # --------------------------------------------------------------------------
        # CARDIO_POM_INT
        # --------------------------------------------------------------------------
        $tipo_turno = 'CARDIO_POM_INT';
        DEBUG("-- cerco ".$tipo_turno);
        $cardiologo_pome_int = $planner->impostaGuardia($data, $tipo_turno, $code_giornata);
    
    }
    
    DEBUG('FINE GUARDIE');
    
    
    
    
    
    if ($giorno['festa']==0) {
        /*
         * FASE 4.1: PIANO DI LAVORO (SOLO GIORNI FERIALI) - POSTAZIONI OBBLIGATORIE
         */
        $sql = "SELECT * FROM destinazioni WHERE code_uo='cardiologia' ORDER BY obbligatoria DESC, ordine";
        $rs = $db->Esegui($sql);
        $destinazioni_ordinate_priorita = array();
        while (!$rs->EOF) {
            $code = $rs->Fields("code");
            $destinazioni_ordinate_priorita[$code] = $rs->FetchRow();
        }

        $turno_extra = 0;
        
            
            # Il piano di lavoro va calcolato diversamente dalle guardie.
            # Qui prima dobbiamo fare tutte le destinazioni in BIANCO, poi tutte in GIALLO 
            # e così via.
            # NON PIU'!!!
            
            $severita = array('BIANCO', 'GIALLO'/*, 'ARANCIO'*/, 'ROSSO');
            foreach ($destinazioni_ordinate_priorita as $key => $destinazione) {
                if ($key == 'DISP') # non dovrebbe esserci ma meglio verificare.
                    continue;
                #if ($key == "DEGDS" && ($calendario[$data]['gsettimana'] == 'Mer' || $calendario[$data]['gsettimana'] == 'Gio' || $calendario[$data]['gsettimana'] == 'Ven')) {
                #    $planner->impostaDestinazionePianoLavoro($data, $destinazione["tipo"], $key, $destinazione["pool"], 'BIANCO', 'ABB');
                #    continue;
                #}
                    
                if ($destinazione["obbligatoria"] != 'S')
                    continue;
                    
                # Se è già impostato, salto:
                $giornata_pl = $obj_planning->getGiornataPianoLavoro($data, $key);
                if (strlen($giornata_pl['code_anagrafica']) > 0)
                    continue;
                        
                $ne_manca_qualcuno = false;
                foreach ($severita as $s) {
                    
                    DEBUG("-- cerco x ".$key." ({$s})");
                    $candidato = $planner->impostaDestinazionePianoLavoro($data, $destinazione["tipo"], $key, $destinazione["pool"], $s);
                    if ($candidato === false) {
                        $ne_manca_qualcuno = true;
                        # Se è l'ultimo tentativo (ROSSO), segnaliamo errore!
                        if ($s == 'ROSSO') 
                            $obj_planning->logGuardieVerificaCandidati($data, $key, $destinazione["tipo"], null, "N", "NESSUN CANDIDATO TROVATO!!!", $s);
                    }
                }
                #if ($ne_manca_qualcuno === false)
                #    break;
            }
    

    
        /*
         * FASE 4.2: PIANO DI LAVORO (SOLO GIORNI FERIALI) - POSTAZIONI NON OBBLIGATORIE
         */
 
        $turno_extra = 0;
        
        # Il piano di lavoro va calcolato diversamente dalle guardie.
        # Qui prima dobbiamo fare tutte le destinazioni in BIANCO, poi tutte in GIALLO 
        # e così via.
        
        $severita = array('BIANCO', 'GIALLO', /*'ARANCIO',*/ 'ROSSO');
        foreach ($severita as $s) {
            $ne_manca_qualcuno = false;
            foreach ($destinazioni as $key => $destinazione) {
                if ($key == 'DISP') # non dovrebbe esserci ma meglio verificare.
                    continue;
                if ($destinazione["obbligatoria"] == 'S')
                    continue;
                DEBUG("-- cerco x ".$key." ({$s})");
                $candidato = $planner->impostaDestinazionePianoLavoro($data, $destinazione["tipo"], $key, $destinazione["pool"], $s);
                if ($candidato === false) {
                    $ne_manca_qualcuno = true;
                    # Se è l'ultimo tentativo (ROSSO), segnaliamo errore!
                    if ($s == 'ROSSO') 
                        $obj_planning->logGuardieVerificaCandidati($data, $key, $destinazione["tipo"], null, "N", "NESSUN CANDIDATO TROVATO!!!", $s);
                }
            }
            if ($ne_manca_qualcuno === false)
                break;
        }
    }
}








/*
 * FASE 5: MEDICI DISPONIBILI (SOLO GIORNI FERIALI)
 */
$turni = $obj_planning->getTurni();
foreach ($calendario as $giorno) {
    $data = $giorno['data'];
    if ($giorno['festa'])
        continue;
    foreach($anagrafiche as $code => $anag) {
        if (!isset($turni[$code][$data])) {
            $obj_planning->insertTurno($data, 'DISP', 'FERIALE', $code); 
        }
    }
}


DEBUG("FINE");
?>
