<?php
ob_start();
session_start();
require_once('include/costanti.inc.php');
set_include_path(get_include_path().PATH_SEPARATOR.'/var/www/LIB'.PATH_SEPARATOR.'C:/WAMP/www/LIB');
require_once("aspidenet-yae/aspidenet.inc.php");
require_once("include/autoload.inc.php");

require_once('adodb5/adodb.inc.php');
$ADODB_FETCH_MODE = ADODB_FETCH_ASSOC; //ADODB_FETCH_BOTH;

//***********************************************
// SMARTY
//***********************************************
require_once('Smarty3/Smarty.class.php');
$smarty = new Smarty;
$smarty->template_dir = 'templates';
$smarty->compile_dir = 'templates_c';
$smarty->force_compile = true;

//***********************************************
// MENU
//***********************************************
#require_once('include/menu.inc.php');

#unset($_SESSION["DB"]);
/*******************************************************************************
   CONNESSIONE AL DATABASE
*******************************************************************************/
if (isset($_SESSION["DB"])) {
    #DEBUG("DB esiste gia'!");
	$db = unserialize($_SESSION["DB"]);
}
else {
	$db = new DB(DB_TYPE);
    
    if (isset($_SESSION["dbname"]) && isset($_SESSION["dbuser"]) && isset($_SESSION["dbpasswd"])) {
        #DEBUG("Mi collego su ".$_SESSION["dbname"]);
        $res = $db->Connetti(DB_HOST_SERVER, $_SESSION["dbuser"], $_SESSION["dbpasswd"], $_SESSION["dbname"]) or die('connessione fallita');
        if ($res) {
            $_SESSION["DB"] = serialize($db);
        }
    }
    else {
        #DEBUG("Mi collego su default.");
        $res = $db->Connetti() or die('connessione fallita');
        if ($res) $_SESSION["DB"] = serialize($db);
    }
	if ($res) 
		$db->Init();
	#if (is_object($db))
		$_SESSION["DB"] = serialize($db);
    #else
    #    exit('DB not is object!');
    
    #print_r($_SESSION);
    #exit();
}

/*******************************************************************************
		UTENTE
*******************************************************************************/
#$utente = "io";

if (!isset($_SESSION["UTENTE"])) {
	if (basename($_SERVER['PHP_SELF']) != "login.php") {
		header("Location: login.php");
		exit();
	}
    $utente = new Utente($db);
}
else {
	$smarty->assign('login', true);
	$utente = unserialize($_SESSION["UTENTE"]);
	$utente->setDB($db);

	$smarty->assign('utente', $utente);
	#$smarty->assign('HTML', new UtilsHtml());

	

	$smarty->assign('sino', array('S' => "si", 'N' => "no"));
	$smarty->assign('nosi', array('N' => "no", 'S' => "si"));
	
	##########################################################################
	# JQUERY-UI THEME
	if (file_exists("css/".JQUERY_UI)) {
		$smarty->assign('jquery_ui', JQUERY_UI);
	}
	else {
		$smarty->assign('jquery_ui', "ui");
	}

	$oggi = date("Y-m-d");
}



/*******************************************************************************
  TIPI TURNO GUARDIA
*******************************************************************************/
if (isset($_SESSION['PLANNING_data_inizio']))
    $data_inizio = $_SESSION['PLANNING_data_inizio'];
else
    $data_inizio = date("Y-m-d");
$sql = "SELECT code, turno, ore FROM tipo_turni_guardia 
        WHERE code_uo='cardiologia' AND COALESCE(data_fine, '2100-12-31')>='{$data_inizio}' ORDER BY ordine";
$rs = $db->Esegui($sql);
$tipi_turno = array();
$ore_dei_turni = array();
while (!$rs->EOF) {
    $code = $rs->Fields("code");
    $tipo = $rs->Fields("turno");
    $tipi_turno[$code] = $tipo;
    $ore_dei_turni[$code] = $rs->Fields("ore");
    $rs->MoveNext();
}
$smarty->assign('tipi_turno', $tipi_turno);


/*******************************************************************************
  TIPI TURNO SPECIALI
*******************************************************************************/
$tipi_turno_ext = array(
    'R' => "Riposo",
    'F' => "Ferie",
    'C' => "Congresso",
    'D' => "Didattica",
    'I' => "Indisponibile",
    'DISP' => "Disponibile",
);
$smarty->assign('tipi_turno_ext', $tipi_turno_ext);

/*******************************************************************************
  ANAGRAFICHE E POOL
*******************************************************************************/
if (isset($_SESSION['ANAGRAFICHE'])) {
    $anagrafiche = $_SESSION['ANAGRAFICHE'];
    $guardiani = array();
    foreach($anagrafiche as $code => $item) {
        if ($item["guardia"] == 'S')
            $guardiani[$code] = $item;
    }
}
else {
    $sql = "SELECT * FROM anagrafiche WHERE valido ORDER BY pool, code";
    $rs = $db->Esegui($sql);
    $anagrafiche = array();
    $guardiani = array();
    $pools = array();
    while (!$rs->EOF) {
        $code = $rs->Fields("code");
        $pool = $rs->Fields("pool");
        $guardia = $rs->Fields("guardia");
        if (isset($pools[$pool]))
            $pools[$pool]++;
        else
            $pools[$pool] = 1;
            
        $anag = $rs->FetchRow();
        
        if ($guardia == 'S')
            $guardiani[$code] = $anag;
            
        $anagrafiche[$code] = $anag;
    }
}
$smarty->assign('anagrafiche', $anagrafiche);

/*******************************************************************************
  DESTINAZIONI E POOL
*******************************************************************************/
$sql = "SELECT * FROM destinazioni WHERE code_uo='cardiologia' ORDER BY ordine_visuale, pool, code";
$rs = $db->Esegui($sql);
$destinazioni = array();
$count_destinazioni_pool = array();
while (!$rs->EOF) {
    $code = $rs->Fields("code");
    $pool = $rs->Fields("pool");
    $ore_dei_turni[$code] = $rs->Fields("ore");
    
    if ($code == 'DISP') {
        $rs->MoveNext();
        continue;
    }    
    
    if (isset($count_destinazioni_pool[$pool]))
        $count_destinazioni_pool[$pool]++;
    else
        $count_destinazioni_pool[$pool] = 1;
    $destinazioni[$code] = $rs->FetchRow();
}
$smarty->assign('destinazioni', $destinazioni);


/*******************************************************************************
  FUNZIONI TURNI
*******************************************************************************/
function poolDestinazione($destinazione) {
    GLOBAL $db;
    $sql = "SELECT * FROM anagrafiche_destinazioni WHERE tipo_destinazione='{$destinazione}' ORDER BY livello";
    $rs = $db->Esegui($sql);
    $result = array();
    while (!$rs->EOF) {
        $anag = $rs->Fields("code_anagrafica");
        $result[] = $anag;
        $rs->MoveNext();
    }
    return $result;
}

function titolariDestinazione($destinazione) {
    GLOBAL $db;
    $sql = "SELECT * FROM anagrafiche_destinazioni WHERE tipo_destinazione='{$destinazione}' AND livello=1";
    $rs = $db->Esegui($sql);
    $result = array();
    while (!$rs->EOF) {
        $anag = $rs->Fields("code_anagrafica");
        $result[] = $anag;
        $rs->MoveNext();
    }
    return $result;
}
